/*
 * Copyright 2003 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/*
 * @test
 * @summary Test subtyping for wildcards with related type bounds.
 *
 * @compile/fail -source 1.5 AssignmentDifferentTypes8.java
 */

public class AssignmentDifferentTypes8 {

    public static void main(String[] args) {
	Ref<Der> derexact = null;
	Ref<Base> baseexact = null;
	Ref<? extends Der> derext = null;
	Ref<? extends Base> baseext = null;
	Ref<? super Der> dersuper = null;
	Ref<? super Base> basesuper = null;

	basesuper = dersuper;	// <<fail>> <? super Base> = <? super Der>
    }
}

class Ref<T> {}
class Base {}
class Der extends Base {}
