'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_101_.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:05 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description  :  Checks the menuitem File in a more detailed way (-> documentation)
'*
'************************************************************************
'*
' #1 C_101_ ' Initial routine
' #1 tFileTextImport
' #1 tFileVersions
' #1 tFileProperties
' #1 tExportAsPDF
' #1 tFileSaveAs
'*
'\***********************************************************************

sub C_101_

Printlog "--------- C_101_ ---------"

   Call tFileTextImport
   call tFileVersions
   Call tFileProperties
   Call tExportAsPDF
   Call tFileSaveAs

End sub
'
'-------------------------------------------------------------------------
'
testcase tFileTextImport
'/// This testcase imports a file with the method TEXTIMPORT, changes the column spread and format ///
'/// of number and checks if these properties will be taken over.///

    dim filename$, filename_new$
    dim form as String
    dim column_current As Single
    dim column_spread As Single
    dim i as integer, k as integer
    dim lng as String
    dim lang as integer
    dim FileFilter as String
    dim FilterNr as integer
    
    if iSystemsprache <> 01 then
       QAErrorLog "Sorry, this Testcase only runs on locale en_US"
       goto endsub
    end if

    printlog "iSprache: " & iSprache

    select case iSprache
        case 01 : lng = "01" : FileFilter = "Text CSV"
        case 03 : lng = "03" : FileFilter = "Text CSV"
        case 07 : lng = "07" : FileFilter = "Text CSV"
        case 31 : lng = "31" : FileFilter = "Text CSV"
        case 33 : lng = "33" : FileFilter = "Texte CSV"
        case 34 : lng = "34" : FileFilter = "Texto CSV"
        case 39 : lng = "39" : FileFilter = "Testo CSV"
        case 45 : lng = "45" : FileFilter = "Text CSV"
        case 46 : lng = "46" : FileFilter = "Text CSV"
        case 48 : lng = "48" : FileFilter = "Text CSV"
        case 49 : lng = "49" : FileFilter = "Text CSV"
        case 55 : lng = "55" : FileFilter = "Texto CSV"
        case 81 : lng = "81" : FilterNr = 28
        case 82 : lng = "82" : FilterNr = 120
        case 86 : lng = "86" : FilterNr = 120
        case 88 : lng = "88" : FilterNr = 120
        case else : QAErrorlog "** So far no language adjustment executed!" : goto endsub
    end select
'/// Open the file "calc\level1\input\c_101\filetextimport_<languageID>.tst" with filetype CSV
   filename$ = convertpath(gTesttoolPath & "calc\level1\input\c_101\filetextimport_" & lng & ".tst")
   filename_new$ = convertpath(gOfficePath & "user/work/filetextimport_" & lng & ".tst")

    FileOpen
    Kontext "OeffnenDlg"
    UebergeordneterOrdner.Click
    Standard.Click
    sleep 3
      k = 1
      Dateityp.select k
       while right(Dateityp.getSelText, 17) <> "CSV (*.csv;*.txt)"
         k = k + 1
         Dateityp.select k
       wend
    Dateiname.settext filename$
    Sleep 2
    Oeffnen.Click
    sleep 2
'/// Now the dialog "TextImport" should be appear
    Kontext "TextImport"
    if TextImport.exists then
      dim cnt as integer
      cnt = Zeichensatz.getItemCount
      Zeichensatz.select cnt
'/// Select the suggested characterset and check semicolon
      Kontext "TextImport"
      Sleep 3
      Semikolon.check
      call Dialogtest (TextImport)
      TextImport.Ok
    else
      warnlog "Text Import Dialog doesn't exists -> BUG!"
      goto Ende
    end if
'/// Select the cellrange 'C2:C5' and set as FormatCode "DD.MM.YYYY"(english OS)
'/// or "TT.MM.JJJJ"(german OS) and confirm the dialog
    try
        Kontext
        call cBereichmarkieren("C2:C5")
        FormatCells
        Kontext
        active.setpage TabZahlen
        Kontext "TabZahlen"
        if iSystemsprache = 01 then
         FormatCode.settext "DD.MM.YYYY"
       else
            FormatCode.settext "TT.MM.JJJJ"
       end if
        form = FormatCode.GetText
        TabZahlen.Ok
'/// Call the menuitem 'FormatColumnOptimalWidthCalc' and confirm it.
        FormatColumnOptimalWidthCalc
        Kontext "SpalteOptimaleBreite"
        SpalteOptimaleBreite.OK
        FormatColumnWidthCalc
           Kontext "SpaltenbreiteCalc"
        column_current = val(Breite.gettext)
        printlog "column_current = " & column_current
        SpaltenbreiteCalc.OK
        Sleep 1
        Kontext
'/// Check, if the Cellcontent of 'C2' is "13.04.1999"
        if cZellwert("C2") = "13.04.1999" then
        Printlog "  Import Ok"
        else
        Warnlog "Imported value isn't '13.04.1999' in cell C2 " & cZellwert("C2")
        end if
    catch
      Warnlog "Textimport doesn't work"
    endcatch
'/// Save the file in any local directory
   call hSpeichernUnterMitFilterKill filename_new$, FileFormat
   printlog "save file"
   FileClose
   printlog "close file"
   Kontext
   if active.exists then
      active.yes
   end if
   printlog "open file"
'/// Open the file and check all made settings
   hDateiOeffnen filename_new$
   printlog "*** check, if the made adjustments exists after close and open the file! ***"
   cgotocell("C1")

   FormatColumnWidthCalc
   Kontext "SpaltenbreiteCalc"
    column_spread = val(Breite.gettext)
    printlog "column_spread = " & column_spread
    SpaltenbreiteCalc.OK
   if column_spread = column_current then
      printlog "OK! The column spread was taken over!"
   else
      warnlog "Failure! The column spread wasn't taken over!"
   end if
   For i = 1 to 4
      Kontext "DocumentCalc"
      DocumentCalc.typekeys "<down>"
      FormatCells
       Kontext
       active.setpage TabZahlen
       Kontext "TabZahlen"
       if FormatCode.GetText = form then
         printlog "OK! Format of numbers is correct after closing and calling the file in cell 'C" & i &"'"
       else
         warnlog "Failure! Format of numbers wasn't taken over in Cell 'C" & i & "'"
       end if
       TabZahlen.OK
       sleep 10
    next i
      Kontext "DocumentCalc"
Ende:
      call hCloseDocument

      Sleep 5

endcase
'
'-----------------------------------------------------------
'
testcase tFileVersions
'/// This testcase check the fileversions functionality. ///
'/// At first a document is loaded and edit. Then this file is saved ///
'/// with a version comment. After this the document is modified ///
'/// and saved with a second version comment. At last the document ///
'/// is reloaded with it's first version and checked if this version ///
'/// was really loaded. ///

    dim Result$
    dim SFile as String
    SFile = convertpath (gOfficePath & "user/work/version1" & Ext)
    call hNewDocument
    Kontext
    cgotocell("B1")
    DocumentCalc.TypeKeys "1111<RETURN>2222<RETURN>3333<RETURN>4444<RETURN>"
    cgotocell("D1")
    DocumentCalc.TypeKeys "before<RETURN>"
    Printlog "Before save in ..."
    hSpeichernUnterMitFilterKill SFile, FileFormat
    Printlog "After saving ..."
    Kontext
    FileVersions
    Kontext "Versionen"
    Speichern.Click
    Kontext "Versionskommentareingeben"
    Kommentar.SetText "First version"
    Versionskommentareingeben.OK
    Kontext "Versionen"
    Versionen.Close
    printlog "modify the document"
    Kontext
    sleep 4
    cgotocell("D1")
    DocumentCalc.TypeKeys "AAAA<RETURN>BBBB<RETURN>CCCC<RETURN>DDDD<RETURN>"
    FileSave
    Sleep (2)
    FileVersions
    Kontext "Versionen"
    Speichern.Click
    Kontext "Versionskommentareingeben"
    Kommentar.SetText "second version"
    Versionskommentareingeben.OK
    Kontext "Versionen"
    Versionen.Close
    FileVersions
    Kontext "Versionen"
    Anzeigen.Click
    Kontext "Versionskommentareingeben"
    Result$ = Kommentar.GetText
    if Result$ <> "First version" then warnlog "The first version wasn't saved!"
    Printlog "First result is " & Result$
    Versionskommentareingeben.Close
    Kontext "Versionen"
    Versionen.Close
    call hCloseDocument
    printlog "Check if the correct version is loaded!"
    call hDateiOeffnen SFile
    FileVersions
    Kontext "Versionen"
    Oeffnen.Click
    Kontext "DocumentCalc"
    checkcellwert ("D1", "Before")
    
    call hCloseDocument
    Kontext "DocumentCalc"
    if DocumentCalc.exists(2) then call hCloseDocument    

endcase

'
'-----------------------------------------------------------
'
testcase tFileProperties
'/// This testcase checks the fileproperties. At first a new document is loaded. ///
'/// Then the file property dialog is called and settings in all tabpages are made. ///
'/// Then the document is stored, reload and the made settings are checked. ///

   dim SFile as String
   SFile = convertpath(gOfficePath & "user/work/tfileproperties" & Ext)

    Call hNewDocument
    sleep 5

   try
      FileProperties

      Kontext
      active.SetPage TabBeschreibung
      Kontext "TabBeschreibung"
      Titel.settext "content1"
      sleep 2
      Kontext
      active.SetPage TabBenutzer
      Kontext "TabBenutzer"
      Info0.settext "info"
      Infofelder.Click
      Kontext "InfonamenBearbeiten"
      Namen1.settext "Kirk"
      InfonamenBearbeiten.Ok
      Kontext
      active.SetPage TabInternet
      Kontext "TabInternet"
      if DoNotRefreshAutomatically.ischecked then
         tcb1a = 1
      else
         tcb1a = -1
      end if
      RefreshThisDocument.check
      'DoNotRefreshAutomatically.check
      TabInternet.Ok

      call hSpeichernUnterMitFilterKill SFile, FileFormat
      call hCloseDocument
      sleep 1
      call hDateioeffnen SFile
      FileProperties

      Kontext
      active.SetPage TabBeschreibung
      Kontext "TabBeschreibung"
      if Titel.gettext = "content1" then
         printlog "TabDescription OK"
      else
         Warnlog "TabDescription not imported"
      end if

      Kontext
      active.SetPage TabBenutzer
      Kontext "TabBenutzer"
      if Info0.gettext = "info" then
         printlog "Tab UserDefined OK"
      else
         warnlog "Tab UserDefined not imported"
      end if
      Infofelder.Click
      Kontext "InfonamenBearbeiten"
      if Namen1.gettext = "Kirk" then
         printlog "InfoFileds OK"
      else
         warnlog "InfoFileds not imported"
      end if
      InfonamenBearbeiten.Ok

      Kontext
      active.SetPage TabInternet
      Kontext "TabInternet"
      if DoNotRefreshAutomatically.ischecked then
         tcb1b = 1
      else
         tcb1b = -1
      end if
      call cBoxVergleichen (tcb1a,tcb1b,"TabInternet")
      DoNotRefreshAutomatically.check
      TabInternet.ok
   catch
      warnlog "Because of bug:99828, this test could not be execute"
        kontext "TabInternet"
        if TabInternet.exists then TabInternet.Cancel
   endcatch

   call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveAs

   dim i as integer, k as integer
   dim sFile as String
       sFile = convertpath(gOfficepath & "user/work/format")
   dim sCurrentFileType, sFileTypeSuffix as STRING
   dim bCommitAlienDialog, bCommitExportDialog , bCommitActiveSheet as BOOLEAN
   
   call hNewDocument
   sleep 2
   FileSaveAs
   sleep(1)
   Kontext "SpeichernDLG"
   AutomatischeDateinamensErweiterung.check
   i =  Dateityp.getItemCount
   printlog "There are " & i & " filters in the listbox"
   SpeichernDLG.cancel
   for k = 1 to  i
      FileSaveAs
      sleep(2)
      Kontext "SpeichernDLG"
      Dateiname.setText sFile
      Dateityp.select k
      sCurrentFileType = Dateityp.getselText
      sFileTypeSuffix = right(sCurrentFileType, 6)
      printlog "Save empty document with filter: " & sCurrentFileType
      Speichern.click
      sleep(1)
      Kontext "Active"
      if Active.exists(2) then
          Active.YES
      endif
      sleep(1)
      '///<li>Check alien file format warning</li>///
      select case sFileTypeSuffix
             case "(.ods)" : bCommitAlienDialog = FALSE
             case "(.ots)" : bCommitAlienDialog = FALSE
             case else : bCommitAlienDialog = TRUE
      end select
      if bCommitAlienDialog = TRUE then
          '///<li>-> Commit if exists</li>///
          Kontext "AlienWarning"
          AlienWarning.OK
          printlog "+ OK, alien warning dialog was found"
      endif
      sleep(1)

      select case sFileTypeSuffix
             case "(.dif)" : bCommitExportDialog = TRUE : bCommitActiveSheet = TRUE
             case "(.dbf)" : bCommitExportDialog = TRUE : bCommitActiveSheet = FALSE
             case "(.csv)" : bCommitExportDialog = TRUE : bCommitActiveSheet = TRUE
             case else : bCommitExportDialog = FALSE
      end select
      if bCommitExportDialog = TRUE then
          Kontext "ExportCalc"
          ExportCalc.OK
          printlog "+ OK, export dialog was found"
          Kontext "Active"
          if bCommitActiveSheet = TRUE then
              Active.OK
          end if
      endif
      sleep(5)
      Kontext "Active"
      if Active.exists(2) then
          Active.OK
          qaErrorLog "Unexpected MsgBox - Issue under evaluation!"
      endif
   next k
   
   call hCloseDocument

endcase

testcase tExportAsPDF
   dim sPath as string
   dim bTemp as boolean
   dim sTemp as string
   dim sApp as string
   dim sFilter as string
   dim sExtension as string
   dim sTextFiltername as string

   sPath = ConvertPath ( gOfficePath + "user/work/calc/pdf.pdf"
   '/// if not exists : gOfficePath + '\\user\\math\\level1\\', create it ///'
   if app.dir (ConvertPath ( gOfficePath + "user/work/calc") ) = "" then
      app.mkdir ConvertPath ( gOfficePath + "user/work/calc")
   endif
'/// open application ///'
'/// the exported document will be at StarOfice Path + 'user//work//math//pdf.pdf' ///'
   hNewDocument()
   hTypeKeys ("a<return>")
   if (dir(sPath) <> "") then
      kill (spath)
   endif
   '/// File->Export as PDF document ///'
   hFileExport (sPath, "PDF")
'/// close application ///'
   hCloseDocument ()
   if (dir(sPath) <> "") then
      sleep 5
         '/// the first line has to be '%PDF-1.4' ///'
         sTemp = fGetFileText(sPath, 8)
         if (sTemp <> "%PDF-1.4") then
            Warnlog "File doesn't start with '%PDF-1.4' it is: '" + sTemp + "'"
         endif
         '/// the last line has to be '%%EOF' ///'
         sTemp = left(fGetFileText(sPath, -7),5)
         if (sTemp <> "%%EOF") then
            Warnlog "File doesn't end with '%%EOF' it is: '" + sTemp + "'"
         endif
   else
      Warnlog "file was not exported to PDF :-( '" + sPAth + "'"
   endif
endcase

