'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: coption3.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:15 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description : Check Tools->Options->Spreadsheet->Calculate
'*
'************************************************************************
'*
' #1 cOption3                          ' Initial Routine
' #1 tOptionsCalculate_save            ' Check all Calculate Options and change them
' #1 tOptionsCalculate_reload          ' Check if changes persist after exit and restart the office
' #1 tOptionsCalculateRestore_settings ' Restore default settings
' #1 tOptionsCalculate_functionality   ' Test correct functionality of changes
'*
'\***********************************************************************

Global curr_It as integer, flag_It as integer, curr_Case as integer, flag_Case as integer
Global curr_Prec as integer, flag_Prec as integer, curr_Search as integer, flag_Search as integer
Global curr_ColRow as integer, flag_ColRow as integer
Global curr_Steps as string, str_Steps as string, set_Steps as string
Global curr_Change as string, str_Change as string
Global curr_Dec as string, str_Dec as string
Global dStd as integer, dSC as integer, d1904 as integer
Global fStd as integer, fdSC as integer, fd1904 as integer, fSC as Integer
Global str_Date as string
Global minChg as string

'*** Global variables for the functionality test
Global chg_int as boolean, chg_case as boolean, chg_prec as boolean, chg_search as string, chg_ColRow as string
Global cval as string, cval_current as string, boolval as string, precval as string
Global str_search as string

sub cOption3

	printLog Chr(13) + "--------- cOption3 ---------"
	printlog "Tools|Options|Spreadsheet|Calculate"

        call tOptionsCalculate_save
        call tOptionsCalculate_reload
        call tOptionsCalculate_functionality
        call tOptionsCalculateRestore_settings

end sub

'*********************************************************************************************************

testcase tOptionsCalculate_save
'/// This test invokes the "Tools|Options|Spreadsheet|Calculate" dialog and checks the default settings. ///'
'/// If the expected settings are not found a warning for each wrong item is thrown ///'
'/// Then each parameter is modified and the dialog is saved & closed with OK. ///'
'/// After restarting the office the persistence of the stored settings is checked ///'
'/// Correct functionality of the changed options is checked as well  ///'
'/// Finally the original settings are restored. ///'

	' Initialize the variables
    curr_It = 0
    curr_Case = 0
    curr_Prec = 0
    curr_Search = 0
    curr_ColRow = 0
    dStd = 0
    dSC = 0
    d1904 = 0
    curr_Dec = "2"
    curr_Steps = "100"
    precval = ""
    str_search = "Fran"
    select case iSystemSprache
    	case 01:	curr_Change = "0.001":	boolval = "FALSE" 	:cval_current = "0.7391"
    	case 49:	curr_Change = "0,001":   boolval = "FALSCH" :cval_current = "0,7391"
    end select
    chg_int = false
    chg_case = false
    chg_prec = false
    chg_search = false
    chg_ColRow = false

    Call hNewDocument

	' Modify all parameters in this tabpage
  	ToolsOptions
  	hToolsOptions("SPREADSHEET", "CALCULATE")

	' Iterations
    if Iterationen.ischecked then
    	warnlog "<iterations> are enabled by default"
    	curr_It = 1
    	call StepsAndChange()
    	Iterationen.uncheck
    	flag_It = Iterationen.GetState
    else
    	curr_It = 0
    	Iterationen.check
    	call StepsAndChange()
    	flag_It = Iterationen.GetState
    end if

	' Case sensitive
    if GrossKleinschreibung.ischecked then
    	curr_Case = 1
    	GrossKleinschreibung.uncheck
    	flag_Case = GrossKleinschreibung.GetState
    else
    	curr_Case = 0
    	warnlog "<case sensitive> isn't enabled by default"
    	GrossKleinschreibung.check
    	flag_Case = GrossKleinschreibung.GetState
    end if

	' Precision
    if GenauigkeitWieAngezeigt.ischecked then
    	warnlog "<precision as shown> is enabled by default"
    	curr_Prec = 1
    	GenauigkeitWieAngezeigt.uncheck
    	flag_Prec = GenauigkeitWieAngezeigt.GetState
    else
    	curr_Prec = 0
    	GenauigkeitWieAngezeigt.check
    	flag_Prec = GenauigkeitWieAngezeigt.GetState
    end if

	' Search Criteria
    if Suchkriterien.ischecked then
    	curr_Search = 1
    	Suchkriterien.uncheck
    	flag_Search = Suchkriterien.GetState
    else
    	curr_Search = 0
    	warnlog "<search criteria> isn't enabled by default"
    	Suchkriterien.check
    	flag_Search = Suchkriterien.GetState
    end if

	' Automatically find Col/Row headers
    if SpaltenZeilenbeschriftung.ischecked then
    	curr_ColRow = 1
    	SpaltenZeilenbeschriftung.uncheck
    	flag_ColRow = SpaltenZeilenbeschriftung.GetState
    else
    	curr_ColRow = 0
    	warnlog "<automatically find> isn't enabled by default"
    	SpaltenZeilenbeschriftung.check
    	flag_ColRow = SpaltenZeilenbeschriftung.GetState
    end if

	' Decimal Places
	if Nachkommastellen.GetText = curr_Dec then
		printlog "OK, the value for the <decimal places> is correct"
		Nachkommastellen.More 2
		str_Dec = Nachkommastellen.GetText
	else
		warnlog "There are " & Nachkommastellen.GetText & " instead of " & curr_Dec
		Nachkommastellen.SetText curr_Dec
		Nachkommastellen.More 2
		str_Dec = Nachkommastellen.GetText
	end if

	' Date format
	if Standard.ischecked then
		dStd = 1
		StarCalc10.check
		fSC = 1
		str_Date = "SC"
		goto end_if
	elseif StarCalc10.ischecked then
			dSC = 1
			Jahr1904.check
			f1904 = 1
			str_Date = "1904"
			goto end_if
	else
		if Jahr1904.ischecked then
			d1904 = 1
			Standard.check
			fStd = 1
			str_Date = "Std"
			goto end_if
		end if
end_if:
	end if

	Kontext "OptionenDlg"
   	OptionenDlg.OK
    sleep 5
   	Call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsCalculate_reload
'/// Documentation is summarized in tOptionsCalculate_save

    sleep 5
	'Restart the complete office
	ExitRestartTheOffice
	Call hNewDocument

	' Check all parameters in this tabpage
  	ToolsOptions
  	hToolsOptions("SPREADSHEET", "CALCULATE")

    ' Iterations
    if Iterationen.GetState = flag_It then
    chg_int = true
    	printlog "OK, new settings for <iterations> are stored"
    else
    	warnlog "New settings for <iterations> failed"
    end if

    ' Steps and change
    Iterationen.check
    if Schritte.GetText = str_Steps then
    	printlog "OK, new settings for <step width> are stored"
    else
    	warnlog "New settings for  <step width> failed"
    end if
    if MinimalerAenderungswert.GetText = str_Change then
    	printlog "OK, new settings for <minimum change> are stored"
    else
    	warnlog "New settings for <minimum change> failed"
    end if

    ' Case sensitive
    if GrossKleinschreibung.GetState = flag_Case then
    	chg_case = true
    	printlog "OK, new settings for <case sensitive> are stored"
    else
    	warnlog "New settings for <case sensitive> failed"
    end if

    ' Precision
    if GenauigkeitWieAngezeigt.GetState = flag_Prec then
    	chg_prec = true
    	printlog "OK, new settings for <precision as shown> are stored"
    else
    	warnlog "New settings for <precision as shown> failed"
    end if

	' Search Criteria
	if Suchkriterien.GetState = flag_Search then
		chg_search = true
    	printlog "OK, new settings for <search criteria> are stored"
    else
    	warnlog "New settings for <search criteria> failed"
    end if

    ' Automatically find Col/Row headers
    if SpaltenZeilenbeschriftung.GetState = flag_ColRow then
    	chg_ColRow = true
    	printlog "OK, new settings for <automatically find col/rows> are stored"
    else
    	warnlog "New settings for <automatically find col/rows> failed"
    end if

	' Decimal Places
	if Nachkommastellen.GetText = str_Dec then
		printlog "OK, the changed value for <decimal place> is stored"
    else
    	warnlog "The change of value for <decimal place> failed"
    end if

    ' Date format
    select case str_Date
    	case "Std"	: 	if Standard.ischecked then
    						printlog "OK, settings for <dateStarcalc10> are stored"
    					else
    						warnlog "Settings for <dateStarcalc10> failed"
    					end if
    	case "SC"	:	if StarCalc10.ischecked then
    						printlog "OK, settings for <dateStarcalc10> are stored"
    					else
    						warnlog "Settings for <dateStarcalc10> failed"
    					end if
    	case "1904"	:	if Jahr1904.ischecked then
    						printlog "OK, settings for <dateStarcalc10> are stored"
    					else
    						warnlog "Settings for <dateStarcalc10> failed"
    					end if
    end select

    Kontext "OptionenDlg"
   	OptionenDlg.Cancel

   	call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsCalculateRestore_settings
'/// Documentation is summarized in tOptionsCalculate_save

	Call hNewDocument

	' Check all parameters in this tabpage
  	ToolsOptions
  	hToolsOptions("SPREADSHEET", "CALCULATE")

    ' Iterations 	' Steps and change
    if curr_It = 1 then
    	Iterationen.check
    	Schritte.Settext curr_Steps
    	MinimalerAenderungswert.SetText curr_Change
    else
    	if NOT Iterationen.ischecked then Iterationen.check
    	Schritte.Settext curr_Steps
    	MinimalerAenderungswert.SetText curr_Change
    	Iterationen.uncheck
    end if

    ' Case sensitive
    if curr_Case = 1 then
    	GrossKleinschreibung.check
    else
    	GrossKleinschreibung.uncheck
    end if

    ' Precision
    if curr_Prec = 1 then
    	GenauigkeitWieAngezeigt.check
    else
    	GenauigkeitWieAngezeigt.uncheck
    end if

    ' Search Criteria
	if curr_Search = 1 then
		Suchkriterien.check
	else
		Suchkriterien.uncheck
	end if

    ' Automatically find Col/Row headers
    if curr_ColRow = 1 then
    	SpaltenZeilenbeschriftung.check
    else
    	SpaltenZeilenbeschriftung.uncheck
    end if

    ' Decimal Places
    Nachkommastellen.SetText curr_Dec

   	' Date format
   	if dStd = 1 then Standard.check

   	if dSC = 1 then StarCalc10.check

   	if d1904 = 1 then Jahr1904.check

   	Kontext "OptionenDlg"
   	OptionenDlg.OK

   	call hCloseDocument

endcase

'*********************************************************************************************************

testcase tOptionsCalculate_functionality
'/// Documentation is summarized in tOptionsCalculate_save

	Call hNewDocument

	' Check the made settings on their functionality

    ' Iterations 	' Steps and change
    printlog "Check functionality of <iterations>, <steps> and <change>"
	if chg_int then
		if flag_It = 1 then
			call insVal()
  		else
  			printlog "Check <iterations>"
  			ToolsOptions
  			hToolsOptions("SPREADSHEET", "CALCULATE")
        	Iterationen.check
        	call StepsAndChange()
        	Kontext "OptionenDlg"
   			OptionenDlg.OK
   			call insVal()
   		end if
   	else
   		warnlog "Unexpected settings of options -> test failed" 
	end if

   	call hCloseDocument
   	call hNewDocument

   	' Case sensitive
   	printlog "Check functionality for <case sensitive>"
   	if chg_case then
   		if flag_Case = 1 then
   			call CaseSensitive()
   		else
   			ToolsOptions
   			hToolsOptions("SPREADSHEET", "CALCULATE")
            GrossKleinschreibung.check
            Kontext "OptionenDlg"
   			OptionenDlg.OK
   			call CaseSensitive()
   		end if
   	else
   		warnlog "Unexpected settings of options -> test failed"
   	end if

	call hCloseDocument
	call hNewDocument

	' Precision
	printlog "Check functionality for <precision as shown>"
	if chg_prec then
    	if flag_Prec = 1 then
    		call Precision()
    	else
   			ToolsOptions
   			hToolsOptions("SPREADSHEET", "CALCULATE")
    		GenauigkeitWieAngezeigt.check
    		Kontext "OptionenDlg"
   			OptionenDlg.OK
   			call Precision()
    	end if
    else
    	warnlog "Unexpected settings of options -> test failed"
    end if

	call hCloseDocument
	sleep 5
	printlog "open file " & convertpath(gtesttoolpath & "calc/options/input/dcount.sxc")
	call hDateiOeffnen convertpath(gtesttoolpath & "calc/options/input/dcount.sxc")

	' Search Criteria
	printlog "Check functionality for <search criteria>"
	if chg_search then
		if flag_Search = 1 then
			call Search()
		else
			ToolsOptions
			hToolsOptions("SPREADSHEET", "CALCULATE")
    		Suchkriterien.check
    		Kontext "OptionenDlg"
   			OptionenDlg.OK
   			call Search()
   		end if
   	else
   		warnlog "Unexpected settings of options -> test failed"
    end if

    call hCloseDocument
    sleep 5
	printlog "open file " & convertpath(gtesttoolpath & "calc/options/input/rcheader.sxc")
    call hDateiOeffnen convertpath(gtesttoolpath & "calc/options/input/rcheader.sxc")

    ' Automatically find Col/Row headers
    printlog "Check functionality for <automatically find col/row headers>"
    if chg_ColRow then
    	if flag_ColRow = 1 then
    		call ColRow()
    	else
			ToolsOptions
			hToolsOptions("SPREADSHEET", "CALCULATE")
    		SpaltenZeilenbeschriftung.check
            Kontext "OptionenDlg"
   			OptionenDlg.OK
   			call hCloseDocument
   			call hDateiOeffnen convertpath(gtesttoolpath & "calc/options/input/rcheader.sxc")
            call ColRow()
      	end if
  	else
  		warnlog "Unexpected settings of options -> test failed"
    end if

    call hCloseDocument
    call hNewDocument

    ' Decimal Places
    printlog "Check functionality for <decimal places>"
    if str_Dec = "4" then
    	call Decimal()
    else
    	ToolsOptions
    	hToolsOptions("SPREADSHEET", "CALCULATE")
    	Nachkommastellen.SetText "4"
    	Kontext "OptionenDlg"
   		OptionenDlg.OK
   		call Decimal()
   	end if

   	call hCloseDocument
   	sleep 5
   	convertpath(gtesttoolpath & "calc/options/input/dateformat.sxc")
   	call hDateiOeffnen convertpath(gtesttoolpath & "calc/options/input/dateformat.sxc")

   	' Date format

   	printlog "Check functionality for <date format>"

    ' set the date formats on the options dialog to standard
    printlog "Set the date formats on the options dialog to standard"
    ToolsOptions
    hToolsOptions("SPREADSHEET", "CALCULATE")
    Standard.check
    Kontext "OptionenDlg"
   	OptionenDlg.OK
   	'if iSystemSprache = 1 then
   	'	printlog "set Dateformat in english"
   	'	call Dateformat("12/30/1899", "Standard")
   	'else
   		call Dateformat("30.12.1899", "Standard")
   	'end if

   	' set the date formats on the options dialog to StarCalc 1.0
   	printlog "Set the date formats on the options dialog to StarCalc 1.0"
   	ToolsOptions
   	hToolsOptions("SPREADSHEET", "CALCULATE")
   	StarCalc10.check
   	Kontext "OptionenDlg"
   	OptionenDlg.OK
   	'if iSystemSprache = 1 then
   	'	printlog "set Dateformat in english"
   	'	call Dateformat("01/01/1900", "StarCalc 1.0")
   	'else
   		call Dateformat("01.01.1900", "StarCalc 1.0")
   	'end if

   	' set the date formats on the options dialog to 1904
   	printlog "Set the date formats on the options dialog to 1904"
   	ToolsOptions
   	hToolsOptions("SPREADSHEET", "CALCULATE")
   	Jahr1904.check
   	Kontext "OptionenDlg"
   	OptionenDlg.OK
   	'if iSystemSprache = 1 then
   	'	printlog "set Dateformat in english"
   	'	call Dateformat("01/01/1904", "1904")
   	'else
   		call Dateformat("01.01.1904", "1904")
   	'end if
   	sleep 3

   	call hCloseDocument

endcase

