'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: calculat.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 14:58:27 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description : Detailed test for functions 
'*
'************************************************************************
'*
' #1 calculat  ' initial routine
' #1 tDatenB   ' Database functions      
' #1 tMinimal  ' Functions that are used in calc short test
' #1 tDezimal  ' Functions for converting decimal, binary etc.
' #1 tDatum    ' Date and Time functoins
' #1 tFinanz   ' Financial functions
' #1 tInformat ' Information functions
' #1 tLogic    ' Logic functions
'*
'\***********************************************************************

sub calculat
Printlog Chr(13) + "--------- calculat ---------"
   call tDatenB
   call tMinimal
   call tDezimal
   call tDatum
   call tFinanz
   call tInformat
   call tLogic
end sub

testcase tDatenB
'/// This testcase checks the results from the file "gtesttoolpath & "calc\special\input\datenb.xls" ///
     Dim file$
     Dim i, r As Integer
     Dim cell as String
     file$ = convertpath (gtesttoolpath & "calc\special\input\datenb.xls")

     call hDateiOeffnen file$
     Kontext "DocumentCalc"
       DocumentCalc.TypeKeys "<Mod1 Shift F9>"
       For i = 4 to 8
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       For i = 10 to 14
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       For i = 16 to 20
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       For i = 22 to 25
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

     Kontext "DocumentCalc"
       DocumentCalc.TypeKeys "<Mod1 Shift F9>"

       For i = 28 to 32
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       For i = 34 to 38
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       For i = 40 to 44
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

     Kontext "DocumentCalc"
       DocumentCalc.TypeKeys "<Mod1 Shift F9>"

       For i = 46 to 50
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       call checkcellwert("A52", 0)

     Kontext "DocumentCalc"
       DocumentCalc.TypeKeys "<Mod1 Shift F9>"

       call checkcellwert("A56", 0)

       For i = 58 to 62
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       For i = 64 to 68
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       call checkcellwert("A70", 0)


       call checkcellwert("A74", 0)

     call hCloseDocument

endcase

testcase tMinimal
'/// This testcase check the results from "gtesttoolpath & "calc\special\input\minimal.sdc" ///
'/// They should be A1=1,2; A2=Err503; A3=3,14. ///

     Dim file$, error503$, sDelimiter$
     file$ = convertpath(gtesttoolpath & "calc\special\input\minimal.sdc")
     sDelimiter$ = getDecimalSeperator()
     
     select case iSprache
               case 01 : error503$ = "Err:503"
               case 31 : error503$ = "Err:503"
               case 33 : error503$ = "Err :503"
               case 34 : error503$ = "Err:503"
               case 39 : error503$ = "Err:503"
               case 46 : error503$ = "Err:503"
               case 49 : error503$ = "Err:503"
               case 55 : error503$ = "Erro:503"
               case 81 : error503$ = "エラー:503"
               case 82 : error503$ = "오류:503"
               case 86 : error503$ = "错误:503"
               case 88 : error503$ = "錯誤：503"
               case else : QAErrorLog "This testcase is only designed to run on BIG 10 languges"
                           goto endsub
     end select

     call hDateiOeffnen file$
     Kontext "DocumentCalc"
       DocumentCalc.TypeKeys "<Mod1 Shift F9>"
       call checkcellwert("A1", "1" & sDelimiter$ & "2")
       call checkcellwert("A2",  error503$)
       call checkcellwert("A3", "3" & sDelimiter$ & "14")

     call hCloseDocument

endcase

testcase tDezimal
'/// This testcase check the function "Dezimal" in file gtesttoolpath & "calc\special\input\dezimal.sdc"
'/// Reference Values for D7=65535; D8=65535; D9=32767. ///

     Dim file$
     file =  convertpath(gtesttoolpath & "calc\special\input\dezimal.sdc")

     call hDateiOeffnen file$
     Kontext "DocumentCalc"
       DocumentCalc.TypeKeys "<Mod1 Shift F9>"
       call checkcellwert("D7", 65535)
       call checkcellwert("D8", 65535)
       call checkcellwert("D9", 32767)

     call hCloseDocument

endcase


testcase tDatum
'/// Open a Excel Document with several date/time functions
'/// Check if results are correct 
     Dim file$
     Dim cell as string
     Dim i as integer
     file$ = convertpath(gtesttoolpath & "calc\special\input\datum.xls")
     
    if iSystemsprache <> 01 then
       QAErrorLog "Sorry, this Testcase only runs on locale en_US"
       goto endsub
    end if


     call hDateiOeffnen file$
     Kontext "DocumentCalc"
       DocumentCalc.TypeKeys "<Mod1 Shift F9>"

       For i = 3 to 7
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       For i = 9 to 13
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       call checkcellwert("A15", 0)

       For i = 17 to 19
           cell = "A" & i
           call checkcellwert(cell, 0)
       next i

       For i = 21 to 25
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       For i = 27 to 31
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       For i = 33 to 37
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       call checkcellwert("A39", 0)

       For i = 41 to 43
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       For i = 47 to 51
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       For i = 53 to 56
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       For i = 59 to 63
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       For i = 67 to 71
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

       For i = 73 to 77
           cell = "A" & i
           call checkcellwert(cell, 0)
       Next i

     call hCloseDocument

endcase


testcase tFinanz
'/// Open Excel file with financial functions
'/// Check for correct results
        Dim file$
        Dim cell as string
        Dim i as integer

        file$ = convertpath(gtesttoolpath & "calc\special\input\finanz.xls")

        call hDateiOeffnen file$
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Shift F9>"

        For i = 4 to 8
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 10 to 14
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 16 to 20
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 22 to 26
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 28 to 32
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 34 to 38
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 40 to 44
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 46 to 50
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 53 to 57
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 59 to 63
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 65 to 69
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 72 to 76
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 78 to 82
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i


        call hCloseDocument

endcase


testcase tInformat
'/// Open Excel file with information functions
'/// Check for correct results

        Dim file$
        Dim cell as string
        Dim i as integer

        file$ = convertpath(gtesttoolpath & "calc\special\input\informat.xls")

        call hDateiOeffnen file$

        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Shift F9>"

        For i = 7 to 11
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 13 to 14
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 16 to 18
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 20 to 24
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 26 to 27
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 29 to 31
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 33 to 35
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 37 to 40
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i


        For i = 42 to 46
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        For i = 48 to 52
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        dim Content$
        select case iSprache
                case 01: Content$ = "#N/A"
                case 31: Content$ = "#NB"
                case 33: Content$ = "#NA"
                case 34: Content$ = "#N/A"
                case 39: Content$ = "#N/D"
                case 46: Content$ = "#Saknas"
                case 49: Content$ = "#NV"
                case 55: Content$ = "#N/D"
                case 81: Content$ = "#N/A"
                case 82: Content$ = "#N/A"
                case 86: Content$ = "#N/V"
                case 88: Content$ = "#N/V"
                case else : QAErrorLog "We guess for non BIG 10 languges."
                            QAErrorLog "A warnlog might appear for cell A54!"
                            Content$ = "#N/A"
        end select
        call checkcellwert("A54", Content$)

        For i = 56 to 58
                cell = "A" & i
                call checkcellwert(cell, 0)
        Next i

        call checkcellwert("A59", -1)

        call hCloseDocument

endcase


testcase tLogic
'/// Open Excel file with logic functions
'/// Check for correct results

        Dim file$
        Dim cell as string
        Dim i as integer

        file$ = convertpath(gtesttoolpath & "calc\special\input\logisch.xls")
        call hDateiOeffnen file$

        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<Mod1 Shift F9>"

        call checkcellwert("A3", 0)
        call checkcellwert("A4", 0)

        call checkcellwert("A6", 0)
        call checkcellwert("A7", 0)

        call checkcellwert("A9", "Zuviel")
        call checkcellwert("A10", "Gehälter OK")
        call checkcellwert("A11", "Mindestgehalt zu niedrig")

        call hCloseDocument

endcase


