'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: un_redo2.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:25 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description :  Complete Test for the undo/redo function which test
'*
'************************************************************************
'*
' #1 un_redo2      ' Initial routinr
' #1 tFormat_Cell2 ' Format cell Aligment/Border/Prodect - Undo/Redo - Check correct settings
'*
'\***********************************************************************

sub un_redo2

Printlog Chr(13) + "--------- FormatCell2 ---------"

        call tFormat_Cell2

end sub

'**************************************************************************************************

testcase tFormat_Cell2

'/// Open a new calc document, call the menuitem 'FormatCells', goto tabpage 'Aligmnent'
'/// and increase left by 10 times
   call hNewDocument
   Printlog ""
   Printlog "* TabPage Borders"
   dim left_str, left_current as string
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   left_current = Links.GetText
   Kontext "TabUmrandung"
   Links.more 10
   left_str = Links.GetText
   if Links.GetText= left_str then
      printlog "OK, the left has been modified"
   else
      warnlog "The left hasn't been modified"
   end if
   Kontext
   TabUmrandung.OK

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if Links.GetText =  left_current then
      printlog "OK, the left has been reset to current"
   else
      warnlog "The left hasn't been reset to current"
   end if
   Kontext
   TabUmrandung.Cancel

   'check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   'printlog "val(Links.GetText" & val(Links.GetText
   'printlog "val(left_str)" & val(left_str)
   'printlog "Diffresult " & (val(Links.GetText) - val(left_str))
   if abs(val(Links.GetText) - val(left_str)) <= 1 then
      printlog "OK, redo works"
   else
      warnlog "The redo-function doesn't work"
   end if
   Kontext
   TabUmrandung.Cancel
   EditUndo
        '____________________________________________________________________________________________

   dim right_str, right_current as string
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   right_current = Rechts.GetText
   Rechts.more 10
   right_str = Rechts.GetText
   if Rechts.GetText= right_str then
      printlog "OK, the right has been modified"
   else
      warnlog "The right hasn't been modified"
   end if
   Kontext
   TabUmrandung.OK

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if Rechts.GetText =  right_current then
      printlog "OK, the right has been reset to current"
   else
      warnlog "The right hasn't been reset to current"
   end if
   Kontext
   TabUmrandung.Cancel

'/// Check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if abs(val(Rechts.GetText) - val(right_str)) <= 1 then
      printlog "OK, redo works"
   else
      warnlog "The redo-function doesn't work"
   end if
   Kontext
   TabUmrandung.Cancel
   EditUndo
   '____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Alignment' and increase top by 10 times
   dim top_str as double, top_current as double, resultstr as double
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   top_current = val(Oben.GetText)
   printlog "Values before set"
   printlog "Oben.GetText:" & val(Oben.GetText)
   printlog "top_current:" & top_current
   Kontext "TabUmrandung"
   Oben.more 10
   top_str = Oben.GetText
   printlog "Values after set"
   printlog "Oben.GetText:" & val(Oben.GetText)
   printlog "top_current:" & top_current
   if val(Oben.GetText) > val(top_current) then
      printlog "OK, the top has been modified"
   else
      warnlog "The top hasn't been modified"
   end if
   Kontext
   TabUmrandung.OK

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   printlog "Values after undo"
   printlog "Oben.GetText:" & val(Oben.GetText)
   printlog "top_current:" & top_current
   resultstr = (val(Oben.GetText) - val(top_current))
   printlog "resultstr:" & str(resultstr)
   if val(resultstr) <= 1 then
      printlog "OK, the top has been reset to current"
   else
      warnlog "The top hasn't been reset to current"
   end if
   Kontext
   TabUmrandung.Cancel

'/// Ceck if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   printlog "Values after redo"
   printlog "Oben.GetText:" & val(Oben.GetText)
   printlog "top_current:" & top_current
   resultstr = (val(Oben.GetText) - val(top_current))
   printlog "resultstr:" & resultstr
   if val(resultstr) > 0 then
      printlog "OK, redo works"
   else
      warnlog "The redo-function doesn't work"
   end if
   Kontext
   TabUmrandung.Cancel
   EditUndo
   '____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Alignment' and increase bottom by 10 times
   dim bottom_str, bottom_current as string
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   bottom_current = Unten.GetText
   Kontext "TabUmrandung"
   Unten.more 10
   bottom_str = Unten.GetText
   if Unten.GetText= bottom_str then
      printlog "OK, the bottom has been modified"
   else
      warnlog "The bottom hasn't been modified"
   end if
   Kontext
   TabUmrandung.OK

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if Unten.GetText =  bottom_current then
      printlog "OK, the bottom has been reset to current"
   else
      warnlog "The bottom hasn't been reset to current"
   end if
   Kontext
   TabUmrandung.Cancel

'/// Check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if abs(val(Unten.GetText) - val(bottom_str)) <= 1 then
      printlog "OK, redo works"
   else
      warnlog "The redo-function doesn't work"
   end if
   Kontext
   TabUmrandung.Cancel
   EditUndo
   '____________________________________________________________________________________________

'   Printlog ""
'   Printlog "* TabPage Borders"

'/// Call the menuitem 'FormatCells', goto tabpage 'Border' and select fonstyle nr 3
   dim borderstyle_id as integer
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   Vorgaben.typekeys "<RIGHT RIGHT RIGHT>"
   borderstyle_id = Stil.GetSelIndex
   Stil.select 3
   Kontext
   TabUmrandung.OK

'/// Check if the modify has been taken over
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if Stil.GetSelIndex = 3 then
      printlog "OK, the borderstyle has been changed"
   else
      warnlog "The borderstyle hasn't been changed"
   end if
   Kontext
   TabUmrandung.Cancel

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if Stil.GetSelIndex = borderstyle_id then
      printlog "OK, the borderstyle has been reset to current"
   else
      warnlog "The borderstyle hasn't been reset to current"
   end if
   Kontext
   TabUmrandung.Cancel

'/// Check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if Stil.GetSelIndex = 3 then
      printlog "OK, redo works"
   else
      warnlog "The redo-function doesn't work"
   end if
   Kontext
   TabUmrandung.Cancel
   EditUndo

   '____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Border' and select color 3
   dim color_id
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   Vorgaben.typekeys "<RIGHT RIGHT RIGHT>"
   color_id = StilFarbe.GetSelIndex
   StilFarbe.select 3
   Kontext
   TabUmrandung.OK

'/// Check if the modify has been taken over
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if StilFarbe.GetSelIndex = 3 then
      printlog "OK, the colorstyle has been changed"
   else
      warnlog "The colorstyle hasn't been changed"
   end if
   Kontext
   TabUmrandung.Cancel

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if StilFarbe.GetSelIndex = color_id then
      printlog "OK, the colorstyle has been reset to current"
   else
      warnlog "The colorstyle hasn't been reset to current"
   end if
   Kontext
   TabUmrandung.Cancel

'/// Check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if StilFarbe.GetSelIndex = 3 then
      printlog "OK, redo works"
   else
      warnlog "The redo-function doesn't work"
   end if
   Kontext
   TabUmrandung.Cancel
   EditUndo

   '____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Border' and select borderposition 2
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   Position.typekeys "<RIGHT>"
   Kontext
   TabUmrandung.OK

'/// Check if the modify has been taken over
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if Groesse.IsEnabled then
      printlog "OK, the shadowposition has been changed"
   else
      warnlog "The shadowposition hasn't been changed"
   end if
   Kontext
   TabUmrandung.Cancel

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if NOT Groesse.IsEnabled then
      printlog "OK, the shadowposition has been reset to current"
   else
      warnlog "The shadowposition hasn't been reset to current"
   end if
   Kontext
   TabUmrandung.Cancel

'/// Check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if Groesse.IsEnabled then
      printlog "OK, redo works"
   else
      warnlog "The redo-function doesn't work"
   end if
   Kontext
   TabUmrandung.Cancel
   EditUndo

   '____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Border' anf slect borderposition 3
   dim shadowsize_str, shadowsize_current as string
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   Position.typekeys "<RIGHT>"
   shadowsize_current = Groesse.GetText
   Groesse.More 3
   shadowsize_str = Groesse.GetText
   Kontext
   TabUmrandung.OK

'/// Check if the modify has been taken over
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if Groesse.GetText = shadowsize_str then
      printlog "OK, the shadowsize has been changed"
   else
      warnlog "The shadowsize hasn't been changed"
   end if
   Kontext
   TabUmrandung.Cancel

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if Groesse.GetText = shadowsize_current then
      printlog "OK, the shadowsize has been reset to current"
   else
      warnlog "The shadowsize hasn't been reset to current"
   end if
   Kontext
   TabUmrandung.Cancel

'/// Check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if Groesse.GetText = shadowsize_str then
      printlog "OK, redo works"
   else
      warnlog "The redo-function doesn't work"
   end if
   Kontext
   TabUmrandung.Cancel
   EditUndo

   '____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Border' and select shadow color 3
   dim shadowcolor_id, shadowcolor_current as integer
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   Position.typekeys "<RIGHT>"
   shadowcolor_current = SchattenFarbe.GetSelIndex
   SchattenFarbe.Select 3
   shadowcolor_id = SchattenFarbe.GetSelIndex
   Kontext
   TabUmrandung.OK

'/// Check if the modify has been taken over
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if SchattenFarbe.GetSelIndex = shadowcolor_id then
      printlog "OK, the shadowcolor has been changed"
   else
      warnlog "The shadowcolor hasn't been changed"
   end if
   Kontext
   TabUmrandung.Cancel

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if SchattenFarbe.GetSelIndex = shadowcolor_current then
      printlog "OK, the shadowcolor has been reset to current"
   else
      warnlog "The shadowcolor hasn't been reset to current"
   end if
   Kontext
   TabUmrandung.Cancel

'/// Check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage TabUmrandung
   Kontext "TabUmrandung"
   if SchattenFarbe.GetSelIndex = shadowcolor_id then
      printlog "OK, redo works"
   else
      warnlog "The redo-function doesn't work"
   end if
   Kontext
   TabUmrandung.Cancel
   EditUndo
   call hCloseDocument

   '____________________________________________________________________________________________

   call hNewDocument
   Printlog ""
   Printlog "* TabPage CellProtection"

'/// Call the menuitem 'FormatCells', goto tabpage 'Protect' and uncheck closed
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   Gesperrt.UnCheck
   Kontext
   TabZellschutz.OK

'/// Check if the modify has been taken over
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   if NOT Gesperrt.IsChecked then
      printlog "OK, the state of cell protection has been changed"
   else
      warnlog "The state of cell protection hasn't been changed"
   end if
   Kontext
   TabZellschutz.Cancel

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   if Gesperrt.IsChecked then
      printlog "OK, the state of cell protection has been reset to current"
   else
      warnlog "The state of cell protection hasn't been reset to current"
   end if
   Kontext
   TabZellschutz.Cancel

'/// Check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   if NOT Gesperrt.IsChecked then
      printlog "OK, redo works"
   else
      warnlog "The redo-function doesn't work"
   end if
   Kontext
   TabZellschutz.Cancel
   EditUndo

   '____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Protect' and check hide formula
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   FormelAusblenden.Check
   Kontext
   TabZellschutz.OK

'/// Check if the modify has been taken over
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   if FormelAusblenden.IsChecked then
      printlog "OK, the state of hide formula has been changed"
   else
      warnlog "The state of hide formula hasn't been changed"
   end if
   Kontext
   TabZellschutz.Cancel

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   if NOT FormelAusblenden.IsChecked then
      printlog "OK, the state of hide formula has been reset to current"
   else
      warnlog "The state of hide formula hasn't been reset to current"
   end if
   Kontext
   TabZellschutz.Cancel

'/// Check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   if FormelAusblenden.IsChecked then
      printlog "OK, redo works"
   else
      warnlog "The redo-function doesn't work"
   end if
   Kontext
   TabZellschutz.Cancel
   EditUndo

   '____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Protect' and check hide all
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   AllesAusblenden.Check
   Kontext
   TabZellschutz.OK

'/// Check if the modify has been taken over
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   if AllesAusblenden.IsChecked then
      printlog "OK, the state of hide all has been changed"
   else
      warnlog "The state of hide all hasn't been changed"
   end if
   Kontext
   TabZellschutz.Cancel

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   if NOT AllesAusblenden.IsChecked then
      printlog "OK, the state of hide all has been reset to current"
   else
      warnlog "The state of hide all hasn't been reset to current"
   end if
   Kontext
   TabZellschutz.Cancel

'/// Check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   if AllesAusblenden.IsChecked then
      printlog "OK, redo works"
   else
      warnlog "The redo-function doesn't work"
   end if
   Kontext
   TabZellschutz.Cancel
   EditUndo

   '____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Protect' and check hide for print
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   FuerAusdruckAusblenden.Check
   Kontext
   TabZellschutz.OK

'/// Check if the modify has been taken over
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   if FuerAusdruckAusblenden.IsChecked then
      printlog "OK, the state of hide for printing out has been changed"
   else
      warnlog "The state of hide for printing out hasn't been changed"
   end if
   Kontext
   TabZellschutz.Cancel

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   if NOT FuerAusdruckAusblenden.IsChecked then
      printlog "OK, the state of hide for printing out has been reset to current"
   else
      warnlog "The state of hide for printing out hasn't been reset to current"
   end if
   Kontext
   TabZellschutz.Cancel

'/// Check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage TabZellschutz
   Kontext "TabZellschutz"
   if FuerAusdruckAusblenden.IsChecked then
      printlog "OK, redo works"
   else
      warnlog "The redo-function doesn't work"
   end if
   Kontext
   TabZellschutz.Cancel
   EditUndo

   '____________________________________________________________________________________________

   call hCloseDocument
endcase


