'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: un_redo3.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:25 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
 ' ** short description	:	Complete Test for the undo/redo function which test
'*
'************************************************************************
'*
' #1 un_redo3     ' Initial routine
' #1 tFormat_Page ' Format Page - Undo/Redo - Check correct settings
'*
'\***********************************************************************

sub un_redo3

Printlog Chr(13) + "--------- FormatPage ---------"

        call tFormat_Page

end sub

'**************************************************************************************************

testcase tFormat_Page

'/// Open a new calc document, call the menuitem 'FormatPage', goto tabpage 'Page'
'/// and increase left by 3 times
	dim pageLeft_str, pageLeft_current as string
	call hNewDocument
	Printlog ""
	Printlog "* TabPage Page"
	FormatPageCalc
	Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	pageLeft_current = Links.GetText
   Links.More 3
   pageLeft_str = Links.GetText
   Kontext
   TabSeite.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Links.GetText = pageLeft_str then
		printlog "OK, the site edge left has been modified"
	else
		warnlog "The site edge left hasn't been modified"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
        Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Links.GetText = pageLeft_current then
		printlog "OK, the site edge left has beenreset to current"
	else
		warnlog "The site edge left hasn't been to current"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the redo-function works
	EditRedo
	FormatPageCalc
        Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Links.GetText = pageLeft_str then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabSeite.Cancel
	'_________________________________________________________________________________________________

'/// Call the menuitem 'FormatPage', goto tabpage 'Page' and increase rigth by 3 times
   dim pageRight_str, pageRight_current as string
   FormatPageCalc
   Kontext
   active.setpage TabSeite
   Kontext "TabSeite"
   pageRight_current = Rechts.GetText
   Rechts.More 3
   pageRight_str = Rechts.GetText
   Kontext
   TabSeite.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if   

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Rechts.GetText = pageRight_str then
		printlog "OK, the site edge right has been modified"
	else
		warnlog "The site edge right hasn't been modified"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Rechts.GetText = pageRight_current then
		printlog "OK, the site edge right has beenreset to current"
	else
		warnlog "The site edge right hasn't been to current"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the redo-function works
	EditRedo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Rechts.GetText = pageRight_str then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabSeite.Cancel
	'_________________________________________________________________________________________________


'/// Call the menuitem 'FormatPage', goto tabpage 'Page' and increase top by 3 times
	dim pageTop_str, pageTop_current as string
	FormatPageCalc
	Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	pageTop_current = Oben.GetText
   Oben.More 3
   pageTop_str = Oben.GetText
   Kontext
   TabSeite.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if   

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Oben.GetText = pageTop_str then
		printlog "OK, the site edge top has been modified"
	else
		warnlog "The site edge top hasn't been modified"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Oben.GetText = pageTop_current then
		printlog "OK, the site edge top has beenreset to current"
	else
		warnlog "The site edge top hasn't been to current"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the redo-function works
	EditRedo
	FormatPageCalc
        Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Oben.GetText = pageTop_str then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabSeite.Cancel
	'_________________________________________________________________________________________________

'/// Call the menuitem 'FormatPage', goto tabpage 'Page' and increase bottom by 3 times

	dim pageBottom_str, pageBottom_current as string
	FormatPageCalc
	Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	pageBottom_current = Unten.GetText
   Unten.More 3
   pageBottom_str = Unten.GetText
   Kontext
   TabSeite.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Unten.GetText = pageBottom_str then
		printlog "OK, the site edge bottom has been modified"
	else
		warnlog "The site edge bottom hasn't been modified"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Unten.GetText = pageBottom_current then
		printlog "OK, the site edge bottom has beenreset to current"
	else
		warnlog "The site edge bottom hasn't been to current"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the redo-function works
	EditRedo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Unten.GetText = pageBottom_str then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabSeite.Cancel
	'_________________________________________________________________________________________________

'/// Call the menuitem 'FormatPage', goto tabpage 'Page' and select layout nr 3

	dim pagePageLayout_int, pagePageLayout_current as integer
	FormatPageCalc
	Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	pagePageLayout_current = Seitenlayout.GetSelIndex
   Seitenlayout.Select 3
   pagePageLayout_int = Seitenlayout.GetSelIndex
   Kontext
   TabSeite.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Seitenlayout.GetSelIndex = pagePageLayout_int then
		printlog "OK, the page layout has been modified"
	else
		warnlog "The page layout hasn't been modified"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
        Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Seitenlayout.GetSelIndex = pagePageLayout_current then
		printlog "OK, the page layout has beenreset to current"
	else
		warnlog "The page layout hasn't been to current"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the redo-function works
	EditRedo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Seitenlayout.GetSelIndex = pagePageLayout_int then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabSeite.Cancel
	'_________________________________________________________________________________________________

'/// Call the menuitem 'FormatPage', goto tabpage 'Page' and select numbering nr 3
	dim pageCounting_int, pageCounting_current as integer
	FormatPageCalc
	Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	pageCounting_current = Numerierung.GetSelIndex
   Numerierung.Select 3
   pageCounting_int = Numerierung.GetSelIndex
   Kontext
   TabSeite.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Numerierung.GetSelIndex = pageCounting_int then
		printlog "OK, the counting has been modified"
	else
		warnlog "The counting hasn't been modified"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
	Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Numerierung.GetSelIndex = pageCounting_current then
		printlog "OK, the counting has beenreset to current"
	else
		warnlog "The counting hasn't been to current"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the redo-function works
	EditRedo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Numerierung.GetSelIndex = pageCounting_int then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabSeite.Cancel
	'_________________________________________________________________________________________________

'/// Call the menuitem 'FormatPage', goto tabpage 'Page' and select paperformat 3
	dim pagePaperFormat_int, pagePaperFormat_current as integer
	FormatPageCalc
	Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	pagePaperFormat_current = Papierformat.GetSelIndex
   Papierformat.Select 3
   pagePaperFormat_int = Papierformat.GetSelIndex
   Kontext
   TabSeite.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Papierformat.GetSelIndex = pagePaperFormat_int then
		printlog "OK, the paper format has been modified"
	else
		warnlog "The paper format hasn't been modified"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Papierformat.GetSelIndex = pagePaperFormat_current then
		printlog "OK, the paper format has beenreset to current"
	else
		warnlog "The paper format hasn't been to current"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the redo-function works
	EditRedo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Papierformat.GetSelIndex = pagePaperFormat_int then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabSeite.Cancel
	'_________________________________________________________________________________________________

'/// Call the menuitem 'FormatPage', goto tabpage 'Page' and increase width by 3 times
	dim pageWidth_str, pageWidth_current as string
	FormatPageCalc
	Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	pageWidth_current = Breite.GetText
   Breite.More 3
   pageWidth_str = Breite.GetText
   Kontext
   TabSeite.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Breite.GetText = pageWidth_str then
		printlog "OK, the width has been modified"
	else
		warnlog "The width hasn't been modified"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Breite.GetText = pageWidth_current then
		printlog "OK, the width has beenreset to current"
	else
		warnlog "The width hasn't been to current"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the redo-function works
	EditRedo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Breite.GetText = pageWidth_str then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabSeite.Cancel
	'_________________________________________________________________________________________________

'/// Call the menuitem 'FormatPage', goto tabpage 'Page' and increase height by 3 times
	dim pageHeigth_str, pageHeigth_current as string
	FormatPageCalc
	Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	pageHeigth_current = Hoehe.GetText
   Hoehe.More 3
   pageHeigth_str = Hoehe.GetText
   Kontext
   TabSeite.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Hoehe.GetText = pageHeigth_str then
		printlog "OK, the heigth has been modified"
	else
		warnlog "The heigth hasn't been modified"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Hoehe.GetText = pageHeigth_current then
		printlog "OK, the heigth has beenreset to current"
	else
		warnlog "The heigth hasn't been to current"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the redo-function works
	EditRedo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Hoehe.GetText = pageHeigth_str then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabSeite.Cancel
	'_________________________________________________________________________________________________

'/// Call the menuitem 'FormatPage', goto tabpage 'Page' and toggle flag for orientation
	dim portrait, portraitCurrent as boolean
	FormatPageCalc
	Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	portrait = false
	portraitCurrent = false
   if Hoch.IsChecked then
   	Quer.Check
      portrait = false
   else
   	Hoch.Check
   	portrait = true
   end if
   portraitCurrent = portrait
   Kontext
   TabSeite.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Hoch.IsChecked then
		portrait = true
	else
		portrait = false
	end if
	if portrait = portraitCurrent then
		printlog "OK, the side adjustment has been modified"
	else
		warnlog "The side adjustment hasn't been modified"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the undo-function works
	EditUndo
	if portraitCurrent = false then
	 	portraitCurrent = true
	else
		portraitCurrent = false
	end if

	FormatPageCalc
        Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Hoch.IsChecked then
		portrait = true
	else
		portrait = false
	end if
	if portrait = portraitCurrent then
		printlog "OK, the side adjustment has been reset to current"
	else
		warnlog "The side adjustment hasn't been reset to current"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the redo-function works
	EditRedo
	if portraitCurrent = false then
	 	portraitCurrent = true
	else
		portraitCurrent = false
	end if
	FormatPageCalc
        Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Hoch.IsChecked then
		portrait = true
	else
		portrait = false
	end if
	if portrait = portraitCurrent then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabSeite.Cancel
	'_________________________________________________________________________________________________

'/// Call the menuitem 'FormatPage', goto tabpage 'Page' and select paper tray entry nr 3
	dim pagePrinter_int, pagePrinter_current as integer
	FormatPageCalc
	Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	pagePrinter_current = Schacht.GetSelIndex
   try
   	Schacht.Select 3
   catch
'/// if no other option is available (in depend of the printer) take the first entry
   	Schacht.select 1
   endcatch
   pagePrinter_int = Schacht.GetSelIndex
   Kontext
   TabSeite.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Schacht.GetSelIndex = pagePrinter_int then
		printlog "OK, the printer setting has been modified"
	else
		warnlog "The printer setting hasn't been modified"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Schacht.GetSelIndex = pagePrinter_current then
		printlog "OK, the printer setting has beenreset to current"
	else
		warnlog "The printer setting hasn't been to current"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the redo-function works
	EditRedo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Schacht.GetSelIndex = pagePrinter_int then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabSeite.Cancel
	'_________________________________________________________________________________________________

'/// Call the menuitem 'FormatPage', goto tabpage 'Page' and check table alignment horizontal
	FormatPageCalc
	Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
   Horizontal.Check
   Kontext
   TabSeite.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check ifthe modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Horizontal.IsChecked then
		printlog "OK, horicontal is checked"
	else
		warnlog "Horicontal isn't checked"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if NOT Horizontal.IsChecked then
		printlog "OK, horicontal has been reset to current"
	else
		warnlog "Horicontal hasn't been reset to current"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the redo-function works
	EditRedo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Horizontal.IsChecked then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabSeite.Cancel
	'_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Page' and check table alignment vertical
	FormatPageCalc
	Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
   Vertikal.Check
   Kontext
   TabSeite.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Vertikal.IsChecked then
		printlog "OK, vertical is checked"
	else
		warnlog "Horicontal isn't checked"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if NOT Vertikal.IsChecked then
		printlog "OK, vertical has been reset to current"
	else
		warnlog "Vertical hasn't been reset to current"
	end if
	Kontext
	TabSeite.Cancel

'/// check if the redo-function works
	EditRedo
	FormatPageCalc
   Kontext
	active.setpage TabSeite
	Kontext "TabSeite"
	if Vertikal.IsChecked then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabSeite.Cancel

	call hCloseDocument
	'_________________________________________________________________________________________________

   call hNewDocument
   Printlog ""
	Printlog "* TabPage Header"
	dim header_current, header_bool as boolean
	header_current = false
	header_current = false

'/// Call menuitem 'FormatPage', goto tabpage 'Header' and toggle header on
	FormatPageCalc
	Kontext
	active.setpage TabKopfzeile
	Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   
	Kontext "TabKopfzeile"
	if KopfzeileMitAbstand.IsChecked then
		KopfzeileMitAbstand.UnCheck
		header_bool = false
	else
		KopfzeileMitAbstand.Check
		header_bool = true
	end if
   header_current = header_bool
   TabKopfzeile.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   
	Kontext "TabKopfzeile"
	if KopfzeileMitAbstand.IsChecked then
		header_bool = true
	else
		header_bool = false
	end if
	if header_current = header_bool then
		printlog "OK, the header state has been modified"
	else
		warnlog "The header state hasn't been modified"
	end if
	Kontext
	TabKopfzeile.Cancel

'/// check if the undo-function works
	EditUndo
	if header_current = true then
		header_current = false
	else
		header_current = true
	end if
	FormatPageCalc
        Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   

	Kontext "TabKopfzeile"
	if KopfzeileMitAbstand.IsChecked then
		header_bool = true
	else
		header_bool = false
	end if
	if header_current = header_bool then
		printlog "OK, the header state has been reset to current"
	else
		warnlog "The header state hasn't been reset to current"
	end if
	Kontext
	TabKopfzeile.Cancel

'/// check if the redo-function works
	EditRedo
	if header_current = true then
		header_current = false
	else
		header_current = true
	end if
	FormatPageCalc
        Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   

	Kontext "TabKopfzeile"
	if KopfzeileMitAbstand.IsChecked then
		header_bool = true
	else
		header_bool = false
	end if
	if header_current = header_bool then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabKopfzeile.Cancel
	EditUndo
	'_________________________________________________________________________________________________

'/// Call the menuitem 'FormatPage', goto tabpage 'Header' and toggle autofit height
	dim heigth_current, heigth_bool as boolean
	heigth_current = false
	heigth_current = false
	FormatPageCalc
	Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   

	Kontext "TabKopfzeile"
	if Hoehedynamisch.IsChecked then
		Hoehedynamisch.UnCheck
		heigth_bool = false
	else
		Hoehedynamisch.Check
		heigth_bool = true
	end if
   heigth_current = heigth_bool
   TabKopfzeile.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   
	Kontext "TabKopfzeile"
	if Hoehedynamisch.IsChecked then
		heigth_bool = true
	else
		heigth_bool = false
	end if
	if heigth_current = heigth_bool then
		printlog "OK, the heigth state has been modified"
	else
		warnlog "The heigth state hasn't been modified"
	end if
	Kontext
	TabKopfzeile.Cancel

'/// check if the undo-function works
	EditUndo
	if heigth_current = true then
		heigth_current = false
	else
		heigth_current = true
	end if
	FormatPageCalc
        Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   

	Kontext "TabKopfzeile"
	if Hoehedynamisch.IsChecked then
		heigth_bool = true
	else
		heigth_bool = false
	end if
	if heigth_current = heigth_bool then
		printlog "OK, the heigth state has been reset to current"
	else
		warnlog "The heigth state hasn't been reset to current"
	end if
	Kontext
	TabKopfzeile.Cancel

'/// check if the redo-function works
	EditRedo
	if heigth_current = true then
		heigth_current = false
	else
		heigth_current = true
	end if
	FormatPageCalc
        Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   
	Kontext "TabKopfzeile"
	if Hoehedynamisch.IsChecked then
		heigth_bool = true
	else
		heigth_bool = false
	end if
	if heigth_current = heigth_bool then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabKopfzeile.Cancel
	'_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Header' and toggle autofit heigth a second time
	dim content_current, content_bool as boolean
	content_current = false
	content_current = false
	FormatPageCalc
	Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   
	Kontext "TabKopfzeile"
	if Hoehedynamisch.IsChecked then
		Hoehedynamisch.UnCheck
		content_bool = false
	else
		Hoehedynamisch.Check
		content_bool = true
	end if
   content_current = content_bool
   TabKopfzeile.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if

'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   

	Kontext "TabKopfzeile"
	if Hoehedynamisch.IsChecked then
		content_bool = true
	else
		content_bool = false
	end if
	if content_current = content_bool then
		printlog "OK, the content-rigth-left state has been modified"
	else
		warnlog "The content-rigth-left state hasn't been modified"
	end if
	Kontext
	TabKopfzeile.Cancel

'/// check if the undo-function works
	EditUndo
	if content_current = true then
		content_current = false
	else
		content_current = true
	end if
	FormatPageCalc
        Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   

	Kontext "TabKopfzeile"
	if Hoehedynamisch.IsChecked then
		content_bool = true
	else
		content_bool = false
	end if
	if content_current = content_bool then
		printlog "OK, the content-rigth-left state has been reset to current"
	else
		warnlog "The content-rigth-left state hasn't been reset to current"
	end if
	Kontext
	TabKopfzeile.Cancel

'/// check if the redo-function works
	EditRedo
	if content_current = true then
		content_current = false
	else
		content_current = true
	end if
	FormatPageCalc
        Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
         end if   
	Kontext "TabKopfzeile"
	if Hoehedynamisch.IsChecked then
		content_bool = true
	else
		content_bool = false
	end if
	if content_current = content_bool then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabKopfzeile.Cancel
	'_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Header' and increase left margin by 3 times
	dim Spacing_current, Spacing_str as string
	FormatPageCalc
	Kontext
	active.setpage TabKopfzeile
        Kontext
        if Active.Exists(2) then
           if Active.GetRT = 304 then
              printlog Active.GetText
              Active.YES
           end if
        end if   

	Kontext "TabKopfzeile"
	Spacing_current = Abstand.GetText
   Abstand.More 3
   Spacing_str = Abstand.GetText
   Kontext
   TabKopfzeile.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   
	Kontext "TabKopfzeile"
	if Abstand.GetText = Spacing_str then
		printlog "OK, the spacing has been modified"
	else
		warnlog "The spacing hasn't been modified"
	end if
	Kontext
	TabKopfzeile.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
        Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   

	Kontext "TabKopfzeile"
        if Abstand.GetText = Spacing_current then
		printlog "OK, the spacing has been reset to current"
	else
		warnlog "The spacing hasn't been reset to current"
	end if
	Kontext
	TabKopfzeile.Cancel

'/// check if the redo-function works
	EditRedo
	FormatPageCalc
        Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   
	Kontext "TabKopfzeile"
	if Abstand.GetText = Spacing_str then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabKopfzeile.Cancel
	EditUndo

	'_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Header' and increase heigth by 3 times
	dim HeigthHeader_current, HeigthHeader_str as string
	FormatPageCalc
	Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   
	Kontext "TabKopfzeile"
	HeigthHeader_current = Hoehe.GetText
   Hoehe.More 3
   HeigthHeader_str = Hoehe.GetText
   Kontext
   TabKopfzeile.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   
	Kontext "TabKopfzeile"
	if Hoehe.GetText = HeigthHeader_str then
		printlog "OK, the heigth has been modified"
	else
		warnlog "The heigth hasn't been modified"
	end if
	Kontext
	TabKopfzeile.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
        Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   

	Kontext "TabKopfzeile"
        if Hoehe.GetText = HeigthHeader_current then
		printlog "OK, the heigth has been reset to current"
	else
		warnlog "The heigth hasn't been reset to current"
	end if
	Kontext
	TabKopfzeile.Cancel

	' check if the redo-function works
	EditRedo
	FormatPageCalc
        Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   
	Kontext "TabKopfzeile"
	if Hoehe.GetText = HeigthHeader_str then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabKopfzeile.Cancel
	EditUndo

	'_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Header' and increase right margin by 3 times
	dim RigthEdge_current, RigthEdge_str as string
	FormatPageCalc
	Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   

	Kontext "TabKopfzeile"
	RigthEdge_current = RechterRandKopfzeile.GetText
   RechterRandKopfzeile.More 3
   RigthEdge_str = RechterRandKopfzeile.GetText
   Kontext
   TabKopfzeile.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   

	Kontext "TabKopfzeile"
	if RechterRandKopfzeile.GetText = RigthEdge_str then
		printlog "OK, the rightEdgeHeader has been modified"
	else
		warnlog "The rightEdgeHeader hasn't been modified"
	end if
	Kontext
	TabKopfzeile.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
   Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   

	Kontext "TabKopfzeile"
   if RechterRandKopfzeile.GetText = RigthEdge_current then
		printlog "OK, the rightEdgeHeader has been reset to current"
	else
		warnlog "The rightEdgeHeader hasn't been reset to current"
	end if
	Kontext
	TabKopfzeile.Cancel

'/// check if the redo-function works
	EditRedo
	FormatPageCalc
   Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   
	Kontext "TabKopfzeile"
	if RechterRandKopfzeile.GetText = RigthEdge_str then
		printlog "OK, redo works"
	else
		warnlog "The the redo-function doesn't work"
	end if
	Kontext
	TabKopfzeile.Cancel
	EditUndo

	'_________________________________________________________________________________________________

'/// Call menuitem 'FormatPage', goto tabpage 'Header' and increase left margin by 3 times
	dim LeftEdge_current, LeftEdge_str as string
	FormatPageCalc
	Kontext
	active.setpage TabKopfzeile
        Kontext
         if Active.Exists(2) then
            if Active.GetRT = 304 then
               printlog Active.GetText
               Active.YES
            end if
         end if   
	Kontext "TabKopfzeile"
	LeftEdge_current = LinkerRandKopfzeile.GetText
   LinkerRandKopfzeile.More 3
   LeftEdge_str = LinkerRandKopfzeile.GetText
   Kontext
   TabKopfzeile.OK
   Kontext
     if Active.Exists(2) then
        if Active.GetRT = 304 then
           printlog Active.GetText
           Active.YES
        end if
     end if
   
'/// check if the modify has been taken over
   FormatPageCalc
   Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   
	Kontext "TabKopfzeile"
	if LinkerRandKopfzeile.GetText = LeftEdge_str then
		printlog "OK, the leftEdgeHeader has been modified"
	else
		warnlog "The leftEdgeHeader hasn't been modified"
	end if
	Kontext
	TabKopfzeile.Cancel

'/// check if the undo-function works
	EditUndo
	FormatPageCalc
   Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   

	Kontext "TabKopfzeile"
        if LinkerRandKopfzeile.GetText = LeftEdge_current then
		printlog "OK, the leftEdgeHeader has been reset to current"
	else
		warnlog "The leftEdgeHeader hasn't been reset to current"
	end if
	Kontext
	TabKopfzeile.Cancel

'/// check if the redo-function works
	EditRedo
	FormatPageCalc
   Kontext
	active.setpage TabKopfzeile
        Kontext
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog Active.GetText
                Active.YES
             end if
          end if   

	Kontext "TabKopfzeile"
	if LinkerRandKopfzeile.GetText = LeftEdge_str then
		printlog "OK, redo works"
	else
		warnlog "The the redo-function doesn't work"
	end if
	Kontext
	TabKopfzeile.Cancel
	EditUndo

	'_________________________________________________________________________________________________

	call hCloseDocument

endcase

