'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: un_redo5.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:25 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description    :       Complete Test for the undo/redo function which test
'*
'************************************************************************
'*
' #1 un_redo5            ' Initial routine
' #1 tConditional_Format ' Conditional format - Undo/Redo - Check correct settings
'*
'\***********************************************************************

sub un_redo5

Printlog Chr(13) + "--------- Conditional_Formating ---------"

        call tConditional_Format

end sub

'**************************************************************************************************

testcase tConditional_Format

'/// Open a new calc document, call menuitem 'FormatConditionalFormatting' and confirm this dialog
        call hNewDocument
        Printlog ""
        Printlog "* FormatConditionalFormatting"
        FormatConditionalFormatting

        Kontext "BedingteFormatierung"
        BedingteFormatierung.OK
'/// Call this menuitem again and select nr 2 from conditionlist1
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        PopupList1.Select 2
        BedingteFormatierung.OK

'/// check if the modify was taken over
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if PopupList1.GetSelIndex = 2 then
                printlog "OK, the first condition has been modified"
        else
                warnlog "The  first condition hasn't been modified"
        end if
        BedingteFormatierung.Cancel

'/// check if the undo-function works
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if PopupList1.GetSelIndex = 1 then
                printlog "OK, the first condition has been reset to current"
        else
                warnlog "The first condition hasn't been reste to current"
        end if
        BedingteFormatierung.Cancel

'/// check if the redo-function works
        EditRedo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if PopupList1.GetSelIndex = 2 then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        BedingteFormatierung.Cancel
        EditUndo
        '_________________________________________________________________________________________________

        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        Vergleich1.Select 2
        BedingteFormatierung.OK

'/// check if the modify was taken over
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Vergleich1.GetSelIndex = 2 then
                printlog "OK, the firstcompare has been modified"
        else
                warnlog "The firstcompare hasn't been modified"
        end if
        BedingteFormatierung.Cancel

'/// check if the undo-function works
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Vergleich1.GetSelIndex = 1 then
                printlog "OK, the firstcompare has been reset to current"
        else
                warnlog "The firstcompare hasn't been reset to current"
        end if
        BedingteFormatierung.Cancel

'/// check if the redo-function works
        EditRedo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Vergleich1.GetSelIndex = 2 then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        BedingteFormatierung.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatConditionalFormatting'and set in Textfield1 a text
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        printlog "Textfield:" & TextField1.GetText & "!"
        TextField1.SetText "cell"
        printlog "Textfield:" & TextField1.GetText & "!"
        BedingteFormatierung.OK

'/// check if the modify was taken over
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if TextField1.GetText = "cell" then
                printlog "OK, the text has been taken over"
        else
                warnlog "The text hasn't been taken over"
        end if
        BedingteFormatierung.Cancel

'/// check if the undo-function works
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        printlog "Textfield:" & TextField1.GetText & "!"
        if TextField1.GetText = "0" then
                printlog "OK, the first comparison has been reset to current"
        else
                warnlog "The first comparison hasn't been reset to current"
        end if
        BedingteFormatierung.Cancel

'/// check if the redo-function works
        EditRedo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if TextField1.GetText = "cell" then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        BedingteFormatierung.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatConditionalFormatting' and select nr 2 from cellstyle1
        dim initialCellIndex1%
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        initialCellIndex1% = Zellvorlage1.GetSelIndex
        Zellvorlage1.Select 2
        BedingteFormatierung.OK

'/// check if the modify was taken over
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Zellvorlage1.GetSelIndex = 2 then
                printlog "OK, the cell template has been modified"
        else
                warnlog "The cell template hasn't been modified"
        end if
        BedingteFormatierung.Cancel

'/// check if the undo-function works
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Zellvorlage1.GetSelIndex = initialCellIndex1% then
                printlog "OK, the cell template has been reset to current"
        else
                warnlog "The cell template hasn't been reset to current"
        end if
        BedingteFormatierung.Cancel

'/// check if the redo-function works
        EditRedo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Zellvorlage1.GetSelIndex = 2 then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        BedingteFormatierung.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatConditionalFormatting' and check condition2
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        Bedingung2.Check
        BedingteFormatierung.OK

'/// check if the modify was taken over
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Bedingung2.IsChecked then
                printlog "OK, the second condition has been activated"
        else
                warnlog "The second condition hasn't been activated"
        end if
        BedingteFormatierung.Cancel

'/// check if the undo-function works
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if NOT Bedingung2.IsChecked then
                printlog "OK, the second condition has been reset to current"
        else
                warnlog "The second condition hasn't been reset to current"
        end if
        BedingteFormatierung.Cancel

'/// check if the redo-function works
        EditRedo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Bedingung2.IsChecked then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        BedingteFormatierung.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatConditionalFormatting', check condition2 and select nr 2
'/// from conditionlist2
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        Bedingung2.Check
        PopupList2.Select 2
        BedingteFormatierung.OK

'/// check if the modify was taken over
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if PopupList2.GetSelIndex = 2 then
                printlog "OK, the second condition has been modified"
        else
                warnlog "The  second condition hasn't been modified"
        end if
        BedingteFormatierung.Cancel

'/// check if the undo-function works
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if PopupList2.GetSelIndex = 1 then
                printlog "OK, the second condition has been reset to current"
        else
                warnlog "The second condition hasn't been reset to current"
        end if
        BedingteFormatierung.Cancel

'/// check if the redo-function works
        EditRedo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if PopupList2.GetSelIndex = 2 then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        BedingteFormatierung.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatConditionalFormatting', check condition2 and select nr 2
'/// from style2
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        Bedingung2.Check
        Vergleich2.Select 2
        BedingteFormatierung.OK

'/// check if the modify was taken over
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Vergleich2.GetSelIndex = 2 then
                printlog "OK, the second comparison has been modified"
        else
                warnlog "The secondcomparison hasn't been modified"
        end if
        BedingteFormatierung.Cancel

'/// check if the undo-function works
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Vergleich2.GetSelIndex = 1 then
                printlog "OK, the second comparison has been reset to current"
        else
                warnlog "The second comparison hasn't been reset to current"
        end if
        BedingteFormatierung.Cancel

'/// check if the redo-function works
        EditRedo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Vergleich2.GetSelIndex = 2 then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        BedingteFormatierung.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatConditionalFormatting', check condition2 and set a text for
'/// TextField2
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        Bedingung2.Check
        printlog "Textfield2:" & TextField2.GetText & "!"
        TextField2.SetText "cell"
        printlog "Textfield2:" & TextField2.GetText & "!"
        BedingteFormatierung.OK

'/// check if the modify was taken over
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if TextField2.GetText = "cell" then
                printlog "OK, the text has been taken over"
        else
                warnlog "The text hasn't been taken over"
        end if
        BedingteFormatierung.Cancel

'/// check if the undo-function works
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        printlog "Textfield2:" & TextField2.GetText & "!"
        if TextField2.GetText = "" then
                printlog "OK, the first comparison has been reset to current"
        else
                warnlog "The first comparison hasn't been reset to current"
        end if
        BedingteFormatierung.Cancel

'/// check if the redo-function works
        EditRedo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if TextField2.GetText = "cell" then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        BedingteFormatierung.Cancel
        EditUndo
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatConditionalFormatting', check condition2 and select nr 2 from
'/// cellstyle 2
        dim initialCellIndex2%
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        Bedingung2.Check
        initialCellIndex2% = Zellvorlage2.GetSelIndex
        Zellvorlage2.Select 2
        BedingteFormatierung.OK

'/// check if the modify was taken over
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Zellvorlage2.GetSelIndex = 2 then
                printlog "OK, cell template 2 has been modified"
        else
                warnlog "Cell template 2 hasn't been modified"
        end if
        BedingteFormatierung.Cancel

'/// check if the undo-function works
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Zellvorlage2.GetSelIndex = initialCellIndex2% then
                printlog "OK, cell template 2 has been reset to current"
        else
                warnlog "Cell template 2 hasn't been reset to current"
        end if
        BedingteFormatierung.Cancel

'/// check if the redo-function works
        EditRedo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Zellvorlage2.GetSelIndex = 2 then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        BedingteFormatierung.Cancel
        EditUndo
        '_________________________________________________________________________________________________

        ' From this point the 3. formatting condition
        '*************************************************************************************************

'/// Call menuitem 'FormatConditionalFormatting', check condition1-3 and set a text for
'/// TextField1-2 and conditionlist3
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        Bedingung1.Check
        Textfield1.SetText "10"
        Bedingung2.Check
        Textfield2.SetText "10"
        Bedingung3.Check
        PopupList3.Select 2
        BedingteFormatierung.OK

'/// check if the modify was taken over
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if PopupList3.GetSelIndex = 2 then
                printlog "OK, the third condition has been modified"
        else
                warnlog "The  third condition hasn't been modified"
        end if
        BedingteFormatierung.Cancel

'/// check if the undo-function works
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if PopupList3.GetSelIndex = 1 then
                printlog "OK, the third condition has been reset to current"
        else
                warnlog "The third condition hasn't been reset to current"
        end if
        BedingteFormatierung.Cancel

'/// check if the redo-function works
        EditRedo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if PopupList3.GetSelIndex = 2 then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        BedingteFormatierung.Cancel
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        Bedingung1.UnCheck
        Bedingung2.UnCheck
        BedingteFormatierung.OK
        '_________________________________________________________________________________________________

'/// Call the menuitem 'FormatConditionalFormatting', check condition1-3 and set a text for
'/// TextField1 and conditionlist2-3
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        Bedingung1.Check
        Textfield1.SetText "10"
        Bedingung2.Check
        Textfield2.SetText "10"
        Bedingung3.Check
        Vergleich3.Select 2
        BedingteFormatierung.OK

'/// check if the modify was taken over
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Vergleich3.GetSelIndex = 2 then
                printlog "OK, the third comparison has been modified"
        else
                warnlog "The third comparison hasn't been modified"
        end if
        BedingteFormatierung.Cancel

'/// check if the undo-function works
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Vergleich3.GetSelIndex = 1 then
                printlog "OK, the third comparison has been reset to current"
        else
                warnlog "The third comparison hasn't been reset to current"
        end if
        BedingteFormatierung.Cancel

'/// check if the redo-function works
        EditRedo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Vergleich3.GetSelIndex = 2 then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        BedingteFormatierung.Cancel
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        Bedingung1.UnCheck
        Bedingung2.UnCheck
        BedingteFormatierung.OK
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatConditionalFormatting', check condition1-3 and set a text for
'/// Textfield1-3
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        Bedingung1.Check
        Textfield1.SetText "10"
        Bedingung2.Check
        Textfield2.SetText "10"
        Bedingung3.Check
        printlog "Textfield3:" & TextField3.GetText & "!"
        TextField3.SetText "cell"
        printlog "Textfield3:" & TextField3.GetText & "!"
        BedingteFormatierung.OK

'/// check if the modify was taken over
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if TextField3.GetText = "cell" then
                printlog "OK, the text has been taken over"
        else
                warnlog "The text hasn't been taken over"
        end if
        BedingteFormatierung.Cancel

'/// check if the undo-function works
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        printlog "Textfield3:" & TextField3.GetText & "!"
        if TextField3.GetText = "" then
                printlog "OK, the third comparison has been reset to current"
        else
                warnlog "The third comparison hasn't been reset to current"
        end if
        BedingteFormatierung.Cancel

'/// check if the redo-function works
        EditRedo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if TextField3.GetText = "cell" then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        BedingteFormatierung.Cancel
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        Bedingung1.UnCheck
        Bedingung2.UnCheck
        BedingteFormatierung.OK
        '_________________________________________________________________________________________________

'/// Call menuitem 'FormatConditionalFormatting', check condition1-3 and set a text for
'/// TextField1-2 and select nr 2 from cellstyle2
        dim initialCellIndex3%
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        Bedingung1.Check
        Textfield1.SetText "10"
        Bedingung2.Check
        Textfield2.SetText "10"
        Bedingung3.Check
        initialCellIndex3% = Zellvorlage3.GetSelIndex
        Zellvorlage3.Select 2
        BedingteFormatierung.OK

'/// check if the modify was taken over
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Zellvorlage3.GetSelIndex = 2 then
                printlog "OK, cell template 3 has been modified"
        else
                warnlog "Cell template 3 hasn't been modified"
        end if
        BedingteFormatierung.Cancel

'/// check if the undo-function works
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Zellvorlage3.GetSelIndex = initialCellIndex3% then
                printlog "OK, the cell template 3 has been reset to current"
        else
                warnlog "Cell template 3 hasn't been reset to current"
        end if
        BedingteFormatierung.Cancel

'/// check if the redo-function works
        EditRedo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        if Zellvorlage3.GetSelIndex = 2 then
                printlog "OK, redo works"
        else
                warnlog "The redo-function doesn't work"
        end if
        BedingteFormatierung.Cancel
        EditUndo
        FormatConditionalFormatting
        Kontext "BedingteFormatierung"
        Bedingung1.UnCheck
        Bedingung2.UnCheck
        BedingteFormatierung.OK
        '_________________________________________________________________________________________________

        call hCloseDocument

endcase
