'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_002_.inc,v $
'*
'*  $Revision: 1.15 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:36 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Check all resources for menuitem Edit
'*
'**************************************************************************
'**
' #1 C_002_ ' Initial routine
' #1 tEditUndo
' #1 tEditRedo
' #1 tEditRepeat
' #1 tEditCut
' #1 tEditCopy
' #1 tEditPaste
' #1 tEditPasteSpecial
' #1 tEditSelectAll
' #1 tEditChangesRecord
' #1 tEditChangesProtectRecords
' #1 tEditChangesShow
' #1 tEditChangesAcceptOrReject
' #1 tEditChangesComments
' #1 tEditChangesMergeDocument
' #1 tEditCompareDocument
' #1 tEditFindAndReplace
' #1 tEditNavigator
' #1 tEditHeadersAndFooters
' #1 tEditFillDown
' #1 tEditFillRight
' #1 tEditFillUp
' #1 tEditFillLeft
' #1 tEditFillSheet
' #1 tEditFillSeries
' #1 tEditDeleteContents
' #1 tEditDeleteCells
' #1 tEditSheetMoveCopy
' #1 tEditSheetSelect
' #1 tEditSheetDelete
' #1 tEditDeleteManuelBreakRowBreak
' #1 tEditDeleteManuelBreakColumnBreak
' #1 tEditLinks
' #1 tEditPlugin
' #1 tEditImageMap
' #1 tEditObjectEdit
' #1 tEditObjectSaveCopyAs
'**
'\************************************************************************************************

sub C_002_

Printlog Chr(13) + "--------- C_002_ ---------"

   Call tEditUndo
   Call tEditRedo
   Call tEditRepeat
   Call tEditCut
   Call tEditCopy
   Call tEditPaste
   Call tEditPasteSpecial
   Call tEditSelectAll
   Call tEditChangesRecord
   call tEditChangesProtectRecords
   Call tEditChangesShow
   Call tEditChangesAcceptOrReject
   Call tEditChangesComments
   Call tEditChangesMergeDocument
   Call tEditCompareDocument
   Call tEditFindAndReplace
   Call tEditNavigator
   Call tEditHeadersAndFooters
   Call tEditFillDown
   Call tEditFillRight
   Call tEditFillUp
   Call tEditFillLeft
   Call tEditFillSheet
   Call tEditFillSeries
   Call tEditDeleteContents
   Call tEditDeleteCells
   Call tEditSheetMoveCopy
   call tEditSheetSelect
   Call tEditSheetDelete
   Call tEditDeleteManuelBreakRowBreak
   Call tEditDeleteManuelBreakColumnBreak
   Call tEditLinks
   Call tEditPlugin
   call tEditImageMap
   call tEditObjectEdit
   call tEditObjectSaveCopyAs

end sub

' TODO: Docu

testcase tEditUndo
'///<u><b>Edit::Undo</b></u>///

    '///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument

    '///<li>Select range A1:B2</li>///
    call fCalcSelectRange("A1:B2")
    Kontext "DocumentCalc"
    '///<li>Add content</li>///
    DocumentCalc.typekeys "1<RETURN>"
    '///<li>Edit::Cut</li>///
    EditCut
    '///<li>Edit::Undo</li>///
    EditUndo
    '///<li>Close document</li>///
    Call hCloseDocument
    '///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tEditRedo
'///<u><b>Edit::Redo</b></u>///

    '///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Select cell A1</li>///
    call fCalcSelectCell("A1")
    '///<li>Add content in A1</li>///
    DocumentCalc.typekeys "1<RETURN>"
    '///<li>Go to bottom of document</li>///
    DocumentCalc.typekeys "<MOD1 DOWN>"
    '///<li>Add content in A65536</li>///
    DocumentCalc.typekeys "Bottom<RETURN>"
    '///<li>Select whole column A1:A65536</li>///
    DocumentCalc.typekeys "<SHIFT MOD1 UP>"
    '///<li>Cut selection</li>///
    DocumentCalc.typekeys "<MOD1 X>"
    '///<li>Edit::Undo</li>///
    EditUndo
    '///<li>Edit::Redo</li>///
    EditRedo
    '///<li>Close document</li>///
    Call hCloseDocument
    '///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tEditRepeat
'///<u><b>Edit::Repeat</b></u>///

    '///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Add content</li>///
    DocumentCalc.typekeys "Hallo World!<RETURN>"
    '///<li>Repeat input</li>///
    EditRepeat

    '///<li>Close document</li>///
    Call hCloseDocument
    '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tEditCut
'///<u><b>Edit::Cut</b></u>///

    '///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Add content</li>///
    DocumentCalc.typekeys "Hallo World!<RETURN><UP>"
    '///<li>Edit::Cut</li>///
    EditCut
    '///<li>Close document</li>///
    Call hCloseDocument
    '///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tEditCopy
'///<u><b>Edit::Copy</b></u>///

    '///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Add content</li>///
    DocumentCalc.typekeys "Hallo World!<RETURN><UP>"
    '///<li>Edit::Copy</li>///
    EditCopy
    '///<li>Close document</li>///
    Call hCloseDocument
    '///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tEditPaste
'///<u><b>Edit::Paste</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Add some content in 'A1:C3'</li>///
    DocumentCalc.typekeys "11<Right>12<Right>13<RETURN>23<LEFT>22<LEFT>21<RETURN>31<RIGHT>32<RIGHT>33<UP UP LEFT LEFT>"
    '///<li>Select range 'A1:C3'</li>///
    call fCalcSelectRange("A1:C3")
    '///<li>Invoke Edit::Copy</li>///
    EditCopy
    '///<li>Invoke Edit::Paste applied on Source</li>///
    EditPaste
    '///<li>Check for overwrite warning</li>///
    try
       Kontext "CellWarning"
       Dialogtest ( CellWarning )
       '///<li>Confirm overwrite warning</li>///
       CellWarning.Yes
       printlog "Paste overwrite MsgBox tested"
    catch
       warnlog "MsgBox for overwrite warning doesn't exist"
    endcatch
    '///<li>Select cell 'D4'</li>///
    Call fCalcSelectCell("D4")
    '///<li>Invoke Edit::Paste</li>///
    EditPaste
    '///<li>Check that NO warning appears</li>///
    Kontext
    if active.exists then
       Warnlog "It shouldn't appear a message: " & active.gettext
       active.yes
    else
       Printlog "OK, there isn't appear a message by inserting a range in a market cell"
    end if
    '///<li>Select range 'B10:C11'</li>///
    call fCalcSelectRange("B10:C11")
    '///<li>Invoke Edit::Paste</li>///
    EditPaste
    '///<li>Check for warning that target range is smaller than source range</li>///
    Kontext
    if active.exists then
       Printlog "OK a mesage has appear" & active.gettext
       active.yes
    else
       Warnlog "It should be appear a message by inserting a range in a smaller selection"
    end if
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tEditPasteSpecial
'///<u><b>Edit::Paste Special...</b></u>///
'///<ul>
    dim Datname as String
    dim paste_flag : paste_flag = true

    '///<li>Open new document</li>///
    Call  hNewDocument

    Kontext
    '///<li>Add random content</li>///
    DocumentCalc.typekeys "13<Return><Up>"
    '///<li>Invoke Edit::Copy</li>///
    EditCopy
    '///<li>Invoke Edit::Paste Special...</li>///
    EditPasteSpecialCalc
    Kontext "InhalteEinfuegenCalc"
    '///<li>Check for 'Paste special' dialog (version for calc specific content)</li>///
    DialogTest ( InhalteEinfuegenCalc )
    '///<li>Cancel dialog</li>///
    InhalteEinfuegenCalc.Cancel
    sleep(2)
    try
        '///<li>Insert a picture from file</li>///
        InsertGraphicsFromFile
        Kontext "GrafikEinfuegenDlg"
        DatName = convertpath( gTesttoolpath + "global\input\graf_inp\baer.tif" )
        Dateiname.Settext DatName
        'warnlog "If the test crashes by inserting a graphic from file it could be the bug:90336"
        Oeffnen.Click
    catch
        Warnlog "InsertGraphicFromFile doesn't work!"
        paste_flag = false
    endcatch
    sleep(2)
    if paste_flag = true then
    '///<li>Invoke Edit::Cut (Picture still selected)</li>///
        EditCut
        sleep(2)
        '///<li>Invoke Edit::Paste Special...</li>///
        EditPasteSpecialCalc
        Kontext "InhaltEinfuegen"
        '///<li>Check for 'Paste special' dialog (version for common content)</li>///
        DialogTest ( InhaltEinfuegen )
        '///<li>Cancel dialog</li>///
        InhaltEinfuegen.Cancel
        sleep(2)
    end if
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tEditSelectAll
'///<u><b>Edit::Select all</b></u>///
'///<ul>
    dim sRange$
    sRange$ = ""
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Invoke Edit::Select all</li>///
    EditSelectAll
    Kontext "RechenleisteCalc"
    '///<li>Check if 'A1:IV65536' is selected</li>///
    sRange$ = Bereich.getSelText
    if sRange$ = "A1:IV65536" then
       printlog "Whole sheet was selected: " & sRange$
    else
       warnlog "Select all using 'CTRL + A' seems to have failed: " & sRange$
    end if
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tEditChangesRecord
'///<u><b>Edit::Changes::Record</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument

    Kontext
    '///<li>Add random content</li>///
    DocumentCalc.typekeys "13<Return>"
    '///<li>Activate 'Redlining' using Edit::Changes::Record</li>///
    EditChangesRecordCalc
    '///<li>Check if NO MsgBox is visible</li>///
    Kontext
    if active.exists then
        active.Yes
        warnlog "Unexpected state of the office - Redlining was initialy enabled -> Check this out!"
        EditChangesRecordCalc
    end if
    Kontext
    '///<li>Add again random content</li>///
    DocumentCalc.typekeys "13<Return>"
    '///<li>Invoke Edit::Changes::Record again</li>///
    EditChangesRecordCalc
    '///<li>Check if a MsgBox is visible</li>///
    Kontext
    if active.exists then 
       '///<li>Cancel MsgBox</li>///
       active.No
    else 
       warnlog "A Dialog asking if change tracking should be deactivated was expected here -> Check this out!"
    endif
    Kontext
    '///<li>Add random content for the third time</li>///
    DocumentCalc.typekeys "13<Return>"
    '///<li>Invoke Edit::Changes::Record again</li>///
    EditChangesRecordCalc
    Kontext
    '///<li>Check if a MsgBox is visible</li>///
    if active.exists then
        '///<li>Confirm MsgBox this time</li>///
        active.Yes
    else 
       warnlog "A Dialog asking if change tracking should be deactivated was expected here -> Check this out!"
    end if
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tEditChangesProtectRecords

    call  hNewDocument    
    Kontext
    EditChangesRecordCalc
    EditChangesProtectTraceCalc
    Kontext ("PasswortEingeben")
    call Dialogtest (PasswortEingeben)
    PasswortEingeben.Cancel
    EditChangesRecordCalc
    Kontext
    if Active.exists then
       Active.Yes
    end if
    
    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditChangesShow

    Call  hNewDocument

    Kontext
    DocumentCalc.typekeys "13<Return>"
    try
        EditChangesShowCalc
        warnlog "Surprise, Slot 'Edit::Changes::Show' shouldn't be available now!"
    catch
        EditChangesRecordCalc
        Kontext
        DocumentCalc.typekeys "13<Return>"
        EditChangesShowCalc
    endcatch

    Kontext "AenderungenAnzeigen"
    call Dialogtest (AenderungenAnzeigen)
    AenderungenAnzeigen.Cancel

    EditChangesRecordCalc
    Kontext
    if active.exists then
       active.Yes
    end if

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditChangesAcceptOrReject

    Call  hNewDocument

    Kontext
    EditChangesRecordCalc
    Kontext
    DocumentCalc.typekeys "13<Return><Up>"

    EditChangesAcceptOrDiscardCalc
    Kontext "AenderungenAnzeigen"
    Kontext "TabControl"
    TabControl.setpage TabListe
    Kontext "TabListe"
    Call Dialogtest (TabListe)

    Kontext "TabControl"
    TabControl.setpage TabFilter
    Call Dialogtest (TabFilter)
    Sleep 1
    Kontext "AenderungenAnzeigen"
    AenderungenAnzeigen.close

    EditChangesRecordCalc
    Kontext
    if active.exists then
       active.Yes
    end if

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditChangesComments

    Call  hNewDocument

    EditChangesRecordCalc
    Kontext
    DocumentCalc.typekeys "13<Return><Up>"

    EditChangesCommentsCalc
    Kontext "Kommentar"
    call Dialogtest( Kommentar )
    Kommentar.cancel

    EditChangesRecordCalc
    kontext
    if active.exists then
       active.Yes
    end if

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditChangesMergeDocument

    call hNewDocument

    EditChangesMergeDocument
    Kontext "OeffnenDlg"
    UebergeordneterOrdner.Click
    Standard.Click
    Call DialogTest (OeffnenDlg)
    Dateiname.settext convertpath(gtesttoolpath +"calc\update\input\c_010\zusuchen.sxc")
    Oeffnen.Click

    Kontext "AenderungenAnzeigen"
    Kontext "TabControl"
    TabControl.setpage TabListe
    Kontext "TabListe"
    Call Dialogtest (TabListe)

    Kontext "TabControl"
    TabControl.setpage TabFilter
    Call Dialogtest (TabFilter)
    Sleep 1
    Kontext "AenderungenAnzeigen"
    AenderungenAnzeigen.close

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditCompareDocument

    Call hNewDocument
    EditCompareDocumentCalc
    Kontext "OeffnenDlg"
    UebergeordneterOrdner.Click
    Standard.Click
    Call DialogTest (OeffnenDlg)
    Dateiname.settext convertpath(gtesttoolpath +"calc\update\input\c_010\zusuchen.sxc")
    Oeffnen.Click

'    Kontext "TextImport"
'    if TextImport.exists then TextImport.Ok
    Kontext "AenderungenAnzeigen"
    Kontext "TabControl"
    TabControl.setpage TabListe
    Kontext "TabListe"
    Call Dialogtest (TabListe)
    Kontext "TabControl"
    TabControl.setpage TabFilter
    call Dialogtest (TabFilter)
    Kontext "TabFilter"
    Kontext "AenderungenAnzeigen"
    AenderungenAnzeigen.close

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditFindAndReplace

    Call  hNewDocument

    EditSearchAndReplace
    Kontext "FindAndReplace"

    More.Click
    SimilaritySearch.Check
    SimilaritySearchFor.Click
    Kontext "Aehnlichkeitssuche"
    Call DialogTest ( Aehnlichkeitssuche )
    Aehnlichkeitssuche.Cancel
    Kontext "FindAndReplace"
    Call DialogTest ( FindAndReplace )
    FindAndReplace.Close
    Call hCloseDocument

endcase
'
'-------------------------------------------------------------------------------
'
testcase tEditNavigator

    Call  hNewDocument

    sleep 1
    EditNavigator
    sleep 1
    Kontext "NavigatorCalc"
    DialogTest ( NavigatorCalc )
    Kontext "Navigator"
    Navigator.Close
    Kontext "NavigatorCalc"
    if NavigatorCalc.exists then
        EditNavigator
        Warnlog "NavigatorCalc.Close doesn't close the navigator"
    end if

    Call hCloseDocument

endcase
'
'-------------------------------------------------------------------------------
'
testcase tEditHeadersAndFooters

    Call  hNewDocument

    FormatPageCalc
    Kontext
    Active.SetPage TabKopfzeile
    Kontext
      if Active.Exists(2) then
        if Active.GetRT = 304 then
          Printlog Active.GetText
          Active.Yes
          sleep(2)
        end if
      end if
    Kontext "TabKopfzeile"
    InhaltLinksRechtsGleich.uncheck
    Kontext
    Active.SetPage TabFusszeile
    Kontext "TabFussZeile"
    InhaltLinksRechtsGleich.uncheck
    TabFusszeile.Ok

    EditHeadersAndFooters

    Kontext
    Active.SetPage TabKopfzeileCalc
    Kontext "TabKopfzeileCalc"
    Call DialogTest ( TabKopfzeileCalc )

    Datei.Click
    Tabelle.Click
    Seitennummer.Click
    Seitenanzahl.Click
    Datum.Click
    Zeit.Click
    
    Textattribute.Click
    Kontext
    Active.setpage TabFont
    Kontext "TabFont"
    TabFont.Cancel

    Kontext
    Active.SetPage TabKopfzeileCalcLinks
    Kontext "TabKopfzeileCalcLinks"
    Call DialogTest ( TabKopfzeileCalcLinks )

    MittlererBereich.typeKeys ("1")
    Datei.Click
    Tabelle.Click
    Seitennummer.Click
    Seitenanzahl.Click
    Datum.Click
    Zeit.Click

    Textattribute.Click
    Kontext
    Active.setpage TabFont
    Kontext "TabFont"
    TabFont.Cancel

    Kontext
    Active.SetPage TabFusszeileCalc
    Kontext "TabFusszeileCalc"
    Call DialogTest ( TabFusszeileCalc )

    RechterBereich.typeKeys ("1")
    Datei.Click
    Tabelle.Click
    Seitennummer.Click
    Seitenanzahl.Click
    Datum.Click
    Zeit.Click

    Textattribute.Click
    Kontext
    Active.setpage TabFont
    Kontext "TabFont"
    TabFont.Cancel

    Kontext
    Active.SetPage TabFusszeileCalcLinks
    Kontext "TabFusszeileCalcLinks"
    Call DialogTest ( TabFusszeileCalcLinks )

    Datei.Click
    Tabelle.Click
    Seitennummer.Click
    Seitenanzahl.Click
    Datum.Click
    Zeit.Click

    Textattribute.Click
    Kontext
    Active.setpage TabFont
    Kontext "TabFont"
    Call DialogTest (TabFont)
    Kontext
    Active.setpage TabFontEffects
    Kontext "TabFontEffects"
    Call DialogTest (TabFontEffects)
    Kontext
    Active.setpage TabFontPosition
    Kontext "TabFontPosition"
    Call DialogTest (TabFontPosition)
    TabFontPosition.Cancel

    Kontext "TabFusszeileCalcLinks"
    TabFusszeileCalcLinks.Close

    FormatPageCalc
    Kontext
    Active.SetPage TabKopfzeile
    Kontext
      if Active.Exists(2) then
        if Active.GetRT = 304 then
          Printlog Active.GetText
          Active.Yes
          sleep(2)
        end if
      end if
    
    Kontext "TabKopfzeile"
    InhaltLinksRechtsGleich.check
    Kontext
    Active.SetPage TabFusszeile
    Kontext "TabFussZeile"
    InhaltLinksRechtsGleich.check
    TabFusszeile.Ok

    Call hCloseDocument

endcase
'
'-------------------------------------------------------------------------------
'
testcase tEditFillDown

    Call  hNewDocument

    Call DocumentCalc.Typekeys "13<Return><Up>"
    Call ZellenMarkieren ( 4, 1 )
    EditFillDown

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditFillRight

    Call  hNewDocument

    Call DocumentCalc.Typekeys "13<Return><Up>"
    Call ZellenMarkieren ( 1, 4 )
    EditFillRight

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditFillUp

    Call  hNewDocument

    Call DocumentCalc.Typekeys "<Down><Down><Down>13<Return><Up><Up><Up><Up>"
    Call ZellenMarkieren ( 4, 1 )
    EditFillUp

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditFillLeft

    Call  hNewDocument

    Call DocumentCalc.Typekeys "<Right><Right><Right>13<Return><Up><Left><Left><Left><Left>"
    Call ZellenMarkieren ( 1, 4 )
    EditFillLeft

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditFillSheet

    Call  hNewDocument

    Kontext
    DocumentCalc.Typekeys "1<Return>=Tabelle1.A1<Return><Up><Up><Shift Down Up>"
    AlleTabellenAuswaehlen

    EditFillSheet
    Kontext "TabellenFuellen"
    DialogTest ( TabellenFuellen )
    TabellenFuellen.Cancel

    Call hCloseDocument

endcase
'
'-------------------------------------------------------------------------------
'
testcase tEditFillSeries

    Call  hNewDocument

    Call ZellenMarkieren ( 4, 1 )
    EditFillSeries
    Kontext "ReiheFuellen"
    DialogTest ( ReiheFuellen )
    ReiheFuellen.Cancel

    Call hCloseDocument

endcase
'
'-------------------------------------------------------------------------------
'
testcase tEditDeleteContents

    Call  hNewDocument

    EditDeleteContents
    Kontext "InhalteLoeschen"
    DialogTest ( InhalteLoeschen )
    InhalteLoeschen.Cancel

    Call hCloseDocument

endcase
'
'-------------------------------------------------------------------------------
'
testcase tEditDeleteCells

    Call  hNewDocument

    EditDeleteCells
    Kontext "ZellenLoeschen"
    DialogTest ( ZellenLoeschen )
    ZellenLoeschen.Cancel

    Call hCloseDocument

endcase
'
'-------------------------------------------------------------------------------
'
testcase tEditSheetMoveCopy

    Call  hNewDocument

    EditCopyMoveSheet
    Kontext "TabelleVerschiebenKopieren"
    DialogTest ( TabelleVerschiebenKopieren )
    TabelleVerschiebenKopieren.Cancel

    Call hCloseDocument

endcase
'
'-------------------------------------------------------------------------------
'

testcase tEditSheetSelect

    Call  hNewDocument

    EditSheetSelect
    Kontext "SelectSheets"
    DialogTest ( SelectSheets )
    SheetSelectionBox.Select (2)
    SelectSheets.Cancel

    Call hCloseDocument

endcase

'
'-------------------------------------------------------------------------------
'
testcase tEditSheetDelete

    Call  hNewDocument

    EditDeleteSheet
    Kontext
    if active.exists then
       DialogTest ( Active )   
       Active.No
    else
       warnlog "Edit::Sheet::Delete - no removal warning appeared!"
    end if
    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditDeleteManuelBreakRowBreak

    Call  hNewDocument

    DocumentCalc.Typekeys "<Down><Down><Down>"
    InsertManuelBreakRowBreak
    EditRemoveManualBreakRowBreak

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditDeleteManuelBreakColumnBreak

    Call  hNewDocument

    DocumentCalc.Typekeys "<Right><Right>"
    InsertManuelBreakColumnBreak
    wait 50
    EditRemoveManualBreakColumnBreak

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditLinks

    dim filename as String

    Call  hNewDocument
    sleep (2)
    InsertGraphicsFromFile
    sleep (2)
    Kontext "GrafikEinfuegenDlg"
    filename = ConvertPath ( gTesttoolPath + "global\input\graf_inp\baer.tif" )
    Dateiname.Settext filename
    Link.Check
    Oeffnen.Click
    sleep (2)
    Kontext "DocumentCalc"
    try
      EditLinksCalc
      printlog "#i36138# seems to be fixed -> remove Catch"
    catch
      warnlog "#i36138# (probably)"
      goto endsub
    endcatch
    sleep (2)
    Kontext "VerknuepfungenBearbeiten"
    Call DialogTest ( VerknuepfungenBearbeiten )
    sleep (2)
    VerknuepfungenBearbeiten.Close

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditPlugin

      Call  hNewDocument

        EditPlugIn
        EditPlugIn

      Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditImageMap

    dim filename as String

    Call  hNewDocument
    sleep (2)
    InsertGraphicsFromFile
    sleep (2)
    Kontext "GrafikEinfuegenDlg"
    filename = ConvertPath ( gTesttoolPath + "global\input\graf_inp\baer.tif" )
    Dateiname.Settext filename
    Link.Check
    Oeffnen.Click
    sleep (2)
    Kontext "DocumentCalc"
    EditImageMap
    sleep (2)
    Kontext "ImageMapEditor"
    Call DialogTest ( ImageMapEditor )
    sleep (2)
    ImageMapEditor.Close

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditObjectEdit
'///<u><b>Edit::Object::Edit</b></u>///

'///<ul>
   dim sInputFile as STRING
       sInputFile = convertPath ( gTesttoolPath & "calc/update/input/c_002/tEditObjectEdit.ods" )
   dim sOutputFile as STRING
       sOutputFile = convertPath ( gOfficePath & "user/work/tEditObjectEdit" & Ext)
   '///<li>File::Open</li>///
   FileOpen
   sleep(2)
   Kontext "OeffnenDlg"
      '///<li>Open test document '.../calc/update/input/c_002/tEditObjectEdit.ods'</li>///
       Dateiname.settext sInputFile
       Oeffnen.Click
       
   '///<li>NOTE: The file contains an empty, really huge chart object</li>///
   sleep(5)
   '///<li>Save file locally to prevend locking</li>///
   try
       if NOT hSpeichernUnterMitFilterKill (sOutputFile, FileFormat) then
           warnlog "Saving test document localy failed -> Aborting"
           call hCloseDocument
           goto endsub
       endif
   catch 
       qaErrorLog "Most probably there's no filter name for this language available. Trying to save without filter."
       'PJ: I would consider calling the following code a hack!
       Kontext "SpeichernDlg"
       Dateiname.SetText sOutputFile
       Speichern.Click
       Kontext "Active"
       if active.exists(2) then
           active.YES
       endif
   endcatch

   sleep(2)
   Kontext "DocumentCalc"
   '///<li>Select Chart</li>///
   selectFirstOLE
   sleep(2)
   '///<li>Edit::Object::Edit</li>///
   EditObjectEdit
   sleep(2)
   '///<li>Close document</li>///
   Call hCloseDocument
'///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tEditObjectSaveCopyAs
'///<u><b>Edit::Object::Save Copy As...</b></u>///

'///<ul>
   dim sInputFile as STRING
       sInputFile = convertPath ( gTesttoolPath & "calc/update/input/c_002/tEditObjectSaveCopyAs.ods" )
   dim sOutputFile as STRING
       sOutputFile = convertPath ( gOfficePath & "user/work/tEditObjectSaveCopyAs" & Ext)
   dim oleFile as STRING
       oleFile = convertPath ( gOfficePath & "user/work/tEditObjectSaveCopyAs.odt")
   if Dir(oleFile) <> "" then
      kill oleFile
   endif
   '///<li>File::Open</li>///
   FileOpen
   sleep(2)
   Kontext "OeffnenDlg"
      '///<li>Open test document '.../calc/update/input/c_002/tEditObjectSaveCopyAs.ods'</li>///
       Dateiname.settext sInputFile
       Oeffnen.Click
       
   '///<li>NOTE: The file contains an empty, really huge chart object</li>///
   sleep(5)
   '///<li>Save file locally to prevend locking</li>///
   try
       if NOT hSpeichernUnterMitFilterKill (sOutputFile, FileFormat) then
           warnlog "Saving test document localy failed -> Aborting"
           call hCloseDocument
           goto endsub
       endif
   catch 
       qaErrorLog "Most probably there's no filter name for this language available. Trying to save without filter."
       'PJ: I would consider calling the following code a hack!
       Kontext "SpeichernDlg"
       Dateiname.SetText sOutputFile
       Speichern.Click
       Kontext "Active"
       if active.exists(2) then
           active.YES
       endif
   endcatch
   sleep(2)
   Kontext "DocumentCalc"
   '///<li>Select writer OLE</li>///
   selectFirstOLE
   sleep(2)
   '///<li>Edit::Object::Save Copy As...</li>///
   EditObjectSaveCopyAsCalc
   sleep(2)
   Kontext "SpeichernDlg"
       '///<li>Enter file name for writer OLE</li>///
       Dateiname.setText oleFile
       '///<li>Click save button</li>///
       Speichern.click
       
   sleep(2)
   if Dir(oleFile) = "" then
      warnlog "Saving a copy of the OLE seems to fail -> Check this out!"
   else
      printlog "Saving a copy of the OLE seems to work!"
   endif
   '///<li>Close document</li>///
   Call hCloseDocument
'///</ul>
endcase

