'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch_105a.inc,v $
'*
'*  $Revision: 1.11 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:01:09 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description : Chart Level 1 test - section FORMAT 2
'*
'************************************************************************
'*
' #1 ch_105a     ' Initial routine
' #1 tFormatTitle
' #1 tFormatLegend
' #1 tFormatAxisXaxis
' #1 tFormatAxisYaxis
'*
'\***********************************************************************

Global GFile as String

sub ch_105a

   printLog "---------  Ch_105a     ----------"

   call tFormatTitle
   Call tFormatLegend
   call tFormatAxisXaxis
   call tFormatAxisYaxis

end sub
'
'-----------------------------------------------------------
'
testcase tFormatTitle
'/// This test checks the available settings in the FormatTitle dialog.
'/// First a chart is created which based on datas of a calc document.

   Dim lager
   Dim binichda
   dim tabtitel, SFile as string
   dim st_Type, st_start, st_finish as string
   dim st_area as boolean
   SFile = convertpath(gOfficePath & "user/work/tFormatTitle" & Ext)

   Call basedocument ("CHART")
   EditObjectEdit
'/// Insert a title, check the maintitle and set the titletext
   InsertTitle
   Kontext "Titel"
   Haupttitel.check
   HaupttitelText.settext "Modifier text"
   Titel.Ok
'/// Save the document
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
   if NOT fSaveAsWithFilterKillCatchMissingName (sFile, FileFormat) then
      warnlog "Saving File failed"
      hCloseDocument
      goto endsub
   endif

   Kontext "DocumentCalc"
   selectFirstOLE
   EditObjectEdit
   Kontext "DocumentChart"
'/// Select the main title in the chart and call the menu item 'FormatTitleMainTitle'
   DocumentChart.mousedown 50,8
   DocumentChart.mouseup 50,8
   FormatTitleMainTitle
   Kontext
'/// Goto tab page 'TabLine' and modify style and color
   active.setpage TabLinie
   Kontext "TabLinie"
   Stil.select 2
   Farbe.select 13
   Kontext
'/// Goto tab page 'TabArea' and modify gradient, gradient type, automatic and increments
   active.setpage TabArea
   Kontext "TabArea"
   FillOptions.select 3
   GradientList.select 3
   Automatic.uncheck
   Increments.settext "4"
   Kontext
'/// Goto tab page 'TabTransparency' and modify the transparency, transparency gradient, degree,
'/// startvalue, endvalue and border
   active.setpage TabTransparenz
   Kontext "TabTransparenz"
   LineareTransparenz.check
   if TransparenzverlaufTyp.isenabled or MFZentrumX.isenabled or MFZentrumY.isenabled or _
      MFWinkel.isenabled or MFRand.isenabled or MFStartwert.isenabled or MFEndwert.isenabled then
         Warnlog "The Controls for transparency gradient are enabled although this radiobutton isn't checked!"
   end if
   Transparenzverlauf.check
   TransparenzverlaufTyp.Select 5
   st_Type = TransparenzverlaufTyp.GetSelText
   MFStartwert.More 2
   st_start = MFStartwert.GetText
   MFEndwert.Less 2
   st_finish = MFEndwert.GetText
   Kontext
'/// Goto tab page 'TabFont' and modify the font and the font size
   active.setpage TabFont
   Kontext "TabFont"
   if asian then
      FontEast.select 7
      SizeEast.setText "17"
   else
      Font.select 7
      Size.select 17
   end if
   Kontext
'/// Goto tab page 'TabFontEffects' and modify underline, shadow and font color
   active.setPage TabFontEffects
   Kontext "TabFontEffects"
   Underline.select 2
   Shadow.check
   FontColor.select 17
   Kontext
'/// Goto tab page 'TabAlignmentChart' and modify degree and alignment
   active.setpage TabAusrichtungChart
   Kontext "TabAusrichtungChart"
   Grad.settext "45"
   TabAusrichtungChart.Ok
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
   Kontext
   if active.exists then active.cancel
   Kontext "DocumentCalc"
   DocumentCalc.MouseDown 10,10
   DocumentCalc.MouseUp 10,10
   DocumentCalc.TypeKeys "<MOD1 S>"
   call hCloseDocument
   sleep(2)
   call hDateioeffnen SFile
   sleep(2)
   Kontext "DocumentCalc"
   if NOT fSelectChartByNumber ( 1 ) then
       warnlog "Selecting desired chart seems to fail -> Expecting more errors to come in this testcase"
   endif
   EditObjectEdit
   sleep (2)
'/// Select the embedded chart with a double click and check all made settings
   FormatTitleMainTitle
   Kontext
   active.setpage TabLinie
   kontext "TabLinie"
   if Stil.getselindex = 2 then
      if Farbe.getselindex = 13 then
         Printlog "Settings are OK"
      else
         Warnlog "Color settings aren't correct " & farbe.getselindex & " instead of 7"
      end if
   else
      Warnlog "Style settings aren't correct " & Stil.getselindex & " instead of 3"
   end if
   Kontext

   active.setpage TabArea
   Kontext "TabArea"
   if FillOptions.GetSelIndex = 3 and GradientList.getselindex = 3 and Automatic.ischecked = False and Increments.gettext = "4" then
      Printlog "Settings are OK"
      else
         Warnlog "ColorGradient:3 Step:4  aren't correct"
         if Gradient.ischecked = False then
            Warnlog "ColorGradient isn't checked"
         else
            Warnlog "ColorGradient " & GradientList.getselindex & " instead of 3"
         if Automatic.ischecked = False then
            Warnlog "StepWidth automatic is not in function"
         else
            Warnlog "StepWidth " & Increments.gettext & " instead of 4"
         end if
      end if
   end if
   Kontext

   active.setpage TabTransparenz
   Kontext "TabTransparenz"
   printlog "* Tabpage Transparence"
   st_area = true
   if NOT Transparenzverlauf.ischecked then
      Warnlog "Tranparency Gradient isn't checked, but it should be!"
      st_area = false
   end if
   if st_Type <> TransparenzverlaufTyp.GetSelIndex then
      Warnlog "The type of transparency is: " & TranparenzverlaufTyp.GetSelIndex & " but it should be: " & st_type
      st_area = false
   end if
   if st_start <> MFStartwert.GetText then
      Warnlog "The start value for transparency is: " & MFStartwert.GetText & " but it should be: " & st_start
      st_area = false
   end if
   if st_finish <> MFEndwert.GetText then
      Warnlog "The finish value for transparency is: " &  MFEndwert.GetText & " but it should be: " & st_finish
      st_area = false
   end if
   if st_area = true then
      printlog "OK, all settings on the tabpage Transparency has been taken over!"
   end if
   Kontext

   active.setpage TabFont
   Kontext "TabFont"
   if asian then
      if FontEast.getselindex = 7 then
         printlog "OK, the Font has been correct selected"
      else
         warnlog "The font is " & FontEast.getselindex & " instead of 7"
      end if
      if SizeEast.getSelText = "17" then
         printlog "OK, the Size has been correct selected"
      else
         warnlog "The size is " & SizeEast.getSelText & " instead of 17"
      end if
   else
      if Font.getselindex = 7 then
         printlog "OK, the Font has been correct selected"
      else
         warnlog "The font is " & Font.getselindex & " instead of 7"
      end if
      if Size.getSelIndex = 17 then
         printlog "OK, the Size has been correct selected"
      else
         warnlog "The size is " & Size.getSelText & " instead of 17"
      end if
   end if
   Kontext

   active.setpage TabFontEffects
   Kontext "TabFontEffects"
   if Shadow.ischecked then
      printlog "OK, Shadow is checked"
   else
      warnlog "Shadow is NOT checked, but it should be"
   end if
   if Underline.getSelIndex = 2 then
      printlog "OK, the correct underline is selected"
   else
      warnlog "The underline has the index " & Underline.getSelIndex & " but it has to be the index 2"
   end if
   Kontext

   active.setpage TabAusrichtungChart
   Kontext "TabAusrichtungChart"
   printlog "* Tabpage Alignment"
   if Grad.gettext = "45" then
      Printlog "Settings are correct"
   else
      Warnlog "The settings aren't correct Degrees " & Grad.gettext & " instead of 45"
   end if
   TabAusrichtungChart.Cancel

   call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tFormatLegend
'/// This test checks the available settings in the FormatLegend dialog.
'/// First a chart is created which based on datas of a calc document.

   Call basedocument ("CHART")
   EditObjectEdit
   Dim SFile
   Dim width_line, width_area, height_area as string

   SFile = convertpath(gOfficePath & "user/work/tlegend" & Ext)
   Kontext "Diagramm"

   printlog "Adjustment of the parameters for the legend"
'/// 'FormatLegend' is called and tab page 'TabLine' selected
'/// style, color and width are modified
   FormatLegend
   Kontext
   Active.SetPage TabLinie
   Kontext "TabLinie"
   Stil.Select 6
   Farbe.Select 8
   Breite.more 2
   width_line = Breite.GetText
   if Transparenz.IsEnabled then
      Transparenz.Settext "50%"
   endif
'/// Select tabpage 'TabArea' and modify checkboxes bitmap, tile, stretch and original
   Kontext
   Active.SetPage TabArea
   Kontext "TabArea"
   FillOptions.select 5
   BitmapList.Select 2
   Tile.Uncheck
   Stretch.UnCheck
   Original.UnCheck

   if Width.IsEnabled then
      Width.more 5
      width_area = Width.GetText
   else
      Warnlog "Adjustment for width 'disabled'! "
   endif

   if Height.IsEnabled then
      Height.more 5
      height_area = Height.GetText
   else
      Warnlog "Adjustment for height 'disabled'! "
   endif
'/// select tabpage 'TabFont' and modify font, fontsize
   Kontext
   Active.SetPage TabFont
   Kontext "TabFont"
   if asian then
      FontWest.Select 17
      if iSprache = 86 or iSprache = 88 then
         SizeWest.Select "14"
      else
         SizeWest.Select 14
      end if
   else
      Font.Select 17
      Size.Select 14
   end if
'/// select tabpage 'TabFontEffects' and modify outline, fontcolor
   Kontext
   Active.SetPage TabFontEffects
   Kontext "TabFontEffects"
   Outline.Check
   FontColor.Select 13
   Kontext
'/// select tabpage 'TabAlignmentLegend' and modify top
   Active.SetPage TabAnordnungLegende
   Kontext "TabAnordnungLegende"
   Oben.Check
   TabAnordnungLegende.OK
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
'/// Save, close and reopen the document
   Printlog "Saving document"
   if NOT fSaveAsWithFilterKillCatchMissingName (sFile, FileFormat) then
      warnlog "Saving File failed"
      hCloseDocument
      goto endsub
   endif
   call hCloseDocument
   call hDateioeffnen(SFile)
   sleep (3)
   Kontext "DocumentCalc"
   if NOT fSelectChartByNumber ( 1 ) then
       warnlog "Selecting desired chart seems to fail -> Expecting more errors to come in this testcase"
   endif
   EditObjectEdit
   sleep (2)

   ' #######   Checking adjustments after saving       ###########
'/// Check all made settings
   FormatLegend
   Printlog "Checking adjustments"
   Kontext
   Active.SetPage TabUmrandungChart
   Kontext "TabUmrandungChart"
   if Stil.GetSelIndex <> 6 then
      Warnlog "Style wasn't adapted"
   end if

   if Farbe.GetSelIndex <> 8 then
      Warnlog "Color wasn't adapted"
   end if

   if Breite.Gettext <> width_line then
      Warnlog "Width wasn't adapted"
   end if

   if Transparenz.GetText <> "50%" then
         Warnlog "Transparency wasn't adapted"
   endif

   printlog "Checking tabpage area"
   Kontext
   Active.SetPage TabArea
   Kontext "TabArea"

   if NOT FillOptions.GetSelIndex = 5 then
   Warnlog "Adjustments for bitmap weren't saved correctly"
   endif

   if BitmapList.GetSelIndex <> 2 then
   Warnlog "Adjustments for bitmap weren't saved correctly"
   endif

   if Tile.IsChecked then
      Warnlog "Adjustments for Page frames weren't adapted"
   endif

   if Stretch.IsChecked then
      Warnlog "Adjustment adaptation weren't saved correctly"
   endif

   if Original.IsChecked then
      Warnlog "Adjustments for original weren't saved correctly"
   endif

   if Width.Gettext<> width_area then
      Warnlog "Adjustments for width weren't saved correctly"
   end if

   if Height.Gettext<> height_area then
      Warnlog "Adjustments for height weren't saved correctly"
   end if

   Printlog "Checking tab page text attributes"
   Kontext
   Active.SetPage TabFont
   Kontext "TabFont"

   if asian then
      if FontWest.GetSelIndex <> 17 then
         Warnlog "Adjustments for character font weren't saved correctly"
      end if
   else
      if Font.GetSelIndex <> 17 then
         Warnlog "Adjustments for character font weren't saved correctly"
      end if
   end if

   if asian then
      if iSprache = 86 or iSprache = 88 then
         if SizeWest.GetSelText <> "14" then
            Warnlog "Adjustment for character size weren't saved correctly. It is " & SizeWest.GetSelIndex & " instead of 14"
         end if
      else
      if SizeWest.GetSelIndex <> 14 then
         Warnlog "Adjustment for character size weren't saved correctly. It is " & SizeWest.GetSelIndex & " instead of 14"
      end if
        end if
      else
         if Size.GetSelIndex <> 14 then
            Warnlog "Adjustment for character size weren't saved correctly"
         end if
      end if
      Kontext
      Active.SetPage TabFontEffects
      Kontext "TabFontEffects"

      if FontColor.GetSelIndex <> 13 then
         Warnlog "Color adjustment wasn't saved correctly"
      end if

      if Outline.IsChecked=False then
         Warnlog "checkbox outline wasn't adjusted correctly"
      end if

    TabFontEffects.Cancel
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tFormatAxisXaxis
'/// This test checks the available settings in the FormatAxisXaxis dialog.
'/// First a chart is created which based on datas of a calc document.

   Dim gradtest
   Dim width_xaxis as string

   Dim SFile
   SFile= convertpath (gOfficePath & "user/work/tFormatAxisXaxis" & Ext)
   Dim StrBreite$, StrTransparenz$

   printlog "FormatAxisX_Axis"

   Call basedocument ("CHART")
   EditObjectEdit
'/// Call the menu item 'FormatAxisXAxis'
   FormatAxisXAxis
   printlog "Make settings"
'/// Select tab page 'TabLine' and modify style, color and width
   Kontext
   active.SetPage TabLinie
   Kontext "TabLinie"
   Stil.select 4
   Farbe.select 5
   Breite.more 4
   width_xaxis = Breite.GetText
   Transparenz.more 4
'/// Select tab page 'TabFont' and modify font, fontsize and font style
   kontext
   active.SetPage TabFont
   Kontext "TabFont"
   if asian then
      FontWest.Select 4
      StyleWest.select 3
      SizeWest.SetText "22"
   else
      Font.Select 4
      Style.select 3
      Size.SetText "22"
   end if
'/// Select tab page 'TabFontEffects' and modify font color, outline, shadow, underline and strike through
   Kontext
   active.setpage TabFontEffects
   Kontext "TabFontEffects"
   FontColor.select 11
   Outline.check
   Shadow.check
   Underline.select 2
   StrikeThrough.select 2
'/// Select tab page 'TabLabelChart' and modify degree, overlap and break
   kontext
   active.SetPage TabBeschriftungChart
   Kontext "TabBeschriftungChart"
   If NOT zeigeBeschriftung.isChecked then warnlog "Labels aren't checked by default!"
   Grad.SetText "70"
   Ueberlappend.check
   Umbruch.check
   TiefHochVersetzt.check
   TabBeschriftungChart.OK

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
'/// Save the document, close and reopen it
   if NOT fSaveAsWithFilterKillCatchMissingName (sFile, FileFormat) then
      warnlog "Saving File failed"
      hCloseDocument
      goto endsub
   endif
   kontext "Active"
   if Active.exists then
      Active.OK
      warnlog "Error while loading document"
      goto endtest
   end if
   call hCloseDocument
    call hDateiOeffnen SFile
    sleep (3)
    Kontext "DocumentCalc"
    if NOT fSelectChartByNumber ( 1 ) then
        warnlog "Selecting desired chart seems to fail -> Expecting more errors to come in this testcase"
    endif
    EditObjectEdit
    sleep (2)

    printlog "- Check settings"

'/// Check all made settings
   FormatAxisXAxis

   Kontext
   active.SetPage TabLinie
   Kontext "TabLinie"
   if Stil.GetSelIndex <> 4 then
      warnlog "Style settings hasn't been taken over!"
   end if
   if Farbe.GetSelIndex <> 5 then warnlog "Color settings hasn't been taken over!"

   StrBreite$ = Breite.GetText
   StrTransparenz$ = Transparenz.GetText
        if StrBreite$ <> width_xaxis then
         warnlog "Width settings hasn't been taken over! Width is: " + StrBreite$
        end if
        if StrTransparenz$ <> "20%" then
         warnlog "Transparency settings hasn't been taken over. Transparency is: " + StrTransparenz$
   end if

   Kontext
   active.SetPage TabFont
   Kontext "TabFont"
   if asian then
       if FontWest.GetSelIndex <> 4 then
         warnlog "Font type hasn't been taken over!"
           warnlog "Font type is: " + FontWest.GetSelText
       end if
   else
      if Font.GetSelIndex <> 4 then
         warnlog "Font type hasn't been taken over!"
           warnlog "Font type is: " + FontWest.GetSelText
       end if
   end if

   if asian then
       if StyleWest.GetSelIndex <> 3 then
         warnlog "Font style hasn't been taken over!"
         warnlog "Font style is: " + StyleWest.GetSelIndex
       end if
   else
      if Style.GetSelIndex <> 3 then
         warnlog "Font style hasn't been taken over!"
         warnlog "Font style is: " + StyleWest.GetSelIndex
       end if
   end if

   if asian then
       if left(SizeWest.GetSelText, 2) <> "22" then
         warnlog "Font size hasn't been taken over!"
         warnlog "Font size is: " + SizeWest.GetSelText
       end if
   else
      if left(Size.GetSelText, 2) <> "22" then
         warnlog "Font size hasn't been taken over!"
         warnlog "Font size is: " + SizeWest.GetSelText
       end if
   end if

   kontext
   active.setpage TabFontEffects
   kontext "TabFontEffects"
   If NOT FontColor.GetSelIndex = 11 then warnlog "Settings for Color hasn't been taken over!"
   If NOT Outline.IsChecked then warnlog "Outline isn't checked!"
   If NOT Shadow.IsChecked then warnlog "Shadow isn't checked!"
   If Underline.getselindex <> 2 then warnlog "Underline.select is " & Underline.getselindex & " instead of 2."
   If StrikeThrough.getselindex <> 2 then warnlog "StrikeThrough.select is " & StrikeThrough.getselindex & " instead of 2."


   Kontext
   active.SetPage TabBeschriftungChart
   Kontext "TabBeschriftungChart"

   If NOT zeigeBeschriftung.isChecked then warnlog "BUG: Labels on Tab Page Labels isn't checked by default!"
   gradtest = Grad.GetText
   If gradtest <> "70" then
      warnlog "Degree settings hasn't been taken over!"
      warnlog "Degree announce : " + gradtest
   end if
   If NOT Ueberlappend.IsChecked then
      warnlog "Overlapping isn't checked!"
   end if
   If NOT Umbruch.IsChecked then warnlog "Brake isn't checked!"
   If NOT TiefHochVersetzt.IsChecked then warnlog "Low-high-shifts isn'tchecked!"

    TabBeschriftungChart.OK

    kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
   call hCloseDocument
endtest:
endcase
'
'-----------------------------------------------------------
'
testcase tFormatAxisYaxis
'/// This test check the available settings in the FormatAxisYaxis dialog.
'/// First a chart is created which based on datas of a calc document.

   Dim width_yaxis as string
   Dim gradtest
   Dim SFile
   SFile= convertpath (gOfficePath & "user/work/tFormatAxisYaxis" & Ext)
    Dim StrBreite$, StrTransparenz$, syslng$
    dim syslngNr as integer
    Dim Formatchk$
    Dim leadzero as integer

   select case iSprache
      case 01  : syslng$ = "Default"
      case 31  : syslng$ = "Standaard"
      case 33  : syslng$ = "Par défaut"
      case 34  : syslng$ = "Predeterminado"
      case 39  : syslng$ = "Standard"
      case 46  : syslng$ = "standard"
      case 49  : syslng$ = "Standard"
      case 55  : syslng$ = "Padrão"
      case 81  : syslng$ = "標準"
      case 82  : syslng$ = "기본값"
      case 86  : syslng$ = "标准"
      case 88  : syslng$ = "預設"
      case else : QAErrorLog "This testcase is only designed to run on BIG 10 languges"
                       goto endsub
   end select

   printlog "FormatAxisY-Axis"

   Call basedocument ("CHART")
   EditObjectEdit
'/// Call the menu item 'FormatAxisYAxis'
   FormatAxisYAxis
   printlog " Make settings"
   Kontext
'/// goto tab page 'TabLine' and modify style, color, width and transparency
   active.SetPage TabLinie
   Kontext "TabLinie"
   Stil.select 4
   Farbe.select 5
   Breite.more 4
   width_yaxis = Breite.GetText
   Transparenz.more 4
   kontext
'/// goto tab page 'TabFont' and modify font, font style and fontsize
   active.SetPage TabFont
   Kontext "TabFont"
   if asian then
      FontWest.Select 4
      StyleWest.select 3
      SizeWest.SetText "22"
   else
      Font.Select 4
      Style.select 3
      Size.SetText "22"
   end if
   kontext
'/// goto tab page 'TabFontEffects' and modify outline, shadow, strike through and font color
   active.setpage TabFontEffects
   kontext "TabFontEffects"
   Outline.check
   Shadow.check
   Underline.select 2
   StrikeThrough.select 2
   FontColor.select 11

   kontext
'/// goto tab page 'TabScale' and modify minimum, maximum, major interval, minor interval,
'/// logarithmic scale, axis marks and inner marks
   active.SetPage TabSkalierung
   Kontext "TabSkalierung"

   If NOT MinimumAutomatisch.IsChecked then
      warnlog "Minimum Automatic isn't checked by default!"
   else
      MinimumAutomatisch.unCheck
   end if

   If NOT MaximumAutomatisch.IsChecked then
      warnlog "Maximum Automatic isn't checked by default!"
   else
      MaximumAutomatisch.uncheck
   end if

   If NOT HauptintervallAutomatisch.IsChecked then
      warnlog "Major Interval Automatic isn't checked by default!"
   else
      HauptintervallAutomatisch.unCheck
   end if

   If NOT HilfsintervallAutomatisch.IsChecked then
      warnlog "Minor Interval Automatic isn't checked by default!"
   else
      HilfsintervallAutomatisch.unCheck
   end if

   If AchseBeiAutomatisch.IsChecked then
      warnlog "Axis at Automatic is checked by default!"
   end if

   If LogarithmischeSkalierung.IsChecked then
      warnlog "Logarithmic Scale is checked by default!"
   end if

   Minimum.SetText "-20"
   Maximum.SetText "100"
   Hauptintervall.SetText "5"
   Hilfsintervall.SetText "2"
   AchseBei.SetText "3"

   if AchsenmarkierungenInnen.IsChecked then
      warnlog "Axis marks Inner are checked by default!"
   else
      AchsenmarkierungenInnen.check
   end if

   if NOT AchsenmarkierungenAussen.IsChecked then
      warnlog "Axis marks Outer aren't checked by default!"
   end if

        if HilfsmarkierungenInnen.IsChecked then
      warnlog "Tick marks Inner are checked by default !"
   else
      HilfsmarkierungenInnen.Check
   end if

   if HilfsmarkierungenAussen.IsChecked then
      warnlog "Tick marks Outer are checked by default!"
   else
      HilfsmarkierungenAussen.Check
   end if
'/// goto tab page 'TabNumbers' and modify category, number format, decimal places, leading zeros,
'/// negative numbers and thousand separator
   Kontext
   active.SetPage TabZahlen
   Kontext "TabZahlen"
   if Standardformat.ischecked then
      Standardformat.uncheck
   end if

   Kategorie.select 1
   ZahlenFormat.select 6

   Nachkommastellen.more 2    ' creates Numberformat 7
   FuehrendeNullen.more 2
   leadzero = FuehrendeNullen.GetText
   NegativInRot.check         ' creates Numberformat 8
   Tausenderpunkt.check

   if Sprache.GetSelText <> syslng$ then warnlog "Language hasn't been set on system!"
   printlog Sprache.GetSelText
   printlog "Format code is: " + Formatcode.GetText
   Formatchk$ = Formatcode.GetText
   if NOT PBHinzufuegen.isEnabled then warnlog "PBAdd is not enabled"
   if NOT PBInfo.isEnabled then warnlog "PBInfo is not enabled!"
   if PBEntfernen.isEnabled then warnlog "PBRemove is enabled!"

'/// goto tab page 'TabLabels' and modify degree, overlap, break, order and text flow
   Kontext
   active.SetPage TabBeschriftungChart
   Kontext "TabBeschriftungChart"
   If NOT zeigeBeschriftung.isChecked then warnlog "ShowLabels isn't checked by default!"
   Grad.SetText "70"
   Ueberlappend.check
   Umbruch.check
   TiefHochVersetzt.check

   TabBeschriftungChart.OK
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
'/// Save, close and reopen the document
   if NOT fSaveAsWithFilterKillCatchMissingName (sFile, FileFormat) then
      warnlog "Saving File failed"
      hCloseDocument
      goto endsub
   endif
   call hCloseDocument
   call hDateioeffnen SFile
   Kontext "DocumentCalc"
   if NOT fSelectChartByNumber ( 1 ) then
       warnlog "Selecting desired chart seems to fail -> Expecting more errors to come in this testcase"
   endif
   EditObjectEdit
   sleep (2)
   printlog " Check settings"
'/// Check all made settings
   'Check the made settings

   FormatAxisYAxis
   Kontext
   active.SetPage TabLinie
   Kontext "TabLinie"
   if Stil.GetSelIndex <> 4 then
      warnlog "Style settings hasn't been taken over!"
   end if
   if Farbe.GetSelIndex <> 5 then warnlog "Color settings hasn't been taken over!"

   StrBreite$ = Breite.GetText
   StrTransparenz$ = Transparenz.GetText
   if StrBreite$ <> width_yaxis then
      warnlog "Width settings hasn't been taken over! Width is: " + StrBreite$
   end if
   if StrTransparenz$ <> "20%" then
      warnlog "Transparency settings hasn't been taken over. Transparency is : " + StrTransparenz$
   end if

   Kontext
   active.SetPage TabFont
   Kontext "TabFont"
   if asian then
       if FontWest.GetSelIndex <> 4 then
         warnlog "Font hasn't been taken over!"
               warnlog "Font is: " + FontWest.GetSelText
       end if
   else
       if Font.GetSelIndex <> 4 then
         warnlog "Font hasn't been taken over!"
               warnlog "Font is: " + FontWest.GetSelText
       end if
   end if

   if asian then
       if StyleWest.GetSelIndex <> 3 then
         warnlog "Style hasn't been taken over!"
         warnlog "Style is: " + StyleWest.GetSelIndex
       end if
   else
       if Style.GetSelIndex <> 3 then
         warnlog "Style hasn't been taken over!"
         warnlog "Style is: " + StyleWest.GetSelIndex
       end if
   end if

   if asian then
       if left(SizeWest.GetSelText, 2) <> "22" then
         warnlog "Size hasn't been taken over!"
         warnlog "Size is: " + SizeWest.GetSelText
       end if
   else
       if left(Size.GetSelText, 2) <> "22" then
         warnlog "Size hasn't been taken over!"
         warnlog "Size is: " + SizeWest.GetSelText
       end if
   end if


   kontext
   active.setpage TabFontEffects
   kontext "TabFontEffects"
   If NOT Outline.IsChecked then warnlog "Outline isn't checked!"
   If NOT Shadow.IsChecked then warnlog "Shadow isn't checked!"
   If Underline.getselindex <> 2 then warnlog "Underline hasn't been taken over"
   If StrikeThrough.getselindex <> 2 then warnlog "Strike through isn't checked!"
   If NOT FontColor.GetSelIndex = 11 then warnlog "Color settings hasn't been taken over!"
   Kontext
   active.SetPage TabSkalierung
   Kontext "TabSkalierung"

   If MinimumAutomatisch.IsChecked then
      warnlog "MinimumAutomatic is checked!"
   end if

   If MaximumAutomatisch.IsChecked then
      warnlog "MaximumAutomatic is checked!"
   end if

   If HauptintervallAutomatisch.IsChecked then
      warnlog "MajorIntervalAutomatic is checked!"
   end if

   If HilfsintervallAutomatisch.IsChecked then
      warnlog "MinorIntervalAutomatic is checked!"
   end if

   If AchseBeiAutomatisch.IsChecked then
      warnlog "AxisatAutomatic is checked!"
   end if

   If LogarithmischeSkalierung.IsChecked then
      warnlog "LogarithmicScale is checked!"
   end if


   if NOT (Minimum.GetText = "-20.0000" OR Minimum.GetText = "-20,0000") then
       warnlog "Minimum: settings hasn't been taken over!"
   endif
   if NOT (Maximum.GetText = "100.0000" OR Maximum.GetText = "100,0000") then
       warnlog "Maximum: settings hasn't been taken over!"
   endif
   if NOT (Hauptintervall.GetText = "5.00000" OR Hauptintervall.GetText = "5,00000") then
       warnlog "MajorInterval: settings hasn't been taken over!"
   endif
   if NOT (Hilfsintervall.GetText = "1.66667" OR Hilfsintervall.GetText = "1,66667") then
       warnlog "MinorInterval: settings hasn't been taken over!"
   endif
   if NOT (AchseBei.GetText = "3.0000" OR AchseBei.GetText = "3,0000") then
       warnlog "Axisat: settings hasn't been taken over!"
   endif

   if NOT AchsenmarkierungenInnen.IsChecked then
      warnlog "AxismarksInner isn't checked!"
   end if

   if NOT AchsenmarkierungenAussen.IsChecked then
      warnlog "AxismarksOuter isn't checked!"
   end if

        if NOT HilfsmarkierungenInnen.IsChecked then
      warnlog "TickmarksInner isn't checked!"
   end if

   if NOT HilfsmarkierungenAussen.IsChecked then
      warnlog "TickmarksOuter isn't checked!"
   end if

   Kontext
   active.SetPage TabZahlen
   Kontext "TabZahlen"

   If Kategorie.GetSelIndex <> 3 then warnlog "Category: settings hasn't been taken over!"
   printlog "Kategorie.GetSelIndex " & Kategorie.GetSelIndex
   If ZahlenFormat.GetSelIndex <> 8 then warnlog "Format: settings hasn't been taken over!"
   printlog "ZahlenFormat.GetSelIndex " & ZahlenFormat.GetSelIndex
   If Nachkommastellen.GetText <> "4" then warnlog "DecimalPlaces: settings hasn't been taken over!"
   printlog Nachkommastellen.GetText
   If FuehrendeNullen.GetText <> leadzero then warnlog "LeadingZeros: settings hasn't been taken over!"
   printlog "FuehrendeNullen.GetText " & FuehrendeNullen.GetText
   If NOT NegativInRot.isChecked then warnlog "NegativeNumbersinRed: settings hasn't been taken over!"
   If NOT Tausenderpunkt.isChecked then warnlog "NegativeNumbersinRed: settings hasn't been taken over!"

   printlog "Formatcode : " + Formatcode.GetText
   If Formatcode.GetText <> Formatchk$ then warnlog "Formatcode: settings hasn't been taken over!"

   if PBHinzufuegen.isEnabled then warnlog "PBAdd is enabled by default!"
   if NOT PBInfo.isEnabled then warnlog "PBInfo isn't enabled!"
   if NOT PBEntfernen.isEnabled then warnlog "PBRemove isn't enabled!"
   Kontext

   active.SetPage TabBeschriftungChart
   Kontext "TabBeschriftungChart"
   If NOT zeigeBeschriftung.isChecked then warnlog "ShowLabel isn't checked by default!"
   gradtest = Grad.GetText
   If gradtest <> "70" then
      warnlog "Degrees hasn't been taken over! Degrees is : " + gradtest
   end if
   If NOT Ueberlappend.IsChecked then
      warnlog "Overlap isn't checked!"
   end if
   If NOT Umbruch.IsChecked then warnlog "Break isn't checked!"
   If NOT TiefHochVersetzt.IsChecked then warnlog "StaggerEven isn't checked!"

   TabBeschriftungChart.OK

   kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
   call hCloseDocument

endcase
'
'-----------------------------------------------------------
'

