'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch_losa_ods.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:47 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Conversion of Microsoft OLE objects in dependency of settings in Tools::Options::Load/Save::MS_Office
'*
'************************************************************************
'*
' #1 subLosaODS        ' Initial routine
' #1 tLoadSaveODStoODS
'*
'\************************************************************************

sub subLosaODS
'///<u><b>Load/Save ODS files with charts</b></u>///
  printLog Chr(13) + "---------  Save ODS as ODS   ----------"

'///<ul>
dim sSourcePath as  STRING
    sSourcePath = convertPath ( gtesttoolpath & "chart\loadsave\input\ods\" )
'///<li>Determine list of files to test (All ODS files in 'chart\loadsave\input\ods\')</li>///
dim lsInputFileList ( 500 ) as STRING
    Call GetAllFileList( sSourcePath , "*.ods" , lsInputFileList() )
'///<li>Determine number of files found</li>///   
dim iFilesInList as INTEGER
    iFilesInList = cInt( lsInputFileList(0) )

'///<li>Run testcase 'tLoadSaveODStoODS' for each file in list</li>///
dim iMainIndex as INTEGER
    for iMainIndex = 2 to iFilesInList
        printlog "Loop " & ( iMainIndex - 1 ) & " of " & ( iFilesInList - 1 )
        printlog "Test document: " & lsInputFileList( iMainIndex )
        call tLoadSaveODStoODS ( lsInputFileList( iMainIndex ) , iMainIndex )
    next iMainIndex
'///</ul>
End Sub

'*******************************************************************

testcase tLoadSaveODStoODS ( sCurrentFile as STRING , iCurrentLoop as INTEGER)
'///<u><b>Load ODS file - SaveAs... ODS - Close - Relaod</b></u>///

dim sOutputFile as STRING
    sOutputFile = ( gOfficePath & ConvertPath("user\work\") & "odsWithChartSavedAsODS_" & iCurrentLoop & ".ods"  )
dim iIndex as INTEGER
'///<ul>   
    '///<li>Open test document</li>///
    call hDateiOeffnen ( sCurrentFile )
    sleep (2)
    '///<li>Invoke navigator if invisible</li>///
    Kontext "NavigatorCalc"
    if NOT NavigatorCalc.exists (3) then
        EditNavigator
    end if
    '///<li>Select chart using navigator</li>///
    Liste.TypeKeys "<HOME>"
    '///<li>(Travel top to bottom through all categories above OLE objects)</li>///
    for iIndex = 1 to 6
    '///<li>(Make sure all elements in category are hidden, apply '-' key)</li>///
         Liste.TypeKeys "-<DOWN>"
    next iIndex
    '///<li>(Select desired category)</li>///
    Liste.select ( 6 )
    '///<li>(Unfold elements of selected category)</li>///
    Liste.TypeKeys "+"
    '///<li>(Select desired position within category)</li>///
    Liste.select ( 7 )
    '///<li>(Hit 'RETURN' key to select element in document)</li>///
    Liste.TypeKeys "<RETURN>"
   
    Kontext "DocumentCalc"
    '///<li>Invoke 'Edit::Object::Edit' to enter inplace mode</li>///
    '///<li>(This triggers the chart engine - Without activating the chart only a substuional image is displayed)</li>///
    EditObjectEdit
    sleep(3)
    '///<li>Hit 'ESCAPE' key to leave inplace mode</li>///
    DocumentCalc.TypeKeys "<ESCAPE>"
    'call gMouseclick ( 99 , 99 )
    '///<li>Save file using ODS format</li>///
    if hSpeichernUnterMitFilterKill ( sOutputFile , gsFileFormat ) then
        printlog "OK, successfully saved the test document!"
    else
        warnlog "Saving the testdocument failed!"
    endif
    sleep(2)
    '///<li>Close document</li>///
    printlog "Closing test document"
    call hCloseDocument
    sleep(2)
    '///<li>Open document again</li>///
    printlog "Loading test document"
    call hDateiOeffnen ( sOutputFile )
    sleep(2)
    '///<li>Close document</li>///
    printlog "Closing test document"
    call hCloseDocument
    '///<li>END</li>///
'///</ul>
endcase

