'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_formcontrols.bas,v $
'*
'*  $Revision: 1.11 $
'*
'*  last change: $Author: jsk $ $Date: 2005/12/01 12:58:34 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Form controls in BASIC-IDE dialogs
'*
'\******************************************************************************

sub main

    use "framework\basic\inc\f_basic_formcontrols.inc"

    use "framework\tools\inc\treelist_tools.inc"    
    use "framework\tools\inc\basicide_tools.inc"
    use "framework\tools\inc\security_tools.inc"
    use "framework\tools\inc\docfuncs.inc"
    use "framework\tools\inc\filetools.inc"
    use "framework\tools\inc\stringtools.inc"
    use "framework\tools\inc\formcontrols.inc"
    use "framework\tools\inc\basicorganizer_tools.inc"
    use "framework\tools\inc\pbrowser_tools.inc"

    call hStatusIn( "framework" , "f_basic_formcontrols.bas" )
    
    if ( gSysName <> "Linux" ) then
        warnlog( "#i58411# ToolsCollectionBar closes while drawing control" )
        goto skiptest
    endif
    
    ' set macro security to low
    hSetMacroSecurity( 0 )
    
    ' The Basic-Formcontrols can be stored in 3 different formats. Note that
    ' src569 (StarOffice 5.2) is not supported anymore. 645 and 641 are
    ' identical, so we test 680 and 645 only.
    
    printlog( "" )
    printlog( "OpenOffice.org 2.x" )
    call tAllControlsOnDialog( "680" )     ' OpenOffice.org 2.X

    printlog( "" )
    printlog( "OpenOffice.org 1.x" )
    call tAllControlsOnDialog( "645" )     ' OpenOffice.org 1.X  
    
    ' set macro security to medium (which is the default)
    hSetMacroSecurity( 1 )
    
    skiptest:

    call hStatusOut()

end sub

'-------------------------------------------------------------------------

sub LoadIncludeFiles

    use "global\system\inc\master.inc"
    use "global\system\inc\gvariabl.inc"
    gApplication = "WRITER"
    call GetUseFiles()

end sub

'-------------------------------------------------------------------------
