'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_ide.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:59 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check macro-dialogs / BASIC-IDE (2. part)
'*
'*******************************************************************************
' **
' #1 tBasic_IDE_Toolbar_Module        ' update-test for Toolbar in Basic-IDE
' #1 tBasic_IDE_Toolbar_Dialogs       ' check macro bar for a new dialog
' #1 tBasic_IDE_Breakpoint            ' working with breakpoints
' **
'\******************************************************************************


testcase tBasic_IDE_Toolbar_Module

    dim brc as boolean
    dim cSourceFile as string
        cSourceFile = gTesttoolpath & "framework\basic\input\resetregistration.bas"
        cSourceFile = convertpath( cSourceFile )

    '///Work with Toolbar on Basic-IDE
    '///<li>Open a new writer-doc</li>
    printlog "open a new writer-doc"
    gApplication = "Writer"


    Call hNewDocument

    '///create a new module for the new document (named TTModule)
    brc = hOpenBasicOrganizerFromDoc()
    brc = hCreateModuleForDoc()

    '///<li> now the basic-IDE is open</li>

    kontext "macrobar"
    '///<li>activate "Compile" on Toolbar</li>
    printlog "- compile"
    Compile.Click
    sleep(1)
    '///<li>activate "Run Basic" on Toolbar</li>
    printlog "- Run Basic"
    BasicRun.Click
    sleep(1)
    '///<li>activate "Step Procedure" on Toolbar</li>
    printlog "- Step Procedure"
    ProcedureStep.Click
    sleep(1)
    '///<li>activate "Stop Basic" on Toolbar</li>
    printlog "- Stop Basic"
    BasicStop.Click
    sleep(1)
    '///<li>activate "Single Step" on Toolbar</li>
    printlog "- Single Step"
    SingleStep.Click
    sleep(1)
    '///<li>activate "Step Back" on Toolbar</li>
    printlog "- Step Back"
    StepBack.Click
    sleep(1)
    '///<li>activate "Breakpoint" on Toolbar</li>
    printlog "- Breakpoint => activate"
    Breakpoint.Click
    sleep(1)
    '///<li>deactivate "Breakpoint" on Toolbar</li>
    printlog "- Breakpoint => deactivate"
    Breakpoint.Click
    sleep(1)
    '///<li>activate "Add Watch" on Toolbar</li>
    printlog "- Add Watch => deactivate"
    AddWatch.Click
    sleep(1)
    '///<li>activate "Object Catalog" on Toolbar => close 'Object'-Dialog</li>
    printlog "- Object Catalog => deactivate"
    ObjectCatalog.Click
    sleep(1)

    kontext "objekte"
    Call DialogTest (Objekte)
    Objekte.Close
    '///<li>activate "Macros" on Toolbar => close 'Macro'-Dialog</li>
    printlog "- Macros"

    kontext "macrobar"
    Macros.Click
    sleep(1)

    kontext "makro"
    Makro.Close
    '///<li>activate "Modules" on Toolbar => close 'Modules'-TabDialog</li>

    kontext "macrobar"
    printlog "- Modules"
    Modules.Click
    sleep(1)

    kontext
    Active.SetPage TabModule
    sleep(1)
    Active.SetPage TabBibliotheken

    kontext "tabbibliotheken"
    TabBibliotheken.Close
    '///<li>activate "Find Paranthese" on Toolbar</li>
    printlog "- Find Paranthese"

    kontext "macrobar"
    FindParanthese.Click
    sleep(1)
    '///<li>"Controls" should be disabled when a module is open</li>
    printlog "- 'controls'-button must be disabled for modules"

    try
        Controls.TearOff
        warnlog "Controls are active in a module window => bug!"
    catch
    endcatch

    sleep(1)
    printlog( "- Insert Source Text (" & cSourceFile & ")" )
    '///<li>activate "Insert Source Text" on Toolbar</li>
    '///<li>- insert [TesttoolPath]\framework\update\input\basic\resetregistration.bas</li>
    InsertSourceText.Click
    sleep(1)

    kontext "oeffnendlg"
    Dateiname.SetText( cSourceFile ) 
    Oeffnen.CLick
    sleep(1)

    ' possible 'could not read from file' error-message -> this is a bug"
    kontext "Active"
    if ( Active.exists() ) then
        warnlog( "Unexpected active: " & active.gettext() )
        active.ok()
    endif    
    

    kontext "macrobar"
    printlog "- Save Source Test "
    '///<li>activate "Save Source Test" on Toolbar</li>
    '///<li>- save it as bas-file</li>
    SaveSourceTest.Click
    sleep(1)

    kontext "speicherndlg"
    Dateiname.SetText ConvertPath (gOfficepath + "user\work\global_test.bas")
    Speichern.CLick
    sleep(1)

    kontext "active"
    if Active.Exists then
        Active.Yes
    endif
    sleep(1)
    '///<li>file/close for Basic-IDE and Document</li></ul>
    Call hCloseDocument   ' for Basic-IDE
    Call hCloseDocument   ' the new writer-doc
endcase

'*******************************************************************************

testcase tBasic_IDE_Toolbar_Dialogs

    dim bIsOpen as boolean
    dim brc as boolean

    '///work with Toolbar on Basic-IDE
    '///<li>open a new writer-doc</li>
    printlog "open a new writer-doc"
    gApplication = "WRITER"
    Call hNewDocument
    '///<li>create a new module for the new document (named TTModule)</li>
    printlog "create a new module "
    brc = hOpenBasicOrganizerFromDoc()
    brc = hCreateModuleForDoc()
    '///<li>create a new dialog in BasicIDE</li>

    kontext "basicide"
    Tabbar.OpenContextMenu
    hMenuSelectNr (1)
    sleep(1)
    hMenuSelectNr (2)
    sleep(2)

    if DialogWindow.Exists (2) <> TRUE then
        warnlog "No dialog window is shown!"
    end if

    '///<li>=> now the basic-IDE is open</li>

    kontext "macrobar"
    '///<li>"Compile" (disabled)</li>
    printlog "- compile (disabled)"

    try
        Compile.Click
        warnlog "Compile : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>"Run Basic" (disabled)</li>
    printlog "- Run Basic (disabled)"

    try
        BasicRun.Click
        warnlog "Run : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>"Step Procedure" (disabled)</li>
    printlog "- Step Procedure (disabled)"

    try
        ProcedureStep.Click
        warnlog "Step Procedure : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>"Stop Basic" (disabled)</li>
    printlog "- Stop Basic (disabled)"

    try
        BasicStop.Click
        warnlog "Stop Basic : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>"Single Step" (disabled)</li>
    printlog "- Single Step (disabled)"

    try
        SingleStep.Click
        warnlog "Single Step : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>"Step Back" (disabled)</li>
    printlog "- Step Back (disabled)"

    try
        StepBack.Click
        warnlog "Single Step : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>"Breakpoint" (disabled)</li>
    printlog "- Breakpoint  (disabled)"

    try
        Breakpoint.Click
        warnlog "Breakpoint : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>"Add Watch" (disabled)</li>
    printlog "- Add Watch  (disabled)"

    try
        AddWatch.Click
        warnlog "Add Watch : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>activate "Object Catalog" on Toolbar => close 'Object'-Dialog</li>
    printlog "- Object Catalog => deactivate"
    ObjectCatalog.Click
    sleep(1)

    kontext "objekte"
    Call DialogTest (Objekte)
    Objekte.Close
    '///<li>activate "Macros" on Toolbar => close 'Macro'-Dialog</li>
    printlog "- Macros"

    kontext "macrobar"
    Macros.Click
    sleep(1)

    kontext "makro"
    Makro.Close
    '///<li>activate "Modules" on Toolbar => close 'Modules'-TabDialog</li>
    printlog "- Modules"

    kontext "macrobar"
    Modules.Click
    sleep(1)

    kontext
    Active.SetPage TabModule
    sleep(1)
    Active.SetPage TabBibliotheken

    kontext "tabbibliotheken"
    TabBibliotheken.Close

    kontext "macrobar"
    printlog "- Find Paranthese (disabled)"
    '///<li>"Find Paranthese" (disabled)</li>

    try
        FindParanthese.Click
        warnlog "Find Paranthese : is not disabled"
    catch
    endcatch

    sleep(1)
    '///<li>tear off controls</li>

    bIsOpen = hShowMacroControls()
    if ( bIsOpen ) then
        ToolsCollectionBar.Close
    end if

    sleep(1)

    kontext "macrobar"
    printlog "- Insert Source Text  (disabled))"
    '///<li>"Insert Source Text" (disabled)</li>

    try
        InsertSourceText.Click
        warnlog "Insert Source Text : is not disabled"
        sleep(1)

        kontext "oeffnendlg"
        Dateiname.SetText ConvertPath (gTesttoolpath + "framework\basic\input\resetregistration.bas")
        Oeffnen.Click
    catch
    endcatch

    sleep(1)

    kontext "macrobar"
    printlog "- Save Source Test  (disabled)"
    '///<li>"Save Source Text" (disabled)</li>
    '///<li>save it as bas-file</li>

    try
        SaveSourceTest.Click
        warnlog "Save Source Text : is not disabled"
        sleep(1)

        kontext "speicherndlg"
        Dateiname.SetText ConvertPath (gOfficepath + "user\work\global_test.bas")
        Speichern.Click
        sleep(1)

        kontext "active"
        if Active.Exists then
            Active.Yes
        endif
        sleep(1)
    catch
    endcatch

    '///<li>file/close for Basic-IDE and Document</li></ul>
    Call hCloseDocument   ' for Basic-IDE
    Call hCloseDocument   ' the new writer-doc
endcase

'*******************************************************************************

testcase tBasic_IDE_Breakpoint
    Dim i as Integer, yJump as Integer
    Dim iMenuCountBrkPoint as integer
    Dim iCountOfBrkItems as integer
    Dim sBrkPoiListEntry as string
    '///Working with breakpoints
    '///Open a new Writer document
    printlog "open a new writer-doc"
    gApplication = "Writer"
    Call hNewDocument
    '///Create a new module for the new document named <i>TTModule</i>
    printlog "create a new module "
    Call hCreateModuleForDoc
    '///Insert a short script (only one print-command)
    printlog "insert a short script"

    kontext "basicide"
    EditWindow.TypeKeys "<MOD1 a>"
    EditWindow.TypeKeys "<DELETE>"
    EditWindow.TypeKeys "'# This is a short testscript for automated testing!<return><return>"
    EditWindow.TypeKeys "sub main<RETURN><RETURN>"
    EditWindow.TypeKeys "print " & Chr (34) & "hallo" + Chr (34) & "<RETURN><RETURN>"
    EditWindow.TypeKeys "<HOME>end sub<RETURN>"
    '///Insert breakpoints with doubleclick
    printlog "insert breakpoints with doubleclick"
    '///<li>Try to insert a breakpoint at a documentation line  => no breakpoint</li>
    printlog "- set a breakpoint at documentation line  => no breakpoint"
    BreakPointsWindow.MouseDoubleClick ( 50, 2 )
    sleep(1)
    '///<li>try to insert a breakpoint at a code line  => breakpoint</li>
    printlog "- set a breakpoint at code line"

    for i=1 to 50
        EditWindow.MouseDoubleClick ( 2, 2*i )

        try
            EditCopy
        catch
            SetClipboard ( "" )
        endcatch


        if lcase ( GetClipboardText ) = "sub" then
            BreakPointsWindow.MouseDoubleClick ( 50, 2*i )
            yJump = 2*i
            i=50
        end if

    next i

    '///check the context menu of breakpoints ( in breakpoint window )
    printlog "check the context menu of breakpoints ( in breakpoint window )"
    '///<li>move the mouse over the breakpoint and open the context menu ( should be 2 entries )</li>
    BreakPointsWindow.MouseMove ( 50, yJump )
    BreakPointsWindow.OpenContextMenu TRUE
    iCountOfBrkItems = 0
    iCountOfBrkItems = hMenuItemGetCount

    if iCountOfBrkItems <> 2 then
        warnlog "Perhaps no breakpoint has been inserted or the mouse is not over the breakpoint => 2 entries are not in the context menu!"
        hMenuClose
    else
        printlog "- deactivate the breakpoint"
        '///<li>deactivate the breakpoint</li>
        printlog "- deactivate the breakpoint"
        hMenuSelectNr(1)
        sleep(1)
        printlog "- activate the breakpoint"
        '///<li>open the contextmenu again and activate the breakpoint</li>
        printlog "- activate the breakpoint"
        BreakPointsWindow.OpenContextMenu TRUE
        hMenuSelectNr(1)
        sleep(1)
        printlog "- open the breakpoint dialog"
        '///<li>open the contextmenu again and open the breakpoint dialog</li>
        printlog "- open the breakpoint-dialog ( properties in context menu ) and close it"
        BreakPointsWindow.OpenContextMenu TRUE
        hMenuSelectNr(2)
        sleep(1)

        kontext "breakpoints"
        Call DialogTest (Breakpoints)
        '///<li>check the number of breakpoints ( should be only one )</li>
        iCountOfBrkItems = 0
        iCountOfBrkItems = BreakpointsList.GetItemCount

        if iCountOfBrkItems <> 1 then
            warnlog "There is not 1 breakpoint, there are " & iCountOfBrkItems & " breakpoints! => bug!"
        else
            BreakpointsList.Select(1)
            sBrkPoiListEntry = BreakpointsList.GetSelText
            if Right (sBrkPoiListEntry , 1 ) <> 3 then
                warnlog "The breakpoint is not at line 3, it is on line " & Right (sBrkPoiListEntry , 1) & "!"
            endif
        end if

        Breakpoints.Cancel
        '///check if active and inactive breakpoint are shown correct in the dialog
        printlog "check if active and inactive breakpoints are shown correct in breakpoints dialog"

        kontext "basicide"
        BreakPointsWindow.MouseMove (50, yJump)
        BreakPointsWindow.OpenContextMenu TRUE
        '///<li>open the context menu over the breakpoint and uncheck 'active'</li>
        printlog "- inactive"
        hMenuSelectNr(1)
        sleep(1)
        '///<li>open the breakpoint properties and check if the 'Active'-checkbox is unchecked for this breakpoint</li>
        BreakPointsWindow.OpenContextMenu TRUE
        hMenuSelectNr(2)
        sleep(1)

        kontext "breakpoints"
        BreakpointsList.Select(1)
        if ActiveBox.IsChecked then
            warnlog "When a breakpoint is inactive and 'Active' is checked in breakpoints dialog => BUG!"
        endif
        Breakpoints.Cancel
        sleep(3)

        kontext "basicide"
        BreakPointsWindow.OpenContextMenu TRUE
        '///<li>open the context menu over the breakpoint and uncheck 'active'</li>
        printlog "- active"
        hMenuSelectNr(1)
        sleep(1)
        '///<li>open the breakpoint properties and check if the 'Active'-checkbox is checked for this breakpoint</li>
        BreakPointsWindow.OpenContextMenu TRUE
        hMenuSelectNr(2)
        sleep(1)

        kontext "breakpoints"
        BreakpointsList.Select(1)
        if ActiveBox.IsChecked <> TRUE then
            Warnlog "When a breakpoint is active and 'Active'-checkbox is unchecked in breakpoints dialog => BUG!"
        endif
        printlog "- delete the breakpoint"
        '///delete the breakpoint
        '///<li> press 'delete' and leave the dialog with 'OK'</li>
        Remove.Click
        Breakpoints.OK

        kontext "basicide"
        BreakPointsWindow.MouseMove (50, yJump)
        BreakPointsWindow.OpenContextMenu TRUE
        '///<li>open the context menu over the breakpoint and uncheck 'active'</li>
        iMenuCountBrkPoint = hMenuItemGetCount
        if hMenuItemGetCount <> 1 then
            Warnlog "Perhaps the breakpoint is not deleted, there is not 1 entry in the context menu, there are " & iMenuCountBrkPoint & " entries."
        endif
        hMenuClose
    end if

    '///insert breakpoints with breakpoints dialog ( at a code line )
    printlog "insert breakpoints with breakpoints dialog"
    '///<li>open context menu on breakpoints window</li>
    printlog "- open breakpoints dialog out of context menu"

    kontext "basicide"
    BreakPointsWindow.OpenContextMenu
    hMenuSelectNr(1)
    sleep(1)
    '///<li>insert a breakpoint only with the line number ( without # ), set 1 and check if 'new' is active and the breakpoint can be inserted</li>

    kontext "breakpoints"
    Call DialogTest ( Breakpoints )
    BreakpointsList.SetText "1"
    sleep(1)

    if NewButton.IsEnabled = FALSE then
        warnlog "Insert a breakpoint only with the line-number is impossible ( new is disabled ) => #101478"
    else
        NewButton.Click
        Breakpoints.OK

        kontext "basicide"
        BreakPointsWindow.OpenContextMenu
        hMenuSelectNr(1)
        sleep(1)

        kontext "breakpoints"
        BreakpointsList.SetText "# 1"

        if Remove.IsEnabled = FALSE then
            warnlog "The Breakpoint isn't set for line 1 => BUG"
        else
            Remove.Click
        end if

    end if

    '///<li>insert a breakpoint only with "# 5" and press new in the dialog</li>
    printlog "- create a new breakpoint (#5)"

    kontext "breakpoints"
    BreakpointsList.SetText "#5"
    NewButton.Click
    sleep(2)
    BreakpointsList.Select(1)

    if BreakpointsList.GetSelText <> "# 5" then
        sBrkPoiListEntry = 0
        sBrkPoiListEntry = BreakpointsList.GetSelText
        warnlog "The new breakpoint is not correct. Should '# 5'  is " & sBrkPoiListEntry & "   perhaps BugID:99372  => Test stops running!"
        Breakpoints.Cancel
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    else
        Breakpoints.OK
        yJump = findBreakpointLine ("print")
        BreakPointsWindow.MouseMove (50, yJump)
        BreakPointsWindow.OpenContextMenu TRUE

        if hMenuItemGetCount <> 2 then

            if bAsianLan = FALSE then
                warnlog "The breakpoint is not at the 5th line!"
            end if

            hMenuClose
            Call hCloseDocument
            Call hCloseDocument
            goto endsub
        else
            hMenuClose
        end if

    end if

    printlog "delete the breakpoints and close the dialog with 'cancel'"
    '///delete the breakpoint
    printlog "- open breakpoints dialog out of context menu"

    kontext "basicide"
    BreakPointsWindow.MouseMove(50, 2)
    BreakPointsWindow.OpenContextMenu TRUE
    hMenuSelectNr(1)
    sleep(1)
    '///<li>select the '# 5'-breakpoint and click on remove</li>
    printlog "- select the '# 5'-breakpoint and click remove"

    kontext "breakpoints"
    Call DialogTest (Breakpoints)
    BreakpointsList.SetText "# 5"
    sleep(1)
    Remove.Click
    '///<li>leave the dialog with 'Cancel' => all changes must be canceled => Breakpoint on line 5 must be active</li>
    printlog "- close the dialog with cancel and check if the breakpoint is not deleted"
    Breakpoints.Cancel
    sleep(1)
    '///<li>check if the breakpoint does exist</li>
    yJump = findBreakpointLine ( "print" )
    BreakPointsWindow.MouseMove ( 50, yJump )
    BreakPointsWindow.OpenContextMenu TRUE

    if hMenuItemGetCount <> 2 then
        warnlog "The breakpoint is deleted! Cancel does not cancel the changes in the dialog! => #99377"
        hMenuSelectNr(1)
    else
        hMenuSelectNr(2)
    end if

    printlog "delete the breakpoints"
    '///<li>delete the breakpoint</li>
    '///<li>select the '# 5'-breakpoint and click on remove</li>
    printlog "- select the '# 5'-breakpoint and click remove"

    kontext "breakpoints"
    Call DialogTest (Breakpoints)
    BreakpointsList.SetText "# 5"
    Remove.Click
    sleep(1)
    '///<li>leave the dialog with 'OK'</li>
    printlog "- close the dialog with OK and check if the breakpoint is deleted"
    Breakpoints.OK
    sleep(1)
    '///<li>check if the breakpoint is deleted</li>
    yJump = findBreakpointLine ( "print" )
    BreakPointsWindow.MouseMove ( 50, yJump )
    BreakPointsWindow.OpenContextMenu TRUE
    if hMenuItemGetCount <> 1 then
        Warnlog "The breakpoint is not deleted!"
    endif
    hMenuClose
    Call hCloseDocument
    Call hCloseDocument
endcase


