'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_modules.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: jsk $ $Date: 2005/10/05 05:45:06 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Edit several modules and dialogs in basic ide
'*
'*******************************************************************************
'**
' #1 tMore_Modules_Dialogs  ' create 10 modules, 10 dialogs, delete all new modules/dialogs and delete the last one
'**
'\******************************************************************************


testcase tMore_Modules_Dialogs

    Dim i as Integer
    dim brc as boolean

    dim cFile as string 
    cFile = gOfficePath & "user\work\basic" & hGetSuffix( "current" )
    cFile = convertpath( cFile )

    'const iTABCOUNT is the number of dialogs and modules.
    'If iTABCOUNT = 10 then 20 tabs (+ the first one!) = 21 should be created.

    const iTABCOUNT as Integer = 10

    '///<h1>Work with macros - create multiple modules</h1>
    '///<ul>
    '///<li>Create a new Writer document.</li>
    printlog "open a new writer-doc"
    gApplication = "WRITER"
    Call hNewDocument
    '///<li>Create a new module for the new document (named TTModule)</li>
    printlog "create a new module "
    brc = hOpenBasicOrganizerFromDoc()
    brc = hCreateModuleForDoc()
    '///<li>Insert 10 modules.</li>
    printlog "insert 10 modules"

    for i=1 to iTABCOUNT
        printlog "   - insert new module : " & i

        kontext "basicide"
        Tabbar.OpenContextMenu
        hMenuSelectNr(1)
        sleep(1)
        hMenuSelectNr(1)
        sleep(2)
        brc = hDeleteMacro()
        if ( brc ) then
            EditWindow.TypeKeys "'# " & (i+1) & ". module in this document"
        endif
    next i

    '///<li>Insert 10 dialogs</li>
    printlog "insert 10 dialogs"

    for i=1 to iTABCOUNT
        printlog "   - insert new dialog : " & i
        Tabbar.OpenContextMenu
        hMenuSelectNr(1)
        sleep(1)
        hMenuSelectNr (2)
        sleep(2)

        if DialogWindow.Exists (2) <> TRUE then
            warnlog "No dialog window is shown!"
        end if

    next i

    '///<li>Close the BasicIDE.</li>
    printlog Chr(13) + "- close the BasicIDE"
    Call hCloseDocument
    '///<li>Save the document.</li>
    printlog Chr(13) + "- save the document"

    Call hSpeichernUnterKill( cFile )
    '///<li>Close the document</li>
    printlog Chr(13) + "- close the document"
    Call hCloseDocument
    '///<li>Open the saved document</li>
    printlog Chr(13) + "- open the saved document"
    Call hDateiOeffnen ( cFile , TRUE)
    ' new security dialog for scripting
    printlog( "- accept to run macro" )

    kontext "SecurityWarning"

    if SecurityWarning.Exists() then
        SecurityWarning.OK
    endif

    sleep( 1 )
    hSelectTheLastModule( true )
    '///<li>Select the last module and open the BASIC IDE.</li>
    Bearbeiten.Click
    '///<li>Delete all modules dialogs.</li>
    printlog "delete all modules and dialogs"

    for i=1 to ((2 * iTABCOUNT)+1)

        try
            printlog "delete  - " & i & "/" & ((2 * iTABCOUNT)+1)
            UseBindings

            kontext "basicide"
            Tabbar.OpenContextMenu
            sleep(2)
            hMenuSelectNr(2)
            sleep(1)

            kontext "active"

            if Active.Exists then
                Active.Yes
            else
                warnlog "No warning after deleting a dialog!"
            end if

        catch
            QAErrorLog "Deleting  - " & i & "/" & ((2 * iTABCOUNT)+1) & " failed."
        endcatch

    next i

    Call hCloseDocument()
    Call hCloseDocument()

    '///</ul>

endcase

