'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg7.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:08:17 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( 1. part )
'*
'************************************************************************
'**
' #1 tAutocompletion1     ' autocompletion of normale directory- and filenames in the filename-field
' #1 tAutocompletion2     ' autocompletion in directorynames with spaces
' #1 tAutocompletion3     ' autocompletion with use the up-/down-functionality of cursors in the filename-field
' #1 tAutocompletion4     ' autocompletion within special cases
' #0 setstring            ' writes a string to "Dateiname" using .setText()
' #0 typestring           ' writes a string to "Dateiname" using .typeKeys()
'**
'\***************************************************************************

testcase tAutocompletion1

   '/// Autocompletion at normal directories and files
   Dim sEntry as String
   dim sFileName as string
   dim sFileName2 as string
   
   
   '///file/open
   FileOpen
   Kontext "OeffnenDlg"

   '///type in filename-field [TesttoolPath]\fram   => ...\framework\
   printlog "- " + gTesttoolPath + "insert 'fram' => ...\framework\"
   
   Dateiname.setText( gTesttoolPath )
   sleep( 1 )
   
   Dateiname.TypeKeys( "<END>" )
   sleep( 1 )
   
   Dateiname.TypeKeys( "fram" )
   Sleep 2
   
   sFileName  = lcase( Dateiname.GetSelText )
   sFileName2 = lcase( gTesttoolPath + "framework" + gPathSigne )
   
   if (sFileName <> sFileName2) then 
      Warnlog( "Expected: '"+ sFileName2 + "'  Is:'" + sFileName + "'" )
   endif
   
   Oeffnen.Click()
   sleep( 2 )
   
   ' in case the string is incorrect, we return to the fileopen dialog
   ' by removing the errormessage.
   kontext "active"
   if ( active.exists() ) then
      warnlog( "Unexpected active: " & active.gettext() )
      active.ok()
      
   end if

   kontext "OeffnenDlg"   
   Dateiname.SetText( "" )
   
   '///type filed  => ...\framework\filedlg\
   printlog "- insert 'filed'  => filedlg" + gPathSigne
   Dateiname.TypeKeys( "<End>filed" )
   Sleep( 2 )
   
   '///type file  => ...\framework\filedlg\input\
   printlog "- insert 'inp' => " + ConvertPath  ( "filedlg\input\" )
   Dateiname.TypeKeys( "<End>inp" )
   Sleep( 2 )
   
   '///type filete  => ...\input\desktop\filedlg\filetest\
   printlog "- insert 'filete' => " + ConvertPath ( "filedlg\input\filetest\" )
   Dateiname.TypeKeys( "<End>filete" )
   Sleep( 2 )
   
   '///type le  => ...\input\desktop\filedlg\level1\
   printlog "- insert 'le' => " + ConvertPath ( "filedlg\input\filetest\level1" )
   Dateiname.TypeKeys( "<End>le" )
   Sleep( 2 )
   
   '///type le  => ...\input\desktop\filedlg\level1\level2
   printlog "- insert 'le' => " +  ConvertPath ( "filedlg\input\filetest\level1\level2\" )
   Dateiname.TypeKeys( "<End>le" )
   Sleep( 2 )
   
   '///type le  => ...\input\desktop\filedlg\level1\level2\level3\
   printlog "- insert 'le' => " + ConvertPath ( "filedlg\input\filetest\level1\level2\level3" )
   Dateiname.TypeKeys( "<End>le" )
   Sleep( 2 )
   
   '///type te  => ...\input\desktop\filedlg\level1\level2\level3\testdoc.sdw
   printlog "- insert 'te' => " + ConvertPath ( "filedlg\input\filetest\level1\level2\level3\testdoc.sdw" )
   Dateiname.TypeKeys( "<End>te" )
   Sleep( 2 )
   
   '///press 'open' and check if the doc exists and is loaded
   Oeffnen.Click()
   Sleep( 3 )
   
   kontext "active"
   if ( active.exists() ) then
      warnlog( "Unexpected active: " & active.gettext() )
      active.ok()
      
      kontext "OeffnenDlg"
      OeffnenDlg.cancel()
   else   
   
      ' check if the correct document has been loaded (read the first string from 
      ' the content)
      if ( hIdentifyWriterDoc( "tAutocompletion1" , true ) = false ) then
         warnlog( "The loaded document is not the one that was expected" )
      endif
   
      '///+Close the document
      printlog( "Close the document" )
      call hCloseDocument()
   endif
   
endcase

'*******************************************************************************

testcase tAutocompletion2

   '/// Autocompletion at directories with spaces
   Dim sEntry as String
   dim sFileName as string
   dim sFileName2 as string
 
   '///file/open
   FileOpen
   Kontext "OeffnenDlg"

   
   '///type in filename-field [TesttoolPath]\fram   => ...\framework\
   printlog "- " + gTesttoolPath + "insert 'fra' => ...\framework\"
   setstring( gTesttoolPath )
   typestring( "fra" )

      
   sFileName  = lcase( Dateiname.GetSelText )
   sFileName2 = lcase( gTesttoolPath + "framework" + gPathSigne )
  
   if ( sFileName <> sFileName2 ) then 
      Warnlog "Should: '"+ sFileName2 + "'  Is:'" + sFileName + "'"
   end if
    
   Oeffnen.Click()
   
   Dateiname.SetText( "" )
  
  
   '///type filed  => ...\framework\filedlg
   printlog "- insert 'filed' => " + ConvertPath ( "filedlg" )
   typestring( "filed" )
   
  
   '///type inp  => ...\framework\filedlg\input\
   printlog "- insert 'inp' => " + ConvertPath ( "filedlg\input\" )
   typestring( "inp" )  
  
   '///type filets  => ...\framework\filedlg\input\filetst2\
   printlog "- insert 'filets' => " + ConvertPath ( "filedlg\input\filetst2\" )
   typechars( "fi" )
   typechars( "le" )
   typestring( "ts" )
   'typestring( "filets" )
   
   
   '///type sp  => ...\framework\filedlg\input\filetst2\spa ces\
   printlog "- insert 'sp' => " + ConvertPath ( "filedlg\input\filetst2\spa ces\" )
   typestring( "sp" )
   
   
   '///type te  => ...\framework\filedlg\input\filetst2\spa ces\testdoc.sdw
   printlog "- insert 'te' => " + ConvertPath ( "filedlg\input\filetst2\spa ces\testdoc.sdw" )
   typestring( "te" )
   
   Oeffnen.Click()
   Sleep( 3 )
   
   kontext "active"
   if ( active.exists() ) then
      warnlog( "Unexpected active: " & active.gettext() )
      active.ok()
      
      kontext "OeffnenDlg"
      OeffnenDlg.cancel()
   else
   
      ' check if the correct document has been loaded (read the first string from 
      ' the content)
      if ( hIdentifyWriterDoc( "tAutocompletion2" , true ) = false ) then
         warnlog( "The loaded document is not the one that was expected" )
      endif
   
      '///+Close the document
      printlog( "Close the document" )
      call hCloseDocument()
   endif

endcase

'*******************************************************************************

testcase tAutocompletion3

   '/// Autocompletion with some targets, using the up/down-feature
   Dim sEntry( 10 ) as String
   Dim i as Integer          ' some increment variable for loops 
   dim richtig as Integer    ' counts correct entries
   
   dim testpath as string    ' the path to be tested next
   dim sFileName as string
   dim sFileName2 as string
 
   dim INPUTPATH as string
       INPUTPATH = convertpath( gTesttoolPath + "framework\filedlg\input\" )
     

   '///file/open
   FileOpen
   Kontext "OeffnenDlg"

   '///scroll between some search-result ( with only f )
   '///+test directory : [TesttoolPath]\framework\filedlg\input
   printlog "scroll between some search-result ( with only f )"
   testpath = INPUTPATH
   Dateiname.settext( testpath )
   
   Oeffnen.Click()
   
   Dateiname.SetText( "" )
   printlog "- insert 'f' und and press <down> => change to the 2. entry"
  
  '///+empty the filename-field and insert 'f'
  '///+use typekey 'down'
  '///+entry should be 'filetest'
  '///+use typekey 'down'
  '///+entry should be 'filetst2'
   Dateiname.TypeKeys( "f" )
   Sleep( 2 )
   
   sEntry( 1 ) = Dateiname.GetSelText()
   printlog "   1. entry : " + sEntry( 1 )
   Dateiname.TypeKeys "<Down>"
   sleep( 1 )
   
   sEntry( 2 ) = Dateiname.GetSelText()
   printlog "   2. entry : " + sEntry( 2 )
   richtig = 0
   
   for i = 1 to 2
   
      if ( lcase ( sEntry( i ) ) ) = ( "filetest" + gPathsigne ) then 
         richtig = richtig + 1
      end if
      
      if ( lcase ( sEntry( i ) ) ) = ( "filetst2" + gPathsigne ) then 
         richtig = richtig + 1
      end if
      
   next i
   
   if ( not richtig = 2 ) then 
      Warnlog "Entries beginning with 'f' < 2, autocomplete failed?"
   end if

   '///+use typekey 'up'
   '///+entry should be 'filetest'
   printlog "- go with <up> one entry higher and compare"
   Dateiname.TypeKeys( "<Up>" )
   Sleep ( 1 )
  
   if ( Dateiname.GetSelText() <> sEntry( 1 ) ) then 
      Warnlog "The first entry wasn't found!"
   end if

   '///scroll to other subdirectories
   printlog "Scroll to other subdirectories"
   
   Dateiname.SetText( "" )

   testpath = convertpath ( gTesttoolPath + "framework\filedlg\" )

   setstring( testpath )
   
   typestring( "inp" )   

   sEntry( 1 ) = Dateiname.GetSelText()
   sFileName2 = lcase( INPUTPATH )
  
   if ( lcase( sEntry( 1 ) ) <> sFileName2 ) then 
      Warnlog "The 1. entry was wrong, perhaps no pathseperator at the end?!"
   end if
   
   '///+press 'open'
   Oeffnen.Click()
   Sleep ( 1 )
   
   '///+set the cursor in the filename-field at the end
   '///+press down 8 times
   '///+check the 7 directories ( ...\cvs\, ...\readonly\, ...\filetest\, ...\filetst2, ...\alldocs\, ..\noentry, ..\readentry )
   Dateiname.TypeKeys( "<End>" )
   Sleep ( 1 )

   ' cycle through the history of the "Dateiname" entryfield and save the content  
   for i = 2 to 8
   
      Dateiname.TypeKeys( "<Down>" )
      sleep( 1 )
      
      sEntry( i ) = lcase(  Dateiname.GetSelText() )
      
   next i
  
   richtig = 0
   printlog "  The entries are"
   
   ' compare the history-entries to some hard coded reference paths
   for i = 2 to 8
   
       printlog "   - " + sEntry (i)
       
       testpath = lcase( ConvertPath ( INPUTPATH + "alldocs\" ) )
       if ( sEntry( i ) = testpath ) then richtig = richtig + 1 
       
       testpath = lcase( ConvertPath ( INPUTPATH + "cvs\" )     )
       if ( sEntry( i ) = testpath ) then richtig = richtig + 1
       
       testpath = lcase( ConvertPath ( INPUTPATH + "filetest\" ))
       if ( sEntry( i ) = testpath ) then richtig = richtig + 1
       
       testpath = lcase( ConvertPath ( INPUTPATH + "filetst2\" ))
       if ( sEntry( i ) = testpath ) then richtig = richtig + 1
       
       testpath = lcase( ConvertPath ( INPUTPATH + "noentry\" ) )
       if ( sEntry( i ) = testpath ) then richtig = richtig + 1
       
       testpath = lcase( ConvertPath ( INPUTPATH + "readentry\"))
       if ( sEntry( i ) = testpath ) then richtig = richtig + 1
       
       testpath = lcase( ConvertPath ( INPUTPATH + "readonly\" ))
       if ( sEntry( i ) = testpath ) then richtig = richtig + 1
       
   next i
  
   ' test if all directories are listed correctly and in correct order
   if ( richtig <> 7 ) then 
      Warnlog "Perhaps not all directories are correctly listed!"
   end if

   'Close File Open dialog
   OeffnenDlg.Cancel()
  
endcase

'*******************************************************************************

testcase tAutocompletion4

   '///special functions with the autocompletion
   
   Dim sEntry as String
   dim testpath as string
   
   dim INPUTPATH as string
       INPUTPATH = convertpath( gTesttoolPath + "framework\filedlg\input\" )
   
   
   '///file/open
   FileOpen
   Kontext "OeffnenDlg"

   '///'..' => no autocompletion, only the pathsigne can be at the end
   printlog "- '..' => no autocompletion"
   typestring( ".." )
   Sleep( 1 )
   
   sEntry = lcase ( Dateiname.GetSelText() )
   
   if ( sEntry <> ".." ) AND ( sEntry <> ".." + gPathSigne ) then 
      Warnlog( "'..' is changed to '" + sEntry + "'" )
   endif
   
   Dateiname.SetText( "" )
   Sleep( 1 )
   
   testpath = INPUTPATH & "filetest\level1\level2\level3"
   testpath = convertpath( testpath )
   Dateiname.SetText( testpath )
   Oeffnen.Click()
   Sleep( 2 )

   '///'..' + pathsigne => no autocompletion
   printlog "- '.." + gPathsigne + "' => no autocompletion"
   Dateiname.SetText( "" )
   Sleep( 1 )
   
   typestring( ".."+ gPathsigne )
   Sleep( 2 )
   
   sEntry = lcase ( Dateiname.GetSelText() )
   
   if ( sEntry <> ( ".." + gPathsigne ) ) then 
      Warnlog( "'.." + gPathsigne + "' is changed to '" + sEntry + "'" )
   endif

   '///'\' => no autocompletion
   printlog "- '\' => no autocompletion"
   Dateiname.SetText( "" )
   Sleep( 1 )
   
   typestring( "\" )
   
   sEntry = lcase ( Dateiname.GetSelText() )
   
   if ( sEntry <> "\" ) then 
      Warnlog( "It wouldn't be shown the root '\' but '" + sEntry + "'" )
   endif

   '///'/' => no autocompletion
   printlog "- '/' => no autocompetion"
   Dateiname.SetText( "" )
   Sleep( 1 )
   
   typestring( "/" )
   
   sEntry = lcase ( Dateiname.GetSelText() )
   
   if ( sEntry <> "/" ) then 
      Warnlog( "It wouldn't be shown the root '/' but '" + sEntry + "'" )
   endif

   '///'.' => no autocompletion only with pathsigne at the end
   printlog "- '.' => no autocompletion"
   Dateiname.SetText( "" )
   typestring( "." )
   
   sEntry = lcase ( Dateiname.GetSelText() )
   
   if ( ( sEntry  <> "." ) AND ( sEntry  <> "." + gPathSigne ) ) then 
      Warnlog( "'.' is changed to '" + sEntry  + "'" )
   endif

   '///'../[dirname]' at relative paths => should autocomplete the path
   printlog "- '../[dirname]' at relative paths => no autocompletion"
   
   '///+test directory : [TesttoolPath]\framework\filedlg\input\filetest\level1\level2\
   setstring( ConvertPath ( INPUTPATH & "filetest\level1\level2\" ) )
   Oeffnen.Click()
   Sleep( 2 )
   '///+empty the filename-field and insert '../leve' or '..\leve' => ../level2/ or ..\level2\
   
   Dateiname.SetText( "" )
   Sleep( 1 )
   
   typestring( ".." + gPathsigne + "leve" )
   
   sEntry = lcase ( Dateiname.GetSelText() )
   
   if ( sEntry <> ( ".." + gPathsigne + "level2" + gPathsigne ) ) then 
      Warnlog( ".."+ gPathsigne + "level2" + gPathsigne + "' is changed to '" + sEntry + "'" )
   endif

   '///( only Windows ) 'c:\conf' => only the filename should be completed
   if gPlatgroup = "w95" then
   
      printlog "- ( only Windows ) 'c:\conf' => only the filename should be completed"
      Dateiname.SetText( "" )
      Sleep( 1 )
      
      Dateiname.TypeKeys( "c:\conf" )
      Sleep( 1 )
      
      sEntry = lcase ( Dateiname.GetSelText() )
      
      if ( instr ( sEntry, "c:\config." ) = 0 ) then 
         Warnlog( "'c:\conf' is changed to '" + sEntry + "'" )
      endif
      
   endif

   printlog "Special autocompletiontest for UNIX"

   '///( only UNIX ) '.' at the begin of filenames => the filename should be autocompleted"
   printlog "- '.' at the begin of filenames => the filename should be autocompleted"
   
   if ( gPlatgroup = "unx" ) then
   
      testpath = INPUTPATH & "filetest\level1\level2\level3"
      testpath = convertpath( testpath )
      
      Dateiname.SetText( testpath )
      Oeffnen.Click()
      sleep( 1 )
      
      Dateiname.SetText( "" )
      sleep( 1 )
      
      typechars( ".t" )
      typechars( "es" )
      typechars( "tt" )
      typestring( "oo" )
      
      sEntry = lcase ( Dateiname.GetSelText() )
      
      if ( sEntry  <> ".testtoolrc" ) then 
         Warnlog( "'.testtoo' is changed to '" + sEntry  + "'" )
      endif
      
   end if

   OeffnenDlg.Cancel()
   
endcase

'*******************************************************************************

function typestring( cString as string ) as string

   ' enters a string into "Dateiname" and waits for the autocompletion to strike

   Dateiname.typekeys( cString )
   sleep( 1 )

   Dateiname.typekeys( "<END>" )
   wait( 500 )
   
   typestring() = Dateiname.getSelText()
   
end function

'*******************************************************************************

function setstring( cString as string ) as string

   ' enters a string into "Dateiname" using SetText. In this case the autocom-
   ' pletion should not interfere

   Dateiname.SetText( cString )
   wait( 500 )
   
   Dateiname.typekeys( "<END>" )
   wait( 500 )
   
   setstring() = Dateiname.getSelText()
   
end function   

'*******************************************************************************

function typechars( cString as string ) as string

   Dateiname.typekeys( cString )
   sleep( 1 )
   
   typechars() = Dateiname.getSelText()
   
end function

