'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: install_XML_tools.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:06:26 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : Tools that use the XML parser to retrieve information
'*
'*******************************************************************************
' **
' #0 hGetSetupLocales ' get the installed languages (serverside/global inst.)
' #0 hGetUserLocale   ' get the installed language (userside)
' **
'\******************************************************************************

function hGetSetupLocales() as string

   ' This function reads the list of installed languages parsing the
   ' Setup.xcu file.
   ' The function looks for the node at a fixed location. If the node is moved,
   ' this function will fail.

   dim sSetupXcuPath as string ' path to setup.xcu
   Dim i as integer            ' counter (needed: Office might not be first node)
   Dim iChildren as integer    ' the count of children in a node

   ' find the path to the Setup.xcu file
   sSetupXcuPath = OFFICEHOME & "share\registry\data\org\openoffice\Setup.xcu"
   sSetupXcuPath = convertpath( sSetupXcuPath )

   ' Open the DOM Tree and parse it.
   SAXReadFile( sSetupXcuPath )
   SAXSeekElement("/")
   SAXSeekElement(1)
   iChildren = SAXGetChildCount

   for i = 1 to iChildren

      SAXSeekElement( i )

      if SaxGetAttributeValue( "oor:name" ) = "Office" then

         SAXSeekElement( 3 )

         if SAXgetAttributeValue( "oor:name" ) = "ooSetupLocales" then

            SAXSeekElement( "value" )
            SAXSeekElement( 1 )

            if SAXGetNodeType = NodeTypeCharacter then
               hGetSetupLocales() = SAXGetChars()
               SAXRelease()
               Exit function
            end if

         else

            SAXRelease()
            Exit function

         end if

      end if

      SAXSeekElement(0)

   next i

end function

'*******************************************************************************

function hGetUserLocale() as string

   ' This function reads the list of installed languages parsing the
   ' Setup.xcu file.
   ' The function looks for the node at a fixed location. If the node is moved,
   ' this function will fail.

   dim sSetupXcuPath as string ' path to setup.xcu
   Dim i as integer            ' counter (needed: Office might not be first node)
   Dim iChildren as integer    ' the count of children in a node
   dim pdebug as boolean
   pdebug = true

   ' find the path to the Setup.xcu file
   sSetupXcuPath = OFFICEHOME & "user\registry\data\org\openoffice\Setup.xcu"
   sSetupXcuPath = convertpath( sSetupXcuPath )
   if ( pdebug ) then printlog( "sSetupXcuPath = " & sSetupXcuPath )

   ' Open the DOM Tree and parse it.
   SAXReadFile( sSetupXcuPath )
   if ( pdebug ) then printlog( "1" )
   SAXSeekElement("/")
   if ( pdebug ) then printlog( "2" )
   SAXSeekElement(1)
   if ( pdebug ) then printlog( "3" )
   iChildren = SAXGetChildCount

   for i = 1 to iChildren

      if ( pdebug ) then printlog( "loop: " & i )

      SAXSeekElement( i )

      if ( pdebug ) then printlog( "1" )

      if SaxGetAttributeValue( "oor:name" ) = "L10N" then

         if ( pdebug ) then printlog( "2" )

         SAXSeekElement( 1 )

         if SAXgetAttributeValue( "oor:name" ) = "ooLocale" then

            if ( pdebug ) then printlog( "3" )

            SAXSeekElement( "value" )
            if ( pdebug ) then printlog( "4" )

            SAXSeekElement( 1 )
            if ( pdebug ) then printlog( "5" )

            if SAXGetNodeType = NodeTypeCharacter then
               if ( pdebug ) then printlog( "6" )
               hGetUserLocale() = SAXGetChars()
               printlog( "hGetSetupLocales() = " & SAXGetChars() )
               SAXRelease()
               if ( pdebug ) then printlog( "7" )
               Exit function
            end if

         else

            SAXRelease()
            Exit function

         end if

      end if

      SAXSeekElement(0)

   next i

end function

