'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: l1_ole_tools.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: tbo $ $Date: 2005/12/14 09:09:56 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : global-level-1-test -> insert all OLE-Objects out of OLE-dialog into all doc-types
'*
'*******************************************************************************
' **
' #0 hReopenDoc
' #0 hOleSelektieren
' #0 hSetToStandardView
' #0 SendEscape
' #0 DisableNavigator
' #1 UncheckAutoFileExtension    'no automatic file name extension
' #1 OLESetFocus                 'sets focus, applicationdependent
' #1 OLESetFocus2                'sets focus, applicationdependent
' #1 OLESetFocus3                'sets focus, applicationdependent
' #1 OLE RemoveFocus             'removes focus, applicationdependent
' #0 ClosePresentationFloat      'closes the presentation float
' **
'\******************************************************************************

sub hReopenDoc
   'Only for bughandling if closing an OLE object fails
   Warnlog "Cannot release Chart Object -> #107005#?"
   hCloseDocument()
   'if Active.Exists ( 1 ) then Active.TypeKeys "<RIGHT><ENTER>"
   hNewDocument()
end sub

'*******************************************************************************

sub hOleSelektieren ( xStart%, yStart%, xEnde%, yEnde% )
    WL_TB_ZF_Auswahl
    select case gApplication
        case "CALC"     :Kontext "DocumentCalc"
                       DocumentCalc.MouseDown xStart%, yStart%
                       DocumentCalc.MouseMove xEnde%, yEnde%
                       DocumentCalc.MouseUp xEnde%, yEnde%
                       wait 200
        case "DRAW"     :Kontext "DocumentDraw"
                       DocumentDraw.MouseDown xStart%, yStart%
                       DocumentDraw.MouseMove xEnde%, yEnde%
                       DocumentDraw.MouseUp xEnde%, yEnde%
        case "WRITER"   :Kontext "DocumentWriter"
                       DocumentWriter.MouseDown xStart%, yStart%
                       DocumentWriter.MouseMove xEnde%, yEnde%
                       DocumentWriter.MouseUp xEnde%, yEnde%
        case "IMPRESS"  :Kontext "DocumentImpress"
                       DocumentImpress.MouseDown xStart%, yStart%
                       DocumentImpress.MouseMove xEnde%, yEnde%
                       DocumentImpress.MouseUp xEnde%, yEnde%
        case "MATH"     :Kontext "DocumentMath"
                       DocumentMath.MouseDown xStart%, yStart%
                       DocumentMath.MouseMove xEnde%, yEnde%
                       DocumentMath.MouseUp xEnde%, yEnde%
        case "GLOBALDOC":Kontext "DocumentMasterDoc"
                       DocumentMasterDoc.MouseDown xStart%, yStart%
                       DocumentMasterDoc.MouseMove xEnde%, yEnde%
                       DocumentMasterDoc.MouseUp xEnde%, yEnde%
    end select
end sub

'*******************************************************************************

sub hSetToStandardView ( DieApp$ )
   select case DieApp$
     case "WRITER"      : gApplication = "WRITER"
                          Call hNewDocument
                          Kontext "DocumentWriter"
     case "GLOBALDOC"   : gApplication = "GLOBALDOC"
                          Call hNewDocument
                          Kontext "DocumentMasterDoc"
   end select
      ViewZoom
      Kontext "Massstab"
      Optimal.Check
      Massstab.ok()
    Call hCloseDocument
end sub

'*******************************************************************************

sub SendEscape(optional iTimes as Integer)
   dim i as Integer
   const ICWAIT as Integer = 1

   if IsMissing( iTimes ) then
      iTimes = 1 
   endif
   '///+press [ESCAPE]
   printlog( "    - send <ESCAPE> keystroke to document" )
   select case gApplication
      case "WRITER"    : Kontext "DocumentWriter"
                         for i = 1 to iTimes
                            sleep( ICWAIT )
                            DocumentWriter.TypeKeys( "<ESCAPE>" , 1 , TRUE )
                         next i
      case "CALC"      : Kontext "DocumentCalc"
                         for i = 1 to iTimes
                            sleep( ICWAIT )
                            DocumentCalc.TypeKeys( "<ESCAPE>" , 1 , TRUE )
                         next i
      case "GLOBALDOC" : Kontext "DocumentMasterDoc"
                         for i = 1 to iTimes
                            sleep( ICWAIT )
                            DocumentMasterDoc.TypeKeys( "<ESCAPE>" , 1 , TRUE )
                         next i
      case "DRAW"      : Kontext "DocumentDraw"
                         for i = 1 to iTimes
                            sleep( ICWAIT )
                            DocumentDraw.TypeKeys( "<ESCAPE>" , 1 , TRUE )
                         next i
      case "IMPRESS"   : Kontext "DocumentImpress"
                         for i = 1 to iTimes
                            sleep( ICWAIT )
                            DocumentImpress.TypeKeys( "<ESCAPE>" , 1 , TRUE )
                         next i
   end select
end sub

'*******************************************************************************

sub DisableNavigator()
   printlog( "    - disable the navigator in globaldoc/writer" )
   select case gApplication
      case "GLOBALDOC" : Kontext "NavigatorGlobalDoc"
                         if NavigatorGlobalDoc.Exists() then
                             EditNavigator
                         endif
      case "WRITER"    : Kontext "NavigatorWriter"
                         if NavigatorWriter.Exists() then
                             EditNavigator
                         endif
   end select
   sleep( 1)
end sub

'*******************************************************************************

sub UncheckAutoFileExtension()
   '///+uncheck automatic file extension, if checked
    Kontext "SpeichernDlg"
    if SpeichernDlg.exists(5) then
        if AutomatischeDateinamenserweiterung.Exists() then
            printlog("l1_ole_tools::UncheckAutoFileExtension  - unchecking automatic file extension" )
            If AutomatischeDateinamenserweiterung.IsChecked() then 
                AutomatischeDateinamenserweiterung.Uncheck()
            endif
        else
            warnlog( "l1_ole_tools::UncheckAutoFileExtension Checkbox 'Automatic Filename Extension' unavailable" )
        endif
    else
        warnlog( "l1_ole_tools::UncheckAutoFileExtension SaveAs Dialog not open." )
    endif
end sub

'*******************************************************************************

function getExtension( optional sExtension as string ) as string
    printlog("l1_ole_ttols::getExtension:: - define the expected file extension" )
    select case gApplication
        case "WRITER"       : sExtension = ".sxw"
        case "DRAW"         : sExtension = ".sxd"
        case "IMPRESS"      : sExtension = ".sxi"
        case "CALC"         : sExtension = ".sxc"
        case "MATH"         : sExtension = ".sxm"
        case "GLOBALDOC"    : sExtension = ".sgl"
    end select
    getExtension = sExtension
end function

'*******************************************************************************

sub OLESetFocus()
   '///+activate the OLE-Object with a doubleclick
   const ICWAIT as Integer = 10
   PrintLog "    - set focus to OLE object (edit mode)"
   select case gApplication
      case "WRITER" :    printlog "      Select and deselect " + gApplication
                         Kontext "DocumentWriter"
                         DocumentWriter.TypeKeys("<F6>"           , 4 , TRUE )
                         DocumentWriter.TypeKeys("<DOWN>"         , 3 , TRUE )
                         DocumentWriter.TypeKeys("<RIGHT>"        , 1 , TRUE )
                         DocumentWriter.TypeKeys("<MOD1 RETURN>"  , 1 , TRUE )
                         DocumentWriter.TypeKeys("<TAB>"          , 1 , TRUE )
                         DocumentWriter.TypeKeys("<RETURN>"       , 1 , TRUE )
                         'DocumentWriter.MouseDoubleClick ( 50, 50 )
                         sleep( ICWAIT )
                         call SendEscape( 3 ) '(to close the float as well)
      case "IMPRESS"   : printlog "      Select and deselect " + gApplication
                         Kontext "DocumentImpress"
                         DocumentImpress.MouseDoubleClick ( 50, 50 )
                         sleep( ICWAIT )
      case "CALC"      : printlog "      Select and deselect " + gApplication
                         Kontext "DocumentCalc"
                         DocumentCalc.TypeKeys( "<F6>"            , 5 , TRUE )
                         DocumentCalc.TypeKeys( "<DOWN>"          , 3 , TRUE )
                         DocumentCalc.TypeKeys( "<MOD1 RETURN>"   , 1 , TRUE )
                         DocumentCalc.TypeKeys( "<RETURN>"        , 1 , TRUE )
                         'gMouseClick ( 20, 20 )
                         'DocumentCalc.MouseDoubleClick ( 20, 20 )
                         sleep( ICWAIT )
                         call SendEscape( 3 ) '(to close the float as well)
      case "GLOBALDOC" : printlog "      Select and deselect " + gApplication
                         Kontext "DocumentMasterDoc"
                         DocumentMasterDoc.MouseDown( 50 , 50 , 1 )
                         DocumentMasterDoc.MouseUp( 50 , 50 , 1 )
                         EditObjectEdit
                         sleep( ICWAIT )
   end select 
end sub
   
'*******************************************************************************

sub OLESetFocus2()
   '///+activate the OLE-Object with a doubleclick
   'default waitstate
   const ICWAIT as Integer = 1
   PrintLog "    - set focus to OLE object (edit mode)"
   select case gApplication
      case "WRITER"  : Kontext "DocumentWriter"
         try
            FormatObject
            Kontext ' This is by intention, do not change!
            active.SetPage TabType
            Kontext "TabType"
            TabType.Cancel()
            sleep( ICWAIT )
            EditObjectEdit
         catch
            warnlog "Can't activate object"
         endcatch
         sleep( ICWAIT * 2 )
         gMouseClick ( 5 , 5 ) 'out of edit mode
         gMouseClick ( 5 , 5 ) 'remove focus
      case "DRAW"    : Kontext "DocumentDraw"
         if OLEApp = "MATH" then
            DocumentDraw.MouseDoubleClick ( 45, 46 )
         else
            DocumentDraw.MouseDoubleClick ( 50, 45 )
         end if
         sleep( ICWAIT * 5 )
         gMouseClick ( 1 , 1 )
      case "IMPRESS"  : Kontext "DocumentImpress"
         printlog( "    - using accessibility shortcuts for objecthandling" )
         printlog( "      (select, activate and release object)" )
         DocumentImpress.TypeKeys( "<F6>" , 5 , TRUE )
         DocumentImpress.TypeKeys( "<TAB><RETURN>" )
         sleep( ICWAIT * 2 )
         call SendEscape()
      case "CALC"     : Kontext "DocumentCalc"
         printlog( "    - using accessibility shortcuts for objecthandling" )
         printlog( "      (select, activate and release object)" )
         DocumentCalc.TypeKeys( "<F6>"          , 5 , TRUE )
         DocumentCalc.TypeKeys( "<DOWN>"        , 3 , TRUE )
         DocumentCalc.TypeKeys( "<RIGHT>"       , 1 , TRUE )
         DocumentCalc.TypeKeys( "<MOD1 RETURN>" , 1 , TRUE )
         DocumentCalc.TypeKeys( "<RETURN>"      , 1 , TRUE )
         sleep( ICWAIT * 2 )
         call sendEscape()
      case "GLOBALDOC": Kontext "DocumentMasterDoc"
         try
            FormatObject
            sleep( ICWAIT )
            Kontext ' This is by intention, do not change!
            Active.SetPage TabType
            Kontext "TabType"
            TabType.Cancel
            Sleep ( ICWAIT )
            EditObjectEdit
         catch
            qaerrorlog( "The object is not selected after reload." )
         endcatch
         Sleep( ICWAIT )
         Kontext "DocumentMasterDoc"
         DocumentMasterDoc.MouseDoubleClick ( 1 , 1 )
   end select
end sub

'*******************************************************************************

sub OLESetFocus3()
   'TODO: Get rid of as many mousemovements as possible
   'default waitstate
   const ICWAIT as Integer = 1
   printlog( "    - set focus to OLE object (edit mode)" )
   select case gApplication
      case "WRITER" : Kontext "DocumentWriter"
         try
            FormatObject
            sleep( ICWAIT )
            Kontext ' This is by intention, do not change!
            active.SetPage TabType
            Kontext "TabType"
            TabType.Cancel
            sleep( ICWAIT )
            EditObjectEdit
         catch
            warnlog "Can't activate object"
         endcatch
         sleep( ICWAIT * 5 )
         gMouseClick ( 1, 1 )
      case "DRAW" : Kontext "DocumentDraw"
         DocumentDraw.TypeKeys ("<Tab>")
         DocumentDraw.MouseDoubleClick ( 50, 50 )
         sleep( ICWAIT * 5 )
         gMouseClick ( 1, 1 )
      case "IMPRESS" : Kontext "DocumentImpress"
         printlog( "    - Using accessibility-shortcuts to manipulate object")
         DocumentImpress.TypeKeys( "<TAB>" )
         sleep( ICWAIT )
         DocumentImpress.TypeKeys( "<SHIFT RETURN>" )
         call SendEscape( 3 )
      case "GLOBALDOC" : Kontext "DocumentMasterDoc"
         try
            FormatObject
            sleep( ICWAIT )
            Kontext ' This is by intention, do not change!
            active.SetPage( TabType )
            Kontext "TabType"
            TabType.Cancel()
            sleep( ICWAIT )
            EditObjectEdit
         catch
            qaerrorlog( "The object is not selected after reload." )
         endcatch
         sleep( ICWAIT * 5 )
         call SendEscape( 2 )
   end select
end sub

'*******************************************************************************

sub OLERemoveFocus
   '///+Deselect OLE object
   printlog( "    - remove focus from OLE object" )
   select case gApplication
      case "WRITER"    : printlog "      Deselect OLE in " + gApplication 
                         call SendEscape( 2 )
      case "GLOBALDOC" : printlog "      Deselect OLE in " + gApplication
                         Kontext "DocumentMasterDoc"
                         DocumentMasterDoc.MouseDoubleClick ( 1, 1 )
      case "IMPRESS"   : printlog "      Deselect OLE in " + gApplication
                         gMouseClick ( 99, 99 )
      case "CALC"      : printlog "      Deselect OLE in " + gApplication
                         Kontext "DocumentCalc"
                         call SendEscape()
   end select
end sub

'*******************************************************************************

sub ClosePresentationFloat()
   gApplication = "IMPRESS" 
   '///+Open a new document
   printlog( "Open a new document" )
   hNewDocument
   'use the tiny little hammer to kill the presentation float
   printlog( "Reset the application (which closes the presentation toolbar)" )
   resetapplication
   '///+Open a new document
   printlog( "Open a new document" )
   hNewDocument
   '///+Look if the presentation toolbar is visible, if yes->warning
   Kontext "CommonTaskbar"
   try
      printlog( "Try to click a button on the presentation toolbar" )
      Seiteduplizieren.click()
      warnlog( "The presentation toolbar is open" )
   catch
      printlog( "Button is unavailable. Good" )
   endcatch
   '///+Close the document
   printlog( "Close the document" )
   hCloseDocument
   gApplication = "WRITER" ' reset, just in case...
end sub
