'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: opt_ooo_userdata.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/11/15 13:36:20 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : Tools->Options: OpenOffice.org User Data
'*
'*******************************************************************************
'**
' #1 tOOoUserData
'**
'\******************************************************************************


testcase tOOoUserData
   Dim lsSave ( 20 ) as String

'///short test if 'StarOffice / User data' is saved in configuration
'///Start the test again, and you do not get the error. If you get the warning again, you have to check this.</FONT>

'///open a new document
   ToolsOptions
   hToolsOptions ( "StarOffice", "UserData" )

'///save old data
 printlog " - save old data"
   lsSave ( 1  ) = Firma.GetText
   lsSave ( 2  ) = VorName.GetText
   lsSave ( 3  ) = ZuName.GetText
   lsSave ( 4  ) = Kuerzel.GetText
   lsSave ( 5  ) = Strasse.GetText
   lsSave ( 6  ) = Land.GetText
   lsSave ( 7  ) = Titel.GetText
   lsSave ( 8  ) = Position.GetText
   lsSave ( 9  ) = TelPriv.GetText
   lsSave ( 10 ) = TelGe.GetText
   lsSave ( 11 ) = Fax.GetText
   lsSave ( 12 ) = EMail.GetText

   if iSprache = 01 then
      lsSave ( 13 ) = City.GetText
      lsSave ( 14 ) = State.GetText
      lsSave ( 15 ) = Zip.GetText
   else
      lsSave ( 16 ) = PLZ.GetText
      lsSave ( 17 ) = Ort.GetText
   end if
   if Apartmentnummer.IsVisible then lsSave ( 18 ) = Apartmentnummer.GetText
   if iSprache = 07 then lsSave ( 19 ) = NameDesVaters.GetText

'///change all data
 printlog " - change data"
   Firma.SetText    "Company name"
   VorName.SetText  "First name"
   ZuName.SetText   "Last name"
   Kuerzel.SetText  "FnLn"
   Strasse.SetText  "Street name"
   Land.SetText     "Land name"
   Titel.SetText    "Title name"
   Position.SetText "Position name"
   TelPriv.SetText  "TelHome number"
   TelGe.SetText    "TelWork number"
   Fax.SetText      "Fax number"
   EMail.SetText    "eMail-adress"

   if iSprache = 01 then
      City.SetText  "City name"
      State.SetText "State name"
      Zip.SetText   "Zip code"
   else
      PLZ.SetText   "PLZ name"
      Ort.SetText   "Ort name"
   end if
   if Apartmentnummer.IsVisible then Apartmentnummer.SetText "Appart number"
   if iSprache = 07 then NameDesVaters.SetText "Farthers name"

'///close the options-dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

'///close the document
   hCloseDocument

'///exit / restart StarOffice
  printlog " - exit/restart StarOffice"
   ExitRestartTheOffice

'///open options 'StarOffice' / 'Userdata'
 printlog " - check changes"
   ToolsOptions
   hToolsOptions ( "StarOffice", "UserData" )

'///check changes
   if Firma.GetText    <> "Company name"   then Warnlog "Company => changes not saved"
   if VorName.GetText  <> "First name"     then Warnlog "First name => changes not saved"
   if ZuName.GetText   <> "Last name"      then Warnlog "Last name => changes not saved"
   if Kuerzel.GetText  <> "FnLn"           then Warnlog "Initials => changes not saved"
   if Strasse.GetText  <> "Street name"    then Warnlog "Street => changes not saved"
   if Land.GetText     <> "Land name"      then Warnlog "Land => changes not saved"
   if Titel.GetText    <> "Title name"     then Warnlog "Title => changes not saved"
   if Position.GetText <> "Position name"  then Warnlog "Position => changes not saved"
   if TelPriv.GetText  <> "TelHome number" then Warnlog "Tel-home => changes not saved"
   if TelGe.GetText    <> "TelWork number" then Warnlog "tel-work => changes not saved"
   if Fax.GetText      <> "Fax number"     then Warnlog "Fax => changes not saved"
   if EMail.GetText    <> "eMail-adress"   then Warnlog "eMail => changes not saved"

   if iSprache = 01 then
      if City.GetText  <> "City name"      then Warnlog "City => changes not saved"
      if State.GetText <> "State name"     then Warnlog "State => changes not saved"
      if Zip.GetText   <> "Zip code"       then Warnlog "Zip => changes not saved"
   else
      if PLZ.GetText   <> "PLZ name"       then Warnlog "PLZ => changes not saved"
      if Ort.GetText   <> "Ort name"       then Warnlog "Ort => changes not saved"
   end if
   if Apartmentnummer.IsVisible then
      if Apartmentnummer.GetText <> "Appart number" then Warnlog "Appartment => changes not saved"
   end if
   if iSprache = 07 then
      if NameDesVaters.GetText <> "Farthers name"   then Warnlog "Farthers name => changes not saved"
   end if

'///reset to saved data
 printlog " - reset to saved data"

   Firma.SetText    lsSave ( 1  )
   VorName.SetText  lsSave ( 2  )
   ZuName.SetText   lsSave ( 3  )
   Kuerzel.SetText  lsSave ( 4  )
   Strasse.SetText  lsSave ( 5  )
   Land.SetText     lsSave ( 6  )
   Titel.SetText    lsSave ( 7  )
   Position.SetText lsSave ( 8  )
   TelPriv.SetText  lsSave ( 9  )
   TelGe.SetText    lsSave ( 10 )
   Fax.SetText      lsSave ( 11 )
   EMail.SetText    lsSave ( 12 )

   if iSprache = 01 then
      City.SetText  lsSave ( 13 )
      State.SetText lsSave ( 14 )
      Zip.SetText   lsSave ( 15 )
   else
      PLZ.SetText   lsSave ( 16 )
      Ort.SetText   lsSave ( 17 )
   end if
   if Apartmentnummer.IsVisible then Apartmentnummer.SetText lsSave ( 18 )
   if iSprache = 07 then NameDesVaters.SetText lsSave ( 19 )

'///close the options-dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

'///open options 'StarOffice' / 'Userdata'
 printlog " - check data"

   ToolsOptions
   hToolsOptions ( "StarOffice", "UserData" )

'///check data
   if Firma.GetText    <> lsSave ( 1 )  then Warnlog "Company => changes not saved"
   if VorName.GetText  <> lsSave ( 2 )  then Warnlog "First name => changes not saved"
   if ZuName.GetText   <> lsSave ( 3 )  then Warnlog "Last name => changes not saved"
   if Kuerzel.GetText  <> lsSave ( 4 )  then Warnlog "Initials => changes not saved"
   if Strasse.GetText  <> lsSave ( 5 )  then Warnlog "Street => changes not saved"
   if Land.GetText     <> lsSave ( 6 )  then Warnlog "Land => changes not saved"
   if Titel.GetText    <> lsSave ( 7 )  then Warnlog "Title => changes not saved"
   if Position.GetText <> lsSave ( 8 )  then Warnlog "Position => changes not saved"
   if TelPriv.GetText  <> lsSave ( 9 )  then Warnlog "Tel-home => changes not saved"
   if TelGe.GetText    <> lsSave ( 10 ) then Warnlog "tel-work => changes not saved"
   if Fax.GetText      <> lsSave ( 11 ) then Warnlog "Fax => changes not saved"
   if EMail.GetText    <> lsSave ( 12 ) then Warnlog "eMail => changes not saved"

   if iSprache = 01 then
      if City.GetText  <> lsSave ( 13 ) then Warnlog "City => changes not saved"
      if State.GetText <> lsSave ( 14 ) then Warnlog "State => changes not saved"
      if Zip.GetText   <> lsSave ( 15 ) then Warnlog "Zip => changes not saved"
   else
      if PLZ.GetText   <> lsSave ( 16 ) then Warnlog "PLZ => changes not saved"
      if Ort.GetText   <> lsSave ( 17 ) then Warnlog "Ort => changes not saved"
   end if
   if Apartmentnummer.IsVisible then
      if Apartmentnummer.GetText <> lsSave ( 18 ) then Warnlog "Appartment => changes not saved"
   end if
   if iSprache = 07 then
      if NameDesVaters.GetText <> lsSave ( 19 ) then Warnlog "Farthers name => changes not saved"
   end if

'///close the options-dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

endcase

' > * > * > * > * > * > * > * > * > * > * > * > * > * > * > * > *
' > * > * > * > * > * > * > * > * > * > * > * > * > * > * > * > *
testcase tStarOfficeGeneral
  Dim lsSave (4) as String
  Dim lbSave (3) as Boolean

'///short test if 'StarOffice / General' is saved in configuration
'///open options 'StarOffice' / 'General'
   ToolsOptions
   hToolsOptions ( "StarOffice", "General" )

'///check platform dependences
'///- 'Load StarOffice at system-startup' has to exists only on windows-systems
 printlog " - check platform dependences "
   if gPlatgroup = "unx" then
      if StarOfficeDialogeBenutzen.Exists then
         if StarOfficeDialogeBenutzen.IsVisible then Warnlog "The 'Use StarOffice dialogs'-Feature is visible on non-windows plattforms"
      end if
   end if

'///save old data
 printlog " - save old data"
   lsSave ( 1 ) = Zweistellig.GetText
   lbSave ( 1 ) = Aktivieren.IsChecked
   Aktivieren.Check
   lsSave ( 2 ) = Anzeigedauer.GetText
   if gPlatgroup = "w95" then
      lbSave (2) = StarOfficeDialogeBenutzen.IsChecked
   end if
   lbSave ( 3 ) = DruckenStatus.IsChecked
   lsSave ( 3 ) = StyleSheet.GetSelText

'///invert/change data
 printlog " - invert/change data"
   Zweistellig.SetText "1950"
   Zuruecksetzen.Click
   Anzeigedauer.SetText "120"
   if gPlatgroup = "w95" then
      if lbSave (2) = TRUE then StarOfficeDialogeBenutzen.Uncheck else StarOfficeDialogeBenutzen.Check
   end if
   If lbSave ( 3 ) = TRUE then DruckenStatus.Uncheck else DruckenStatus.Check
   StyleSheet.Select 3

'///close options-dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

'///exit/restart StarOffice
 printlog " - exit/restart StarOffice"
   ExitRestartTheOffice

'///open options 'StarOffice' / 'General'
 printlog " - check data"
   ToolsOptions
   hToolsOptions ( "StarOffice", "General" )

'///check data
   if Zweistellig.GetText <> "1950" then Warnlog "Year ( 2 digits ) => changes not saved: '" + Zweistellig.GetText +"'"
   if Aktivieren.IsChecked <> TRUE then Warnlog "Enable HelpAgent => changes not saved"
   Zuruecksetzen.Click
   if Anzeigedauer.GetText <> "60" then Warnlog "The maximum of duration is not 60sec, it is " + Anzeigedauer.GetText + "sec!"
   if gPlatgroup = "w95" then
      if StarOfficeDialogeBenutzen.IsChecked = lbSave (2) then Warnlog "Use StarOffice dialogs => changes not saved!"
   end if
   If DruckenStatus.IsChecked = lbSave ( 3 ) then Warnlog "Printing sets 'Document modified' status => changes not saved!"

'///make 2. changes
 printlog " - 2. change data"
   Zweistellig.SetText "1800"
   Anzeigedauer.SetText lsSave ( 2 )
   DruckenStatus.UnCheck

'///close options-dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

'///open options 'StarOffice' / 'General'
 printlog " - check data"
   ToolsOptions
   hToolsOptions ( "StarOffice", "General" )

'///check data
   if Zweistellig.GetText <> "1800" then Warnlog "Year ( 2 digits ) => changes not saved : '" + Zweistellig.GetText +"'"
   if Anzeigedauer.GetText <> lsSave (2) then Warnlog "Duration => changes not saved"
   If DruckenStatus.IsChecked <> FALSE then Warnlog "Printing sets 'Document modified' status => changes not saved!"
   if StyleSheet.GetSelIndex <> 3 then Warnlog "Style sheet for StarOffice Help => changes not saved!"

'///reset to saved data
 printlog " - reset to saved data"
   Zweistellig.SetText lsSave ( 1 )
   Aktivieren.Check
   Zuruecksetzen.Click
   Anzeigedauer.SetText lsSave (2)
   if lbSave (1) = TRUE then Aktivieren.Check else Aktivieren.Uncheck
   if gPlatgroup = "w95" then
      if lbSave (2) = TRUE then StarOfficeDialogeBenutzen.Check else StarOfficeDialogeBenutzen.UnCheck
   end if
   If lbSave(3)= TRUE then DruckenStatus.Check else DruckenStatus.UnCheck
   StyleSheet.Select lsSave(3)

'///close options-dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

'///open options 'StarOffice' / 'General'
   ToolsOptions
   hToolsOptions ( "StarOffice", "General" )

'///check data
 printlog " - check the reset data"
   if Zweistellig.GetText <> lsSave ( 1 ) then Warnlog "Year ( 2 digits ) => changes not saved"
   if Aktivieren.IsChecked <> lbSave (1) then Warnlog "Enable HelpAgent => changes not saved"
   Aktivieren.Check
   Zuruecksetzen.Click
   if Anzeigedauer.GetText <> lsSave (2) then Warnlog "Duration => changes not saved => 88805"
   if lbSave (1) = TRUE then Aktivieren.Check else Aktivieren.Uncheck
   if gPlatgroup = "w95" then
      if StarOfficeDialogeBenutzen.IsChecked <> lbSave (2) then Warnlog "Use StarOffice dialogs => changes not saved!"
   end if
   If DruckenStatus.IsChecked <> lbSave(3) then Warnlog "Printing sets 'Document modified' status => changes not saved!"
   if StyleSheet.GetSelText <> lsSave (3) then Warnlog "Style sheet for StarOffice Help => changes not saved!"

'///close options-dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

endcase


' > * > * > * > * > * > * > * > * > * > * > * > * > * > * > * > *
' > * > * > * > * > * > * > * > * > * > * > * > * > * > * > * > *
testcase tStarOfficeMemory
  Dim lsSave (7) as String
  Dim lbSave as Boolean
  Dim sValue as String

'///short test if 'StarOffice / Momory' is saved in configuration
'///open options 'StarOffice' / 'Memory'
   ToolsOptions
   hToolsOptions ( "StarOffice", "Memory" )

'///check platform dependences
'///- 'Load StarOffice at system-startup' has to exists only on windows-systems
 printlog " - check platform dependences "
   if gPlatgroup = "unx" then
      if LoadQuickstarter.Exists then
         if LoadQuickstarter.IsVisible then Warnlog "The 'Load StarOffice during system-startup'-Feature is visible on non-windows plattforms => BUG 88257"
      end if
   end if

'///save old data
 printlog " - save old data"
   lsSave(1) = UndoSteps.GetText
   lsSave(2) = StarOffice.GetText
   lsSave(3) = MemoryPerObject.GetText
   lsSave(4) = RemoveFromMemoryAfter.GetText
   lsSave(5) = NumberOfObjects.GetText
   if gPlatgroup = "w95" then lbSave = LoadQuickstarter.IsChecked

'///invert/change data
 printlog " - invert/change data"
   UndoSteps.SetText "80"
   StarOffice.SetText "50"
   if Instr ( lsSave(3), "," ) <> 0 then
      sValue = "4,1"
   else
      sValue = "4.1"
   end if
   MemoryPerObject.SetText sValue
   RemoveFromMemoryAfter.SetText "00:41"
   NumberOfObjects.SetText "81"
   if gPlatgroup = "w95" then
      LoadQuickstarter.UnCheck
   end if

'///close options-dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

'///exit/restart StarOffice
 printlog " - exit/restart StarOffice"
   ExitRestartTheOffice

'///open options 'StarOffice' / 'Memory'
 printlog " - check data"
   ToolsOptions
   hToolsOptions ( "StarOffice", "Memory" )

'///check data
   if UndoSteps.GetText             <> "80" then Warnlog "Undo steps => changes not saved!"
   if StarOffice.GetText            <> "50" then Warnlog "Use For StarOffice => changes not saved!"
   if MemoryPerObject.GetText       <> sValue then Warnlog "Memory per object => changes not saved! => " + MemoryPerObject.GetText
   if RemoveFromMemoryAfter.GetText <> "00:41" then Warnlog "Remove from memory after => changes not saved! =>" + RemoveFromMemoryAfter.GetText
   if NumberOfObjects.GetText       <> "81" then Warnlog "Number of objects => changes not saved!"
   if gPlatgroup = "w95" then
      if LoadQuickstarter.IsChecked = TRUE then Warnlog "Load StarOffice during system-startup => changes not saved!"
   end if

'///make 2. changes
 printlog " - 2. change data"
   UndoSteps.SetText "5"
   StarOffice.SetText "11"
   if Instr ( lsSave(3), "," ) <> 0 then
      sValue = "1,9"
   else
      sValue = "1.9"
   end if
   MemoryPerObject.SetText sValue
   RemoveFromMemoryAfter.SetText "01:32"
   NumberOfObjects.SetText "2"
   if gPlatgroup = "w95" then
      LoadQuickstarter.Check
   end if

'///close options-dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

'///open options 'StarOffice' / 'Memory'
 printlog " - check data"
   ToolsOptions
   hToolsOptions ( "StarOffice", "Memory" )

'///check data
   if UndoSteps.GetText             <> "5" then Warnlog "Undo steps => changes not saved!"
   if StarOffice.GetText            <> "11" then Warnlog "Use For StarOffice => changes not saved!"
   if MemoryPerObject.GetText       <> sValue then Warnlog "Memory per object => changes not saved! => " + MemoryPerObject.GetText
   if RemoveFromMemoryAfter.GetText <> "01:32" then Warnlog "Remove from memory after => changes not saved! => " + RemoveFromMemoryAfter.GetText
   if NumberOfObjects.GetText       <> "2" then Warnlog "Number of objects => changes not saved!"
   if gPlatgroup = "w95" then
      if LoadQuickstarter.IsChecked <> TRUE then Warnlog "Load StarOffice during system-startup => changes not saved!"
   end if

'///reset to saved data
 printlog " - reset to saved data"
   UndoSteps.SetText lsSave(1)
   StarOffice.SetText lsSave(2)
   MemoryPerObject.SetText lsSave(3)
   RemoveFromMemoryAfter.SetText lsSave(4)
   NumberOfObjects.SetText lsSave(5)
   if gPlatgroup = "w95" then
      if lbSave = TRUE then LoadQuickstarter.Check else LoadQuickstarter.UnCheck
   end if

'///close options-dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

'///open options 'StarOffice' / 'Memory'
   ToolsOptions
   hToolsOptions ( "StarOffice", "Memory" )

'///check data
 printlog " - check the reset data"
   if UndoSteps.GetText             <> lsSave(1) then Warnlog "Undo steps => changes not saved!"
   if StarOffice.GetText            <> lsSave(2) then Warnlog "Use For StarOffice => changes not saved!"
   if MemoryPerObject.GetText       <> lsSave(3) then Warnlog "Memory per object => changes not saved! => " + MemoryPerObject.GetText
   if RemoveFromMemoryAfter.GetText <> lsSave(4) then Warnlog "Remove from memory after => changes not saved! =>" + RemoveFromMemoryAfter.GetText
   if NumberOfObjects.GetText       <> lsSave(5) then Warnlog "Number of objects => changes not saved!"
   if gPlatgroup = "w95" then
      if LoadQuickstarter.IsChecked <> lbSave then Warnlog "Load StarOffice during system-startup => changes not saved!"
   end if

'///close options-dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

endcase


