'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_sec_macrosecurity.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: jsk $ $Date: 2006/02/02 19:02:14 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Macros with all security-levels
'*
'*******************************************************************************
'**
' #1 tMacroSecurityLevels ' Macro execution in all security levels
'**
'\******************************************************************************

testcase tMacroSecurityLevels

    '///<H1>Macro execution in all security levels</H1>

    dim cWorkFile as string
        cWorkFile = gTesttoolPath & "framework\basic\input\BasicDocs\"
        cWorkFile = cWorkFile & "basic" & hGetSuffix( "current" )
        cWorkFile = convertpath( cWorkFile )

    dim iSecLevel as integer
    dim brc as boolean

    for iSecLevel = 0 to 3

        printlog( "" )
        hSetMacroSecurity( iSecLevel )

        select case iSecLevel
        case 0 : brc = hLoadFile( cWorkFile )
                 brc = hIdentifyExecutedMacro()
                 if ( not brc ) then
                     warnlog( CFN & "#i53711# Macro was not found/executed" )
                 endif                 
        case 1 : brc = hLoadFile( cWorkFile )
                 brc = hHandleSecurityWarning()
                 brc = hIdentifyExecutedMacro()
                 if ( not brc ) then
                     warnlog( CFN & "#i53711# Macro was not found/executed" )
                 endif
                 
        case 2 : brc = hLoadFile( cWorkFile )
                 brc = hHandleActivesOnLoad( 1 , 1 )
                 if ( not brc ) then
                     qaerrorlog( "#i53710# unexpected second messagebox" )
                 endif
                 brc = hIdentifyExecutedMacro()
                 if ( brc ) then
                     warnlog( "Macro was executed" )
                 endif                 
                 
        case 3 : brc = hLoadFile( cWorkFile )
                 brc = hHandleActivesOnLoad( 1 , 0 )
                 brc = hIdentifyExecutedMacro()
                 if ( brc ) then
                     warnlog( "Macro was executed" )
                 endif
        end select

        brc = hDestroyDocument()

    next iSecLevel

    hSetMacroSecurity( 1 )

endcase

'*******************************************************************************

function hIdentifyExecutedMacro() as boolean

    dim cMessage as string
    const CFN = "hIdentifyExecutedMacro::"

    sleep( 3 )

    kontext "active"
    if ( active.exists() ) then

        cMessage = active.getText()
        
        if ( cMessage = "TTMacro3" ) then
            printlog( CFN & "The Macro has been executed" )
            hIdentifyExecutedMacro() = true
            active.ok()
        else
            warnlog( CFN & "The WRONG macro/dialog is open" )
            hIdentifyExecutedMacro() = false
            hHandleActivesOnLoad( 0 , 2 )
        endif
        
    else
    
        printlog( CFN & "No macro/dialog is open" )
        hIdentifyExecutedMacro() = false
        
    endif
    
end function
