'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_autotext.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/16 14:45:30 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Short autotext ressource test
'*
'*******************************************************************************
'**
' #1 tUpdtAutotext ' Update test for autotext ressources
'**
'\******************************************************************************

testcase tUpdtAutotext

    '///<H1>Update test for autotext ressources</H1>
    '///<ul>
    
    dim cFile as string
    dim cFileIn as string
    dim cFileOut as string
    
    dim aRefList( 200 ) as string
    dim aUIList( 200 ) as string
    
    dim brc as boolean
    
    '///+<li>Create input/output paths</li>
    cFile = "names_" & iSprache & ".txt"
    cFileIn = gTesttoolPath & "framework\update\input\autotext\" & cFile
    cFileIn = convertpath( cFileIn )
    
    cFileOut = hGetWorkPath() & cFile
    
    '///+<li>Open a new writer document</li>
    hCreateDocument()
    
    '///+<li>Open the Autotext dialog</li>
    EditAutotext
    
    Kontext "AutoText"
    call dialogtest( AutoText )
    Vorschau_Anzeigen.unCheck()
    
    '///+<li>Retrieve all items from the Tree List Box</li>
    hExpandAllNodes( Liste )
    hSelectTopNode( Liste )
    hGetVisibleNodeNames( Liste , aUIList() )
    
    '///+<li>Close the dialog</li>
    AutoText.close()
    
    '///+<li>Close the document</li>
    brc = hDestroyDocument()

    '///+<li>Compare the entries agains a reference or create the list</li>
    if ( dir( cFileIn ) <> "" ) then
        hgetDataFileSection( cFileIn, aRefList() , "" , "" , "" )
        brc = gCompare2Lists( aUIList(), aRefList() )
        if ( not brc ) then
            warnlog( "Lists are not identical. please verify" )
        else
            printlog( "Comparision succeeded." )
        endif
    else
        warnlog( "The reference list does not exist. It will be created" )
        listwrite( aUIList() , cFileOut , "UTF8" )
        printlog( "File created at: " & cFileOut )
        printlog( "Manually copy to: " & cFileIn )
    endif
    
    '///</ul>
    
endcase

