'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_mailmerge.inc,v $
'*
'*  $Revision: 1.16 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/17 13:40:09 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Update test for the mailmerge wizard
'*
'*******************************************************************************
'**
' #1 tUpdtMailmerge ' Update test for Mailmerge Wizard
' #1 hUpdtMMWpage1()' UPdate test for Mailmerge Wizard page 1
' #1 hUpdtMMWpage2()' UPdate test for Mailmerge Wizard page 2
' #1 hUpdtMMWpage3()' UPdate test for Mailmerge Wizard page 3
' #1 hUpdtMMWpage4()' UPdate test for Mailmerge Wizard page 4
' #1 hUpdtMMWpage5()' UPdate test for Mailmerge Wizard page 5
' #1 hUpdtMMWpage6()' UPdate test for Mailmerge Wizard page 6
' #1 hUpdtMMWpage7()' UPdate test for Mailmerge Wizard page 7
' #1 hUpdtMMWpage8()' UPdate test for Mailmerge Wizard page 8
'**
'\******************************************************************************

private CSV_DATABASE as string

testcase tUpdtMailmerge

    dim brc as boolean
    dim irc as integer
    
    CSV_DATABASE = hGetWorkPath() & "myDatabase"
    hDeleteFile( CSV_DATABASE )

    '///<H1>Mailmerge Wizard</H1>
    '///<ul>

    call ExitRestartTheOffice()
    
    '///<li>Open the Mailmerge-Wizard</li>
    printlog( "Open the Mailmerge-Wizard" )
    irc = hOpenWizardWithMenu( "MAILMERGE" )
    if ( irc <> 0 ) then
        warnlog( "Could not open MailMerge Wizard, aborting Test" )
        goto endsub
    endif
    
    '///<ol>
    '///<li>Page 1</li>
    Kontext "MailMergeWizard"
    brc = hUpdtMMWpage1()
    if ( not brc ) then
        warnlog( "MailMergeWizard is not visible, aborting test" )
        goto endsub
    endif
    
    '///<li>Page 2</li>
    Kontext "MailMergeWizard"
    brc = hClickNextButton()
    hUpdtMMWPage2()
    
    '///<li>Page 3</li>
    Kontext "MailMergeWizard"
    brc = hClickNextButton()
	hUpdtMMWpage3()
    
    '///<li>Page 4</li>
    Kontext "MailMergeWizard"
    brc = hClickNextButton()
    hUpdtMMWPage4()
    
    '///<li>Page 5</li>
    Kontext "MailMergeWizard"
    brc = hClickNextButton()
    hUpdtMMWPage5()

    '///<li>Page 6</li>
    Kontext "MailMergeWizard"
    brc = hClickNextButton()
    hUpdtMMWPage6()
    
    '///<li>Page 7</li>
    Kontext "MailMergeWizard"
    brc = hClickNextButton()
    hUpdtMMWPage7()
    
    '///<li>Page 8</li>
    Kontext "MailMergeWizard"
    brc = hClickNextButton()
    hUpdtMMWPage8()
    
    '///</ol>
    '///<li>close the wizard</li>
    printlog( "close the wizard" )
    hFinishWizard( 2 )

    hUpdtMailMergeExit()
    '///</ul>
    

endcase

'**********************************************************************

function hUpdtMMWpage1() as boolean

    '///<h3>Update test for Mailmerge Wizard - page 1</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorstatus (boolean)</li>
    '///<ul>
    '///+<li>Do not use</li>
    '///</ul>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>
    

    const CFN = "hUpdtMMWpage1::"
    
    '///+<li>Verify that the tabpage is open</li>
    Kontext "TabMailMergeSourceDocument"
    if ( not TabMailMergeSourceDocument.exists() ) then
        warnlog( CFN & "Page 1 could not be accessed" )
        hUpdtMMWPage1() = false
        exit function
    endif

    '///+<li>Click on Browse Document to open FileOpen</li>
    Kontext "TabMailMergeSourceDocument"
    if ( BrowseDocument.exists() ) then
        if ( BrowseDocument.isEnabled ) then
            BrowseDocument.click()
            
            '///+<li>Cancel FileOpen dialog</li>
            Kontext "OeffnenDlg"
            if ( OeffnenDlg.exists ) then
                printlog( CFN & "BrowseDocument::File Open Dialog" )
                call dialogtest( OeffnenDlg )
                OeffnenDlg.cancel()
            else
                warnlog( CFN & "BrowseDocument::FileOpen not open" )
            endif
        else
            warnlog( CFN & "BrowseDocument::Button is disabled" )
       endif
    else
        warnlog( CFN & "BrowseDocument::Button does not exist" )
    endif
    
    '///+<li>Click on Browse Template to open the New...-dialog</li>
    Kontext "TabMailMergeSourceDocument"
    if ( BrowseTemplate.exists() ) then
        if ( BrowseTemplate.isEnabled ) then
            BrowseTemplate.click()
            
            '///+<li>Cancel the New...-dialog</li>
            Kontext "Neu"
            if ( Neu.exists ) then
                printlog( CFN & "BrowseTemplate::New Dialog" )
                call dialogtest( Neu )
                Neu.cancel()
            else
                warnlog( CFN & "BrowseTemplate::FileOpen not open" )
            endif
        else
            warnlog( CFN & "BrowseTemplate::Button is disabled" )
        endif
    else
        warnlog( CFN & "BrowseTemplate::Button does not exist" )
    endif
        
    '///+<li>Check to create a new document</li>
    kontext "TabMailMergeSourceDocument"
    if ( CreateANewDocument.exists() ) then
        if ( CreateANewDocument.isEnabled ) then
            printlog( CFN & "Check Create new Document" )
            CreateANewDocument.check()
        else
            warnlog( CFN & "CheckBbox is disabled" )
        endif
    else
        warnlog( CFN & "CheckBox does not exist" )
    endif

    hUpdtMMWPage1() = true
    '///</ul>

end function

'**********************************************************************

function hUpdtMMWpage2()

    '///<h3>Update test for Mailmerge Wizard - page 2</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>

    const CFN = "hUpdtMMWpage2::"

    '///+<li>Verify that the tabpage is open</li>
    Kontext "TabMailMergeDocumentType"
    if ( not TabMailMergeDocumentType.exists ) then
        warnlog( CFN & "Page 2 could not be accessed" )
        exit function
    endif
    
    call dialogtest( TabMailMergeDocumentType )
    
    '///+<li>Check the Letter-checkbox</li>
    printlog( CFN & "Select to create a letter" )
    if ( Letter.exists() ) then
        if ( Letter.isEnabled ) then
            Letter.check()
        else
            warnlog( CFN & "Cannot check Letter-Checkbox" )
        endif
    else
        warnlog( CFN & "Letter Checkbox does not exist" )
    endif
    '///</ul>
    
end function   

'*******************************************************************************

function hUpdtMMWpage3()

    '///<h3>Update test for Mailmerge Wizard - page 3</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>

    const CFN = "hUpdtMMWpage3::"
    
    dim cDatabase as string
        cDatabase = gTesttoolpath & "framework\tools\input\mailmerge_data.odb"
        cDatabase = convertpath( cDatabase )
    
    '///+<li>Verify that the tabpage is open</li>
    Kontext "TabMailMergeAddressBlock"
    if ( not TabMailMergeAddressBlock.exists() ) then
        warnlog( CFN & "Page 3 could not be accessed" )
        exit function
    endif
    
    call Dialogtest( TabMailMergeAddressBlock )
    
    '///+<li>Click &quot;different addresslist&quot; button and open all subsequent dialogs</li>
    Kontext "TabMailMergeAddressBlock"
    hSelectDifferentAddressList( cDatabase )
    
    '///+<li>Click more button</li>
    Kontext "TabMailMergeAddressBlock"
    hSelectAddressBlock()
    
    '///+<li>Click match fields button</li>
    Kontext "TabMailMergeAddressBlock"
    MatchFieldsButton.click()
    
    ' IMPLEMENT NEW DIALOG HERE
    
    'warnlog( "#i48232 Help-Id is missing for Match Fields button" )
    '///</ul>
    
    
end function

'*******************************************************************************

function hUpdtMMWpage4()

    '///<h3>Update test for Mailmerge Wizard - page 4</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>

    const CFN = "hUpdtMMWpage4::"
    dim brc as boolean
   
    brc = false

    '///+<li>Verify that the tabpage is open</li>
    Kontext "TabMailMergeGreetingsPage"
    if ( not TabMailMergeGreetingsPage.exists() ) then
        warnlog( CFN & "Page 4 could not be accessed" )
        exit function
    endif
    
    call dialogtest( TabMailMergeGreetingsPage )
    
    ' the salutation checkbox must be checked, otherwise the buttons are not 
    ' available
    '///+<li>Verify that the Checkbox for Salutation is chaecked</li>
    if ( not GreetingPersonalized.isEnabled() ) then
        warnlog( CFN & "CheckBox Salutation not in HID.LST, it should be checked" )
        exit function
    endif
    
    '///+<li>Edit Addressblock for female salutation (GreetingsbuttonFemale)</li>
    Kontext "TabMailMergeGreetingsPage"
    printlog( CFN & "GreetingButtonFemale" )
    if ( GreetingButtonFemale.isEnabled() ) then
        hNewEditAddressBlock( 3 )
    else
        warnlog( CFN & "GreetingButtonFemale is not enabled" )
    endif

    '///+<li>Edit Addressblock for female salutation (GreetingsbuttonMale)</li>
    Kontext "TabMailMergeGreetingsPage"
    printlog( CFN & "GreetingButtonMale" )
    if ( GreetingButtonMale.isEnabled() ) then
        hNewEditAddressBlock( 4 )
    else
        warnlog( CFN & "GreetingButtonMale is not enabled" )
    endif

    '///+<li>Click the &quot;Match Fields&quot;-button</li>
    Kontext "TabMailMergeGreetingsPage"
    warnlog( "#i48232 " & CFN & "Button: MatchFields not in HID.LST" )
    '///</ul>

end function


'**************************************************************************

function hUpdtMMWpage5()

    '///<h3>Update test for Mailmerge Wizard - page 5</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>

    const CFN = "hUpdtMMWpage5::"
    
    '///+<li>Verify that the tabpage is open</li>
    kontext "TabMailMergeLayoutPage"
    if ( not TabMailMergeLayoutPage.exists() ) then
        warnlog( CFN & "Page 5 could not be accessed" )
        exit function
    endif
    
    '///+<li>Change nothing, go to next page directly</li>
    call DialogTest( TabMailMergeLayoutPage )
    
    printlog( CFN )
    '///</ul>
    
end function

'**************************************************************************

function hUpdtMMWpage6()

    '///<h3>Update test for Mailmerge Wizard - page 6</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>

    const CFN = "hUpdtMMWpage6::"
    
    printlog( CFN )
    
    '///+<li>Verify that the tabpage is open</li>
    kontext "TabMailMergePrepare"
    if ( not TabMailMergePrepare.exists() ) then
        warnlog( CFN & "Page 6 could not be accessed" )
        exit function
    endif
    
    call DialogTest( TabMailMergePrepare )
    
    '///+<li>Click the &quot;Edit&quot;-button</li>
    if ( EditButton.exists() and EditButton.isEnabled() ) then
        EditButton.click()
        sleep( 5 )
        '///+<li>Click on &quot;Back to Wizard&quot; float to return to the wizard</li>
        hWaitForBackToWizardFloat()
    else    
        warnlog( CFN & "Could not access Edit-Button" )
    endif
    '///</ul>
    
end function

'**************************************************************************

function hUpdtMMWpage7()

    '///<h3>Update test for Mailmerge Wizard - page 7</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>

    const CFN = "hUpdtMMWpage7::"
    
    printlog( CFN )    
    
    sleep( 10 ) ' for some reason this page is very slow to appear
    
    '///+<li>Verify that the tabpage is open</li>
    kontext "TabMailMergePersonalize"
    if ( not TabMailMergePersonalize.exists() ) then
        warnlog( CFN & "Page 7 could not be accessed" )
        exit function
    endif
    
    call DialogTest( TabMailMergePersonalize )
    
    '///+<li>Click on &quot;EditIndividual&quot;-button</li>
    if ( EditIndividualButton.exists() and EditIndividualButton.isEnabled() ) then
        EditIndividualButton.click()
        sleep( 5 )
        '///+<li>Return to the Wizard by clicking on the float</li>
        hWaitForBackToWizardFloat()
    else
        warnlog( CFN & "Could not access Edit-Button" )
    endif  
    '///</ul>
    
end function

'**************************************************************************

function hUpdtMMWpage8()

    '///<h3>Update test for Mailmerge Wizard - page 8</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Description</u>:
    '///<ul>

    const CFN = "hUpdtMMWpage8::"
    
    '///+<li>Verify that the tabpage is open</li>
    kontext "TabMailMergeOutputPage"
    if ( not TabMailMergeOutputPage.exists() ) then
        warnlog( CFN & "Page 8 could not be accessed" )
        exit function
    endif
    
    printlog( CFN )
    
    call DialogTest( TabMailMergeOutputPage )
    
    '///+<li>Check Save Document, go throught subsequent dialogs (if any)</li>
    kontext "TabMailMergeOutputPage"
    hSaveStartingDocument()
    
    '///+<li>Check Save Mailmerge Document, go throught subsequent dialogs (if any)</li>
    kontext "TabMailMergeOutputPage"
    hSaveMailMergeDocument()
    
    '///+<li>Check Print, go throught subsequent dialogs (if any)</li>
    kontext "TabMailMergeOutputPage"
    hPrintMailMergeDocument()
    
    '///+<li>Check Send, go throught subsequent dialogs (if any)</li>
    kontext "TabMailMergeOutputPage"
    hSendMailMergeDocument()
    '///</ul>
    
end function

'*******************************************************************************

function hSelectDifferentAddressList( cDatabase as string ) as boolean

    const CFN = "hSelectDifferentAddressList::"
    
    dim brc as integer
        brc = false
        
    Kontext "TabMailMergeAddressBlock"
    SelectAddressListButton.click()

    Kontext "SelectAddressList"
    if ( SelectAddressList.exists() ) then
        printlog( CFN & "Select Address List Dialog" )
        call dialogtest( SelectAddressList )
        brc = true
    else
        warnlog( CFN & "SelectAddressList dialog is not open" )
        exit function
    endif
	    
	' make sure we have two databases to choose from
    Kontext "SelectAddressList"
    brc = hAddDatabase( cDatabase ) 
    sleep( 1 )
    
    Kontext "SelectAddressList"
    if ( AdressList.getItemCount() < 2 ) then
        brc = hAddDatabase( cDatabase )
    endif
    
    Kontext "SelectAddressList"
    brc = hEditCreateAddressList( 1 )
    sleep( 1 )
	
    Kontext "SelectAddressList" 
    brc = hFilterDialog()
    sleep( 1 )

    Kontext "SelectAddressList"
    brc = hEditCreateAddressList( 2 )
    sleep( 1 )
	
    Kontext "SelectAddressList"
    AdressList.select( 2 )
        
    kontext "SelectAddressList"
    SelectAddressList.ok()	 
    
    Kontext "TabMailMergeAddressBlock"
    hSelectDifferentAddressList() = brc

end function

'*******************************************************************************

function hWaitForBackToWizardFloat() as boolean

    '///<h1>Try to close the BackToWizard float</h1>

    const CFN = "hWaitForBackToWizardFloat::"
    const MAXTRIES = 20 
    dim iTry as integer
    dim brc as boolean
        brc = false
           
    '///+Try to grab the float (it is currently an "active"
    Kontext "MailMergeFloat"
    for iTry = 1 to MAXTRIES
    
        if ( MailMergeFloat.exists() ) then
            printlog( CFN & "Back to document float is open" )
            ReturnToMailMergeWizard.click()
            sleep( 1 )
            brc = true
            exit for
        else
            sleep( 1 )
            if ( iTry = MAXTRIES ) then
                warnlog( CFN & "Failed to find BackToWizard-Float" )
            endif
        endif
        
    next iTry
    
    '///+Verify that we are back to the wizard (might take some time)
    Kontext "MailMergeWizard"
    brc = false
    for iTry = 1 to MAXTRIES
    
        if ( MailMergeWizard.exists() ) then
            brc = true
            exit for
        else
            sleep( 1 )
        endif
        
    next iTry
    
    hWaitForBackToWizardFloat() = brc
        
end function

'*******************************************************************************

function hAddDatabase( cDatabase as string ) as boolean

    const CFN = "hAddDatabase::"
    
    dim brc as boolean
        brc = false
        
    dim iWait as integer
    
    add.click()

    Kontext "OeffnenDlg"
    if ( OeffnenDlg.exists() ) then
        printlog( CFN & "File Open Dialog" )
        DateiName.setText( cDatabase )
        Oeffnen.click()
        brc = true
    else
        warnlog( CFN & "FileOpen is missing" )
    endif
	
    ' When a new addressdatabase is imported it might take some time before we
    ' get back to the SelectAddressList dialog
    hWaitForSelectAddressListDialog()
    
    hAddDatabase() = brc
    
end function

'******************************************************************************

function hEditCreateAddressList( iMode as integer ) as boolean

    const CFN = "hEditCreateAddressList::"

    dim brc as boolean
        brc = false
        
    dim iWait as integer
        
    Kontext "SelectAddressList"
    select case iMode
    case 1 : create.click()
    case 2 : edit.click()
    end select

    Kontext "NewAddressList"
    if ( NewAddressList.exists() ) then
        printlog( CFN & "New/Edit Address List Dialog is open" )
        call dialogtest( NewAddressList )
        brc = true
    else
        warnlog( CFN & "New/EditAddressList does not exist" )
    endif

    if ( not brc ) then
        hEditCreateAddressList() = brc
        exit function
    endif
        

    ' Try to use the Find-dialog, do not evaluate the returncode,
    ' the test should continue even if the dialog does not come up.
    brc = hFindDialog()
    sleep( 1 )
    
    ' Try to use the Customize-dialog, don't evaluate the rc either
    brc = hCustomizeAddressList()
    
    ' Return to "NewAddressList" 
    Kontext "NewAddressList"
    NewAddressList.ok()
    
    ' only save when a new list has been created, editing saves automatically
    if ( iMode = 1 ) then
        hSaveNewAddressList()
    endif
    
    hWaitForSelectAddressListDialog()
    
    Kontext "SelectAddressList"
    hEditCreateAddressList() = brc
	
end function

'*******************************************************************************

function hFindDialog() as boolean

    const CFN = "hFindDialog::"

    dim brc as boolean
        brc = false
        
    printlog( CFN )

    Kontext "NewAddressList"
    find.click()

    kontext "FindEntry"
    if ( FindEntry.exists() ) then
        call dialogtest( FindEntry )
        printlog( CFN & "Find Entry Dialog is open" )
        FindEntry.cancel()
        brc = true
    else
        warnlog( CFN & "Dialog is not open" )
    endif
	
    Kontext "NewAddressList"
    hFindDialog() = brc
	
end function

'******************************************************************************

function hCustomizeAddressList() as boolean

    const CFN = "hCustomizeAddressList::"

    dim brc as boolean
        brc = false
        
    printlog( CFN )

    Kontext "NewAddressList"
    if ( Customize.exists() ) then
        if ( Customize.isEnabled() ) then
            Customize.click()

            kontext "CustomizeAddressList"
            if ( CustomizeAddressList.exists() ) then
                printlog( CFN & "Customize Address List Dialog" )
                call dialogtest( CustomizeAddressList )
		
                kontext "CustomizeAddressList"
                hAddRenameElement( "NewElement" , 1 ) 
                sleep( 1 )
                
                kontext "CustomizeAddressList"
                hAddRenameElement( "Renamed" , 2 )
                sleep( 1 )
                
                kontext "CustomizeAddressList"
                printlog( CFN & "Delete" )
                delete.click()
                
                kontext "CustomizeAddressList"
                CustomizeAddressList.cancel()
                brc = true
            else
                warnlog( CFN & "Dialog is not open" )
            endif
        else
            warnlog( CFN & "Button is not enabled" )
        endif
    else
        warnlog( BRC & "Button does not exist" )
    endif
        
    Kontext "NewAddressList"
    hCustomizeAddressList() = brc
	
end function

'************************************************************************************

function hAddRenameElement( cElementName as string , iMode as integer ) as boolean

    const CFN = "hAddRenameElement::"
    dim brc as boolean
        brc = false

    select case iMode
    case 1 : Add.click()
    case 2 : Rename.click()
    end select
    
    Kontext "RenameElement"
    if ( RenameElement.exists() ) then
        printlog( CFN & "Add/Rename Element Dialog" )
        call Dialogtest( RenameElement )
        
        FieldTitle.setText( cElementName )
        RenameElement.ok()
        brc = true
    else
        warnlog( CFN & "Dialog is not open" )
    endif
       	
    hAddRenameElement() = brc
	
end function

'*******************************************************************************

function hFilterDialog() as integer

    const CFN = "hFilterDialog::"
    
    dim brc as boolean
        brc = false
        
    Kontext "SelectAddressList"
    if ( Filter.exists() ) then
        if ( Filter.isEnabled() ) then
            Filter.click()
            
            kontext "FilterDialog"
            if ( FilterDialog.exists() ) then
                printlog( CFN & "Filter Dialog" )
                call Dialogtest( FilterDialog )
                
                FilterDialog.cancel()
                brc = true
            else
                warnlog( "#i54150 " & CFN & "Filter dialog is not open" )
            endif
        else
            warnlog( CFN & "Filter Button is not enabled" )
        endif
    else
        warnlog( CFN & "Filter Button is missing" )
    endif
    
    hWaitForSelectAddressListDialog()
    hFilterDialog() = brc
  
end function

'****************************************************************************

function hSelectAddressBlock() as boolean

    const CFN = "hSelectAddressBlock::"
    
    dim brc as boolean
        brc = false
        
    printlog( CFN  & "More..." )
        
    Kontext "TabMailMergeAddressBlock"
    if ( more.exists() ) then
        if ( more.isEnabled() ) then
            more.click()
            
            Kontext "SelectAddressBlock"
            if ( SelectAddressBlock.exists() ) then
                printlog( CFN & "SelectAddressBlock dialog is open" )
                call DialogTest( SelectAddressBlock )
                
                Kontext "SelectAddressBlock"
                hNewEditAddressBlock( 1 )
                
                Kontext "SelectAddressBlock"
                hNewEditAddressBlock( 2 )
                
                Kontext "SelectAddressBlock"
                SelectAddressBlock.ok()
                brc = true
            else
                warnlog( CFN & "Dialog is not open" )
            endif        
        else
            warnlog( CFN & "Button is disabled" )
        endif
    else
        warnlog( CFN & "Button does not exist" )
    endif
        
    hSelectAddressBlock() = brc
    
end function

'*******************************************************************************

function hNewEditAddressBlock( iMode as integer ) as boolean

    const CFN = "hNewEditAddressBlock::"

    select case iMode
    case 1 : NewBtn.click()
    case 2 : Customize.click()
    case 3 : GreetingButtonFemale.click()
    case 4 : GreetingButtonMale.click()
    end select
    
    Kontext "NewAddressBlock"
    if ( NewAddressBlock.exists() ) then
        printlog( cfn & "Dialog is open" )
        NewAddressBlock.cancel()
        hNewEditAddressBlock() = true
    else
        warnlog( cfn & "Dialog is not open" )
        hNewEditAddressBlock() = false
    endif
        
end function

'*******************************************************************************

function hSaveStartingDocument() as boolean

    const CFN = "hSaveStartingDocument::"
    
    dim brc as boolean
        brc = false

    if ( RBSaveStartDoc.exists() ) then
         if ( RBSaveStartDoc.isEnabled ) then
             RBSaveStartDoc.check()
             brc = true
         else
             warnlog( CFN & "Cannot set radiobutton" )
         endif
    else
        warnlog( CFN & "Radiobutton is missing" )
    endif
    
    ' save file
    if ( PBSaveStartDoc.exists() ) then
        if ( PBSaveStartDoc.isEnabled ) then
            PBSaveStartDoc.click()
             
            Kontext "SpeichernDlg"
            if ( SpeichernDlg.exists() ) then
                printlog( CFN & "Save As Dialog is open" )
                SpeichernDlg.cancel()
                brc = true
            else
                warnlog( CFN & "FileSave dialog is missing" )
            endif
        else
            warnlog( CFN & "SaveStartDoc is disabled" )
        endif
    else
        warnlog( CFN & "SaveStartDoc is missing" )
    endif            
    
    hSaveStartingDocument() = brc
    
end function

'******************************************************************************* 

function hSaveMailMergeDocument() as boolean

    const CFN = "hSaveMailMergeDocument::"
    
    dim brc as boolean
        brc = false

    if ( RBSaveMergedDoc.exists() ) then
         if ( RBSaveMergedDoc.isEnabled ) then
             RBSaveMergedDoc.check()
             brc = true
         else
             warnlog( CFN & "Cannot set radiobutton" )
         endif
    else
        warnlog( CFN & "Radiobutton is missing" )
    endif
    
    ' save file
    if ( PBSaveNow.exists() ) then
        if ( PBSaveNow.isEnabled ) then
            PBSaveNow.click()
             
            Kontext "SpeichernDlg"
            if ( SpeichernDlg.exists() ) then
                printlog( CFN & "Save As Dialog is open" )
                SpeichernDlg.cancel()
                brc = true
            else
                warnlog( CFN & "FileSave dialog is missing" )
            endif
        else
            warnlog( CFN & "Save Now is disabled" )
        endif
    else
        warnlog( CFN & "Save Now is missing" )
    endif            
    
    hSaveMailMergeDocument() = brc
    
end function

'******************************************************************************* 

function hPrintMailMergeDocument() as boolean

    const CFN = "hPrintMailMergeDocument::"
    
    dim brc as boolean
        brc = false

    if ( RBPrintMerged.exists() ) then
         if ( RBPrintMerged.isEnabled ) then
             RBPrintMerged.check()
             brc = true
         else
             warnlog( CFN & "Cannot set radiobutton" )
         endif
    else
        warnlog( CFN & "Radiobutton is missing" )
    endif

    if ( instr( gtSYSName , "win" ) > 0 ) then
        printlog( CFN & "Skipping printer dialog on windows" )
        hPrintMailMergeDocument() = true
        exit function
    endif
    
    ' printer settings
    if ( PBPrinterSettings.exists() ) then
        if ( PBPrinterSettings.isEnabled ) then
            PBPrinterSettings.click()
             
            Kontext "TabSPAPaper"
            if ( TabSPAPaper.exists() ) then
                printlog( CFN & "Printer Settings Dialog" )
                TabSPAPaper.OK
                brc = true
            else
                warnlog( CFN & "Printer Settings dialog is missing" )
            endif
        else
            warnlog( CFN & "Printer Settings is disabled" )
        endif
    else
        warnlog( CFN & "Printer Settings is missing" )
    endif   
    
    hPrintMailMergeDocument() = brc
    
end function

'******************************************************************************* 

function hSendMailMergeDocument() as boolean

    const CFN = "hSendMailMergeDocument::"
    
    dim brc as boolean
        brc = false

    if ( RBSendAsMail.exists() ) then
         if ( RBSendAsMail.isEnabled ) then
             RBSendAsMail.check()
         else
             warnlog( CFN & "Cannot set radiobutton" )
         endif
    else
        warnlog( CFN & "Radiobutton is missing" )
    endif
    
    ' send copy to
    if ( PBCopyTo.exists() ) then
        if ( PBCopyTo.isEnabled ) then
            PBCopyTo.click()
             
            Kontext "CopyToDialog"
            if ( CopyToDialog.exists() ) then
                printlog( CFN & "CopyToDialog is open" )
                call DialogTest( CopyToDialog )
                CopyToDialog.OK()
            else
                warnlog( CFN & "CopyToDialog dialog is missing" )
            endif
        else
            warnlog( CFN & "PBCopyTo is disabled" )
        endif
    else
        warnlog( CFN & "PBCopyTo is missing" )
    endif   
    
    kontext "TabMailMergeOutputPage"
    if ( PBSendDocuments.exists() ) then
        if ( PBSendDocuments.isEnabled() ) then
            PBSendDocuments.click()
            Kontext "Active"
            if ( active.exists() ) then
                printlog( CFN & "Dialog asking for EMail-account is open" )
                call Dialogtest( active )
                active.yes()
                
                kontext "TabMailMergeEmail"
                hMailMergeEmailDialog()
            else
                warnlog( CFN & "Dialog asking for EMail-account is missing" )
            endif
        else
            warnlog( CFN & "Send documents Button is disabled" )
        endif
    else
        warnlog( CFN & "Send Documents Button is missing" )
    endif
    
    hSendMailMergeDocument() = brc
    
end function

'******************************************************************************* 

function hMailMergeEmailDialog() as boolean

    const CFN = "hMailMergeEmailDialog::"
    dim brc as boolean
        brc = false
    
    if ( TabMailMergeEmail.exists ) then
        printlog( CFN & "EMail Account Dialog is open" )
        brc = true
    else
        warnlog( CFN & "EMail Account Dialog is not open" )
        exit function
    endif
    
    ' server authentication
    if ( ServerAuthentication.exists() ) then
        if ( ServerAuthentication.isEnabled() ) then
            ServerAuthentication.click()
            
            Kontext "ServerAuthentication"
            if ( ServerAuthentication.exists() ) then
                printlog( CFN & "Server Authentication dialog is open" )
                call DialogTest( ServerAuthentication )
                ServerAuthentication.cancel()
            else
                warnlog( CFN & "ServerAuthentication is not open" )
            endif
        else
            warnlog( CFN & "ServerAuthentication-Button is not enabled" )
        endif
    else
        warnlog( CFN & "ServerAuthentication-Button does not exist" )
        brc = false
    endif
    
    ' Test settings
    kontext "TabMailMergeEmail"   
    if ( TestSettings.exists() ) then
        if ( TestSettings.isEnabled() ) then
            TestSettings.click()
            
            kontext "TestAccountSettings"
            if ( TestAccountSettings.exists() ) then
                printlog( CFN & "Test Account Settings Dialog is open" )
                call DialogTest( TestAccountSettings )
                TestAccountSettings.cancel()
            else
                warnlog( CFN & "Test Account Settings Dialog is not open" )
            endif
        else
            warnlog( CFN & "Test Settings-button is disabled" )
        endif
    else
        warnlog( CFN & "Test Settings-button is missing" )
    endif
    
    kontext "TabMailMergeEmail"
    TabMailMergeEmail.cancel()
    
    hMailMergeEmailDialog() = brc
    
end function

'*******************************************************************************

function hWaitForSelectAddressListDialog() as boolean

    dim iWait as integer
    
    Kontext "SelectAddressList"
    for iWait = 1 to 10
    
        if ( SelectAddressList.exists() ) then
            hWaitForSelectAddressListDialog() = true
            exit function
        else
            sleep( 1 )
        endif
        
    next iWait  
    
    hWaitForSelectAddressListDialog() = false
    
end function

'*******************************************************************************

function hSaveNewAddressList()

    const CFN = "hSaveNewAddressList::"

    Kontext "SpeichernDlg"
    if ( SpeichernDlg.exists() ) then
    
        DateiName.setText( CSV_DATABASE )
        Speichern.click()
        
        kontext "active"
        if ( active.exists() ) then
            warnlog( active.getText() ) 
            active.yes()
        endif
        
        printlog( CFN & "File saved" )
    else
        warnlog( CFN & "FileSave did not come up" )
    endif
    
end function

'*******************************************************************************

function hUpdtMailMergeExit() as boolean

    const CFN = "hUpdtMailMergeExit::"

    dim iDatabaseCount as integer
    dim cCurrentDatabase as string
    dim brc as boolean
        brc = true
        
    brc = hDestroyDocument()
    if ( not brc ) then
        warnlog( CFN & "Could not close document" )
    endif
        
    
    
        
    iDatabaseCount = 1000
    do while ( iDatabaseCount > 2 ) 
    
        ToolsOptions
        hToolsOptions( "DATASOURCES" , "DATABASES" )
        
        kontext "TabRegisteredDataSources"
        if ( RegisteredDatabases.exists() ) then
        
            sleep( 1 )
            iDatabaseCount = RegisteredDatabases.getItemCount()
        
            RegisteredDatabases.select( iDatabaseCount )
            cCurrentDatabase = RegisteredDatabases.getText()
            printlog( CFN & "Deleting: " & cCurrentDatabase )
        
            DeleteBtn.click()
            sleep( 1 )
        
            kontext "active"
            if ( active.exists() ) then
                active.yes()
                sleep( 1 )
            else
                warnlog( CFN & "No confirmation for deletion of a database" )
                brc = false
            endif
        else
            printlog( CFN & "Failed to access Tabpage, retrying" )
        endif
        
        sleep( 1 )
        exitToolsOptions( false )
               
    loop
    
    
    
    hDeleteFile( CSV_DATABASE )    
    
    hUpdtMailMergeExit() = brc
    
end function
