'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: g_option2.inc,v $
'*
'*  $Revision: 1.22 $
'*
'*  last change: $Author: tbo $ $Date: 2006/01/25 16:38:26 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : update and resouce test for all option pages (at tools/options)
'*
'************************************************************************
'*
' #1  tToolsOptionsTextdocument
' #1  tToolsOptionsHTMLDocument
' #1  tToolsOptionsSpreadsheet
' #1  tToolsOptionsPresentation
' #1  tToolsOptionsDrawing
' #1  tToolsOptionsFormula
' #1  tToolsOptionsChart
' #1  tToolsOptionsDataSources
'*
'\***********************************************************************

testcase tToolsOptionsTextdocument
  dim EchteAnzahl as Integer, i as Integer
  dim gefunden as Boolean
    
     PrintLog "- Tools/Options/Text document  ( Extras/Optionen/Textdokument )"
    if (0 = iSectionNumber) then 
        warnlog "You can't run this testcase seperated! Ending now! Please run it via: tToolsOptionsTest"
        goto endsub
    endif
   if gApplication <> "DESKTOP" then Call hNewDocument
 '///- tools / options / text document
   ToolsOptions
   Kontext "Active"
   if Active.Exists (3) then
      if Active.GetText <> sErrMes then Warnlog "A messagebox exists => BUG : " + Active.GetText
      Active.OK
   end if
   ToPosInOptionlist ( 4 )
   EchteAnzahl = Optionsliste.GetItemCount - iSectionNumber
   if EchteAnzahl = 10 AND ( gAsianSup = TRUE OR gCTLSup = TRUE ) then
      Warnlog "There are only 10 pages in 'text document'-section, but asian support or CTL support are activated! => a section is missing?"
   else
      printlog "Asian support and CTL support are not activated ( on languages-page )!"
   end if
   if bDebugVersion = TRUE  then EchteAnzahl = EchteAnzahl - 1
   if gAsianSup     = FALSE then EchteAnzahl = EchteAnzahl + 1
   if gCTLSup       = FALSE then EchteAnzahl = EchteAnzahl + 1
   for i=1 to EchteAnzahl
      gefunden = FALSE
      Kontext "OptionenDlg"
      Optionsliste.TypeKeys "<Down>"
      if gAsianSup = FALSE AND gCTLSup = FALSE AND i=6 then i=i+2
      if gAsianSup = FALSE AND gCTLSup = TRUE  AND i=6 then i=i+1
      if gAsianSup = TRUE  AND gCTLSup = FALSE AND i=7 then i=i+1
      select case i
       case 1 : Kontext "TabLaden"
                '///+-    general
                printlog "  - General / Allgemein"
                if TabLaden.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabLaden )
                end if
       case 2 : Kontext "TabInhalteWriter"
                '///+-    view
                printlog "  - View / Ansicht"
                if TabInhalteWriter.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabInhalteWriter )
                end if
       case 3 : Kontext "TabDirektCursor"
                '///+-    formating aids
                printlog "  - Formating aids / Formatierungshilfen"
                if TabDirektCursor.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabDirektCursor )
                end if
       case 4 : Kontext "TabRaster"
                '///+-    grid
                printlog "  - Grid / Raster"
                if TabRaster.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabRaster )
                end if
       case 5 : Kontext "TabGrundschriften"
                '///+-    default fonts
                printlog "  - Default Fonts / Grundschriften"
                if TabGrundschriften.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabGrundschriften )
                end if
       case 6 : Kontext "TabGrundschriftenAsian"
                '///+-    default fonts asian
                printlog "  - Default Fonts Asian / Grundschriften Asiatisch"
                if TabGrundschriftenAsian.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabGrundschriftenAsian )
                end if
       case 7 : Kontext "TabGrundschriftenCTL"
                '///+-    default fonts asian
                printlog "  - Default Fonts CTL / Grundschriften CTL"
                if TabGrundschriftenCTL.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabGrundschriftenCTL )
                end if
       case 8 : Kontext "TabDruckenWriter"
                '///+-    print
                printlog "  - Print / Drucken"
                if TabDruckenWriter.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabDruckenWriter )
                end if
       case 9 : Kontext "TabTabelleOptionen"
                '///+-    table
                printlog "  - Table / Tabellen"
                if TabTabelleOptionen.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabTabelleOptionen )
                end if
       case 10: Kontext "TabAenderungenWriter"
                '///+-    changes
                printlog "  - Changes / Aenderungen"
                if TabAenderungenWriter.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabAenderungenWriter )
                end if
       case 11: Kontext "TabCompatibility"
                '///+-    compatibility
                printlog "  - Compatibility"
                if TabCompatibility.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabCompatibility )
                end if
       case 12: Kontext "TabAutoCaption"
                '///+-    AutoCaption
                printlog "  - AutoCaption"
                if TabAutoCaption.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabAutoCaption )
                end if
       case 13: Kontext "TabMailMergeEMail"
                '///+-    Mail Merge E-mail
                printlog "  - Mail Merge E-mail"
                if TabMailMergeEMail.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabMailMergeEMail )
                   ServerAuthentication.click
                   kontext "ServerAuthentication"
                   Call DialogTest ( ServerAuthentication )
                   ServerAuthentication.cancel
                   Kontext "TabMailMergeEMail"
                   TestSettings.click
                   
                   ' in case java is not enabled
                   sleep( 2 )
                   try   
                       Kontext "Messagebox"
                       if ( MessageBox.exists()) then            
                           sleep(2)                
                           warnlog(Messagebox.GetText())                
                           try
                   Messagebox.Cancel()
                               sleep( 2 )
               catch
                           Messagebox.OK() ' if "OK" works, we are in an undefined state
                   warnlog( "" )
                           endcatch                
                       end if             
           catch
               warnlog( "A messagebox was displayed but coul not be closed." )
                   endcatch
                   
                   Kontext "TestaccountSettings"
                   Call DialogTest ( TestaccountSettings )
                   TestaccountSettings.cancel
                end if
      end select
      if gefunden=FALSE then
         Warnlog "Error with the " + i + ".page, perhaps this page is deleted or change the place!"
         EchteAnzahl = EchteAnzahl - 1
         if EchteAnzahl < 12 then
            i=13
         else
            i=1-1
         end if
      end if
   next i
'///+- close the options dialog
   Kontext "OptionenDlg"
   OptionenDlg.Cancel
   if gApplication <> "DESKTOP" then Call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase tToolsOptionsHTMLDocument
  dim EchteAnzahl as Integer, i as Integer
  dim gefunden as Boolean
    
   PrintLog "- Tools/Options/HTML-Document  ( Extras/Optionen/HTML-Dokument )"
    if (0 = iSectionNumber) then 
        warnlog "You can't run this testcase seperated! Ending now! Please run it via: tToolsOptionsTest"
        goto endsub
    endif
   if gApplication <> "DESKTOP" then Call hNewDocument
 '///- tools / options / HTML document
   ToolsOptions
   ToPosInOptionlist ( 5 )
   i = 6
   if bDebugVersion = TRUE  then i = i + 1  ' here exists the special debug-tabpage, too
   EchteAnzahl = OptionTabPageZaehler (i)
   if bDebugVersion = TRUE  then EchteAnzahl = EchteAnzahl - 1
   for i=1 to EchteAnzahl
      gefunden = FALSE
      Kontext "OptionenDlg"
      Optionsliste.TypeKeys "<Down>"
      select case i
       case 1 : Kontext "TabInhalteHTML"
                '///+-    view
                printlog "  - View / Ansicht"
                if TabInhalteHTML.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabInhalteHTML )
                end if
       case 2 : Kontext "TabDirektCursor"
                '///+-    formating aids
                printlog "  - Formatting aids / Formatierungshilfen"
                if TabDirektCursor.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabDirektCursor )
                end if
       case 3 : Kontext "TabRaster"
                '///+-    grid
                printlog "  - Grid / Raster"
                if TabRaster.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabRaster )
                end if
       case 4 : Kontext "TabDruckenHTML"
                '///+-    print
                printlog "  - Print / Drucken"
                if TabDruckenHTML.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabDruckenHTML )
                end if
       case 5 : Kontext "TabTabelleOptionen"
                '///+-    table
                printlog "  - Table / Tabelle"
                if TabTabelleOptionen.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabTabelleOptionen )
                end if
       case 6 : Kontext "TabHintergrund"
                '///+-    background
                printlog "  - Background / Hintergrund"
                Sleep 1
                if TabHintergrund.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabHintergrund )
                end if
      end select
      if gefunden=FALSE then
         Warnlog "Error with the " + i + ".page, perhaps this page is deleted or change the place!"
         EchteAnzahl = EchteAnzahl - 1
         if EchteAnzahl < 6 then
            i=11
         else
            i=1-1
         end if
      end if
   next i
'///+- close the options dialog
   Kontext "OptionenDlg"
   OptionenDlg.Cancel
   if gApplication <> "DESKTOP" then Call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase tToolsOptionsSpreadsheet
  dim EchteAnzahl as Integer, i as Integer
  dim gefunden as Boolean
    
    PrintLog "- Tools/Options/Spreadsheet  ( Extras/Optionen/Tabellendokument )"
    if (0 = iSectionNumber) then 
        warnlog "You can't run this testcase seperated! Ending now! Please run it via: tToolsOptionsTest"
        goto endsub
    endif
   if gApplication <> "DESKTOP" then Call hNewDocument
 '///- tools / options / spreadsheet
   ToolsOptions
   ToPosInOptionlist ( 4 )
   EchteAnzahl = OptionTabPageZaehler ( 7, FALSE )
   for i=1 to EchteAnzahl
      gefunden = FALSE
      Kontext "OptionenDlg"
      Optionsliste.TypeKeys "<Down>"
      select case i
       case 1 : Kontext "TabLayoutCalc"
                '///+-    general
                printlog "  - General / Allgemein"
                if TabLayoutCalc.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabLayoutCalc )
                end if
       case 2 : Kontext "TabInhaltCalc"
                '///+-    view
                printlog "  - View / Ansicht"
                if TabInhaltCalc.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabInhaltCalc )
                end if
       case 3 : Kontext "TabBerechnen"
                '///+-    calculate
                printlog "  - Calculate / Berechnen"
                if TabBerechnen.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabBerechnen )
                end if
       case 4 : Kontext "TabSortierlisten"
                '///+-    sort lists
                printlog "  - Sort Lists / Sortierliste"
                if TabSortierlisten.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabSortierlisten )
                end if
       case 5 : Kontext "TabAenderungenCalc"
                '///+-    changes
                printlog "  - Changes / Aenderungen"
                if TabAenderungenCalc.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabAenderungenCalc )
                end if
       case 6 : Kontext "TabRaster"
                '///+-    grid
                printlog "  - Grid / Raster"
                if TabRaster.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabRaster )
                end if
       case 7 : Kontext "TabPrintCalcOptions"
                '///+-    print
                printlog "  - Print / Drucken"
                if TabPrintCalcOptions.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabPrintCalcOptions )
                end if
      end select
      if gefunden=FALSE then
         Warnlog "Error with the " + i + ".page, perhaps this page is deleted or change the place!"
         EchteAnzahl = EchteAnzahl - 1
         if EchteAnzahl < 7 then
            i=11
         else
            i=1-1
         end if
      end if
   next i
'///+- close the options dialog
   Kontext "OptionenDlg"
   OptionenDlg.Cancel

   if gApplication <> "DESKTOP" then Call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase tToolsOptionsPresentation
  dim EchteAnzahl as Integer, i as Integer
  dim gefunden as Boolean
  dim iTemp as integer
    
   PrintLog "- Tools/Options/Presentation  ( Extras/Optionen/Praesentation )"
    if (0 = iSectionNumber) then 
        warnlog "You can't run this testcase seperated! Ending now! Please run it via: tToolsOptionsTest"
        goto endsub
    endif
   if gApplication <> "DESKTOP" then Call hNewDocument
   kontext "DocumentImpress"
   if DocumentImpress.exists(5) then
       printlog "  - An application of type Presentation is available."
   else
       qaErrorLog "  - No application of type Presentation is available"
   end if
 '///- tools / options / presentation
   ToolsOptions
   ToPosInOptionlist ( 4 )
   EchteAnzahl = OptionTabPageZaehler ( 4, FALSE )
   for i=1 to EchteAnzahl
      gefunden = FALSE
      Kontext "OptionenDlg"
      Optionsliste.TypeKeys "<Down>"
      select case i
       case 1 : Kontext "TabSonstigesDraw"
                '///+-    general
                printlog "  - General / Allgemein"
                if TabSonstigesDraw.exists then
                    if TabSonstigesDraw.IsVisible then
                       gefunden = TRUE
                       Call DialogTest ( TabSonstigesDraw )
                    end if
                else
                    ' Trying to get root cause on some systems it seems the backing window is used. #i48383#
                    Kontext "OptionenDlg"
                    OptionenDlg.SnapShot convertPath(gOfficePath + "user/work/"+gApplication+".bmp")
                    qaErrorLog "#i48383# Trying to get root cause for wrong window; check picture: " + convertPath(gOfficePath + "user/work/"+gApplication+".bmp")
                    for iTemp = 1 to Optionsliste.getItemCount
                        qaErrorLog "" + iTemp + ": '" + Optionsliste.getItemText(iTemp) + "'"
                    next iTemp
                end if
       case 2 : Kontext "TabInhalteDraw"
                '///+-    view
                printlog "  - View / Ansicht"
                if TabInhalteDraw.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabInhalteDraw )
                end if
       case 3 : Kontext "TabRaster"
                '///+-    grid
                printlog "  - Grid / Raster"
                if TabRaster.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabRaster )
                end if
       case 4 : Kontext "TabDruckenDraw"
                '///+-    print
                printlog "  - Print / Drucken"
                if TabDruckenDraw.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabDruckenDraw )
                end if
      end select
      if gefunden=FALSE then
         Warnlog "Error with the " + i + ".page, perhaps this page is deleted or change the place!"
         EchteAnzahl = EchteAnzahl - 1
         if EchteAnzahl < 4 then
            i=11
         else
            i=1-1
         end if
      end if
   next i
'///+- close the options dialog
   Kontext "OptionenDlg"
   OptionenDlg.Cancel

   if gApplication <> "DESKTOP" then Call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase tToolsOptionsDrawing
  dim EchteAnzahl as Integer, i as Integer
  dim gefunden as Boolean
    
   PrintLog "- Tools/Options/Drawing  ( Extras/Optionen/Zeichnung )"
    if (0 = iSectionNumber) then 
        warnlog "You can't run this testcase seperated! Ending now! Please run it via: tToolsOptionsTest"
        goto endsub
    endif
 '///- tools / options / drawing
   if gApplication <> "DESKTOP" then Call hNewDocument
   ToolsOptions
   ToPosInOptionlist ( 4 )
   EchteAnzahl = OptionTabPageZaehler ( 4, FALSE )
   for i=1 to EchteAnzahl
      gefunden = FALSE
      Kontext "OptionenDlg"
      Optionsliste.TypeKeys "<Down>"
      select case i
       case 1 : Kontext "TabSonstigesDraw"
                '///+-    general
                printlog "  - General / Allgemein"
                if TabSonstigesDraw.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabSonstigesDraw )
                end if
       case 2 : Kontext "TabInhalteDraw"
                '///+-    view
                printlog "  - View / Ansicht"
                if TabInhalteDraw.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabInhalteDraw )
                end if
       case 3 : Kontext "Active"
                if Active.Exists then
                   Warnlog "A messagebox exists => BUG  : " + Active.GetText
                   try
                      Active.No
                   catch
                      Active.OK
                   endcatch
                end if
                Kontext "TabRaster"
                '///+-    grid
                printlog "  - Grid / Raster"
                if TabRaster.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabRaster )
                end if
       case 4 : Kontext "TabDruckenDraw"
                '///+-    print
                printlog "  - Print / Drucken"
                if TabDruckenDraw.IsVisible then
                   gefunden = TRUE
                   Call DialogTest ( TabDruckenDraw )
                end if
      end select
      if gefunden=FALSE then
         Warnlog "Error with the " + i + ".page, perhaps this page is deleted or change the place!"
         EchteAnzahl = EchteAnzahl - 1
         if EchteAnzahl < 4 then
            i=11
         else
            i=1-1
         end if
      end if
   next i
'///+- close the options dialog
   Kontext "OptionenDlg"
   OptionenDlg.Cancel
   if gApplication <> "DESKTOP" then Call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase tToolsOptionsFormula
  dim EchteAnzahl as Integer, i as Integer
    
   PrintLog "- Tools/Options/Formula  ( Extras/Optionen/Formel )"
    if (0 = iSectionNumber) then 
        warnlog "You can't run this testcase seperated! Ending now! Please run it via: tToolsOptionsTest"
        goto endsub
    endif
 '///- tools / options / formula
   if gApplication <> "DESKTOP" then Call hNewDocument
   ToolsOptions
   ToPosInOptionlist ( 4 )
   EchteAnzahl = OptionTabPageZaehler ( 1, FALSE )
   Kontext "OptionenDlg"
   '///+-    print
   Optionsliste.TypeKeys "<Down>"
   printlog "  - Print / Drucken"
   Kontext "TabDruckenMath"
   Call DialogTest ( TabDruckenMath )
'///+- close the options dialog
   Kontext "OptionenDlg"
   OptionenDlg.Cancel
   if gApplication <> "DESKTOP" then Call hCloseDocument
endcase
'-------------------------------------------------------------------------
testcase tToolsOptionsChart
    dim EchteAnzahl as Integer, i as Integer

    PrintLog "- Tools/Options/Chart  ( Extras/Optionen/Diagramm )"
    if (0 = iSectionNumber) then 
        warnlog "You can't run this testcase seperated! Ending now! Please run it via: tToolsOptionsTest"
        goto endsub
    endif
    '///- tools / options / chart
    if gApplication <> "DESKTOP" then Call hNewDocument
    ToolsOptions
    ToPosInOptionlist ( iSectionNumber -1 )
    EchteAnzahl = OptionTabPageZaehler ( 1, FALSE )
    Kontext "OptionenDlg"
    Optionsliste.TypeKeys "<Down>"
    '///+-    default colors
    printlog "  - Default Colors / Grundfarben"
    Kontext "TabGrundfarben"
    Call DialogTest ( TabGrundfarben )
    '///+- close the options dialog
    Kontext "OptionenDlg"
    OptionenDlg.Cancel
    if gApplication <> "DESKTOP" then Call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase tToolsOptionsDataSources
   dim EchteAnzahl as Integer, i as Integer

   PrintLog "- Tools/Options/Data Sources  ( Extras/Optionen/Datenbank )"
    if (0 = iSectionNumber) then 
        warnlog "You can't run this testcase seperated! Ending now! Please run it via: tToolsOptionsTest"
        goto endsub
    endif
   '///- tools / options / Data source
   if gApplication <> "DESKTOP" then Call hNewDocument
   ToolsOptions
   ToPosInOptionlist ( iSectionNumber -2)
   EchteAnzahl = OptionTabPageZaehler ( 2 , FALSE )
   Kontext "OptionenDlg"
   Optionsliste.TypeKeys "<Down>"
   printlog "  - Connections / Verbindungen"
   Kontext "TabConnections"
   '///+-    connections
   Call DialogTest ( TabConnections )
   Kontext "OptionenDlg"
   Optionsliste.TypeKeys "<Down>"
   printlog "  - Databases / Datenbanken"   
   Kontext "TabRegisteredDatabase"
   '///+-    databases
   Call DialogTest ( TabRegisteredDatabase )
   NewBtn.click
   Kontext "CreateDatabaseLink"
   call DialogTest( CreateDatabaseLink )
   Browse.click
   Kontext "OeffnenDlg"
   OeffnenDlg.cancel
   Kontext "CreateDatabaseLink"
   CreateDatabaseLink.cancel
   Kontext "OptionenDlg"
   '///+- close the options dialog
   OptionenDlg.Cancel
   if gApplication <> "DESKTOP" then Call hCloseDocument
endcase

'-------------------------------------------------------------------------

