'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: export_graphic.inc,v $
'*
'*  $Revision: 1.20 $
'*
'*  last change: $Author: msc $ $Date: 2005/12/23 10:11:58 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : fredrik.haegg@sun.com
'*
'* short description : Graphics Export Test
'*
'************************************************************************
'*
' #1 tPBM   
' #1 tPGM   
' #1 tPPM   
' #1 tPNG   
' #1 tRAS   
' #1 tTIFF   
' #1 tXPM   
' #1 tRAS_SVG   
' #1 tSWF   
' #1 tSVG   
' #1 tPDF    
' #1 tPDF_Creator
'*
'\***********************************************************************************

sub sFileExport
   '/// just exporting is done in qatesttool/framework/first test: 'tGraphicExport' but there is no loading, ///'
   '///+ of the created files and the items on the dialogs are not checked completely ///'   
   Dim ExZaehler as Integer
   Dim ExPath as String
   Dim Liste( 50 ) as String

   '///- all files are saved in [StarOfficePath]/user/work/[applicatoion]/export ///'
   ExPath = ConvertPath (gOfficePath + "user\work\" + lCase(gApplication) + "\export\" )
   OutputGrafikTBO = ExPath & "expo"
   Printlog "Create the export-dir for the graphics ( " + ExPath + " )"
   try
      app.mkDir ( ExPath )
      ExZaehler = GetFileList ( ExPath , "*.*" , Liste() )
      if ExZaehler <> 0 then
         Printlog "The export-dir exists. The test want to delete all Files ( " + ExZaehler + " )!"
         if KillFileList ( Liste() ) = FALSE then
            Warnlog "Not all files can be deleted. " + ListCount ( Liste() ) + " files exists!"
         end if
      end if
   catch
      Warnlog "An error at creating the export-dir, the test ends!"
      exit sub
   endcatch

    '///+ open the test document qatesttool/graphics/level1/input/graphicexport.sx[d,i] ///'
  
    call tBMP   '///+-   Windows Bitmap                     ///'
    call tEMF   '///+-   Enhanced Metafile                  ///'
    call tEPS   '///+-   Encapsulated PostScript            ///'
    call tGIF   '///+-   Graphics Interchange Format        ///'
    call tJPEG  '///+-   Joint Photographic Experts Group   ///'
    call tMET   '///+-   OS/2 Metafile                      ///'
    call tPBM   '///+-   Portable Bitmap                    ///'
    call tPCT   '///+-   Mac Pict                           ///'
    call tPGM   '///+-   Portable Graymap                   ///'
    call tPNG   '///+-   Portable Network Graphic           ///'
    call tPPM   '///+-   Portable Pixelmap                  ///'
    call tRAS   '///+-   Sun Raster Image                   ///'
    call tSVM   '///+-   StarView Metafile                  ///'
    call tTIFF  '///+-   Tagged Image File Format           ///'
    call tWMF   '///+-   Windows Metafile                   ///'
    call tXPM   '///+-   X PixMap                           ///'
    call tPDF   '///+-   Portable Document Format           ///'
    call tPDF_Creator '///+-   test if the right creator is set in the PDF document
    call tSWF   '///+-   Macromedia Flash (SWF) (.swf)      ///'
    call tSVG   '///+-   Scalable Vector Graphics           ///'
      
end sub
'-------------------------------------------------------------------------
function hCallExport ( HyWhatsYourName as String , sFilter as String, optional bSelection as boolean ) as Boolean
   hCallExport = TRUE
   Printlog "Will try to select export filter: '" + sFilter + "'" + ""
   try
      FileExport
   catch
      Sleep 10
      Warnlog "It takes to much time to export the graphic (>10 sec.). Please check the problem, maybe it's a bug!"
      FileExport
   endcatch

   Kontext "ExportierenDlg"
   try
      Dateityp.Select sFilter
   catch
      Warnlog "'" + sFilter + "' is missing!"
      hCallExport = FALSE
      ExportierenDlg.Cancel
      exit function
   endcatch
   if ((IsMissing(bSelection) = FALSE) AND (bSelection = TRUE)) then
      Selektion.Check
   else
      if (Selektion.isEnabled) then
         Selektion.UnCheck
      endif
   endif
   AutomatischeDateinamenserweiterung.Check
   Dateiname.SetText ( HyWhatsYourName )
   sleep 2
   Speichern.Click
   sleep 2
   kontext "AlienWarning"
      if AlienWarning.exists(5) then
         warnlog "#i41983# Alien Warning on export not allowed"
         AlienWarning.OK
      endif
   Kontext "Active"
   if Active.Exists then Active.Yes
   Sleep 3
end function
'-------------------------------------------------------------------------
function fGetSizeXY (sX as string, sY as string, bGet as boolean) as Boolean
   dim sTx as string
   dim sTy as string
   dim bReturn as boolean

   bReturn = True
   try
      ContextPositionAndSize
   catch
      warnlog "couldn't call 'ContextPositionAndSize' no object selected ?"
   endcatch
   kontext
   active.SetPage TabPositionAndSize
   kontext "TabPositionAndSize"
   if TabPositionAndSize.exists (5) then
      sTx = Width.GetText
      sTy = Height.GetText
      TabPositionAndSize.OK
   else
      warnlog "Couldn't switch tab page :-( "
   endif
   if bGet then  ' Get the Values only
      sY = sTy
      sX = sTx
   else          ' Get the Values and COMPARE them
      if (LiberalMeasurement (sX,sTx) <> TRUE) then
         warnlog "width is different :-( should: '"+sX+"' is: '"+sTx+"'" + "eventually a result of i35519"
         bReturn = False
      endif
      if (LiberalMeasurement (sY,sTy) <> TRUE) then
         warnlog "hight is different :-( should: '"+sY+"' is: '"+sTy+"'" + "eventually a result of i35519"
         bReturn = False
      endif
      bGet = bReturn
   endif
end function
'-------------------------------------------------------------------------
testcase tPBM
   dim x,i as integer
   dim sFilter as string
   dim sExt as string

   sFilter = "PBM - Portable Bitmap (.pbm)"
   sExt = ".pbm"
   
   '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) ))

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "PBMOptionen"
      if PBMOptionen.Exists (2) then
            Ascii.Check
         PBMOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tPGM
   dim x,i as integer
   dim sFilter as string
   dim sExt as string

   sFilter = "PGM - Portable Graymap (.pgm)"
   sExt = ".pgm"

   '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) ))

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "PGMOptionen"
      if PGMOptionen.Exists (2) then
            Ascii.Check
         PGMOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif
   
   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tPPM
   dim x,i as integer
   dim sFilter as string
   dim sExt as string

   sFilter = "PPM - Portable Pixelmap (.ppm)"
   sExt = ".ppm"
   
   '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) ))

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "PPMOptionen"
      if PPMOptionen.Exists (2) then
            Ascii.Check
         PPMOptionen.OK
         sleep 5
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tPNG
   dim x,i as integer
   dim sFilter as string
   dim sExt as string

   sFilter = "PNG - Portable Network Graphic (.png)"
   sExt = ".png"
   
   '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) ))

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      Kontext "PNGOptionen"
      if PNGOptionen.Exists (2) then
            Kompression.ToMax
            Interlaced.UnCheck
         PNGOptionen.OK
         sleep 30
      endif
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
      else
         warnlog "File didn't get saved :-("
      endif
      hCloseDocument ()
      sleep 5
      hNewDocument()
      sleep 5
      Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tRAS
   tRAS_SVG ("RAS - Sun Raster Image (.ras)", ".ras")
endcase
'-------------------------------------------------------------------------
testcase tTIFF
   tRAS_SVG ("TIFF - Tagged Image File Format (.tif;.tiff)", ".tif")
endcase
'-------------------------------------------------------------------------
testcase tXPM
   tRAS_SVG ("XPM - X PixMap (.xpm)", ".xpm")
endcase
'-------------------------------------------------------------------------
testcase tRAS_SVG (sFilter as string, sExt as string)
   dim x,i as integer
   
   '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) ))

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
         hCloseDocument ()
         sleep 5
         hNewDocument()
         sleep 5
         Call hGrafikEinfuegen ( OutputGrafikTBO+sExt )
      else
         warnlog "File didn't get saved :-("
      endif
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tSWF
   dim sFilter as string
   dim sExt as string
   dim x,i as integer

   sFilter = "Macromedia Flash (SWF) (.swf)"
   sExt = ".swf"
   
   '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) ))

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
         sleep 5
      else
         warnlog "File didn't get saved :-("
      endif
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tSVG
   dim x,i as integer
   dim sFilter as string
   dim sExt as string
   dim bTemp as boolean
   dim sTemp as string
   dim sTextFilter as string
   dim sExtension() as string
   dim sTextFiltername as string

   sFilter = "SVG - Scalable Vector Graphics (.svg)"
   sExt = ".svg"
   
   '/// open the document
   hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport.sx"+left(lcase(gApplication),1) ))

   '/// save it ///'
   if hCallExport (OutputGrafikTBO , sFilter ) = TRUE then
      if ( dir(OutputGrafikTBO+sExt) <> "") then
         Printlog "Ok :-) Saved as: '" + OutputGrafikTBO+sExt + "'"
         if (iSprache <> 82) then
             hCloseDocument ()
             sleep 5
             '/// load file in writer as text ///'
             sTextFilter = hGetUIFiltername("Text")
             sExtension() = hGetFilternameExtension("writer_Text")
             sTextFiltername = sTextFilter & " (*." & sExtension(0) & ")"
             hDateiOeffnenMitFilter (OutputGrafikTBO+sExt, sTextFiltername, FALSE, TRUE)
             sTemp = gApplication
             gApplication = "writer"
             sleep 5 ' wait for document to be loaded
             bTemp = hFindeImDokument ("<!DOCTYPE svg PUBLIC "+chr(34)+ "-//W3C//DTD SVG 1.1//EN"+chr(34)+" "+chr(34)+"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"+chr(34)+">")
             if (bTemp = TRUE) then
                Printlog "OK"
             else
                warnlog "DOCTYPE not found in svg file :-("
             endif
             gApplication = sTemp
         else
             qaerrorlog "disabled for 82: #111017#"
         endif
      else
         warnlog "File didn't get saved :-("
      endif
   endif

   call hCloseDocument

endcase
'-------------------------------------------------------------------------
testcase tPDF
    dim sPath as string    
    dim sTemp as string    
    dim iFileSize(12) as long
    dim i as integer
    

    '/// Export the file 12 times: ///'
    '///+ every compression level (3) and every range (3), check if button in toolbar uses last settings (6) (-> 12) ///'

    hDateiOeffnen (ConvertPath ( gTesttoolPath + "graphics\level1\input\graphicexport_pdf.sx"+left(lcase(gApplication),1)))
    sleep (10)

    '###### all / Screen optimized ######     
    
    '/// File->Export as PDF document
    printlog "File->Export as PDF document"    
    '///+ range = All
    printlog " range = All"
    '///+ compression = Screen optimized
    printlog " compression = Screen optimized"
    hExportAsPDFmulti (3, TRUE, OutputGrafikTBO + 1, TRUE, FALSE, 1, 1)
    sleep(3)
    
    '/// Export using Button in toolbar
    printlog "Export using Button in toolbar"
    '///+ use the settings from the export before
    printlog " use the settings from the export before"
    hExportAsPDFmulti (1, TRUE, OutputGrafikTBO + 2, TRUE, FALSE, 1, 1) ' buton in toolbar -> last settings have to be used
    sleep(3)

    '###### range / Screen optimized ######     

    '/// File->Export as PDF document
    printlog "File->Export as PDF document"
    '///+ range = Range
    printlog " range = Range"
    '///+ compression = Screen optimized
    printlog " compression = Screen optimized"    
    hExportAsPDFmulti (3, TRUE, OutputGrafikTBO + 3, TRUE, FALSE, 2, 1, "2")
    sleep(3)
    
    '/// Export using Button in toolbar 
    printlog "Export using Button in toolbar"
    '///+ use the settings from the export before
    printlog " use the settings from the export before"    
    hExportAsPDFmulti (1, TRUE, OutputGrafikTBO + 4, TRUE, FALSE, 2, 1) ' buton in toolbar -> last settings have to be used
    sleep(3)

    '###### all / Print optimized ######    

    '/// File->Export as PDF document
    printlog "File->Export as PDF document"
    '///+ range = all
    printlog " range = all"
    '///+ compression = Print optimized
    printlog " compression = Print optimized"    
    hExportAsPDFmulti (3, TRUE, OutputGrafikTBO + 5, TRUE, FALSE, 1, 2)
    sleep(3)
    
    '/// Export using Button in toolbar
    printlog "Export using Button in toolbar"
    '///+ use the settings from the export before
    printlog " use the settings from the export before"
    hExportAsPDFmulti (1, TRUE, OutputGrafikTBO + 6, TRUE, FALSE, 1, 2) ' buton in toolbar -> last settings have to be used
    sleep(3)

    '###### range / Print optimized ######    

    '/// File->Export as PDF document
    printlog "File->Export as PDF document"
    '///+ range = Range
    printlog " range = Range"
    '///+ compression = Screen optimized
    printlog " compression = Screen optimized"    
    hExportAsPDFmulti (3, TRUE, OutputGrafikTBO + 7, TRUE, FALSE, 2, 2, "2")
    sleep(3)
    
    '/// Export using Button in toolbar
    printlog "Export using Button in toolbar"
    '///+ use the settings from the export before
    printlog " use the settings from the export before"    
    hExportAsPDFmulti (1, TRUE, OutputGrafikTBO + 8, TRUE, FALSE, 2, 2) ' buton in toolbar -> last settings have to be used
    sleep(3)

    '###### all / Press optimized ######

    '/// File->Export as PDF document ///'
    printlog "File->Export as PDF document ///'"
    '///+ range = all
    printlog " range = all"
    '///+ compression = Press optimized
    printlog " compression = Press optimized"    
    hExportAsPDFmulti (3, TRUE, OutputGrafikTBO + 9, TRUE, FALSE, 1, 3)
    sleep(3)
    
    '/// Export using Button in toolbar
    '///+ use the settings from the export before
    hExportAsPDFmulti (1, TRUE, OutputGrafikTBO + 10, TRUE, FALSE, 1, 3) ' buton in toolbar -> last settings have to be used
    sleep(3)

    '###### range / Press optimized ######

    '/// File->Export as PDF document ///'
    printlog "File->Export as PDF document ///'"
    '///+ range = all
    printlog " range = all"
    '///+ compression = Press optimized
    printlog " compression = Press optimized"    
    hExportAsPDFmulti (3, TRUE, OutputGrafikTBO + 11, TRUE, FALSE, 2, 3, "2")
    sleep(3)
    
    '/// Export using Button in toolbar
    '///+ use the settings from the export before
    hExportAsPDFmulti (1, TRUE, OutputGrafikTBO + 12, TRUE, FALSE, 2, 3) ' buton in toolbar -> last settings have to be used
    sleep(3)

    for i=1 to 12
        sPath = OutputGrafikTBO
        sPath = sPath + i + ".pdf"
        iFileSize(i) = app.FileLen(sPath)
        Printlog (" - " + i + ": " + " " + iFileSize(i) + " " + sPath
        if (dir(sPath) <> "") then
            sleep(1)
            '/// the first line has to be '%PDF-1.4' ///'
            sTemp = fGetFileText(sPath, 8)
            if (sTemp <> "%PDF-1.4") then
                Warnlog "File doesn't start with '%PDF-1.4' it is: '" + sTemp + "'"
            endif
            '/// the last line has to be '%%EOF' ///'
            sTemp = left(fGetFileText(sPath, -7),5)
            if (sTemp <> "%%EOF") then
                Warnlog "File doesn't end with '%%EOF' it is: '" + sTemp + "'"
            endif
        else
            Warnlog "File was not exported to PDF :-( '" + sPath + "'"
        endif
    next i

    
    ' Check if the file size is the same when exporting via toolbar and file/export
    ' if the size different then the options are not used when exporting via the toolbar
    if (iFileSize(1) <> iFileSize(2)) then
        Warnlog ("Diffrence in filesize for file 1 and 2")
    endif
    ' print optimized
    if (iFileSize(5) <> iFileSize(6)) then
        Warnlog ("Diffrence in filesize for file 5 and 6")
    endif
    ' press optimized
    if (iFileSize(9) <> iFileSize(10)) then
        Warnlog ("Diffrence in filesize for file 9 and 10")
    endif
    

    if (iFileSize(1) > iFileSize(5)) then
        Warnlog ("Filesize for file 1 is greater then for file 5. The compression level doesn't work.")
    endif
    if (iFileSize(5) > iFileSize(9)) then
        Warnlog ("Filesize for file 5 is greater then for file 9. The compression level doesn't work.")
    endif    

    hCloseDocument()

endcase
'-------------------------------------------------------------------------
testcase tPDF_Creator
    dim sPath as String
    dim sApp as String
    dim sTemp as String
    dim bTemp as String
    dim sTemp2 as String
    dim iFileSize(3) as long
    dim iCreatorOffset as integer
    dim i as integer
    dim sTextFilter as String
    dim sTextFiltername as String
    dim sExtension() as String

    sTemp = ConvertPath ( gTesttoolPath + "graphics\level1\input\export_graphic3.sx"+left(lcase(gApplication),1))
    hDateiOeffnen (sTemp)
    sleep (30)
    sPath = OutputGrafikTBO
    sTemp = sPath
    sPath = sPath + "L.pdf"
    hExportAsPDFmulti (1, TRUE, sPath, TRUE, FALSE, 1, 1)
    name sPath as sTemp+"L.txt"
    sleep (30)
    iFileSize(3) = app.FileLen(sTemp+"L.txt")
    iCreatorOffset = 0
    sleep 5
    '/// load file in writer as text ///'
        
    hDateiOeffnen(sTemp+"L.txt")

    '/// if dialog 'AsciiFilterOptionen' comes up, say OK ///'
    Kontext "AsciiFilterOptionen"
    If AsciiFilterOptionen.Exists(3) then        
        AsciiFilterOptionen.OK     
    endif

    Kontext "Filterauswahl"
    If Filterauswahl.Exists then        
        Filter.Select ( hGetUIFiltername("Text" ))
        Filterauswahl.OK
    End If

    sApp = gApplication
    gApplication = "writer"
    sleep 5 ' wait for document to be loaded
    ' /Creator
    bTemp = hFindeImDokument ("<< /Creator <")
    if (bTemp = TRUE) then
        Printlog "OK"
    else
        warnlog " /Creator not found in pdf file :-("
    endif
    hTypeKeys("<left><right><shift end>")
    editcopy
    sTemp = getClipboardText()
    sTemp = left(sTemp, inStr(sTemp, ">")-1)
    sTemp2 = ""
    for i = 0 to (len(sTemp)/4)-1
        sTemp2 = sTemp2 + chr("&H"+mid(sTemp,(i*4)+1, 4))
    next i
    printlog sTemp + " -- " + len(sTemp) + " ::: '" + sTemp2 + "'"
    if (lCase(sapp) <> lCase(right(sTemp2, len(stemp2)-1))) then
        warnlog "Application is different from Creator; is: '" + lCase(sTemp2) + "' should: '" + lCase(sapp) + "'"
    endif
    iCreatorOffset = iCreatorOffset + len(sTemp)
    ' /Producer
    bTemp = hFindeImDokument ("/Producer <")
    if (bTemp = TRUE) then
        Printlog "OK"
    else
        warnlog " /Producer not found in pdf file :-("
    endif
    hTypeKeys("<left><right><shift end><shift down>")
    editcopy
    sTemp = getClipboardText()
    sTemp = left(sTemp, inStr(sTemp, ">")-1)
    sTemp2 = ""
    for i = 0 to (len(sTemp)/4)-1
        sTemp2 = sTemp2 + chr("&H"+mid(sTemp,(i*4)+1, 4))
    next i
    printlog sTemp + " -- " + len(sTemp) + " ::: '" + sTemp2 + "'"
    if gOOO then
        iCreatorOffset = iCreatorOffset + len(sTemp)
    else
        if bAsianLan then
            iCreatorOffset = iCreatorOffset + 48
            if (len(sTemp) <> 48) then
                warnlog "Producer is different from 'StarSuite 8'; is: '" + sTemp2 + "'"
            endif
        else
            iCreatorOffset = iCreatorOffset + 52
            if (len(sTemp) <> 52) then
                warnlog "Producer is different from 'StarOffice 8'; is: '" + sTemp2 + "'"
            endif
        endif
    endif
    ' /CreationDate (
    bTemp = hFindeImDokument ("/CreationDate (")
    if (bTemp = TRUE) then
        Printlog "OK"
    else
        warnlog " /CreationDate not found in pdf file :-("
    endif
    hTypeKeys("<left><right><shift end>")
    editcopy
    sTemp = getClipboardText()
    sTemp = left(sTemp, inStr(sTemp, ")")-1)
    printlog sTemp + " -- " + len(sTemp)
    iCreatorOffset = iCreatorOffset + (len(sTemp) - 23)
    if (len(sTemp) <> 23) then
        warnlog "Date is longer than expected; is: '" + sTemp2 + "'"
    endif
    gApplication = sApp    

    call hCloseDocument
    
    call hCloseDocument

endcase
'-------------------------------------------------------------------------
