'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: g_ole.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2006/01/18 12:19:26 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* Owner : fredrik.haegg@sun.com
'*
'* short description: includefile for Ole-testing
'*
'**************************************************************************************
' #1 tOLE_Copy
' #1 tOLE_SaveLoad
'\*************************************************************************************

testcase tOLE_Copy
   '/// Test to see if three different OLEs can be copied and identified correctly. ///'

   dim writerfilename1 as string
   writerfilename1 = ConvertPath (gTesttoolPath + "graphics\level1\input\oletest.odg")

   '/// Open draw-file ///'
   FileOpen
   Kontext "OeffnenDlg"
   sleep 1
   Dateiname.SetText (writerfilename1)
   Oeffnen.Click
   Sleep 3

   '/// When messagebox about "Update all links" shows up - press yes. ///'
   kontext "Messagebox"
   if Messagebox.exists then
      Messagebox.Yes
   endif

   sleep 3
   gApplication = "DRAW"
   '/// Select first object. Use EditCopy to copy it to the clipboard ///'
   sleep 1
   kontext "DocumentDraw"
   DocumentDraw.mousedown (10,10)
   DocumentDraw.mouseup (10,10)
   sleep 1
   DocumentDraw.Typekeys "<TAB>"
   EditCopy

   '/// Close document. Open new Impress-Document. Paste the OLE-Object. ///'
   Call hCloseDocument
   gApplication = "Impress"
   Call hNewDocument
   EditPaste

   '/// Select object and check via the Context-menu what it has been opened as. ///'
   sleep 1
   Kontext "DocumentImpress"
   hTypekeys "<MOD1> A"
   hTypekeys "<RETURN>"
   hOpenContextMenu

   '/// Count the number of entries. If 5 (including a menuseparator), then its a spreadsheet ///'
    if MenuGetItemCount <> 5 then
       Warnlog "This doesn't seem to be recognized as a Metafile. It has " + MenuGetItemCount + " entries."
    end if

   '/// Close Context menu. Then check if a Edit-line for the Cells is visible. ///'
   sleep 3
   MenuSelect (1)  'Default

   Kontext "RechenleisteCalc"
   if RechenleisteCalc.Exists then
      Printlog "This is a spreadsheet-Document. Good"
   endif

   Kontext "DocumentImpress"
   '/// Click outside the OLE to deactivate it. Then close the Document ///'
   DocumentImpress.mousedown (10,10)
   DocumentImpress.mouseup (10,10)
   sleep 3
   Call hCloseDocument

   '/// Open Draw-file ///'
   FileOpen
   Kontext "OeffnenDlg"
   sleep 1
   Dateiname.SetText (writerfilename1)
   Oeffnen.Click
   Sleep 3

   '/// When messagebox about "Update all links" shows up - press yes. ///'
   kontext "Messagebox"
   if Messagebox.exists then
      Messagebox.Yes
   endif
   sleep 3

   '/// Select second object. Use EditCopy to copy it to the clipboard ///'
   gApplication = "DRAW"
   sleep 1
   kontext "DocumentDraw"
   DocumentDraw.mousedown (10,10)
   DocumentDraw.mouseup (10,10)
   sleep 1
   DocumentDraw.Typekeys "<TAB><TAB>"
   EditCopy

   '/// Close document. Open new Impress-Document. Paste the OLE-Object. ///'
   sleep 1
   DocumentDraw.mousedown (10,10)
   DocumentDraw.mouseup (10,10)
   sleep 1
   Call hCloseDocument

   gApplication = "Impress"
   Call hNewDocument
   EditPaste

   '/// Select the object, and check via the Context-menu what it has been opened as. ///'
   sleep 1
   Kontext "DocumentImpress"
   hTypekeys "<MOD1> A"
   hTypekeys "<RETURN>"
   hOpenContextMenu

   '/// Count the number of entries. If 5 (including a menuseparator), then its a spreadsheet ///'
    if MenuGetItemCount <> 5 then
       Warnlog "This doesn't seem to be recognized as a Metafile. It has " + MenuGetItemCount + " entries."
    end if

   '/// Close Context menu. Then check if a Edit-line for the Cells is visible. ///'
   sleep 3
   MenuSelect (1)  'Default

   Kontext "RechenleisteCalc"
   if RechenleisteCalc.Exists then
      Printlog "This is a spreadsheet-Document. Good"
   endif

   kontext "DocumentImpress"
   sleep 1
   DocumentImpress.mousedown (10,10)
   DocumentImpress.mouseup (10,10)
   sleep 1

   '/// Close document ///'
   Call hCloseDocument

   '/// Open draw-file ///'
   FileOpen
   Kontext "OeffnenDlg"
   sleep 1
   Dateiname.SetText (writerfilename1)
   Oeffnen.Click
   Sleep 3
   kontext "Messagebox"
   '/// When messagebox about "Update all links" shows up - press yes. ///'
   if Messagebox.exists then
      Messagebox.Yes
   endif
   sleep 3

   '/// Select third object. Use EditCopy to copy it to the clipboard ///'
   gApplication = "DRAW"
   sleep 1
   kontext "DocumentDraw"
   DocumentDraw.mousedown (10,10)
   DocumentDraw.mouseup (10,10)
   sleep 1
   DocumentDraw.Typekeys "<TAB><TAB><TAB>"
   EditCopy

   '/// Close the Document. Open new Impress-Document. Paste the OLE-Object. ///'
   sleep 1
   DocumentDraw.mousedown (10,10)
   DocumentDraw.mouseup (10,10)
   sleep 1
   Call hCloseDocument

   gApplication = "Impress"
   Call hNewDocument
   EditPaste

   '/// Select the object, and check via the Context-menu what it has been opened as. ///'
   Kontext "DocumentImpress"
   hTypekeys "<MOD1> A"
   hTypekeys "<RETURN>"
   hOpenContextMenu

   '/// Count the number of entries. If 5 (including a menuseparator), then its a spreadsheet ///'
    if MenuGetItemCount <> 5 then
       Warnlog "This doesn't seem to be recognized as a Metafile. It has " + MenuGetItemCount + " entries."
    end if

   '/// Close Context menu. Then check if a Edit-line for the Cells is visible. ///'
   sleep 3
   MenuSelect (1)  'Default

   Kontext "RechenleisteCalc"
   if RechenleisteCalc.Exists then
      Printlog "This is a spreadsheet-Document. Good"
   endif

   '/// Close Context menu. Then close the Document ///'
   Call hCloseDocument
endcase 'tOLE_Copy

'-----------------------------------------------------------------------------------------------------------'

testcase tOLE_SaveLoad
   '/// test to see if an OLE can be saved and loaded correctly. ///'
   dim filename as string
   dim filetype as string
   dim filetype2 as string

   filename = ConvertPath (gOfficePath + "user\work\oletest.odp")
   '/// Create OLE, save file, open file. ///'
   Call hNewdocument
   '/// Insert->Object->OLE Object... ///'
   InsertObjectOLEObject
   Kontext "OLEObjektInsert"

   '/// Choose "create new". Select "Spreadsheet". ///'
   Objekttyp.Select 1

   OLEObjektInsert.OK

   '/// Deselect object. Select object. Check the perferences for it. Save document. ///'
   sleep 1
   kontext "DocumentImpress"
   DocumentImpress.mousedown (10,10)
   DocumentImpress.mouseup (10,10)
   sleep 1
   hTypekeys "<MOD1 A>"
   hOpenContextMenu
   '/// Count number of entries. If 18 (including menuseparators), then its a metafile ///'
   if MenuGetItemCount <> 18 then
      Warnlog "This doesnt seem to be a spreadsheet-OLE. It has " + MenuGetItemCount + " entries."
   end if

   hMenuSelectNr(2)
   FileSaveAs
   sleep 1
   Kontext "SpeichernDlg"
   Dateiname.Settext (filename)
   Speichern.Click

   '/// If the file already exists - press yes to overwrite it. ///'
   Sleep 3
   kontext "Messagebox"
   if Messagebox.exists then
      Messagebox.Yes
   endif
   Sleep 3

   hTypekeys "<MOD1 A>"
   hOpenContextMenu
   hMenuSelectNr(0)
   Kontext "SpeichernDlg"
   filetype = Dateityp.GetSelText
   SpeichernDlg.Cancel

   '/// Close Document. Open saved file. Check if it has the same perferences. ///'
   Call hCloseDocument
   Call hNewdocument

   Kontext "DocumentImpress"
   Call hDateiOeffnen filename
   sleep 1
   hTypekeys "<MOD1 A>"
   hOpenContextMenu
   hMenuSelectNr(0)
   Kontext "SpeichernDlg"
   filetype2 = Dateityp.GetSelText
   SpeichernDlg.Cancel
   Printlog "The OLE created was a: " + filetype + " and the one which was loaded was a: " + filetype2
   if ((left(right(filetype,4),3))) <> ((left(right(filetype2,4),3))) then
      warnlog "The first was a: " + ((left(right(filetype,4),3))) + " and second was a: " + ((left(right(filetype2,4),3)))
   else
      printlog "Good: the first one was a: " + ((left(right(filetype,4),3))) + "-file, and second one was a: " + ((left(right(filetype2,4),3))) + "-file."
   endif

   Call hCloseDocument
endcase ' tOLE_Save

'FHA TODO
'testcase tOLE_DragDrop
   '/// Create OLE, drag n drop within the document. ///'
   '/// If Impress, drag and drop from document to another slide. ///'
'endcase 'tOLE_DragDrop
