'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_drawing_tools1.inc,v $
'*
'*  $Revision: 1.12 $
'*
'*  last change: $Author: jsi $ $Date: 2006/01/18 14:40:21 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Test of the drawing tools
'*
'************************************************************************
'*
' #1 tCreateObjects_1
' #1 tPositionAndSize_1
' #1 tPositionAndSize_2
' #1 tPositionAndSize_3
' #1 tPositionAndSize_4
' #1 tPositionAndSize_5
' #1 tPositionAndSize_6
' #1 tPositionAndSize_7
' #1 tPositionAndSize_8
' #1 tPositionAndSize_9
' #1 tPositionAndSize_10
' #1 tEditPoint_1
' #1 tLine_1
' #1 tLine_2
' #1 tLine_3
' #1 tLine_4
' #1 tLine_5
' #1 tLine_6
'*
'\***********************************************************************

sub w_drawing_tools_1

    printLog Chr(13) + "- Test of the drawing tools 1"

      printLog Chr(13) + " -- Format/Position And Size"

       Call tCreateObjects_1            'Create objects from the drawing functions of the Toolbar

      'Dialog format/Position and size
      'Tools/Options / TextDocument / Grid
      'Set Subdivision 1 point
      '    Resolution  1.00cm
       ToolsOptions
       Call hToolsOptions("TEXTDOCUMENT","GRID")
         RasterUnterteilungXAchse.SetText "1"
         Sleep 1
         RasterAufloesungXAchse.SetText   "1"
         Sleep 1
         RasterUnterteilungYAchse.SetText "1"
         Sleep 1
         RasterAufloesungYAchse.SetText   "1"
         Sleep 1
       Kontext "ExtrasOptionenDlg"
       ExtrasOptionenDlg.OK

       Call tPositionAndSize_1          'check checkbox "protect position" of the object
       Call tPositionAndSize_2          'check Undo/Redo function of position assignment
       Call tPositionAndSize_3          'check "keep ratio" option
       Call tPositionAndSize_4          'check Undo/Redo function of size assignment
       Call tPositionAndSize_5          'check rotation angle of an object
       Call tPositionAndSize_6          'check corner radius of rectangles
       Call tPositionAndSize_7          'check corner radius of textboxes
     ' Call tPositionAndSize_8          'check base points of position  --> due to position is removed , these 2 cases aren't needed to test
     ' Call tPositionAndSize_9          'check base points of size
       Call tPositionAndSize_10         'check pivot points of rotation

   printLog Chr(13) + " -- Edit Points Mode"
'      Call tEditPoint_1                 'Edit Points

   printLog Chr(13) + " -- Format/line"
      'Dialog format/line/line
       Call tLine_1                     'check style, color, width and arrow styles . Test undo and redo .
       Call tLine_2                     'Check call Format.Line dialog via Button in object bar
       Call tLine_3                     'check line attributes are applied in object bar
       Call tLine_4                     'check  "synchronize ends"
      'Dialog format/line/line styles
       Call tline_5                     'check the attributes in format/line/line styles
      'Dialog format/line/arrow styles
       Call tline_6                     'check the attributes in format/line/arrow styles

end sub

'-------------------------------------------------------------------------

testcase tCreateObjects_1

  printLog "Create objects from the drawing functions of the Toolbar "
  '/// Create objects from the drawing functions of the Toolbar , include ...

   Call hNewDocument

   Call hToolbarSelect("DRAWING", true)

  '/// Draw a line
   Kontext "Drawbar"
   Linie.Click
   gMouseMove(20,20,25,25)
   gMouseClick (75,5)
   Sleep 1

  '/// Draw a rectangle
   Kontext "Drawbar"
   Rechteck.Click
   gMouseMove(30,20,40,40)
   gMouseClick (75,5)
   Sleep 1

  '/// Draw a ellipse (circle)
   Kontext "Drawbar"
   Ellipse.Click
   Call gMouseMove(50,20,75,40)
   gMouseClick (75,5)
   Sleep 1

  '/// Draw a arc
   Kontext "Drawbar"
   Kreisbogen.Click
   gMouseMove(20,40,50,60)
   gMouseClick (20,40)
   gMouseClick (50,60)
   gMouseClick (75,5)
   Sleep 1

  '/// Circle segment
   Kontext "Drawbar"
   Kreissegment.Click
   gMouseMove(50,40,75,60)
   gMouseClick (50,40)
   gMouseClick (70,40)
   gMouseClick (75,5)
   Sleep 1

  '/// Draw a ellipse pie
   Kontext "Drawbar"
   Kreissektor.Click
   Call gMouseMove(20,60,40,75)
   gMouseClick (20,60)
   gMouseClick (35,60)
   gMouseClick (75,5)
   Sleep 1

  '/// Draw textobject
   Kontext "Drawbar"
   Textobjekt.Click
   gMouseMove(40,60,60,75)
   Sleep 1
   Kontext "DocumentWriter"
   Call wDokSchreiben "This is StarOffice Test !"
   gMouseClick (75,5)

  '/// Draw callouts
   Kontext "Drawbar"
   Legende.Click
   gMouseMove(20,80,50,95)
   gMouseClick (75,5)
   Sleep 1

  '/// Draw polygon
   Kontext "Drawbar"
   Polygon.Click
   Kontext "DocumentWriter"
   gMouseDown (50,80)
   gMouseClick (40,100)
   gMouseClick (70,90)
   gMouseClick (50,80)
   gMouseDoubleClick (40,100)
   gMouseClick (75,5)
   Sleep 1

  '/// Draw curve
   Kontext "Drawbar"
   Bezier.Click
   Kontext "DocumentWriter"
   gMouseDown  (70,80)
   gMouseMove2 (80,110)
   gMouseUp (50,70)
   Sleep 1
   gMouseMove2 (100,82)
   gMouseDown  (100,82)
   gMouseDoubleClick (100,82)
   Sleep 1

   Kontext "Drawbar"
   Drawbar.Close

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tPositionAndSize_1

  Dim sPositionX     , sPositionY     as String
  Dim sPositionXMove , sPositionYMove as String

  sPositionX      = "3" + gSeperator + "00" + gMeasurementUnit
  sPositionY      = "3" + gSeperator + "00" + gMeasurementUnit
  sPositionXMove  = "5" + gSeperator + "00" + gMeasurementUnit
  sPositionYMove  = "5" + gSeperator + "00" + gMeasurementUnit

  printLog "Check the checkbox 'protect position' of the object "
  '/// Check the checkbox 'protect position' of the object

   Call hNewDocument

   '/// Insert a drawing object (rectangle)
    Call wZeichenobjektEinfuegen("RECHTECK", 30, 40, 60, 60)
    Call gMouseClick(40,50)

    printLog "when 'protect position' is Checked"
   '/// Format/Position and size /Position and size ,
   '/// + set positionX and positionY , and Check 'postion' in protect area
   '/// + close the dialogue  and reopen it
   '/// check wether the rectangle can be removed when 'protect position' is Checked
    fPositionAndSize("TabPositionAndSizeWriter")

     Horizontalby.Settext "3"
     Verticalby.Settext "3"
     ProtectPosition.Check

    TabPositionAndSizeWriter.OK
    Sleep 1

    Kontext "DocumentWriter"
    Call wDokSchreiben "<Right>",2
    Call wDokSchreiben "<Down>" ,2
    Sleep 1

    fPositionAndSize("TabPositionAndSizeWriter")

      if Horizontalby.Gettext <> sPositionX then Warnlog "X-Position is wrong: Not -> "+sPositionX+"  but -> "+Horizontalby.Gettext
      if Verticalby.Gettext <> sPositionY then Warnlog "Y-Position is wrong: Not -> "+sPositionY+"  but -> "+Verticalby.Gettext

      ProtectPosition.UnCheck
    TabPositionAndSizeWriter.OK

    printLog "when 'protect position' is UnChecked"
   '/// check wether the rectangle can be removed when 'protect position' is UnChecked
    Kontext "DocumentWriter"
    Call wDokSchreiben "<Right>",2
    Call wDokSchreiben "<Down>" ,2
    Sleep 1

    fPositionAndSize("TabPositionAndSizeWriter")

      if Horizontalby.Gettext <> sPositionXMove then Warnlog "X-Position is wrong: Not -> "+sPositionXMove+"  but -> "+Horizontalby.Gettext
      if Verticalby.Gettext <> sPositionYMove then Warnlog "Y-Position is wrong: Not -> "+sPositionYMove+"  but -> "+Verticalby.Gettext

    TabPositionAndSizeWriter.OK

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tPositionAndSize_2

  Dim sPositionX     , sPositionY     as String
  Dim sPositionXMove , sPositionYMove as String

  sPositionX      = "3" + gSeperator + "00" + gMeasurementUnit
  sPositionY      = "3" + gSeperator + "00" + gMeasurementUnit
  sPositionXMove  = "4" + gSeperator + "00" + gMeasurementUnit
  sPositionYMove  = "4" + gSeperator + "00" + gMeasurementUnit

  printLog "check Undo/Redo function of position assignment "
  '/// check Undo/Redo function of position assignment

   Call hNewDocument

   '/// Insert a drawing object (rectangle)
    Call wZeichenobjektEinfuegen("RECHTECK", 30, 40, 60, 60)
    Call gMouseClick(40,50)

    fPositionAndSize("TabPositionAndSizeWriter")
     Horizontalby.Settext "3"
     Verticalby.Settext "3"
    TabPositionAndSizeWriter.OK
    Sleep 1

    Kontext "DocumentWriter"
    Call wDokSchreiben "<Right>"
    Call wDokSchreiben "<Down>"
    Sleep 1

    printLog "check undo function"
   '/// check undo function
    EditUndo
    Sleep 1
    EditUndo
    Sleep 1

    fPositionAndSize("TabPositionAndSizeWriter")
      if Horizontalby.Gettext <> sPositionX then Warnlog "#i40845# X-Position is wrong: Not -> "+sPositionX+"  but -> "+Horizontalby.Gettext
      if Verticalby.Gettext <> sPositionY then Warnlog "Y-Position is wrong: Not -> "+sPositionY+"  but -> "+Verticalby.Gettext
    TabPositionAndSizeWriter.Cancel

    printLog "check redo function"
   '/// check redo function
    EditRedo
    Sleep 1
    EditRedo
    Sleep 1

    fPositionAndSize("TabPositionAndSizeWriter")
      if Horizontalby.Gettext <> sPositionXMove then Warnlog "X-Position is wrong: Not -> "+sPositionXMove+"  but -> "+Horizontalby.Gettext
      if Verticalby.Gettext <> sPositionYMove then Warnlog "Y-Position is wrong: Not -> "+sPositionYMove+"  but -> "+Verticalby.Gettext
    TabPositionAndSizeWriter.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tPositionAndSize_3

  Dim sWidth        , sHeight        as String
  Dim sWidthChange  , sHeightChange  as String

  sHeightChange  = "8" + gSeperator + "00" + gMeasurementUnit
  sWidthChange   = "6" + gSeperator + "00" + gMeasurementUnit

  printLog "check 'keep ratio' option"
  '/// check 'keep ratio' option

   Call hNewDocument

   '/// Insert a drawing object (rectangle)
    Call wZeichenobjektEinfuegen("RECHTECK", 30, 40, 60, 60)
    Call gMouseClick(40,50)

    fPositionAndSize("TabPositionAndSizeWriter")

   '/// Check when ratio is 5:4
     Width.Settext  "5"
     Height.Settext "4"

     KeepRatio.Check
     Width.Settext "10"
     Sleep 2
     if Height.GetText <> sHeightChange then Warnlog "Height is wrong: Not -> "+sHeightChange+"  but -> "+Height.GetText

     KeepRatio.UnCheck
   '/// Check when ratio is 3:5
     Width.Settext  "3"
     Height.Settext "5"

     KeepRatio.Check
     Height.Settext "10"
     Sleep 2
     if Width.GetText <> sWidthChange then Warnlog "Width is wrong: Not -> "+sWidthChange+"  but -> "+Width.GetText

    'Recover to the default
     KeepRatio.UnCheck
    TabPositionAndSizeWriter.OK

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tPositionAndSize_4

  Dim sWidth        , sHeight        as String
  Dim sWidthChange  , sHeightChange  as String

  sWidth        = "5" + gSeperator + "00" + gMeasurementUnit
  sHeight       = "4" + gSeperator + "00" + gMeasurementUnit
  sWidthChange  = "8" + gSeperator + "00" + gMeasurementUnit
  sHeightChange = "6" + gSeperator + "00" + gMeasurementUnit

  printLog "check Undo/Redo function of size assignment"
  '/// check Undo/Redo function of size assignment

   Call hNewDocument

   '/// Insert a drawing object (rectangle) , and set the first Size
    Call wZeichenobjektEinfuegen("RECHTECK", 30, 40, 60, 60)
    Call gMouseClick(40,50)

    fPositionAndSize("TabPositionAndSizeWriter")
     Width.Settext  sWidth
     Height.Settext sHeight
    TabPositionAndSizeWriter.OK
    Sleep 1

   '/// Set the second Size
    fPositionAndSize("TabPositionAndSizeWriter")
     Width.Settext  sWidthChange
     Height.Settext sHeightChange
    TabPositionAndSizeWriter.OK
    Sleep 1

    printLog "check undo function"
   '/// check undo function
    EditUndo
    Sleep 1
    fPositionAndSize("TabPositionAndSizeWriter")
      if Width.GetText  <> sWidth  then Warnlog "Width is wrong: Not -> "+sWidth+"  but -> "+Width.GetText
      if Height.GetText <> sHeight then Warnlog "Height is wrong: Not -> "+sHeight+"  but -> "+Height.GetText
    TabPositionAndSizeWriter.Cancel

    printLog "check redo function"
   '/// check redo function
    EditRedo
    Sleep 1

    fPositionAndSize("TabPositionAndSizeWriter")
      if Width.GetText  <> sWidthChange  then Warnlog "Width is wrong: Not -> "+sWidthChange+"  but -> "+Width.GetText
      if Height.GetText <> sHeightChange then Warnlog "Height is wrong: Not -> "+sHeightChange+"  but -> "+Height.GetText
    TabPositionAndSizeWriter.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tPositionAndSize_5

  Dim sDegree as String

   Select case iSprache
         case 01   : sDegree = "45" + gSeperator + "00 degrees"
         case 31   : sDegree = "45" + gSeperator + "00 graden"
         case 33   : sDegree = "45" + gSeperator + "00 degrés"
         case 34   : sDegree = "45" + gSeperator + "00 Grados"
         case 39   : sDegree = "45" + gSeperator + "00 gradi"
         case 46   : sDegree = "45" + gSeperator + "00 grader"
         case 49   : sDegree = "45" + gSeperator + "00 Grad"
         case 55   : sDegree = "45" + gSeperator + "00 graus"
         case 81   : sDegree = "45" + gSeperator + "00度"
         case 82   : sDegree = "45" + gSeperator + "00도"
         case 86   : sDegree = "45" + gSeperator + "00度"
         case 88   : sDegree = "45" + gSeperator + "00度"
         case else : QAErrorLog "Now, the test does not support for the language " +iSprache
                     Goto endsub
   end select

  printLog "check rotation angle of an object "
  '/// check rotation angle of an object

   Call hNewDocument

   '/// Insert a drawing object (rectangle) , and set its rotation angle
    Call wZeichenobjektEinfuegen("RECHTECK", 30, 40, 60, 60)
    Call gMouseClick(40,50)

    fPositionAndSize("TabDrehung")
     Winkel.SetText "45"
    TabDrehung.OK
    Sleep 1

    fPositionAndSize("TabDrehung")
     if Winkel.GetText <> sDegree then Warnlog "The rotation angle isn't corroct! It should be " +sDegree+ " ,but get " +Winkel.GetText
    TabDrehung.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tPositionAndSize_6

  Dim sRadius as String

  sRadius = "0" + gSeperator + "50" + gMeasurementUnit

  printLog "check corner radius of rectangles"
  '/// check corner radius of rectangles

   Call hNewDocument

   '/// Insert a rectangle , and set its corner radius
    Call wZeichenobjektEinfuegen("RECHTECK", 30, 40, 60, 60)
    Call gMouseClick(40,50)

    fPositionAndSize("TabSchraegstellen")
     Radius.SetText sRadius
    TabSchraegstellen.OK
    Sleep 1

    fPositionAndSize("TabSchraegstellen")
     if Radius.GetText <> sRadius then Warnlog "The Radius isn't corroct! It should be " +sRadius + " ,but get " +Radius.GetText
    TabSchraegstellen.Cancel

   Call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase  tPositionAndSize_7

  Dim sRadius as String

  sRadius = "0" + gSeperator + "50" + gMeasurementUnit

  printLog "check corner radius of textboxes"
  '/// check corner radius of textboxes

   Call hNewDocument

   '/// Insert a rectangle , and set its corner radius

    Call wZeichenobjektEinfuegen("TEXT", 30, 40, 60, 60)
    Call wDokSchreiben "The test for corner radius of textboxes..."
    Kontext "DocumentWriter"
    Call wDokSchreiben "<ESCAPE>"

    fPositionAndSize("TabSchraegstellen")
     Radius.SetText sRadius
    TabSchraegstellen.OK
    Sleep 1

    fPositionAndSize("TabSchraegstellen")
     if Radius.GetText <> sRadius then Warnlog "The Radius isn't corroct! It should be " +sRadius + " ,but get " +Radius.GetText
    TabSchraegstellen.Cancel

   Call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase  tPositionAndSize_8

  Dim sPositionStartX , sPositionStartY  as String
  Dim sPositionEndX   , sPositionEndY    as String
  Dim sWidth          , sHeight          as String

  sPositionStartX  = "3" + gSeperator + "00" + gMeasurementUnit
  sPositionStartY  = "3" + gSeperator + "00" + gMeasurementUnit
  sPositionEndX    = "7" + gSeperator + "00" + gMeasurementUnit
  sPositionEndY    = "6" + gSeperator + "00" + gMeasurementUnit
  sWidth           = "4" + gSeperator + "00" + gMeasurementUnit
  sHeight          = "3" + gSeperator + "00" + gMeasurementUnit

  printLog "check base points of position"
  '/// check base points of position

   Call hNewDocument

   '/// Insert a drawing object (rectangle)
    Call wZeichenobjektEinfuegen("RECHTECK", 30, 40, 60, 60)
    Call gMouseClick(40,50)

    fPositionAndSize("TabPositionAndSizeWriter")
     Width.Settext     sWidth
     Height.Settext    sHeight
     Horizontalby.Settext sPositionStartX
     Verticalby.Settext sPositionStartY
    TabPositionAndSizeWriter.OK
    Sleep 1

   '/// Move the base point of position to the Right-Down
    fPositionAndSize("TabPositionAndSizeWriter")
     PositionPosition.TypeKeys "<Down>"  , 2
     PositionPosition.TypeKeys "<Right>" , 2
     if Horizontalby.Gettext <> sPositionEndX then Warnlog "X-Position is wrong: Not -> "+sPositionEndX+"  but -> "+Horizontalby.Gettext
     if Verticalby.Gettext <> sPositionEndY then Warnlog "Y-Position is wrong: Not -> "+sPositionEndY+"  but -> "+Verticalby.Gettext
    TabPositionAndSizeWriter.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tPositionAndSize_9

  Dim sPositionStartX , sPositionStartY  as String
  Dim sPositionEndX   , sPositionEndY    as String
  Dim sWidth          , sHeight          as String
  Dim sWidthNew       , sHeightNew       as String

  sPositionStartX  = "4" + gSeperator + "00" + gMeasurementUnit
  sPositionStartY  = "4" + gSeperator + "00" + gMeasurementUnit
  sPositionEndX    = "3" + gSeperator + "00" + gMeasurementUnit
  sPositionEndY    = "2" + gSeperator + "00" + gMeasurementUnit
  sWidth           = "5" + gSeperator + "00" + gMeasurementUnit
  sHeight          = "3" + gSeperator + "00" + gMeasurementUnit
  sWidthNew        = "6" + gSeperator + "00" + gMeasurementUnit
  sHeightNew       = "5" + gSeperator + "00" + gMeasurementUnit

  printLog "check base points of size"
  '/// check base points of size

   Call hNewDocument

   '/// Insert a drawing object (rectangle)
    Call wZeichenobjektEinfuegen("RECHTECK", 30, 40, 60, 60)
    Call gMouseClick(40,50)

    fPositionAndSize("TabPositionAndSizeWriter")
     Width.Settext     sWidth
     Height.Settext    sHeight
     Horizontalby.Settext sPositionStartX
     Verticalby.Settext sPositionStartY
    TabPositionAndSizeWriter.OK
    Sleep 1

   '/// Move the base point of size to the Right-Down
    fPositionAndSize("TabPositionAndSizeWriter")
     SizePosition.TypeKeys "<Down>"  , 2
     SizePosition.TypeKeys "<Right>" , 2
     Width.Settext     sWidthNew
     Height.Settext    sHeightNew
    TabPositionAndSizeWriter.OK

    fPositionAndSize("TabPositionAndSizeWriter")
     if Horizontalby.Gettext <> sPositionEndX then Warnlog "X-Position is wrong: Not -> "+sPositionEndX+"  but -> "+Horizontalby.Gettext
     if Verticalby.Gettext <> sPositionEndY then Warnlog "Y-Position is wrong: Not -> "+sPositionEndY+"  but -> "+Verticalby.Gettext
    TabPositionAndSizeWriter.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tPositionAndSize_10

  Dim sPositionStartX , sPositionStartY  as String
  Dim sWidth          , sHeight          as String
  Dim sPivotDefaultX  , sPivotDefaultY   as String
  Dim sPivotStartX    , sPivotStartY     as String
  Dim sPivotEndX      , sPivotEndY       as String

  sPositionStartX   = "3" + gSeperator + "00" + gMeasurementUnit
  sPositionStartY   = "3" + gSeperator + "00" + gMeasurementUnit
  sWidth            = "4" + gSeperator + "00" + gMeasurementUnit
  sHeight           = "3" + gSeperator + "00" + gMeasurementUnit

  sPivotDefaultX    = "5" + gSeperator + "00" + gMeasurementUnit
  sPivotDefaultY    = "4" + gSeperator + "50" + gMeasurementUnit
  sPivotStartX      = "3" + gSeperator + "50" + gMeasurementUnit
  sPivotStartY      = "2" + gSeperator + "50" + gMeasurementUnit
  sPivotEndX        = "6" + gSeperator + "50" + gMeasurementUnit
  sPivotEndY        = "6" + gSeperator + "50" + gMeasurementUnit

  printLog "check 'keep ratio' option"
  '/// check 'keep ratio' option

   Call hNewDocument

   '/// Insert a drawing object (rectangle)
    Call wZeichenobjektEinfuegen("RECHTECK", 30, 40, 60, 60)
    Call gMouseClick(40,50)

    fPositionAndSize("TabPositionAndSizeWriter")
     Width.Settext        sWidth
     Height.Settext       sHeight
     Horizontalby.Settext sPositionStartX
     Verticalby.Settext   sPositionStartY
    TabPositionAndSizeWriter.OK
    Sleep 1
    fPositionAndSize("TabDrehung")
     Winkel.SetText "270"
    TabDrehung.OK
    Sleep 1

    fPositionAndSize("TabDrehung")
     if PositionX.Gettext <> sPivotDefaultX then Warnlog "X-Position is wrong: Not -> "+sPivotDefaultX+"  but -> "+PositionX.Gettext
     if PositionY.Gettext <> sPivotDefaultY then Warnlog "Y-Position is wrong: Not -> "+sPivotDefaultY+"  but -> "+PositionY.Gettext

     Drehpunkt.TypeKeys "<Up>"
     Drehpunkt.TypeKeys "<Left>"

     if PositionX.Gettext <> sPivotStartX then Warnlog "X-Position is wrong: Not -> "+sPivotStartX+"  but -> "+PositionX.Gettext
     if PositionY.Gettext <> sPivotStartY then Warnlog "Y-Position is wrong: Not -> "+sPivotStartY+"  but -> "+PositionY.Gettext

     Drehpunkt.TypeKeys "<Right>" , 2
     Drehpunkt.TypeKeys "<Down>"  , 2

     if PositionX.Gettext <> sPivotEndX then Warnlog "X-Position is wrong: Not -> "+sPivotEndX+"  but -> "+PositionX.Gettext
     if PositionY.Gettext <> sPivotEndY then Warnlog "Y-Position is wrong: Not -> "+sPivotEndY+"  but -> "+PositionY.Gettext
    TabDrehung.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tEditPoint_1

   Dim sMouseState

  printLog "Create objects from the drawing functions of the Toolbar "
  '/// Create objects from the drawing functions of the Toolbar , include ...

   Call hNewDocument
   Kontext "Toolbar"
   Zeichnen.TearOff

   Kontext "Drawbar"

  '/// polygon
   Polygon.Click
   Kontext "DocumentWriter"
   gMouseDown  (30,30)
   gMouseClick (30,60)
   gMouseClick (70,60)
   gMouseDoubleClick (70,100)
   gMouseClick (30,30)
   Sleep 1

   Kontext "Drawbar"
   PunkteBearbeiten.Click

   gMouseDown  (30,30)

   sMouseState = GetMouseStyle

   gMouseMove2 60,60
   gMouseUp    60,60

   Kontext "Drawbar"
   Drawbar.Close

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tLine_1

  Dim iLineStyle      , iColor           as Integer
  Dim iArrowStyleLeft , iArrowStyleRight as Integer
  Dim sLineWidth      , sTransparency    as String
  Dim sArrowWidthLeft , sArrowWidthRight as String

  Dim iLineStyleDefault      , iColorDefault           as Integer
  Dim iArrowStyleLeftDefault , iArrowStyleRightDefault as Integer
  Dim sLineWidthDefault      , sTransparencyDefault    as String
  Dim sArrowWidthLeftDefault , sArrowWidthRightDefault as String

  sTransparency    = "25%"
  iLineStyle       = 3
  iColor           = 7
  iArrowStyleLeft  = 2
  iArrowStyleRight = 3
  sLineWidth       = "0" + gSeperator + "10" + gMeasurementUnit
  sArrowWidthLeft  = "0" + gSeperator + "55" + gMeasurementUnit
  sArrowWidthRight = "0" + gSeperator + "60" + gMeasurementUnit

  PrintLog "- check style, color, width and arrow styles"
  '/// check style, color, width and arrow styles

   Call hNewDocument

   '/// Insert a line
    Call wZeichenobjektEinfuegen("LINIE", 40,40 ,  60,50 , false)
    Sleep 2
    Call gMouseClick(40,40)
    Sleep 2
    if Val(mid$(gMinor, 2, Len(gMinor))) <= 130 then
        Call wDokSchreiben ( "<Shift F5>" )
    else
        Call wDokSchreiben ( "<Shift F4>" )
    endif
    Sleep 1

   '/// modify Style ,color , width and arrow styles
    fFormatLine("TabLinie")

     iLineStyleDefault       = Stil.GetSelIndex
     iColorDefault           = Farbe.GetSelIndex
     slineWidthDefault       = Breite.GetText
     sTransparencyDefault    = Transparenz.GetText
     iArrowStyleLeftDefault  = StilLinks.GetSelIndex
     iArrowStyleRightDefault = StilRechts.GetSelIndex
     sArrowWidthLeftDefault  = BreiteLinks.GetText
     sArrowWidthRightDefault = BreiteRechts.GetText

    '/// Line properties , include :
    '/// - Style
     Stil.Select iLineStyle
     wait 500
    '/// - Color
     Farbe.Select iColor
     wait 500
    '/// - Width
     Breite.SetText sLineWidth
     wait 500
    '/// - Transparency
     Transparenz.SetText sTransparency
     wait 500

    '/// Arrow styles , include :
    '/// - Synchronize ends
     EndenSynchronisieren.UnCheck
    '/// - Style (left and right)
     StilLinks.Select  iArrowStyleLeft
     StilRechts.Select iArrowStyleRight
     wait 500
    '/// - Width (left and right)
     BreiteLinks.SetText  sArrowWidthLeft
     BreiteRechts.SetText sArrowWidthRight
    '/// - Center (left and right)
     ZentriertLinks.Check
     ZentriertRechts.Check

    TabLinie.OK

   '/// Check all changes
    fFormatLine("TabLinie")

     if Stil.GetSelIndex    <> iLineStyle    then Warnlog "Line style is wrong."
     if Farbe.GetSelIndex   <> iColor        then Warnlog "Line color is wrong."
     if Breite.GetText      <> sLineWidth    then Warnlog "Line width is wrong."
     if Transparenz.GetText <> sTransparency then Warnlog "Line transparency is wrong."

     if EndenSynchronisieren.IsChecked = TRUE         then Warnlog "Synchronize ends should NOT be checked."
     if StilLinks.GetSelIndex     <> iArrowStyleLeft  then Warnlog "The left arrow style is wrong."
     if StilRechts.GetSelIndex    <> iArrowStyleRight then Warnlog "The right arrow style is wrong."
     if BreiteLinks.GetText       <> sArrowWidthLeft  then Warnlog "The left arrow width is wrong."
     if BreiteRechts.GetText      <> sArrowWidthRight then Warnlog "The right arrow width is wrong."
     if ZentriertLinks.IsChecked  <> TRUE             then Warnlog "The left 'center' should be checked"
     if ZentriertRechts.IsChecked <> TRUE             then Warnlog "The right 'center' should be checked"
    TabLinie.Cancel

   '/// Test Undo function
    printLog "check undo function"
    Kontext "DocumentWriter"
    EditUndo
    Sleep 1

    fFormatLine("TabLinie")
     if Stil.GetSelIndex    <> iLineStyleDefault    then Warnlog "Line style is wrong."
     if Farbe.GetSelIndex   <> iColorDefault        then Warnlog "Line color is wrong."
     if Breite.GetText      <> sLineWidthDefault    then Warnlog "Line width is wrong."
     if Transparenz.GetText <> sTransparencyDefault then Warnlog "Line transparency is wrong."

     if EndenSynchronisieren.IsChecked = TRUE                then Warnlog "Synchronize ends should NOT be checked."
     if StilLinks.GetSelIndex     <> iArrowStyleLeftDefault  then Warnlog "The left arrow style is wrong."
     if StilRechts.GetSelIndex    <> iArrowStyleRightDefault then Warnlog "The right arrow style is wrong."
     if BreiteLinks.GetText       <> sArrowWidthLeftDefault  then Warnlog "The left arrow width is wrong."
     if BreiteRechts.GetText      <> sArrowWidthRightDefault then Warnlog "The right arrow width is wrong."
     if ZentriertLinks.IsChecked  = TRUE                     then Warnlog "The left 'center' should be checked"
     if ZentriertRechts.IsChecked = TRUE                     then Warnlog "The right 'center' should be checked"
    TabLinie.Cancel

   '/// Test Redo function
    printLog "check redo function"
    Kontext "DocumentWriter"
    EditRedo
    Sleep 1

    fFormatLine("TabLinie")
     if Stil.GetSelIndex    <> iLineStyle    then Warnlog "Line style is wrong."
     if Farbe.GetSelIndex   <> iColor        then Warnlog "Line color is wrong."
     if Breite.GetText      <> sLineWidth    then Warnlog "Line width is wrong."
     if Transparenz.GetText <> sTransparency then Warnlog "Line transparency is wrong."

     if EndenSynchronisieren.IsChecked = TRUE         then Warnlog "Synchronize ends should NOT be checked."
     if StilLinks.GetSelIndex     <> iArrowStyleLeft  then Warnlog "The left arrow style is wrong."
     if StilRechts.GetSelIndex    <> iArrowStyleRight then Warnlog "The right arrow style is wrong."
     if BreiteLinks.GetText       <> sArrowWidthLeft  then Warnlog "The left arrow width is wrong."
     if BreiteRechts.GetText      <> sArrowWidthRight then Warnlog "The right arrow width is wrong."
     if ZentriertLinks.IsChecked  <> TRUE             then Warnlog "The left 'center' should be checked"
     if ZentriertRechts.IsChecked <> TRUE             then Warnlog "The right 'center' should be checked"
    TabLinie.Cancel

   Call hCloseDocument
endcase

'-------------------------------------------------------------------------

testcase  tLine_2

  PrintLog "- Check call Format.Line dialog via Button in object bar "
  '/// Check call Format.Line dialog via Button in object bar

   Call hNewDocument

   '/// Insert a line
    Call wZeichenobjektEinfuegen("LINIE", 40,40 ,  60,50 , false)
    Sleep 2
    Call gMouseClick(40,40)
    Sleep 2
    if Val(mid$(gMinor, 2, Len(gMinor))) <= 130 then
        Call wDokSchreiben ( "<Shift F5>" )
    else
        Call wDokSchreiben ( "<Shift F4>" )
    endif
    Sleep 1

   '/// call Format/Line dialog via Button in object bar
    try
      Kontext "DrawingObjectbar"
      Linie.Click
      Kontext
      active.SetPage TabLinie
      Sleep 1
      Kontext "TabLinie"
      Kontext
      active.SetPage TabLinienstile
      Sleep 1
      Kontext "TabLinienstile"
      Kontext
      active.SetPage TabLinienenden
      Sleep 1
      Kontext "TabLinienenden"
      TabLinienenden.Cancel
    catch
      Warnlog "Can't call format/line via Button in object bar."
    endcatch

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tLine_3

  Dim iLineStyle       , iColor           as Integer
  Dim iArrowStyleLeft  , iArrowStyleRight as Integer
  Dim sLineWidth                          as String

  iLineStyle       = 4
  iColor           = 5
  iArrowStyleLeft  = 4
  iArrowStyleRight = 6

  PrintLog "- check line attributes are applied in object bar "
  '/// check line attributes are applied in object bar ,include -

  Call hNewDocument

   '/// Insert a line
    Call wZeichenobjektEinfuegen("LINIE", 40,40 ,  60,50 , false)
    Sleep 2
    Call gMouseClick(40,40)
    Sleep 2
    if Val(mid$(gMinor, 2, Len(gMinor))) <= 130 then
        Call wDokSchreiben ( "<Shift F5>" )
    else
        Call wDokSchreiben ( "<Shift F4>" )
    endif
    Sleep 1

   '/// set Arrow Styles
    Kontext "DrawingObjectbar"
    Linienendenstil.TearOff
    Kontext "Linienenden"
     Sleep 1
     Auswahl.TypeKeys "<Down>" , 4
     Sleep 2
     Auswahl.TypeKeys "<Return>"
     Sleep 2
     Auswahl.TypeKeys "<Right>"
     Sleep 2
     Auswahl.TypeKeys "<Down>" , 2
     Sleep 2
     Auswahl.TypeKeys "<Return>"
     Sleep 2
    Linienenden.Close
    Sleep 2

   '/// set Line Style
    Kontext "DrawingObjectbar"
    Linienstil.Select iLineStyle

   '/// + Line Width
    Linienbreite.More 4
    sLineWidth = Linienbreite.GetText

   '/// + Line Colour
    Linienfarbe.Select iColor

   '/// check the lines status
    fFormatLine("TabLinie")
     if Stil.GetSelIndex    <> iLineStyle    then Warnlog "Line style is wrong."
     if Farbe.GetSelIndex   <> iColor        then Warnlog "Line color is wrong."
     if Breite.GetText      <> sLineWidth    then QAErrorLog "#i40843# Line width is wrong."

     if StilLinks.GetSelIndex   <> iArrowStyleLeft  then Warnlog "The left arrow style is wrong."
     if StilRechts.GetSelIndex  <> iArrowStyleRight then Warnlog "The right arrow style is wrong."

    TabLinie.Cancel

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tLine_4

  Dim iArrowStyleLeft , iArrowStyleRight as Integer

  iArrowStyleLeft  = 2
  iArrowStyleRight = 3

  PrintLog "- check  'synchronize ends'"
  '/// check  'synchronize ends'

   Call hNewDocument

    Call wZeichenobjektEinfuegen("LINIE", 40,40 ,  60,50 , false)
    Sleep 2
    Call gMouseClick(40,40)
    Sleep 2
    if Val(mid$(gMinor, 2, Len(gMinor))) <= 130 then
        Call wDokSchreiben ( "<Shift F5>" )
    else
        Call wDokSchreiben ( "<Shift F4>" )
    endif
    Sleep 1

    fFormatLine("TabLinie")
    '/// Check Synchronize ends
     EndenSynchronisieren.Check

    '/// Style (left and right)
     StilLinks.Select  iArrowStyleLeft
     Sleep 1
     if StilRechts.GetSelIndex <> iArrowStyleLeft then Warnlog "The right arrow style is wrong."

     StilRechts.Select iArrowStyleRight
     Sleep 1
     if StilLinks.GetSelIndex <> iArrowStyleRight then Warnlog "The left arrow style is wrong."

    TabLinie.Cancel

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tLine_5

  Dim iLineTypeLeft , iLineTypeRight      as Integer
  Dim sLineStyle ,  sRightLength , sSpace as String
  Dim sLeftNumber , sRightNumber          as String

  sLineStyle     = "myTest"
  iLineTypeLeft  =  1
  iLineTypeRight =  2
  sLeftNumber    = "3"
  sRightNumber   = "2"
  sRightLength   = "0" + gSeperator + "30" + gMeasurementUnit
  sSpace         = "0" + gSeperator + "10" + gMeasurementUnit

  PrintLog "- check the attributes in format/line/line styles"
  '/// check  'check the attributes in format/line/line styles'

   Call hNewDocument

    Call wZeichenobjektEinfuegen("LINIE", 40,40 ,  60,50 , false)
    Sleep 2
    Call gMouseClick(40,40)
    Sleep 2
    if Val(mid$(gMinor, 2, Len(gMinor))) <= 130 then
        Call wDokSchreiben ( "<Shift F5>" )
    else
        Call wDokSchreiben ( "<Shift F4>" )
    endif
    Sleep 1

    fFormatLine("TabLinienstile")

      AnLinienbreite.UnCheck

      TypLinks.Select      iLineTypeLeft
      TypRechts.Select     iLineTypeRight
      AnzahlLinks.SetText  sLeftNumber
      AnzahlRechts.SetText sRightNumber
      LaengeRechts.SetText sRightLength
      Abstand.SetText      sSpace
      TabLinienstile.OK
      Sleep 1

      Kontext
      Kontext "Linienstil"
      if Linienstil.Exists then
         Hinzufuegen.Click
      else
         Warnlog "The dialog doesn't appear ! No test for this case"
         Kontext "TabLinienstile"
         goto NoTEST
      end if
      Sleep 1

      Kontext
      Kontext "LinieName"

      if LinieName.Exists then
         Sleep 1
         Eingabefeld.SetText sLineStyle
         Sleep 1
         LinieName.OK
         Sleep 1
      else
         Warnlog "The dialog doesn't appear !"
         Goto endsub
      end if

    fFormatLine("TabLinienstile")
      Sleep 2
      if AnLinienbreite.IsChecked =  TRUE           then Warnlog "Fit to line width should NOT be checked"
      Sleep 1
      if TypLinks.GetSelIndex     <> iLineTypeLeft  then Warnlog "The left line type is wrong !"
      Sleep 1
      if TypRechts.GetSelIndex    <> iLineTypeRight then Warnlog "The right line type is wrong !"
      Sleep 1
      if AnzahlLinks.GetText      <> sLeftNumber    then Warnlog "The left number is wrong !"
      Sleep 1
      if AnzahlRechts.GetText     <> sRightNumber   then Warnlog "The right number is wrong !"
      Sleep 1
      if LaengeLinks.IsEnabled                      then Warnlog "The left length should be unable !"
      Sleep 1
      if LaengeRechts.GetText     <> sRightLength   then Warnlog "The right length is wrong !"
      Sleep 1
      if Abstand.GetText          <> sSpace         then Warnlog "The spacing is wrong !"
      Sleep 1
NoTEST:
     'delete the testing line type , recover to the default
      Loeschen.Click
      Sleep 1
        Kontext "Active"
        if Active.Exists then
          if Active.GetRT = 304 then
             Active.Yes
             Sleep 1
          else
             Warnlog "Something wrong when deleting the new line type!"
          end if
        end if

    Kontext
    Kontext "TabLinienstile"
    TabLinienstile.OK
    Sleep 1
   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase  tLine_6

  Dim i                           as Integer
  Dim sArrowTitle1 , sArrowTitle2 as String
  Dim soeFile , soeDefaultFile    as String

  sArrowTitle1  = "myTest1"
  sArrowTitle2  = "myTest2"

  soeFile        = ConvertPath(gOfficePath + "user\work\standard_reserver.soe")
  soeDefaultFile = ConvertPath(gOfficePath + "user\config\standard.soe")

  if hFileExists ( soeFile ) then app.kill ( soeFile )

  PrintLog "- check the attributes in format/line/arrow styles"
  '/// check the attributes in format/line/arrow styles

   Call hNewDocument

    Call wZeichenobjektEinfuegen("RECHTECK", 20, 40, 40, 60)
    Call wZeichenobjektEinfuegen("ELLIPSE",  20, 65, 40, 85)

    Call gMouseClick(20,40)

   '/// add the first test arrow type
    fFormatLine("TabLinienenden")
     '/// save the arrow types first
      Speichern.Click
      Kontext
      Kontext "SpeichernDlg"
       Dateiname.SetText soeFile
       Speichern.Click
       Sleep 2

      Kontext
      Kontext "TabLinienenden"
     '/// delete the all arrow types
      if Loeschen.IsEnabled then
        for i = 1 to Liste.GetItemCount
            Loeschen.Click
            Kontext "Active"
            if Active.Exists then
               if Active.GetRT = 304 then
                  Active.Yes
               else
                  Warnlog "Something wrong when deleting the arrow types!"
               end if
            end if
            Kontext
            Kontext "TabLinienenden"
        next i
      end if

      Hinzufuegen.Click
      Kontext
      Kontext "LinieName"
       Eingabefeld.SetText sArrowTitle1
      LinieName.OK

      Kontext
      Kontext "TabLinienenden"
      TabLinienenden.OK

   '/// add the second test arrow type
      Call gMouseClick(30,70)
      fFormatLine("TabLinienenden")
        Hinzufuegen.Click
         Kontext
         Kontext "LinieName"
          Eingabefeld.SetText sArrowTitle2
         LinieName.OK

      Kontext
      Kontext "TabLinienenden"
      TabLinienenden.OK

      Call gMouseClick(20,40)
      fFormatLine("TabLinienenden")

      Liste.Select 1
      if TextFeld.GetText <> sArrowTitle1 then Warnlog "The first arraw title is wrong, hope "+sArrowTitle1+ " but get " +TextFeld.GetText
      Liste.Select 2
      if TextFeld.GetText <> sArrowTitle2 then Warnlog "The first arraw title is wrong, hope "+sArrowTitle2+ " but get " +TextFeld.GetText

      Oeffnen.Click
      Kontext
      Kontext "OeffnenDlg"
       Pfad.SetText soeFile
      Oeffnen.Click
      Sleep 1
      Kontext
      Kontext "TabLinienenden"

       if hFileExists ( soeDefaultFile ) then app.kill ( soeDefaultFile )

       Speichern.Click
       Kontext
       Kontext "SpeichernDlg"
        Dateiname.SetText soeDefaultFile
        Speichern.Click
        Sleep 2

      Kontext
      Kontext "TabLinienenden"
      TabLinienenden.OK

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

