'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_german_spell_check1.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:19:52 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Spellcheck for some new German words I
'*
'************************************************************************
'*
' #1 tGermanSpellCheck_1
' #1 tGermanSpellCheck_2
' #1 tGermanSpellCheck_3
' #1 tGermanSpellCheck_4
' #1 tGermanSpellCheck_5
' #1 tGermanSpellCheck_6
' #1 tGermanSpellCheck_7
' #1 tGermanSpellCheck_8
' #1 tGermanSpellCheck_9
' #1 tGermanSpellCheck_10
'*
'\***********************************************************************

sub w_german_spell_check_1

'///   This case is based on -- "
'///   http://staroffice-doc.germany.sun.com:8080/Teams/QA/Test_Plans/Writer/tools
'///      --- new_german_spelling.vor
   printLog Chr(13) + "- Tools/Spellcheck/check for some new German words"
      Call tGermanSpellCheck_1        'Tools/Spellcheck/check  for some new German words Page 1
      Call tGermanSpellCheck_2        'Tools/Spellcheck/check  for some new German words Page 2
      Call tGermanSpellCheck_3        'Tools/Spellcheck/check  for some new German words Page 3
      Call tGermanSpellCheck_4        'Tools/Spellcheck/check  for some new German words Page 4
      Call tGermanSpellCheck_5        'Tools/Spellcheck/check  for some new German words Page 5
      Call tGermanSpellCheck_6        'Tools/Spellcheck/check  for some new German words Page 6
      Call tGermanSpellCheck_7        'Tools/Spellcheck/check  for some new German words Page 7
      Call tGermanSpellCheck_8        'Tools/Spellcheck/check  for some new German words Page 8
      Call tGermanSpellCheck_9        'Tools/Spellcheck/check  for some new German words Page 9
      Call tGermanSpellCheck_10       'Tools/Spellcheck/check  for some new German words Page 10
end sub

' *******************************************************************
testcase tGermanSpellCheck_1

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
  
  sFileName = "new_german_spelling1.stw"
  
  aCheckedWord = Array( _
                       "abend" ,"aberhundert" , "Aberhunderte" , "abertausend",   _
                       "Abertausende", "Abfluß","abgeblaßt", "Abguß",           _
                       "Ablaß"    , "Abriß"   , "Abschluß" , "Abschuß" ,        _
                       "absein"   , "Abszeß"  , "abwärtsgehen" , "acht" ,        _
                       "acht" ,  "8achser" ,   "achte",  "achte"       ,         _
                       "achtgeben" , "achthaben" , "8jährig" , "8jährige",       _
                       "8mal",  "achtmillionenmal" , "8tonner" ,"achtunggebietend", _
                       "Achtzig" ,"Achtzig" , "Achtzig" , "achtziger Jahre" ,       _
                       "Achtzigerjahre" , "ackerbautreibende" , "Action-painting" , "ade sagen" , _
                       "Aderlaß"   , "Adhäsionsverschluß" , "Adreßbuch" , "afro-amerikanisch", _
                       "afro-asiatisch" , "Afro-Look" , "After-shave" , "ähnliches", _
                       "ähnliches" , "Alkoholmißbrauch", "alleinerziehend" , "alleinseligmachend" , _
                       "alleinstehend" , "daß" ,"allgemeinen" , "allgemeingültig" , _
                       "allgemeinverständlich" , "allzubald" , "allzufrüh" , "allzugern" , _
                       "allzulange" , "allzuoft" , "allzusehr" , "allzuviel" , _
                       "mater" , _
                       )

  aCorrectWord = Array( _
                       "Abend" , "Aberhundert" , "aberhunderte" , "Abertausend" ,  _
                       "abertausende" , "Abfluss" , "abgeblasst" , "Abguss"     ,  _
                       "Ablass" , "Abriss" , "Abschluss",     "Abschuss"        ,  _
                       "ab sein" , "Abszess" , "abwärts gehen" , "Acht"         ,  _
                       "Acht"   ,  "8-Achser", "Achte" , "Achte"                ,  _
                       "Acht geben" , "Acht haben" , "8-jährig" , "8-Jährige"   ,  _
                       "8-mal" ,  "acht Millionen Mal" , "8-Tonner" ,"Achtung gebietend" , _
                       "achtzig" , "achtzig" , "achtzig" , "Achtzigerjahre*"    ,  _
                       "achtziger Jahre" , "Ackerbau treibende" ,"Actionpainting" , "Ade sagen*" , _
                       "Aderlass" , "Adhäsionsverschluss" , "Adressbuch" , "afroamerikanisch" ,  _
                       "afroasiatisch" , "Afrolook" , "Aftershave" , "Ähnliches" ,         _
                       "Ähnliches" , "Alkoholmissbrauch" , "allein erziehend" , "allein selig machend" , _
                       "allein stehend" , "dass" , "Allgemeinen" , "allgemein gültig" ,   _
                       "allgemein verständlich" , "allzu bald" , "allzu früh" , "allzu gern" , _
                       "allzu lange" ,"allzu oft" , "allzu sehr" , "allzu viel" , _
                       "Mater" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words -- Page 1"
  '/// Tools/Spellcheck/check  for some new German words -- Page 1
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_2

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
  
  sFileName = "new_german_spelling2.stw"
  
  aCheckedWord = Array( _
                       "Alpdruck" , "Alptraum" ,"daß" , "alt"  ,  _
                       "alt" , "alte" , "alten" , "ego" ,          _
                       "altwienerisch" , "Amboß" , "Anbiß" , "andersdenkend" , _
                       "andersgeartet" , "anderslautend" , "aneinanderfügen", "aneinandergeraten" , _
                       "aneinandergrenzen" ,"aneinanderlegen" ,"aneinanderreihen","angepaßt" , _
                       "Angepaßtheit" , "Anglo-Amerikaner" ,"angst" ,"anheimfallen" , _
                       "anheimstellen" , "Anlaß" , "anläßlich" , "Anriß" , _
                       "Anschiß" , "Anschluß" ,"ansein" , "Archimedische" , _
                       "argen" , "arm" , "Armee-Einheit" , "Aschantinuß" , _
                       "As" , "aufeinanderbeißen" , "aufeinanderfolgen" , "aufeinandertreffen" , _
                       "aufgepaßt" , "aufgerauht" , "Aufguß" , "Auflösungsprozeß" , _
                       "aufrauhen" , "Aufriß" , "Aufschluß" , "aufschlußreich" , _
                       "aufsehenerregendes" , "aufsein" , "auf seiten" , "auf seiten" , _
                       "aufsichtführende" ,  "aufwärtsgehen" ,  "aufwendig" , "auseinanderbiegen" , _
                       "auseinanderfallen" , "auseinandergehen" , "auseinanderhalten" , "auseinanderleben" , _
                       "auseinanderreißen" , "auseinandersetzen" ,  "Ausfluß" , _
                       )

                        
  aCorrectWord = Array( _
                       "Albdruck" , "Albtraum" , "dass" ,"Alt" , _
                       "Alt" , "Alte" , "Alten" ,"Ego" , _
                       "alt-wienerisch" , "Amboss" , "Anbiss" , "anders denkend" , _
                       "anders geartet" , "anders lautend" , "aneinander fügen" , "aneinander geraten" , _
                       "aneinander grenzen" , "aneinander legen" , "aneinander reihen", "angepasst" , _
                       "Angepasstheit" , "Angloamerikaner" , "Angst", "anheim fallen" , _
                       "anheim stellen" , "Anlass" , "anlässlich" , "Anriss" , _
                       "Anschiss" , "Anschluss" , "an sein" , "der archimedische Punkt" , _
                       "im Argen liegen" , "bei Arm und Reich" , "auch: Armeeeinheit" , "Aschantinuss" , _
                       "Ass" , "aufeinander beißen" , "aufeinander folgen" , "aufeinander treffen" , _
                       "aufgepasst" , "aufgeraut" ,  "Aufguss" , "Auflösungsprozess" , _
                       "aufrauen" , "Aufriss" , "Aufschluss" , "aufschlussreich" , _
                       "Aufsehen erregendes" , "auf sein" , "aufseiten" ,"auf Seiten" , _
                       "der Aufsicht führende Lehrer", "aufwärts gehen" , "aufwändig" , "auseinander biegen" , _
                       "auseinander fallen" , "auseinander gehen" , "auseinander halten" , "auseinander leben" , _
                       "auseinander reißen" , "auseinander setzen" , "Ausfluss"  , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 2"
  '/// Tools/Spellcheck/check  for some new German words - page 2
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_3

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
    
  sFileName = "new_german_spelling3.stw"

  aCheckedWord = Array( _
                       "Ausguß" , "Ausschluß" , "Ausschuß" , "aussein" , _
                       "äußerste" , "außerstande" , "Bajonettverschluß" , "Ballettänzerin" , _
                       "Ballettänzerin" , "Ballokal" , "Ballokal" , "Bänderriß" , _
                       "angst" , "bange " , "bankrott" , "Baroneß" , _
                       "baß erstaunt" , "Baß" , "Baßgeige" , _
                       "Baßsänger" , "Baßsänger" , "Baukostenzuschuß" , "beeinflußbar" , _
                       "Beeinflußbarkeit" , "beeinflußt" , "befaßt" , "Begrüßungskuß" , _
                       "behende" , "Behendigkeit" , "beieinanderhaben" , "beieinandersein" , _
                       "beieinandersitzen" , "beieinanderstehen" , "beifallheischend" , "beisammensein" , _
                       "Beischluß" , "belemmert" , "beliebige" , "Beschiß" , _
                       "Beschluß" , "beschlußfähig" , "Beschlußfassung" , "Beschuß" , _
                       "besonderen" , "bessergehen" , "beste" , "beste" , _
                       "besten" , "besten" , "beste" , "bestehenbleiben" , _
                       "Bestelliste" , "Bestelliste" , "bestgehaßt" ,  "bestußt" , _
                       "Betelnuß" , "beträchtliches" , "betreff" , "betreßt" , _
                       "Bettuch" , "Bettuch" , "bevorschußt" , "bewußt" , "baselstädtisch" ,  _
                       )


                        
  aCorrectWord = Array( _
                       "Ausguss" , "Ausschluss" , "Ausschuss" , "aus sein" , _
                       "Äußerste" , "außer Stande" , "Bajonettverschluss" , "Balletttänzerin" , _
                       "Ballett-Tänzerin" , "Balllokal" , "Ball-Lokal" , "Bänderriss" , _
                       "Angst" , "Bange" , "Bankrott" , "Baroness" , _
                       "bass erstaunt" , "Bass" , "Bassgeige" , _
                       "Basssänger" , "Bass-Sänger" , "Baukostenzuschuss" , "beeinflussbar" , _
                       "Beeinflussbarkeit" , "beeinflusst" , "befasst" , "Begrüßungskuss" , _
                       "behände" , "Behändigkeit" , "beieinander haben" , "beieinander sein" , _
                       "beieinander sitzen" , "beieinander stehen" , "Beifall heischend" , "beisammen sein" , _
                       "Beischluss" , "belämmert" , "jeder Beliebige " , "Beschiss" , _
                       "Beschluss" , "beschlussfähig " , "Beschlussfassung " , "Beschuss" , _
                       "Besonderen" , "besser gehen" , "Beste" , "Beste" , _
                       "Besten" , "Besten" , "Beste " , "bestehen bleiben" , _
                       "Bestellliste" , "Bestell-Liste" , "bestgehasst" , "bestusst" , _
                       "Betelnuss" , "Beträchtliches" , "Betreff" , "betresst" , _
                       "Betttuch " , "Bett-Tuch" , "bevorschusst" , "bewusst" , "basel-städtisch" ,  _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 3"
  '/// Tools/Spellcheck/check  for some new German words - page 3
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_4

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x , Flag           as Integer  
  
  sFileName = "new_german_spelling4.stw"
  
  aCheckedWord = Array( _
                        "bewußtlos" ,"Bewußtlosigkeit" ,"Bewußtsein" ,"bezug" , _
                        "bezuschußt" ,"Bibliographie" ,"Bierfaß" ,"Bismarckschen" , _
                        "Bismarckschen" ,"Biß" ,"bißchen" ,"bitte" , _
                        "bitter kalt" ,"Bittag" ,"Bittag" ,"Blackout" , _
                        "blankpoliert" ,"blaß" ,"Bläßhuhn" ,"Bleßhuhn" , _
                        "bläßlich" ,"blaßrosa" ,"Blattschuß" ,"blaue" , _
                        "blaugestreift" ,"bläulichgrün" ,"bleibenlassen" ,"blendendweiß" , _
                        "blondgefärbt" ,"Bluterguß" ,"Bonbonniere" ,"Börsentip" , _
                        "bösen" ,"guten" ,"Boß" ,"Bouclé" , _
                        "braungebrannt" ,"bräunlichgelb" ,"langen" ,"breiten" , _
                        "breitgefächert" ,"Brennessel" ,"Brennessel" ,"Bruderkuß" , _
                        "Brummbaß" ,"brütendheiß" ,"buntgefiedert" ,"buntschillernd" , _
                        "Büroschluß" ,"Butterfaß" ,"Cashewnuß" ,"Centre Court" , _
                        "Centre Court" ,"Chansonnier" ,"Choreographie" ,"Cleverneß" , _
                        "Comeback" ,"Common sense" ,"Common sense" ,"Corned beef" , _
                        "Corned beef" ,"Corpus delicti" ,"Countdown" ,"dabeisein" , _
                        "Dachgeschoß" ,"dahinterklemmen" ,"dahinterkommen" ,"Dampfschiffahrt" , _
                        "Danaidenfaß" , _
                        )


                        
  aCorrectWord = Array( _
                       "bewusstlos" ,"Bewusstlosigkeit" ,"Bewusstsein" ,"Bezug" , _
                       "bezuschusst" ,"Bibliografie" ,"Bierfass" ,"bismarckschen" , _
                       "Bismarck'schen" ,"Biss" ,"bisschen" ,"Bitte" , _
                       "bitterkalt" ,"Bitttag" ,"Bitt-Tag" ,"Black-out" , _
                       "blank poliert" ,"blass" ,"Blässhuhn" ,"Blesshuhn" , _
                       "blässlich" ,"blassrosa" ,"Blattschuss" ,"Blaue" , _
                       "blau gestreift" ,"bläulich grün" ,"bleiben lassen" ,"blendend weiß" , _
                       "blond gefärbt" ,"Bluterguss" ,"Bonboniere" ,"Börsentipp" , _
                       "Bösen" ,"Guten" ,"Boss" ,"Buklee" , _
                       "braun gebrannt" ,"bräunlich gelb" ,"Langen" ,"Breiten" , _
                       "breit gefächert" ,"Brennnessel" ,"Brenn-Nessel" ,"Bruderkuss" , _
                       "Brummbass" ,"brütend heiß" ,"bunt gefiedert" ,"bunt schillernd" , _
                       "Büroschluss" ,"Butterfass" ,"Cashewnuss" ,"Centrecourt" , _
                       "Centre-Court" ,"Chansonier" ,"Choreografie" ,"Cleverness" , _
                       "Come-back" ,"Commonsense" ,"Common Sense" ,"Cornedbeef" , _
                       "Corned Beef" ,"Corpus Delicti" ,"Count-down" ,"dabei sein" , _
                       "Dachgeschoss" ,"dahinter klemmen" ,"dahinter kommen" ,"Dampfschifffahrt" , _
                       "Danaidenfass" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 4" 
  '/// Tools/Spellcheck/check  for some new German words - page 4
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_5

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x , Flag           as Integer  
  
  sFileName = "new_german_spelling5.stw"
  
  aCheckedWord = Array( _
                        "Danaidenfaß" , "darauffolgend" , "Darmverschluß" , "darüberstehen" , _
                        "dasein" , "daß" , "daß-Satz" , "daß-Satz" , _
                        "datenverarbeitend" , "Dein" , "mein" , "dein " , _
                        "Deinen" , "Deinigen" , "Dekolleté" , "Delikateßgurke" , _
                        "Delikateßsenf" , "Delikateßsenf" , "Delphin" , "Denkprozeß" , _
                        "derartiges" , "dessenungeachtet" , "weiteren" , "deutsch" , _
                        "deutschsprechend" , "d'Hondtsche" , "d'Hondtsche" , "diät leben" , _
                        "Dich" , "dichtbehaart" , "dichtgedrängt" , "Differential" , _
                        "Diktaphon" , "Dir" , "Doppelpaß" , "dortbleiben" , _
                        "dortzulande" , "draufsein" , "Dreß" , "dringendste" , _
                        "drinsein" , "dritte" , "dritten" , "dritte" , _
                        "drückendheiß" , "Du" , "du" , "dunkeln" , _
                        "dunkeln" , "dünnbesiedelt" , "Dünnschiß" , "durcheinanderbringen" , _
                        "durcheinandergeraten" , "durcheinanderlaufen" , "Durchfluß" , "Durchlaß" , _
                        "durchnumerieren" , "Durchschuß" , "durchsein" , "dußlig" , _
                        "Dußligkeit" , "Dutzende" , "Dutzende" , "ebensogut" , _
                        "ebensosehr" ,  _
                        )
                        
  aCorrectWord = Array( _
                        "Danaidenfass" , "darauf folgend" , "Darmverschluss" , "darüber stehen" , _
                        "da sein" , "dass" , "dass-Satz" , "Dasssatz" , _
                        "Daten verarbeitend" , "dein" , "Mein" , "Dein" , _
                        "deinen" , "deinigen" , "Dekolletee" , "Delikatessgurke" , _
                        "Delikatesssenf" , "Delikatess-Senf" , "Delfin" , "Denkprozess" , _
                        "Derartiges" , "dessen ungeachtet" , "Weiteren" , "Deutsch" , _
                        "Deutsch sprechend" , "d'hondtsche" , "d'Hondt'sche" , "Diät leben" , _
                        "dich" , "dicht behaart" , "dicht gedrängt" , "Differenzial" , _
                        "Diktafon" , "dir" , "Doppelpass" , "dort bleiben" , _
                        "dort zu Lande" , "drauf sein" , "Dress" , "Dringendste" , _
                        "drin sein" , "Dritte" , "Dritten" , "Dritte" , _
                        "drückend heiß" , "du" , "Du" , "Dunkeln" , _
                        "Dunkeln" , "dünn besiedelt" , "Dünnschiss" , "durcheinander bringen" , _
                        "durcheinander geraten" , "durcheinander laufen" , "Durchfluss" , "Durchlass" , _
                        "durchnummerieren" , "Durchschuss" , "durch sein" , "dusslig" , _
                        "Dussligkeit" , "dutzende" , "dutzende" , "ebenso gut" , _
                        "ebenso sehr" , _
                       )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 5" 
  '/// Tools/Spellcheck/check  for some new German words - page 5
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_6

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
  
  sFileName = "new_german_spelling6.stw"
  
  aCheckedWord = Array( _
                       "ebensowenig" , "Statt" , "eigen" , "eigen" , _
                       "einbleuen" , "eindringlichste" , "einfachste" , "Einfluß" , _
                       "einflußreich" , "eingehendste" , "einiggehen" , "Einlaß" , _
                       "einläßlich" , "Einriß" , "Einschluß" , "Einschuß" , _
                       "Einschußstelle" , "Einschußstelle" , "Einsendeschluß" , "einwärtsgebogen" , _
                       "einzelne" , "einzelne" , "einzelne" , "einzelne" , _
                       "einzelnstehend" , "einzige" , "einziger" , "einziger" , _
                       "einzige" , "einzigartige" , "Eisenguß" , "eisenverarbeitende" , _
                       "eisigkalt" , "eislaufen" , "Eisschnellauf" , "Eisschnelläufer" , _
                       "energiebewußt" , "engste" , "engbefreundet" , "engbedruckt" , _
                       "Engpaß" , "entferntesten" , "entschiedenste" , "Entschluß" , _
                       "Oder" , "Entwicklungsprozeß" , "erblaßt" , "Erdgeschoß" , _
                       "Erdnuß" , "erdölexportierenden" , "erfaßbar" , "erfaßt" , _
                       "Erguß" , "erholungsuchende" , "Erlaß" , "ermeßbar" , _
                       "ernstgemeint" , "ernstzunehmend" , "erpreßbar" , "erstbesten" , _
                       "erste" , _
                       )

  aCorrectWord = Array( _
                       "ebenso wenig" , "statt" , "Eigen" , "Eigen" , _
                       "einbläuen" , "Eindringlichste" , "Einfachste" , "Einfluss" , _
                       "einflussreich" , "Eingehendste" , "einig gehen" , "Einlass" , _
                       "einlässlich" , "Einriss" , "Einschluss" , "Einschuss" , _
                       "Einschussstelle" , "Einschuss-Stelle" , "Einsendeschluss" , "einwärts gebogen" , _
                       "Einzelne" , "Einzelne" , "Einzelne" , "Einzelne" , _
                       "einzeln stehend" , "Einzige" , "Einziger" , "Einziger" , _
                       "Einzige" , "Einzigartige" , "Eisenguss" , "Eisen verarbeitende" , _
                       "eisig kalt" , "Eis laufen" , "Eisschnelllauf" , "Eisschnellläufer" , _
                       "energiebewusst" , "Engste" , "eng befreundet" , "eng bedruckt" , _
                       "Engpass" , "Entferntesten" , "Entschiedenste" , "Entschluss" , _
                       "oder" , "Entwicklungsprozess" , "erblasst" , "Erdgeschoss" , _
                       "Erdnuss" , "Erdöl exportierenden" , "erfassbar" , "erfasst" , _
                       "Erguss" , "Erholung suchende" , "Erlass" , "ermessbar" , _
                       "ernst gemeint" , "ernst zu nehmend" , "erpressbar" , "Erstbesten" , _
                       "Erste" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words -- Page 6"
  '/// Tools/Spellcheck/check  for some new German words -- Page 6
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_7

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
  
  sFileName = "new_german_spelling7.stw"
  
  aCheckedWord = Array( _
                        "erste" , "erste" , "ersten" , "zweiten" , _
                        "dritten" , "Erste" , "erstemal" , "erstenmal" , _
                        "Erstkläßler" , "Erstplazierten" , "eßbar" , "Eßbesteck" , _
                        "Eßecke" , "essentiell" , "Eßlöffel" , "eßlöffelweise" , _
                        "Eßtisch" , "etlichemal" , "Euch" , "Euer" , _
                        "Euren" , "Eurigen" , "Existentialismus" , "existentialistisch" , _
                        "existentiell" , "Exportüberschuß" , "Exposé" , "expreß" , _
                        "Expreßreinigung" , "Expreßzug" , "Exzeß" , "Fabrikationsprozeß" , _
                        "fahrenlassen" , "Fairneß" , "Fair play" , "Fair play" , _
                        "fallenlassen" , "Fallinie" , "Fallinie" , "Fallout" , _
                        "Familienanschluß" , "Fangschuß" , "Faß" , "faßbar" , _
                        "Faßbier" , "Fäßchen" , "faßlich" , "faßt" , _
                        "Fast food" , "Fast food" , "Faxanschluß" , "Feedback" , _
                        "Fehlpaß" , "Fehlschuß" , "feind" , "feingemahlen" , _
                        "fernliegen" , "fertigbringen" , "fertigstellen" , "Fertigungsprozeß" , _
                        "festangestellt" , "festumrissen" , "festverwurzelt" , "fettgedruckt" , _
                        "feuerspeiende" , "fischverarbeitende" , _
                        )

                        
  aCorrectWord = Array( _
                        "Erste" , "Erste" , "Ersten" , "Zweiten" , _
                        "Dritten" , "erste" , "das erste Mal" , "zum ersten Mal" , _
                        "Erstklässler" , "Erstplatzierten" , "essbar" , "Essbesteck" , _
                        "Essecke" , "essenziell" , "Esslöffel" , "esslöffelweise" , _
                        "Esstisch" , "etliche Mal" , "euch" , "euer" , _
                        "euren" , "eurigen" , "Existenzialismus" , "existenzialistisch" , _
                        "existenziell" , "Exportüberschuss" , "Exposee" , "express" , _
                        "Expressreinigung" , "Expresszug" , "Exzess" , "Fabrikationsprozess" , _
                        "fahren lassen" , "Fairness" , "Fairplay" , "Fair Play" , _
                        "fallen lassen" , "Falllinie" , "Fall-Linie" , "Fall-out" , _
                        "Familienanschluss" , "Fangschuss" , "Fass" , "fassbar" , _
                        "Fassbier" , "Fässchen" , "fasslich" , "fasst" , _
                        "Fastfood" , "Fast Food" , "Faxanschluss" , "Feed-back" , _
                        "Fehlpass" , "Fehlschuss" , "Feind" , "fein gemahlen" , _
                        "fern liegen" , "fertig bringen" , "fertig stellen" , "Fertigungsprozess" , _
                        "fest angestellt" , "fest umrissen" , "fest verwurzelt" , "fett gedruckt" , _
                        "Feuer speiende" , "Fisch verarbeitende" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 7"
  '/// Tools/Spellcheck/check  for some new German words - page 7
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_8

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x, Flag            as Integer  
    
  sFileName = "new_german_spelling8.stw"

  aCheckedWord = Array( _
                        "Fitneß" , "Flachschuß" , "fleischfressende" , "Flohbiß" , _
                        "floß" , "flötengehen" , "Fluß" , "flußabwärts" , _
                        "flußaufwärts" , "Flußbett" , "Flüßchen" , "Flußdiagramm" , _
                        "flüssigmachen" , "Flußsand" , "Flußsand" , "Flußschiffahrt" , _
                        "Flußschiffahrt" , "Flußspat" , "Flußspat" , "fönen" , _
                        "folgendes" , "folgenden" , "Fraktionsausschuß" , "Fraktionsbeschluß" , _
                        "Free climbing" , "Free climbing" , "Free Jazz" , "Freßgier" , _
                        "Freßpaket" , "Freßsack" , "Freßsack" , "Friedensschluß" , _
                        "frischgebacken" , "fritieren" , "frohgelaunt" , "frühverstorben" , _
                        "Full-time-Job" , "Full-time-Job" , "Fünfpaß" , "funkensprühend" , _
                        "Funkmeßtechnik" , "fürbaß" , "fürliebnehmen" , "Fußballänderspiel" , _
                        "Fußballänderspiel" , "Gangsterboß" , "ganzen" , "großen" , "ganzen" , _
                        "Gärungsprozeß" , "Gäßchen" , "gefangenhalten" , "gefangennehmen" , _
                        "gefaßt" , "gefirnißt" , "gegebene" , "gegeneinanderprallen" , _
                        "gegeneinanderstoßen" , "gehaßt" , "geheimhalten" , "gehenlassen" , _
                        "Gelaß" , "gutgelaunt" , "gelblichgrün" , _
                      )
                        
  aCorrectWord = Array( _
                        "Fitness" , "Flachschuss" , "Fleisch fressende" , "Flohbiss" , _
                        "floss" ,  "flöten gehen" , "Fluss" , "flussabwärts" , _
                        "flussaufwärts" , "Flussbett" , "Flüsschen" , "Flussdiagramm" , _
                        "flüssig machen" , "Flusssand" , "auch: Fluss-Sand" , "Flussschifffahrt" , _
                        "Fluss-Schifffahrt" , "Flussspat" , "Fluss-Spat" , "föhnen" , _
                        "Folgendes" , "Folgenden" , "Fraktionsausschuss" , "Fraktionsbeschluss" , _
                        "Freeclimbing" , "Free Climbing" , "auch: Freejazz" , "Fressgier" , _
                        "Fresspaket" , "Fresssack" , "Fress-Sack" , "Friedensschluss" , _
                        "frisch gebacken" , "frittieren" , "froh gelaunt" , "früh verstorben" , _
                        "Fulltimejob" , "Full-Time-Job" , "Fünfpass" , "Funken sprühend" , _
                        "Funkmesstechnik" , "fürbass" , "fürlieb nehmen" , "Fußballländerspiel" , _
                        "Fußball-Länderspiel" , "Gangsterboss" , "Ganzen" , "Großen" , "Ganzen" , _
                        "Gärungsprozess" , "Gässchen" , "gefangen halten" , "gefangen nehmen" , _
                        "gefasst" , "gefirnisst" , "Gegebene" , "gegeneinander prallen" , _
                        "gegeneinander stoßen" , "gehasst" , "geheim halten" , "gehen lassen" , _
                        "Gelass" , "gut gelaunt" , "gelblich grün" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 8"
  '/// Tools/Spellcheck/check  for some new German words - page 8
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument

endcase

' *******************************************************************

testcase tGermanSpellCheck_9

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x , Flag           as Integer  
  
  sFileName = "new_german_spelling9.stw"
  
  aCheckedWord = Array( _
                        "Gemse" , "gemußt" , "genäßt" , "genaueste" , _
                        "genaugenommen" , "genausogut" , "genausowenig" , "Generalbaß" , _
                        "genoß" , "Genuß" , "genüßlich" , "Genußmittel" , _
                        "genußsüchtig" , "Geographie" , "gepaßt" , "gepraßt" , _
                        "gepreßter" , "geradehalten" , "geradesitzen" , "geradestellen" , _
                        "Gerichtsbeschluß" , "geringes" , "geringste" , "geringsten" , _
                        "geringachten" , "geringschätzen" , "Geruchsverschluß" , "Geschäftsschluß" , _
                        "geschaßt" , "Geschichtsbewußtsein" , "Geschirreiniger" , "Geschirreiniger" , _
                        "Geschoß" , "abend" , "nacht" , "gestreßt" , _
                        "getrenntlebend" , "Gewinnummer" , "Gewinnummer" , "gewiß" , _
                        "Gewissensbiß" , "Gewißheit" , "gewißlich" , "gewußt" , _
                        "Ginkgo" , "Glacéhandschuh" , "glänzendschwarz" , "glattgehen" , _
                        "glatthobeln" , "glattschleifen" , "glattstreichen" , "gleiche" , _
                        "gleiche" , "gleich" , "gleich" , "gleichlautend" , _
                        "Gleisanschluß" , "Glimmstengel" , "glühendheiß" , "Gnadenerlaß" , _
                        "Goetheschen" , "Goetheschen" , "Graphit" , "Graphologie" , _
                        "gräßlich" , "graugestreift" , _
                        )
                       
  aCorrectWord = Array( _
                       "Gämse" , "gemusst" , "genässt" , "Genaueste" , _
                       "genau genommen" , "genauso gut" , "genauso wenig" , "Generalbass" , _
                       "genoss" , "Genuss" , "genüsslich" , "Genussmittel" , _
                       "genusssüchtig" , "Geografie" , "gepasst" , "geprasst" , _
                       "gepresster" , "gerade halten" , "gerade sitzen" , "gerade stellen" , _
                       "Gerichtsbeschluss" , "Geringes" , "Geringste" , "Geringsten" , _
                       "gering achten" , "gering schätzen" , "Geruchsverschluss" , "Geschäftsschluss" , _
                       "geschasst" , "Geschichtsbewusstsein" , "Geschirrreiniger" , "Geschirr-Reiniger" , _
                       "Geschoss" , "Abend" , "Nacht" , "gestresst" , _
                       "getrennt lebend" , "Gewinnnummer" , "Gewinn-Nummer" , "gewiss" , _
                       "Gewissensbiss" , "Gewissheit" , "gewisslich" , "gewusst" , _
                       "Ginko" , "Glaceehandschuh" , "glänzend schwarz" , "glatt gehen" , _
                       "glatt hobeln" , "glatt schleifen" , "glatt streichen" , "Gleiche" , _
                       "Gleiche" , "Gleich" , "Gleich" , "gleich lautend" , _
                       "Gleisanschluss" , "Glimmstängel" , "glühend heiß" , "Gnadenerlass" , _
                       "goetheschen" , "Goethe'schen" , "Grafit" , "Grafologie" , _
                       "grässlich" , "grau gestreift" , _
                      )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 9" 
  '/// Tools/Spellcheck/check  for some new German words - page 9
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

testcase tGermanSpellCheck_10

  Dim sFileName as String
  Dim aCheckedWord(), aCorrectWord() as String
  Dim i , j , k , x , Flag           as Integer  
  
  sFileName = "new_german_spelling10.stw"
  
  aCheckedWord = Array( _
                        "grellbeleuchtet" , "Grenzfluß" , "Greuel" , "greulich" , _
                        "griffest" , "gröbste" , "grobgemahlen" , "groß" , _
                        "klein" , "großen" , "ganzen" , "größte" , _
                        "Großschiffahrtsweg" , "groß schreiben" , "grünlichgelb" , "Guß" , _
                        "Gußeisen" , "gußeisern" , "guten" , "guten" , _
                        "gutaussehend" , "gutbezahlt" , "gutgehen" , "gutgehend" , _
                        "gutgelaunt" , "gutgemeint" , "guttun" , "gutunterrichtet" , _
                        "haftenbleiben" , "haltmachen" , "Hämorrhoide" , "händchenhaltend" , _
                        "handeltreibend" , "Handkuß" , "Handout" , "hängenbleiben" , _
                        "hängenlassen" , "Happy-End" , "Happy-End" , "Haraß" , _
                        "Hard cover" , "Hard cover" , "Hard-cover-Einband" , "Hard-cover-Einband" , _
                        "hartgekocht" , "Haselnuß" , "Haselnußstrauch" , "Haselnußstrauch" , _
                        "Haß" , "haßerfüllt" , "häßlich" , "Häßlichkeit" , _
                        "Haßliebe" , "du haßt" , "Hauptschulabschluß" , "nach Hause" , _
                        "zu Hause" , "haushalten" , "Haushaltsausschuß" , "Hawaii-Insel" , _
                        "heiligsprechen" , "Heilungsprozeß" , "heimlichtun" , _
                        )
                        
  aCorrectWord = Array( _
                        "grell beleuchtet" , "Grenzfluss" , "Gräuel" , "gräulich" , _
                        "grifffest" , "Gröbste" , "grob gemahlen" , "Groß" , _
                        "Klein" , "Großen" , "Ganzen" , "Größte" , _
                        "Großschifffahrtsweg" , "großschreiben" , "grünlich gelb" , "Guss" , _
                        "Gusseisen" , "gusseisern" , "Guten" , "Guten" , _
                        "gut aussehend" , "gut bezahlt" , "gut gehen" , "gut gehend" , _
                        "gut gelaunt" , "gut gemeint" , "gut tun" , "gut unterrichtet" , _
                        "haften bleiben" , "Halt machen" , "auch: Hämorride" , "Händchen haltend" , _
                        "Handel treibend" , "Handkuss" , "Hand-out*" , "hängen bleiben" , _
                        "hängen lassen" , "Happyend" , "Happy End" , "Harass" , _
                        "Hardcover" , "Hard Cover" , "Hardcovereinband" , "Hard-Cover-Einband" , _
                        "hart gekocht" , "Haselnuss" , "Haselnussstrauch" , "Haselnuss-Strauch" , _
                        "Hass" , "hasserfüllt" , "hässlich" , "Hässlichkeit" , _
                        "Hassliebe" , "du hasst" , "Hauptschulabschluss" , "nachhause" , _
                        "zuhause" , "Haus halten" , "Haushaltsausschuss" , "Hawaiiinsel" , _
                        "heilig sprechen" , "Heilungsprozess" , "heimlich tun" , _
                       )
    
  j = UBound(aCheckedWord)
                        
  PrintLog "- Tools/Spellcheck/check  for some new German words - page 10" 
  '/// Tools/Spellcheck/check  for some new German words - page 10
                        
   select case iSprache 
       case 81 : Printlog "- No Spellcheck in Japanese!"
       			 exit sub
       case 82 : Printlog "- No Spellcheck in Korean!"
       			 exit sub
       case 86 : Printlog "- No Spellcheck in Chinese (simplified)!"
       			 exit sub
       case 88 : Printlog "- No Spellcheck in Chinese (traditional)!"
       			 exit sub
   end select           
                        
   '/// + Open a New writerdocument
'    Call hNewDocument   
                        
   '/// + Open the test file
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\advanced\" + sFileName )
    Sleep 8             
                        
   '/// + Spell check   
    ToolsSpellcheckCheckWriter
    Kontext             
    Kontext "Rechtschreibung"

   For i = 0 to j
       Flag = 0
       if Wort.GetText = aCheckedWord(i) then        
          For k = 1 to Vorschlaege.GetItemCount
              Vorschlaege.Select k
              wait 500
              if Wort.GetText = aCorrectWord(i) then 
                 Flag = 1
                 Ignorieren.Click
                 wait 500
                 goto GOOD
              end if   
          next k
          if Flag = 0 then  
             Warnlog "Can't get the correct word for " +aCheckedWord(i)
             Ignorieren.Click
             wait 300
          end if
       else 
          for x = i+1 to j
            if Wort.GetText = aCheckedWord(x) then  
               Warnlog aCheckedWord(i) +" has not been detected as mistake."
               goto GOOD
            end if   
          next x            
          Warnlog "Something wrong for the word -- " +aCheckedWord(i) + " ,get " +Wort.GetText
          Ignorieren.Click
       end if
    GOOD:
       Kontext "Active"
       if Active.Exists then
          if Active.GetRT = 304 then Active.No
          Sleep 2
          Kontext "Active"
          if Active.Exists then
             if Active.GetRT = 304 then Active.OK
          end if
          goto Last
       else
         Kontext
         Kontext  "Rechtschreibung"
       end if
    next i

    Kontext "Active"
    if Active.Exists then
      if Active.GetRT = 304 then Active.No
      Sleep 2
      Kontext "Active"
      if Active.Exists then
        if Active.GetRT = 304 then Active.OK
      end if
    else
      Kontext
      Kontext  "Rechtschreibung"
      Rechtschreibung.Close
    end if

Last:    
   '/// + Close document ///
   hCloseDocument
endcase

' *******************************************************************

