'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_102a_.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:25:48 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Put description here
'*
'\***********************************************************************

sub w_102a_
   printLog Chr(13) + "---------   Level 1   - Menu / Edit(2) -   ----------"

   Call tEditExchangeDatabase
   Call tEditFields
   Call tEditFootnote
   Call tEditIndexEntry
   Call tEditImageMap

end sub

' **********************************************************************

testcase tEditExchangeDatabase
   '/// Edit / Exchange Database ///
  PrintLog "- Edit / Exchange Database"
   '/// New Document ///
   Call hNewDocument
   '/// Edit / Exchange Database ///
   EditExchangeDatabase
   Kontext "DatenbankAustauschen"
   try
    DatenbankAustauschen.Ok
   catch
    VerfuegbareDatenbanken.TypeKeys "<Up>",2
    VerfuegbareDatenbanken.TypeKeys "+"
    VerfuegbareDatenbanken.TypeKeys "<Down>"
     try
      DatenbankAustauschen.Ok
     catch
      Warnlog "No Database could be defined! Maybe there is no Database ? BUG?"
      DatenbankAustauschen.Cancel
     endcatch
    endcatch
   Sleep 1
   '/// Close dialog and document ///
   Call hCloseDocument
endcase

' **********************************************************************

testcase tEditFields
   '/// Edit / Fields ///
  PrintLog "- Edit / Fields"

   '/// New document ///
   Call hNewDocument
  PrintLog "  - Date"
   '/// Insert / Fields / Date ///
   InsertFieldsDate
   '/// Change format of field and check if it has been changed ///
   Call FeldbefehlAendernUndKontrollieren ( 5 )

  PrintLog "  - Time"
   '/// Insert / Fields / Time ///
   InsertFieldsTime
   '/// Change format of field and check if it has been changed ///
   Call FeldbefehlAendernUndKontrollieren ( 4 )

  PrintLog "  - Page Numbers"
   '/// Insert / Fields / Page Numbers ///
   InsertFieldsPageNumbers
   '/// Change format of field and check if it has been changed ///
   Call FeldbefehlAendernUndKontrollieren ( 2 )

  PrintLog "  - Page Count"
   '/// Insert / Fields / Page Count ///
   InsertFieldsPageCount
   '/// Change format of field and check if it has been changed ///
   Call FeldbefehlAendernUndKontrollieren ( 1 )

  printlog "- Properties"
   '/// File / Properties ///
   FileProperties
   Kontext
   '/// Select Tabpage 'Description' and and insert any text in edit fields ///
   Active.SetPage TabBeschreibung
   Kontext "TabBeschreibung"
   Titel.SetText "Dies ist ein Titel"
   Thema.SetText "Dies ist ein Thema"
   '/// Close dialog ///
   TabBeschreibung.OK

  PrintLog "  - Subject"
   '/// Insert / Fields / Subject ///
   InsertFieldsSubject
   Call wDokSchreiben "<Left>"
   '/// Edit / Fields ///
   EditFields
   Kontext "FeldbefehlBearbeitenDokumentinfo"
   '/// In dialog Check 'fixed content' and close dialog ///
   InhaltFix.Check
   FeldbefehlBearbeitenDokumentinfo.OK
   '/// Reopen dialog with Edit / Fields and check if checkbox is checked ///
   EditFields
   Kontext "FeldbefehlBearbeitenDokumentinfo"
   If Not InhaltFix.IsChecked then Warnlog "'Fixed Content' isn't checked anymore"
   FeldbefehlBearbeitenDokumentinfo.OK
   '/// Close dialog and insert in document a line break at end of first line ///
   Call wDokSchreiben "<End>"
   Call wDokSchreiben "<Return>"

  PrintLog "  - Title"
      '/// Insert / Fields / Title ///
   InsertFieldsTitle
   Call wDokSchreiben "<Left>"
   '/// Edit / Fields ///
   EditFields
   Kontext "FeldbefehlBearbeitenDokumentinfo"
   '/// Check in dialog 'fixed content' ///
   InhaltFix.Check
   FeldbefehlBearbeitenDokumentinfo.OK
   '/// Reopen dialog with Edit / Fields and check if checkbox is checked ///
   EditFields
   Kontext "FeldbefehlBearbeitenDokumentinfo"
   If Not InhaltFix.IsChecked then Warnlog "'Fixed Content' isn't checked anymore"
   FeldbefehlBearbeitenDokumentinfo.OK
   '/// Close dialog ///
   Call wDokSchreiben "<End>"
   Call wDokSchreiben "<Return>"

  PrintLog "  - Author"
   '/// Insert / Fields / Author ///
   '/// Author Name will be shown, after document has been saved ! ///
   InsertFieldsAuthor
   if gApplication = "WRITER" then
     Call hSpeichernUnterKill (convertpath(gOfficepath & "user\work\edit_fields.sxw"))
   else
     Call hSpeichernUnterKill (convertpath(gOfficepath & "user\work\edit_fields.sxg"))
   endif
   '/// Change format of field and check if it has been changed ///
   Call wDokSchreiben( "<Left>" )
   EditFields
   Kontext "FeldbefehlBearbeitenDokumentinfo"
   if Not FeldbefehlBearbeitenDokumentinfo.Exists then
      Warnlog "Unable to Edit Field 'Author'"
   else
      FeldbefehlBearbeitenDokumentinfo.Cancel
   endif

   '/// Close document ///
   Call hCloseDocument
endcase

' **********************************************************************

testcase tEditFootnote
 Dim Folge as String
   '/// Edit / Footnote ///
  PrintLog "- Edit / Footnote"

   '/// New document ///
   Call hNewDocument
   '/// Insert /Footnote ///
   InsertFootnote
   Kontext "FussnoteEinfuegen"
   '/// Check 'Automatic' and close dialog with 'ok'///
   Automatisch.Check
   FussnoteEinfuegen.OK

   Call wDokSchreiben "<PageUp><Left>"

  printlog "  - check settings"
   '/// Edit / Footnote ///
   EditFootnote
   Kontext "FussnoteBearbeiten"
   '/// Check if checkbox is checked ///
   if Not Automatisch.Ischecked then Warnlog "  - Automatic isn't checked"
   '/// Check Radiobutton 'Character' ///
   Zeichen.Check
   try
   '/// try to insert some text '?=)!)!$/&%(%&' ///
      ZeichenText.SetText "?=)!)!$/&%(%&"
      Folge = "?=)!)!$/&%(%&"
      ZeichenText.TypeKeys "<Shift Home>"
      ZeichenText.TypeKeys "<Mod1 C>"
      if GetClipboardtext = Folge then
   '/// Check limit of characters to 10 ///
        Printlog "Theres no limit for Characters of 10"
      else
       Folge = GetClipboardtext
      endif
   catch
      ZeichenText.SetText "06[]=(&$@"
      Folge = "06[]=(&$@"
      Printlog "Theres a limit for Characters of 10"
   endcatch
   '/// Close dialog with 'ok' ///
   FussnoteBearbeiten.OK

  printlog "  - check changed settings again"
   '/// Edit / Footnote ///
   EditFootnote
   Kontext "FussnoteBearbeiten"
   '/// Check if changes are already in dialog ///
   if NOT Zeichen.Ischecked then Warnlog "  - Character isn't checked"
   if ZeichenText.GetText <> Folge then Warnlog "Character sequence is wrong. Not " + Folge + " but " + ZeichenText.GetText
   FussnoteBearbeiten.OK
   Sleep 1
   '/// close dialog and document ///
   Call hCloseDocument
endcase

' **********************************************************************

testcase tEditIndexEntry
   Dim Fertich as boolean
   '/// Edit / Indexes Entry ///
   PrintLog "- Edit / Indexes Entry"

   '/// New document ///
   Call hNewDocument
  printlog "  - Table of Contents - Entry"
   '/// Insert any text and select last word ///
    Call wDokSchreiben "Dies ist ein Eintrag fr's Inhaltsverzeichnis<Shift Mod1 Left>"
   '/// Insert / Indexes / Entry ( Table of Contents ) ///
    InsertIndexesEntry
    Kontext "VerzeichniseintragEinfuegen"
    Sleep 2
   '/// In dialog select 'Table of Contents' ///
    Verzeichnis.Select 1
   '/// Check if selected word has been correct entered in dialog ///
    if Verzeichniseintrag.GetText <> "Inhaltsverzeichnis" then Warnlog "Text from document has wrong taken over : " + Verzeichniseintrag.GetText
   '/// Select as Level '4' ///
    Stufe.SetText "4"
   '/// Close dialog with 'OK'///
    EintragOK.Click
    EinfuegenSchliessen.Click

    Call wDokSchreiben "<End><Left>"
   try
   '/// Move cursors in word an select Edit / Index Entry ///
    EditIndexEntry
    Sleep 1
   '/// Check properties of Index Entry ///
    Kontext "VerzeichniseintragBearbeiten"
    if VerzeichniseintragBearbeiten.Exists then
     if Verzeichnis.IsEnabled then Warnlog "Index Field is enabled in Edit mode"
     if Verzeichniseintrag.GetText <> "Inhaltsverzeichnis" then Warnlog "Index Entry wrong :  "+ Verzeichniseintrag.GetText
     if Stufe.GetText <> "4" then Warnlog "Level wrong:  " + Stufe.GetText
     EintragOK.Click
    else
     Warnlog "Index Entry couldn't be edited -> Dialog's missing!"
    endif
   catch
    Warnlog "Index Entry couldn't be edited -> Menue Entry's missing!"
   '/// Close dialog ///
   endcatch


   '/// Insert / Indexes / Entry ( Alphabetical Index ) ///
  printlog "  - Alphabetical Index - Entry"
    Call wDokSchreiben "<End><Return>",2
   '/// Insert any text and select last word ///
    Call wDokSchreiben "Dies ist ein Eintrag fr's Stichwortverzeichnis<Shift Mod1 Left>"
   '/// Insert / Indexes / Entry ///
   InsertIndexesEntry
   Sleep 1
   Kontext "VerzeichniseintragEinfuegen"
   '/// In dialog select entry 'Alphabetical index' ///
   Verzeichnis.Select 2
   '/// Check if selected word has been correct entered in dialog ///
   if Verzeichniseintrag.GetText <> "Stichwortverzeichnis" then Warnlog "Text from Document is wrong: "+ Verzeichniseintrag.GetText
   Schluessel1.SetText "Dies ist der Schlssel"
   Schluessel2.SetText "Dies ist noch ein Schlssel"
   EintragOK.Click
   EinfuegenSchliessen.Click
   '/// Close dialog with 'Ok'///

   Call wDokSchreiben "<End><Left>"

 try
   '/// Move cursor into word and select Edit / Index / Entry ///
   EditIndexEntry
   Sleep 1
   '/// Check properties of entry made ///
   Kontext "VerzeichniseintragBearbeiten"
  if VerzeichniseintragBearbeiten.Exists then
   if Verzeichnis.IsEnabled then Warnlog "Index is enabled in Edit Mode"
   if Verzeichniseintrag.GetText <> "Stichwortverzeichnis" then Warnlog "Wrong Entry: "+Verzeichniseintrag.GetText
   if Schluessel1.GetSelText <> "Dies ist der Schlssel" then Warnlog "1st Key"
   if Schluessel2.GetSelText <> "Dies ist noch ein Schlssel" then Warnlog "2nd Key wrong"
   EintragOk.Click
   Kontext "VerzeichniseintragBearbeiten"
   if Verzeichniseintragbearbeiten.Exists then
    Warnlog "Index Entry Dialog could not be closed!"
    EinfuegenSchliessen.Click
   endif
  else
     Warnlog "Index Entry couldn't be edited -> Dialog's missing!"
  endif
 catch
  Warnlog "Index Entry couldn't be edited -> Menue Entry's missing!"
   '/// Close dialog ///
 endcatch

   '/// Insert / Indexes / Entry ( User-defined ) ///
 printlog "  - User-Defined - Entry"
   Call wDokSchreiben "<End><Return>",2
   '/// Insert any text and select last word ///
   Call wDokSchreiben "Dies wird ein Eintrag fr's Benutzerverzeichnis<Left>"

   '/// Insert / Indexes / Entry ///
   InsertIndexesEntry
   Kontext "VerzeichniseintragEinfuegen"
   '/// In dialog select 'User-defined' ///
   Verzeichnis.Select 3
   '/// Check if selected word has been correct entered in dialog ///
   if Verzeichniseintrag.GetText <> "Benutzerverzeichnis" then Warnlog "Text from Document is wrong: " + Verzeichniseintrag.GetText
   EintragOK.Click
   EinfuegenSchliessen.Click
   '/// Close dialog with 'Ok' ///

   Call wDokSchreiben "<End><Left>"
 try
   '/// Move cursor into word and select Edit / Index / Entry ///
   EditIndexEntry
   Sleep 1
   Kontext "VerzeichniseintragBearbeiten"
   '/// Check properties of entry made ///
  if VerzeichniseintragBearbeiten.Exists then
   if Verzeichnis.IsEnabled then Warnlog "Index is enabled in Edit Mode"
   if Verzeichniseintrag.GetText <> "Benutzerverzeichnis" then Warnlog "Entry wrong in Edit Mode"
   EintragOK.Click
  else
   Warnlog "Index Entry couldn't be edited -> Dialog's missing!"
  endif
 catch
   Warnlog "With opended dialog 'Insert Index Entry' the entry couldn't be edited -> Menue entry!"
 endcatch
   Kontext "VerzeichniseintragBearbeiten"
   if VerzeichniseintragBearbeiten.Exists then
    Warnlog "Dialog 'Insert Index Entry' has not been closed!"
    EinfuegenSchliessen.Click
   endif

   Kontext "VerzeichniseintragEinfuegen"
   if VerzeichniseintragEinfuegen.Exists then
    Warnlog "Dialog 'Insert Index Entry' has not been closed"
    EinfuegenSchliessen.Click
   endif
   Sleep 1
   '/// Close dialog and document ///
   Call hCloseDocument
endcase

' **********************************************************************

testcase tEditImageMap
Dim Holodeck(5,2)
   '/// Edit / Image Map ///
  printlog "- Edit / ImageMap"

   '/// New document ///
   hNewDocument
   '/// Insert graphic from file ( "...writer\input\misc\enter.bmp" ) ///
   if hGrafikEinfuegen (gtesttoolpath & "writer\input\misc\enter.bmp")=False then
    Warnlog "Graphic has not been inserted -> Test failed!"
    goto endsub
   endif
   '/// Edit / Image Map ///
   try
      EditImageMap
   catch
    Warnlog "Unable to execute: Edit / Image Map -> Test failed!"
    goto endsub
   endcatch
      Kontext "ImageMapEditor"
        if ImageMapEditor.notexists (5) then
          EditImageMap
            if ImageMapEditor.notexists (5) then
              warnlog "ImageMapEditor's not up"
               end if
            end if

      Kontext "TB_ImagemapEditor"
      Sleep 1
   '/// Draw an ellypse ///
      TB_ImagemapEditor.click Ellipse
      Kontext "DocumentImageMap"
      DocumentImageMap.Mousedown 42,50
      DocumentImageMap.MouseMove 0,0
      DocumentImageMap.MouseUp 0,0
      DocumentImageMap.Mousedown 21,50
      DocumentImageMap.MouseMove 21,100
      DocumentImageMap.MouseUp 21,100
   '/// Load Image Map 1 ( ...writer\input\misc\mapziel1.sdc )
        printlog "-  Load ImageMap 1"
        Kontext "ImageMapEditor"
        Adresse.Settext convertpath(gtesttoolpath & "writer\input\misc\mapziel1.sdc")
   '/// Insert any address and text ///
        Beschreibung.SetText ("Untertassensektion")
                  Holodeck(1,1) = Adresse.getseltext
                  Holodeck(1,2) = Beschreibung.gettext

      Kontext "TB_ImagemapEditor"
      Sleep 1
   '/// Draw a rectangle ///
      TB_ImagemapEditor.click Rechteck
      Kontext "DocumentImageMap"
      DocumentImageMap.Mousedown 42,33
      DocumentImageMap.MouseMove 100,0
      DocumentImageMap.MouseUp 100,0
   '/// Load Image Map 2 ( ...writer\input\misc\mapziel2.sdc )///
        printlog "-  Load ImageMap 2"
        Kontext "ImageMapEditor"
        Adresse.Settext convertpath(gtesttoolpath & "writer\input\misc\mapziel2.sdc")
   '/// Insert any address and text ///
        Beschreibung.SetText ("Steuerbord warpgondel")
                  Holodeck(2,1) = Adresse.getseltext
                  Holodeck(2,2) = Beschreibung.gettext

      Kontext "TB_ImagemapEditor"
      Sleep 1
   '/// Draw a rectangle ///
      TB_ImagemapEditor.click Rechteck
      Kontext "DocumentImageMap"
      DocumentImageMap.Mousedown 42,66
      DocumentImageMap.MouseMove 100,100
      DocumentImageMap.MouseUp 100,100
   '/// Laod Image Map 3///
        printlog "-  Load ImageMap 3"
        Kontext "ImageMapEditor"
        Adresse.Settext convertpath(gtesttoolpath & "writer\input\misc\mapziel3.sdc")
   '/// Insert any address and text ///
        Beschreibung.SetText ("Backbord Warpgondel")
                  Holodeck(3,1) = Adresse.getseltext
                  Holodeck(3,2) = Beschreibung.gettext

        sleep 3
      Kontext "TB_ImagemapEditor"
      Sleep 1
   '/// Draw a Polygon ///
      TB_ImagemapEditor.click Polygon
      Kontext "DocumentImageMap"
      DocumentImageMap.Mousedown 42,60
      DocumentImageMap.MouseMove 42,40
      DocumentImageMap.MouseUp 42,40
      DocumentImageMap.MouseMove 75,45
      DocumentImageMap.MouseDown 75,45
      DocumentImageMap.MouseUp 75,45
      DocumentImageMap.MouseMove 75,55
      DocumentImageMap.MouseDoubleClick 75,55
   '/// Load Image Map 4 ( ...writer\input\misc\mapziel1.sdc ) ///
        printlog "-  Load ImageMap 4"
        Kontext "ImageMapEditor"
        Adresse.Settext convertpath(gtesttoolpath & "writer\input\misc\mapziel4.sdc")
        Beschreibung.SetText ("Maschinendeck")
                  Holodeck(4,1) = Adresse.getseltext
                  Holodeck(4,2) = Beschreibung.gettext

   '/// Insert any address and text ///
        sleep 2
      Kontext "TB_ImagemapEditor"
      Sleep 1
      printlog "-  Edit Points"
   '/// Edit / Points ///
      TB_ImagemapEditor.click Punktebearbeiten
        sleep 3
      Kontext "TB_ImagemapEditor"
      printlog "-  Insert Points"
   '/// Insert Points ///
      TB_ImagemapEditor.click Punkteeinfuegen
      Kontext "DocumentImageMap"
      DocumentImageMap.MouseDown 75,50
      DocumentImageMap.MouseUp 75,50
      sleep 3
      Kontext "TB_ImagemapEditor"
   '/// Move Points ///
      printlog "-  Move Points"
      try
       TB_ImagemapEditor.click Punkteverschieben
      catch
       Warnlog "Move Points is disabled!"
      endcatch
      Kontext "DocumentImageMap"
      DocumentImageMap.MouseDown 75,50
      DocumentImageMap.MouseMove 80,50
      DocumentImageMap.MouseUp 80,50
        sleep 2
   '/// Edit Points ///
      Kontext "TB_ImagemapEditor"
      try
       TB_ImagemapEditor.click Punktebearbeiten
      catch
       Warnlog "Edit-Points is disabled!"
      endcatch
      sleep 2
      Kontext "TB_ImagemapEditor"
   '/// Draw a freeform polygon ///
      printlog "-  Freeform Polygon"
      Sleep 1
      try
       TB_ImagemapEditor.click Freihandpolygon
      catch
       Warnlog "Freeform Polygon is disabled!"
      endcatch
      Kontext "DocumentImageMap"
      DocumentImageMap.MouseDown 82,34
      DocumentImageMap.MouseMove 100,34
      DocumentImageMap.MouseMove 100,65
      DocumentImageMap.MouseMove 82,65
      DocumentImageMap.MouseUp 82,65
      Kontext "ImageMapEditor"
   '/// Insert any address and text ///
      try
       Adresse.Settext convertpath(gtesttoolpath & "writer\input\misc\mapziel4.sdc")
      catch
       warnlog "Adress seems to be disabled!"
      endcatch
      try
       Beschreibung.SetText ("Leer")
      catch
       Warnlog "Description seems to be disabled!"
      endcatch
        Holodeck(5,1) = Adresse.getseltext
        Holodeck(5,2) = Beschreibung.gettext

        sleep 3
   '/// Close Image Map editor///
       ImageMapEditor.Close
        Kontext
        if active.exists then
          Active.yes
        end if
   Sleep 10
   '/// Save document and close it ///
  if gApplication = "WRITER" then
   Call hSpeichernUnterKill (convertpath(gOfficepath & "user\work\imagemap.sxw"))
  else
   Call hSpeichernUnterKill (convertpath(gOfficepath & "user\work\imagemap.sxg"))
  endif
  Sleep 2
  call hCloseDocument

    printlog "- check settings"
   '/// Open previous saved document ///
   if gApplication = "WRITER" then
    Call hDateiOeffnen (convertpath(gOfficepath & "user\work\imagemap.sxw")
   else
    Call hDateiOeffnen (convertpath(gOfficepath & "user\work\imagemap.sxg")
   endif

   Call wDocSetContext
   '/// Edit / Image Map and check previous saved Image Map properties ///
   try
    EditImageMap
   catch
    Warnlog "Edit / ImageMap is disabled. Maybe graphic is not selected after reload!"
    Call hCloseDocument
    goto endsub
   endcatch
   Kontext "ImageMapEditor"
     if ImageMapEditor.notexists (5) then
       EditImageMap
         if ImageMapEditor.notexists (5) then
           warnlog "ImageMapEditor's not up"
           Call hCloseDocument
           goto endsub
         end if
     end if

  Kontext "TB_ImagemapEditor"
  Kontext "DocumentImageMap"
    DocumentImageMap.Mousedown 21,50
    DocumentImageMap.MouseUp 21,50
      Kontext "ImageMapEditor"
          if Ucase(Holodeck(1,1)) = Ucase(Adresse.getseltext) then
            Printlog "-  Adress 1 is after saving and reloading correct"
          else
                Warnlog "-  Adress 1 is after saving and reloading incorrect: " & Adresse.getseltext & " statt " &  Holodeck(1,1)
          end if
          if Holodeck(1,2) = Beschreibung.gettext then
                Printlog "-  Description 1 is after saving and reloading correct"
          else
                Warnlog "-  Description 1 is after saving and reloading incorrect: " & Beschreibung.gettext & " statt " & Holodeck(1,2)
          end if

  Kontext "DocumentImageMap"
    DocumentImageMap.Mousedown 50,30
    DocumentImageMap.MouseUp 50,30
      Kontext "ImageMapEditor"
          if Ucase(Holodeck(2,1)) = Ucase(Adresse.getseltext) then
            Printlog "-  Adress 2 is after saving and reloading correct"
          else
                Warnlog "-  Adress 2 is after saving and reloading incorrect: " & Adresse.getseltext & " statt " &  Holodeck(2,1)
          end if
          if Holodeck(2,2) = Beschreibung.gettext then
                Printlog "-  Description 2 is after saving and reloading correct"
          else
                Warnlog "-  Description 2 is after saving and reloading incorrect: " & Beschreibung.gettext & " statt " & Holodeck(2,2)
          end if

  Kontext "DocumentImageMap"
    DocumentImageMap.Mousedown 50,70
    DocumentImageMap.MouseUp 50,70
      Kontext "ImageMapEditor"
          if Ucase(Holodeck(3,1)) = Ucase(Adresse.getseltext) then
            Printlog "-  Adress 3 is after saving and reloading correct"
          else
                Warnlog "-  Adress 3 is after saving and reloading incorrect: " & Adresse.getseltext & " statt " &  Holodeck(3,1)
          end if
          if Holodeck(3,2) = Beschreibung.gettext then
                Printlog "-  Description 3 is after saving and reloading correct"
          else
                Warnlog "-  Description 3 is after saving and reloading incorrect: " & Beschreibung.gettext & " statt " & Holodeck(3,2)
          end if

  Kontext "DocumentImageMap"
    DocumentImageMap.Mousedown 50,50
    DocumentImageMap.MouseUp 50,50
      Kontext "ImageMapEditor"
          if UCase(Holodeck(4,1)) = Ucase(Adresse.getseltext) then
            Printlog "-  Adress 4 is after saving and reloading correct"
          else
                Warnlog "-  Adress 4 is after saving and reloading incorrect: " & Adresse.getseltext & " statt " &  Holodeck(4,1)
          end if
          if Holodeck(4,2) = Beschreibung.gettext then
                Printlog "-  Description 4 is after saving and reloading correct"
          else
                Warnlog "-  Description 4 is after saving and reloading incorrect: " & Beschreibung.gettext & " statt " & Holodeck(4,2)
          end if

  Kontext "DocumentImageMap"
    DocumentImageMap.Mousedown 99,50
    DocumentImageMap.MouseUp 99,50
      Kontext "ImageMapEditor"
          if UCase(Holodeck(5,1)) = UCase(Adresse.getseltext) then
            Printlog "-  Adress 5 is after saving and reloading correct"
          else
                Warnlog "-  Adress 5 is after saving and reloading incorrect: " & Adresse.getseltext & " statt " &  Holodeck(5,1)
          end if
          if Holodeck(5,2) = Beschreibung.gettext then
                Printlog "-  Description 5 is after saving and reloading correct"
          else
                Warnlog "-  Description 5 is after saving and reloading incorrect: " & Beschreibung.gettext & " statt " & Holodeck(5,2)
          end if

    Kontext "ImageMapEditor"
    ImageMapEditor.Close
      Kontext
      if active.exists then
        Active.no
      end if

   '/// Close Image Map Editor and document ///
    Call hCloseDocument

endcase
