'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_104b_.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:26:33 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :
'*
'\***********************************************************************


sub w_104b_
    printLog Chr(13) + "---------   Level 1  - Menu / Insert Part 3 -   ----------"

    Call tInsertEnvelope

    Call tInsertObjectOLEObject
    Call tInsertObjectPlugIn
    Call tInsertObjectChart
    Call tInsertFormula
    Call tInsertFloatingFrame
    Call tInsertFile

    Call tInsertIndexesEntry
    Call tInsertIndexesTableOfContents
    Call tInsertIndexesAlphabeticalIndex
    Call tInsertIndexesUserDefined

end sub

'***********************************************************************

testcase tInsertEnvelope
    printlog "- Insert / Envelope"
    '/// New writerdocument ///

    Call hNewDocument
    '/// Call Insert / Envelope and create an envelope///
    InsertEnvelope

    Kontext
    Active.Setpage TabEnvelope
    Kontext "TabEnvelope"
    Addressee.TypeKeys "An<Return>", true
    Addressee.TypeKeys "QS-Writer-Team<Return>", true
    Addressee.TypeKeys "Sachsenfeld 4<Return>", true
    Addressee.TypeKeys "20097 Hamburg", true

    Kontext
    Active.Setpage TabFormatEnvelope
    Kontext "TabFormatEnvelope"
    SizeFormat.Select 2            ' DIN A4
    AddresseeEdit.Click
    Sleep 1
    Call hMenuSelectNr(1)
    Sleep 2

    Kontext
    Active.Setpage TabFont
    Kontext "TabFont"
    try
        StyleWest.Settext "Arial"
    catch
        Style.Settext "Arial"
    endcatch
    Kontext
    Active.Setpage TabFontEffects
    Kontext "TabFontEffects"
    FontColor.Select 11
    Outline.check
    TabFontEffects.Ok

    Kontext "TabFormatEnvelope"
    SenderEdit.Click
    Sleep 1
    Call hMenuSelectNr(1)
    Sleep 2
    Kontext
    Active.Setpage TabFontEffects
    Kontext "TabFontEffects"
    FontColor.Select 7
    TabFontEffects.Ok

    Kontext
    Active.Setpage TabEnvelope
    Kontext "TabEnvelope"
    Insert.Click

    '/// Save document, close and reload previous saved document///
    if gApplication = "WRITER" then
        Call hSpeichernUnterKill (gOfficepath+"user\work\envelope.sxw")
    else
        Call hSpeichernUnterKill (gOfficepath+"user\work\envelope.sxg")
    endif
    Sleep 2
    Call hCloseDocument
    Sleep 2
    if gApplication = "WRITER" then
        Call hDateiOeffnen (gOfficepath+"user\work\envelope.sxw")
    else
        Call hDateiOeffnen (gOfficepath+"user\work\envelope.sxg")
    endif
    InsertEnvelope

    Kontext
    Active.Setpage TabEnvelope
    Kontext "TabEnvelope"
    TabEnvelope.Cancel

    Sleep 2

    Call hCloseDocument
endcase

'***********************************************************************

testcase tInsertObjectOLEObject
    Dim i : Dim Zaehler as Integer : Dim ObjektName
    PrintLog "- Insert / Object / OLE-Object"
    '/// New writerdocument
    Call hNewDocument
    '/// Insert - Object - Ole Object
    InsertObjectOLEObject
    Kontext "OLEObjektEinfuegen"
    NeuErstellen.Check
    Zaehler = Objekttyp.GetItemCount
    ObjektName = ""
    printlog "  - " & ( Zaehler ) & " create internal OLE-Object, external Object without function in testtool!"
    '/// Count number of objects (current 7)
    if gPlatgroup ="unx" then
        if (Zaehler) > 7 then Warnlog "- Cool, new Ole Objects, now " + Zaehler + " instead of 7"
    else
        if (Zaehler) > 7 then Warnlog "- Cool, new Ole Objects, now " + Zaehler + " instead of 7"
    endif
    wait 500
    OLEObjektEinfuegen.OK
    '/// Insert every Ole object one time
    Call hCloseDocument
    for i = 1 to 5
        Sleep 5
        Call hNewDocument
        Sleep 2
        InsertObjectOLEObject
        Kontext "OLEObjektEinfuegen"
        wait 500
        Objekttyp.Select i
        ObjektName = Objekttyp.GetSelText
        printlog "-  " + ObjektName
        OLEObjektEinfuegen.OK
        Sleep 5
        Kontext "Active"
        if Active.Exists then
            if Active.GetRT = 304 then
                Warnlog Active.Gettext
                Active.Ok
            endif
        endif
        Sleep 2
        Call wDokSchreiben "<Escape>"
        Sleep 1
        Call hCloseDocument
    next i

    printlog "  - From File"
    '/// Create Ole object from file
    Call hNewDocument
    InsertObjectOLEObject
    Kontext "OLEObjektEinfuegen"
    wait 500
    AusDateiErstellen.Check
    Sleep 2
    if gApplication = "WRITER" then
        OleDatei.Settext ConvertPath(gTesttoolPath + "writer\input\st1_1.sxw")
    else
        OleDatei.Settext ConvertPath(gTesttoolPath + "writer\level1\input\masterdoc\st1_1.sxg")
    endif
    OLEObjektEinfuegen.OK
    Sleep 2

    Call hCloseDocument
    '/// Close document
endcase

'***********************************************************************

testcase tInsertObjectPlugIn
    PrintLog "- Insert / Object / Plug-In"
    Call hNewDocument

    InsertObjectPlugIn
    Kontext "PlugInEinfuegen"
    DateiUrl.SetText ConvertPath ( gTesttoolPath + "writer\input\misc\notify.wav" )
    PlugInEinfuegen.OK
    Sleep 10
    Call hCloseDocument
endcase

'***********************************************************************

testcase tInsertObjectChart
    Dim i as Integer
    Dim Zahl
    PrintLog "- Insert / Object / Chart"
    '/// Insert / Object / Chart ///

    Call hNewDocument
    Call hTabelleEinfuegen
    '///+ Insert a table and enter some numbers in table ///
    for i=1 to 10
        Zahl = Str ( (i+2)*i )
        Call wDokSchreiben zahl
        Call wDokSchreiben "<Right>"
    next i
    Call wDokSchreiben "<Up><Up>"

    PrintLog "  - Table with Numbers"
    InsertObjectChart
    '/// Insert Chart depending on table values ///
    Kontext "AutoformatDiagramm1"
    Sleep 2
    ErsteReihe.UnCheck
    ErsteSpalte.UnCheck
    Weiter.Click
    Kontext "AutoformatDiagramm2"
    wait 500
    Diagrammtyp.TypeKeys "<Down>", 2
    Weiter.Click
    Kontext "AutoformatDiagramm3"
    wait 500
    Variante.TypeKeys "<Right>", 6
    Fertigstellen.Click
    Sleep 2
    Call gMouseClick (1,1)
    Sleep 3

    PrintLog "  - Table including text"
    '/// Insert a table including text ///
    Call wDokSchreiben "<Down>", 5
    Sleep 1
    Call hTabelleEinfuegen
    for i=1 to 10
        Call wDokSchreiben "Hallo<Right>"
    next i
    Call wDokSchreiben "<Up><Up>"
    InsertObjectChart
    '/// Insert a chart depending on values in table ///
    Kontext "AutoformatDiagramm1"
    wait 500
    ErsteReihe.UnCheck
    ErsteSpalte.UnCheck
    Weiter.Click
    Kontext "AutoformatDiagramm2"
    wait 500
    Diagrammtyp.TypeKeys "<Down><Right>", 1
    Weiter.Click
    Kontext "AutoformatDiagramm3"
    wait 500
    Variante.TypeKeys "<Right>", 2
    Fertigstellen.Click
    Sleep 2

    PrintLog "  - Table without entry"
    '/// Insert a table without values ///
    Call gMouseClick 1,1
    Sleep 3
    Call wDokSchreiben "<Down>", 10
    Call hTabelleEinfuegen
    Call wDocSetContext
    '/// Insert / Object chart and close dialog ///
    InsertObjectChart
    Kontext "AutoformatDiagramm1"
    Sleep 1
    Bereich.TypeKeys "<End>"
    Bereich.TypeKeys "<Left><Backspace>"
    Bereich.TypeKeys "1"                          ' Autopilot crashed here
    Sleep 1
    try
        Fertigstellen.Click
    catch
        AutoformatDiagramm1.Cancel
    endcatch
    Sleep 2

    '/// Close document ///
    Call hCloseDocument
endcase

'***********************************************************************

testcase tInsertFormula
    PrintLog "- Insert / Formula"
    '/// Insert a formula in writerdocument ///

    Call hNewDocument
    InsertObjectFormulaWriter
    Sleep 2
    SetClipboard "a+b = c"
    '/// Check if formula has been inserted ///
    wait 500
    Kontext
    try
        EditPaste
    catch
        Warnlog "Unable to execute Edit / Paste!"
    endcatch
    Sleep 10
    Call gMouseClick 1, 1
    Sleep 2

    '/// Close document ///
    Call hCloseDocument
endcase

'***********************************************************************

testcase tInsertFloatingFrame
    Dim Brei : Dim Hoeh
    PrintLog "- Insert / Floating Frame"

    Call hNewDocument
    '/// Open new document ///
    InsertFloatingFrame
    '/// Insert / Floating Frame and change properties///
    Kontext "TabEigenschaften"
    FrameName.SetText "Hallo"
    Inhalt.SetText ConvertPath ( gTesttoolPath+"writer\input\misc\frameset.htm" )
    '/// Choose as floating frame "..writer\input\misc\frameset.htm" ///
    Aus.Check
    UmrandungAus.Check
    BreiteStandard.Uncheck
    Breite.SetText "12"
    HoeheStandard.Uncheck
    Hoehe.SetText "4"
    Brei = Breite.GetText
    Hoeh = Hoehe.GetText
    TabEigenschaften.OK
    Sleep 2

    '/// Check frame propties after closing and reopening properties ///

    printlog "  - check Frame properties"
    Edit
    Kontext "TabEigenschaften"
    if FrameName.GetText <> "Hallo" then Warnlog "Name is wrong"
    if NOT Aus.IsChecked then Warnlog "Scrollbar is not checked"
    if BreiteStandard.IsChecked then
        Warnlog "Width has standard value"
    else
        if Breite.GetText <> Brei then Warnlog "Wrong width : "+ Breite.GetText
    end if
    if HoeheStandard.IsChecked then
        Warnlog "Height has standard value"
    else
        if Hoehe.GetText <> Hoeh then Warnlog "Wrong height : " + Hoehe.GetText
    end if
    TabEigenschaften.Cancel

    Call hSpeichernUnterKill (gOfficepath + "user\work\FloatingFrame.sxw")
    Sleep 2
    Call hCloseDocument
    Sleep 2
    Call hDateiOeffnen ConvertPath(gOfficepath + "user\work\FloatingFrame.sxw")
    Sleep 2

    '/// Check frame propties after saving and reopening document ///
    printlog "  - check Frame properties (saved document)"
    Edit
    Kontext "TabEigenschaften"
    if FrameName.GetText <> "Hallo" then Warnlog "Name is wrong"
    if NOT Aus.IsChecked then Warnlog "Scrollbar is not checked"
    if BreiteStandard.IsChecked then
        Warnlog "Width has standard value"
    else
        if Breite.GetText <> Brei then Warnlog "Wrong width : "+ Breite.GetText
    end if
    if HoeheStandard.IsChecked then
        Warnlog "Height has standard value"
    else
        if Hoehe.GetText <> Hoeh then Warnlog "Wrong height : " + Hoehe.GetText
    end if
    TabEigenschaften.Cancel

    Sleep 1

    Call hCloseDocument

endcase

'***********************************************************************

testcase tInsertFile
    Dim i as Integer  : Dim AlterWert as String
    PrintLog "- Insert / File"
    '/// New writerdocument and select Insert / File /Writer ///
    Call hNewDocument
    InsertFileWriter
    Kontext "OeffnenDlg"
    '/// Insert as file: "..\writer\level1\input\st1_1.sxw" ///
    if gApplication = "WRITER" then
        Dateiname.Settext ConvertPath( gTesttoolPath + "writer\input\st1_1.sxw" )
    else
        Dateiname.Settext ConvertPath( gTesttoolPath + "writer\level1\input\masterdoc\st1_1.sxg" )
    endif
    Oeffnen.Click
    Sleep 5
    Kontext "Active"
    if Active.Exists then
        if Active.getRT = 304 then
            Warnlog Active.Gettext
            Active.Ok
        endif
    endif
    Kontext "Navigator"
    if Navigator.NotExists then EditNavigator
    '/// Check if document has been inserted ///
    Call wNavigatorAuswahl(5,1)
    wait 500

    try
        FormatObjekt
        wait 500
        Kontext
        Active.Setpage TabType
        Kontext "TabType"
        TabType.Cancel
    catch
        Warnlog "Document has not been inserted!"
    endcatch
    '/// Close document ///
    Call hCloseDocument
endcase

' ***********************************************************************

testcase tInsertIndexesEntry
    printlog "- Create entries to generate index!"
    Dim MeinName as string, i as integer
    '/// Open file ../input/writer/stufe1/verzeichnis/verzeichnis.sxw ///
    if gApplication = "WRITER" then
        Call hDateiOeffnen(gTesttoolpath + "writer\level1\input\verzeichnis\verzeichnis.sxw")
    else
        Call hDateiOeffnen(gTesttoolpath + "writer\level1\input\masterdoc\verzeichnis\verzeichnis.sxg")
    endif
    Sleep 5

    Call wDokSchreiben "<Mod1 Shift Right>" , 2   'Artstar Custom
    EditCopy
    '/// Insert 11 Index entrys for a user-definded index ///
    InsertIndexesEntry
    Kontext "VerzeichniseintragEinfuegen"
    if GetClipBoardtext <> Verzeichniseintrag.Gettext then Warnlog "- 1. Entry is not correct!"
    EintragNeu.Click
    Kontext "BenutzerverzeichnisDefinieren"
    NameBenutzerverzeichnis.Settext "Mein Verzeichnis"
    BenutzerverzeichnisDefinieren.Ok

    Kontext "VerzeichniseintragEinfuegen"
    if Verzeichnis.GetSelText <> "Mein Verzeichnis" then
        Warnlog "Indexname is not correct!"
        Verzeichnis.Select 3
    endif
    MeinName = Verzeichnis.GetSelText
    EintragOk.Click

    MachMirDenEintrag(8,2)        ' Artstar Esprit
    MachMirDenEintrag(7,2)        ' Artstar II
    MachMirDenEintrag(7,1)        ' Artstar
    MachMirDenEintrag(4,1)        ' Fibrestar
    MachMirDenEintrag(9,1)        ' Granstar
    MachMirDenEintrag(3,2)        ' Granstar Custom
    MachMirDenEintrag(6,2)        ' Granstar II
    MachMirDenEintrag(5,1)        ' Imperialstar
    MachMirDenEintrag(3,2)        ' Rockstar DX
    MachMirDenEintrag(4,2)        ' Rockstar Pro

    Call wDocSetContext
    EditCopy
    if GetClipBoardtext <> "Rockstar Pro " then Warnlog "- 10. Entry is not correct!"
    Call wDokSchreiben "<PageUp>",4
    Kontext "VerzeichniseintragEinfuegen"
    EinfuegenSchliessen.Click
    Call wDokSchreiben "<Home>"
    '/// Save document, close it and reload previous saved document ///
    if gApplication = "WRITER" then
        Call hSpeichernUnterKill(gOfficepath + "user\work\verzeih.sxw")
    else
        Call hSpeichernUnterKill(gOfficepath + "user\work\verzeih.sxg")
    endif
    Sleep 10
    FileClose
    Sleep 1
    if gApplication = "WRITER" then
        Call hDateiOeffnen(gOfficepath + "user\work\verzeih.sxw")
    else
        Call hDateiOeffnen(gOfficepath + "user\work\verzeih.sxg")
    endif
    Sleep 2
    for i = 1 to 11
        Call wDokSchreiben "<PageUp>"
        wait 500
    next i
    Call wDokSchreiben "<Up>",2
    Call wDokSchreiben "<Right>"

    '/// Check created index entries ///
    printlog "- check created Index entries (Load/Save)"
    for i = 1 to 11
        Call wDokSchreiben "<PageUp>"
        wait 500
    next i
    Call wDokSchreiben "<Up>", 5

    EditIndexEntry
    Kontext "VerzeichniseintragBearbeiten"
    if Verzeichniseintrag.Gettext <> "Artstar Custom " then Warnlog "1. Entry is wrong"
    Naechster.Click
    if Verzeichniseintrag.Gettext <> "Artstar Esprit " then Warnlog "2. Entry is wrong"
    Naechster.Click
    if Verzeichniseintrag.Gettext <> "Artstar II " then Warnlog "3. Entry is wrong"
    Naechster.Click
    if Verzeichniseintrag.Gettext <> "Artstar " then Warnlog "4. Entry is wrong"
    Naechster.Click
    if Verzeichniseintrag.Gettext <> "Fibrestar " then Warnlog "5. Entry is wrong"
    Naechster.Click
    if Verzeichniseintrag.Gettext <> "Granstar " then Warnlog "6. Entry is wrong"
    Naechster.Click
    if Verzeichniseintrag.Gettext <> "Granstar Custom " then Warnlog "7. Entry is wrong"
    Naechster.Click
    if Verzeichniseintrag.Gettext <> "Granstar II " then Warnlog "8. Entry is wrong"
    Naechster.Click
    if Verzeichniseintrag.Gettext <> "Imperialstar " then Warnlog "9. Entry is wrong"
    Naechster.Click
    if Verzeichniseintrag.Gettext <> "Rockstar DX " then Warnlog "10. Entry is wrong"
    Naechster.Click
    if Verzeichniseintrag.Gettext <> "Rockstar Pro " then Warnlog "11. Entry is wrong"
    BearbeitenSchliessen.Click
    Sleep 2
    '/// Close document ///
    Call hCloseDocument
endcase

' ***********************************************************************

testcase tInsertIndexesTableOfContents
    Dim i as integer
    PrintLog "- First Time / Create Entrys!"
    '/// Open document ../input/writer/stufe1/verzeichnis/verzeichnis.sxw ///
    if gApplication = "WRITER" then
        Call hDateiOeffnen(gTesttoolpath + "writer\level1\input\verzeichnis\verzeichnis.sxw")
    else
        Call hDateiOeffnen(gTesttoolpath + "writer\level1\input\masterdoc\verzeichnis\verzeichnis.sxg")
    endif
    InsertIndexesEntry
    Kontext "VerzeichniseintragEinfuegen"
    Verzeichnis.Select 1
    '/// Insert 11 index entrys ///

    MachMirDenEintrag(0,2)        ' Artstar Custom
    MachMirDenEintrag(8,2)        ' Artstar Esprit
    MachMirDenEintrag(7,2)        ' Artstar II
    MachMirDenEintrag(7,1)        ' Artstar
    MachMirDenEintrag(4,1)        ' Fibrestar
    MachMirDenEintrag(9,1)        ' Granstar
    MachMirDenEintrag(3,2)        ' Granstar Custom
    MachMirDenEintrag(6,2)        ' Granstar II
    MachMirDenEintrag(5,1)        ' Imperialstar
    MachMirDenEintrag(3,2)        ' Rockstar DX
    MachMirDenEintrag(4,2)        ' Rockstar Pro

    Kontext "VerzeichniseintragEinfuegen"
    EinfuegenSchliessen.Click
    Call wDokSchreiben "<Home>"
    For i = 1 to 4
        Call wDokSchreiben "<PageDown>"
        wait 500
    next i
    InsertManualBreak
    Kontext "UmbruchEinfuegen"
    Seitenumbruch.Check
    UmbruchEinfuegen.Ok
    Call wDocSetContext

    '/// Create index with entries made ///
    printlog "- Create Index"
    InsertIndexes
    Sleep 1
    Kontext "Active"
    if Active.GetRT = 304 then Active.Ok
    Sleep 1
    Kontext
    Active.Setpage TabVerzeichnisseVerzeichnis
    Kontext "TabVerzeichnisseVerzeichnis"
    VerzeichnisTyp.Select 1
    VerzeichnisTitel.Settext "Mein Inhaltsverzeichnis"
    if Not VerzeichnisGeschuetzt.IsChecked then
        Warnlog "Protected against manual changes is not checked by default!"
    else
        VerzeichnisGeschuetzt.UnCheck
    endif
    ErzeugenAusGliederung.Check
    ErzeugenAusMarkierungen.Check
    TabVerzeichnisseVerzeichnis.Ok

    '/// Check created index ///
    printlog "- check index"
    Call wDokSchreiben "<Mod1 Shift Right>"
    EditCopy
    if GetClipBoardtext <> "Mein " then Warnlog "Indexname is wrong : -> " + GetClipBoardtext
    Call wDokSchreiben "<Home><Down>"
    Call wDokSchreiben "<Mod1 Shift Right>",2
    EditCopy
    if Left$(GetClipBoardtext,14) <> "Artstar Custom" then Warnlog "1. Entry wrong -> " + GetClipBoardtext
    Call wDokSchreiben "<End>"
    Call wDokSchreiben "<Shift Left>"
    EditCopy
    if GetClipBoardtext <> "1" then Warnlog "Pagenumber: 1. Entry is wrong!"
    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<Down>" , 3
    Call wDokSchreiben "<Mod1 Shift Right>"
    EditCopy
    if Left$(GetClipBoardtext,7) <> "Artstar" then Warnlog "4. Entry is wrong -> " + GetClipBoardtext
    Call wDokSchreiben "<End>"
    Call wDokSchreiben "<Shift Left>"
    EditCopy
    if GetClipBoardtext <> "2" then Warnlog "Pagenumber: 4. Entry is wrong!"
    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<Down>" , 3
    Call wDokSchreiben "<Mod1 Shift Right>",2
    EditCopy
    if Left$(GetClipBoardtext,15) <> "Granstar Custom" then Warnlog "7. Entry is wrong -> " + GetClipBoardtext
    Call wDokSchreiben "<End>"
    Call wDokSchreiben "<Shift Left>"
    EditCopy
    if GetClipBoardtext <> "3" then Warnlog "Pagenumber 7. Enry is wrong!"
    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<Down>" , 4
    Call wDokSchreiben "<Mod1 Shift Right>",2
    EditCopy
    if Left$(GetClipBoardtext,12) <> "Rockstar Pro" then Warnlog "11. Entry is wrong -> " + GetClipBoardtext
    Call wDokSchreiben "<End>"
    Call wDokSchreiben "<Shift Left>"
    EditCopy
    if GetClipBoardtext <> "4" then Warnlog "Pagenumber 11. Entry is wrong!"
    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<Up>" , 11

    printlog "- format Index!"
    InsertIndexes
    Sleep 1
    Kontext "Active"
    if Active.GetRT = 304 then Active.Ok
    Sleep 1
    Kontext
    Active.Setpage TabVerzeichnisseVerzeichnis
    Kontext "TabVerzeichnisseVerzeichnis"
    Verzeichnistitel.Settext "Mein schnes Inhaltsverzeichnis"
    Kontext
    Active.Setpage TabVerzeichnisseEintraege
    Kontext "TabVerzeichnisseEintraege"
    Sleep 2
    AufbauText.TypeKeys "<Right>"
    AufbauAuswahl.TypeKeys "<Right>"
    AufbauText.TypeKeys "<Right>"

    TabVerzeichnisseEintraege.Ok
    '/// Save document, close it and load previous saved document ///
    if gApplication = "WRITER" then
        Call hSpeichernUnterKill (gOfficepath+"user\work\inhalts.sxw")
    else
        Call hSpeichernUnterKill (gOfficepath+"user\work\inhalts.sxg")
    endif
    Sleep 2
    Call hCloseDocument
    Sleep 2
    if gApplication = "WRITER" then
        Call hDateiOeffnen (gOfficepath+"user\work\inhalts.sxw")
    else
        Call hDateiOeffnen (gOfficepath+"user\work\inhalts.sxg")
    endif
    Call wNavigatorAuswahl(10,1)

    '/// Check Index in saved document ///
    printlog "- check Index (Save/Load)"
    InsertIndexes
    Sleep 1
    Kontext "Active"
    if Active.GetRT = 304 then Active.Ok
    Sleep 1
    Kontext
    Active.Setpage TabVerzeichnisseVerzeichnis
    Kontext "TabVerzeichnisseVerzeichnis"
    if VerzeichnisGeschuetzt.IsChecked then Warnlog "Checkbox 'Protected against manual changes' is checked!"
    VerzeichnisGeschuetzt.UnCheck
    if Verzeichnistitel.Gettext <> "Mein schnes Inhaltsverzeichnis" then Warnlog "Titel des Inhaltsverzeichnisses falsch!"
    TabVerzeichnisseVerzeichnis.Cancel

    Call wDokSchreiben "<Mod1 Shift Right>",3
    EditCopy
    if GetClipBoardtext <> "Mein schnes Inhaltsverzeichnis" then Warnlog "The name of the index is wrong -> " + GetClipBoardtext
    Call wDokSchreiben "<Home><Down>"
    Call wDokSchreiben "<Mod1 Shift Right>",2
    EditCopy
    if Left$(GetClipBoardtext,14) <> "Artstar Custom" then Warnlog "1. Entry is wrong -> " + GetClipBoardtext
    Call wDokSchreiben "<End>"
    Call wDokSchreiben "<Shift Left>"
    EditCopy
    if GetClipBoardtext <> "1" then Warnlog "Pagenumber: 1. Entry is wrong!"
    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<Down>" , 3
    Call wDokSchreiben "<Mod1 Shift Right>"
    EditCopy
    if Left$(GetClipBoardtext,7) <> "Artstar" then Warnlog "4. Entry is wrong -> " + GetClipBoardtext
    Call wDokSchreiben "<End>"
    Call wDokSchreiben "<Shift Left>"
    EditCopy
    if GetClipBoardtext <> "2" then Warnlog "Pagenumber 4. Entry is wrong!"
    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<Down>" , 3
    Call wDokSchreiben "<Mod1 Shift Right>",2
    EditCopy
    if Left$(GetClipBoardtext,15) <> "Granstar Custom" then Warnlog "7. Entry is wrong -> " + GetClipBoardtext
    Call wDokSchreiben "<End>"
    Call wDokSchreiben "<Shift Left>"
    EditCopy
    if GetClipBoardtext <> "3" then Warnlog "Pagenumber: 7. Entry is wrong!"
    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<Down>" , 4
    Call wDokSchreiben "<Mod1 Shift Right>",2
    EditCopy
    if Left$(GetClipBoardtext,12) <> "Rockstar Pro" then Warnlog "11. Entry is wrong -> " + GetClipBoardtext
    Call wDokSchreiben "<End>"
    Call wDokSchreiben "<Shift Left>"
    EditCopy
    if GetClipBoardtext <> "4" then Warnlog "Pagenumber 11. Entry is wrong!"
    Call wDokSchreiben "<Home>"
    '/// Close document ///
    Call hCloseDocument
endcase

' ***********************************************************************

testcase tInsertIndexesAlphabeticalIndex
    Dim WelchesVerzeichnis as String, i as integer, dasIsses as string
    Dim Buchstabe as string, Buchstaben as string
    Select case iSystemSprache
        case 01     : Buchstabe= "p."
                    : Buchstaben = "pp."
        case 03     : Buchstabe= "seg"
                    : Buchstaben = "segs"
        case 31     : Buchstabe = "e.v."
                    : Buchstaben = "e.v."
        case 33     : Buchstabe = "suivante"
                    : Buchstaben = "suivantes"
        case 34     : Buchstabe = "seg"
                    : Buchstaben = "segs"
        case 39     : Buchstabe = "seg"
                    : Buchstaben = "segg"
        case 45     : Buchstabe= "f."
                    : Buchstaben = "ff"
        case 46     : Buchstabe= "f."
                    : Buchstaben = "ff"
        case 48     : Buchstabe = "p."
                    : Buchstaben = "pp."
        case 49     : Buchstabe = "f."
                    : Buchstaben = "ff."
        case else   : Warnlog "Language adjustment for " + iSprache +" is missing"
                    : Buchstabe = "p."
                    : Buchstaben = "pp."
                    : goto endsub
    end select

    '/// Open document ...input/writer/stufe1/verzeichnis/verzeichnis.sxw ///

    printlog "-  create Index entrys"
    if gApplication = "WRITER" then
        Call hDateiOeffnen(gTesttoolpath + "writer\level1\input\verzeichnis\verzeichnis.sxw")
    else
        Call hDateiOeffnen(gTesttoolpath + "writer\level1\input\masterdoc\verzeichnis\verzeichnis.sxg")
    endif
    for i= 1 to 10
        try
            InsertIndexesEntry
            i = 11
        catch
            Sleep 1
        endcatch
    next i
    '/// Create index entrys ///
    Kontext "VerzeichniseintragEinfuegen"
    Verzeichnis.Select 2
    if Verzeichniseintrag.Gettext <> "Artstar" then
        Call wDokSchreiben "<Up><Home>"
        Call wDokSchreiben "<Right>"
        Kontext "VerzeichniseintragEinfuegen"
        Verzeichniseintrag.TypeKeys "<Up>"
    endif
    if Verzeichniseintrag.Gettext <> "Artstar" then Warnlog "1. Entry has been selected wrong"
    Haupteintrag.Check
    AufAlleGleichenAnwenden.Check
    EintragOk.Click

    Call wDokSchreiben "<Mod1 Right>",2
    Call wDokSchreiben "<Right>"
    Kontext "VerzeichniseintragEinfuegen"
    wait 500
    Verzeichniseintrag.TypeKeys "<Up>"
    if Verzeichniseintrag.Gettext <> "drums" then
        EinfuegenSchliessen.Click
        InsertIndexesEntry
        Kontext "VerzeichniseintragEinfuegen"
        AufAlleGleichenAnwenden.Check
        wait 500
        if Verzeichniseintrag.Gettext <> "drums" then Warnlog "2. Entry has been selected wrong"
    endif
    Haupteintrag.UnCheck
    '/// Check in index dialog 'Apply to similar texts' ///
    EintragOk.Click
    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<Down>",4
    Call wDokSchreiben "<Mod1 Right><Right>"
    Kontext "VerzeichniseintragEinfuegen"
    wait 500
    Verzeichniseintrag.TypeKeys "<Up>"
    'Workaround, does not work on Linux
    if Verzeichniseintrag.Gettext <> "hardware" then
        EinfuegenSchliessen.Click
        InsertIndexesEntry
        Kontext "VerzeichniseintragEinfuegen"
        AufAlleGleichenAnwenden.Check
        wait 500
        if Verzeichniseintrag.Gettext <> "hardware" then Warnlog "3. Entry has been selected wrong"
    endif
    EintragOk.Click
    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<Down>",2
    Call wDokSchreiben "<Mod1 Right><Right>"
    wait 500

    Kontext "VerzeichniseintragEinfuegen"
    wait 500
    Verzeichniseintrag.TypeKeys "<Up>"
    if Verzeichniseintrag.Gettext <> "Custom" then
        EinfuegenSchliessen.Click
        InsertIndexesEntry
        Kontext "VerzeichniseintragEinfuegen"
        wait 500
        if Verzeichniseintrag.Gettext <> "Custom" then Warnlog "4. Entry has been selected wrong"
    endif
    EintragOk.Click
    EinfuegenSchliessen.Click

    Call wDokSchreiben "<Home>"
    for i = 1 to 8
        Call wDokSchreiben "<PageDown>"
        Wait 500
    next i

    '/// Create index ///
    printlog "- Insert index!"
    InsertIndexes
    Kontext
    Active.Setpage TabVerzeichnisseVerzeichnis
    Kontext "TabVerzeichnisseVerzeichnis"
    Verzeichnistyp.Select 2
    Verzeichnistitel.Settext "Tama World"
    if Not VerzeichnisGeschuetzt.IsChecked then
        Warnlog "Protected against manual changes is not checked by default!"
    else
        VerzeichnisGeschuetzt.UnCheck
    endif
    ZusammenfassenGleicherEintraege.Check
    ZusammenfassenMitEff.Check
    GrossKlein.Check
    AutomatischGross.Check
    TabVerzeichnisseVerzeichnis.Ok

    '/// Save document ///
    if gApplication = "WRITER" then
        Call hSpeichernUnterKill (gOfficepath+"user\work\alphabet.sxw")
    else
        Call hSpeichernUnterKill (gOfficepath+"user\work\alphabet.sxg")
    endif
    Call wNavigatorAuswahl(10,1)

    '/// Check created index ///
    printlog "- check the index"
    Call wDokSchreiben "<Shift End>"
    EditCopy
    if GetClipBoardtext <> "Tama World" then Warnlog "Index heading is wrong"
    Call wDokSchreiben "<Home><Down>"
    Call wDokSchreiben "<Mod1 Shift Right>"
    EditCopy
    if Left$(GetClipboardtext,7) <> "Artstar" then Warnlog "1. Index entry is wrong!"
    Call wDokSchreiben "<End>"
    Call wDokSchreiben "<Shift Left>",3
    EditCopy
    if GetClipBoardtext <> "1" & Buchstabe then
        Warnlog "Combine identical entries with '" & Buchstabe  & "' has not been worked ! Is: " & GetClipBoardtext
    endif
    Call wDokSchreiben "<Home><Down>"
    Call wDokSchreiben "<Mod1 Shift Right>"
    EditCopy
    if Left$(GetClipBoardtext,6) <> "Custom" then
        Warnlog "2. Index entry is wrong!"
    endif
    Call wDokSchreiben "<Home><Down>"
    Call wDokSchreiben "<Mod1 Shift Right>"
    EditCopy
    if Left$(GetClipBoardtext,5) <> "Drums" then
        if Left$(GetClipboardtext,5) = "drums" then Warnlog "AutoCapitalize entries has not been worked!"
        if Left$(GetClipboardtext,5) <> "drums" then Warnlog "3. Index entry is wrong !"
    endif
    Call wDokSchreiben "<End>"
    Call wDokSchreiben "<Shift Left>",4
    EditCopy
    if GetClipboardtext <> "1" + Buchstaben then
        Warnlog "Combine identical entries with '" & Buchstaben  & "' has not been worked ! Is: " & GetClipBoardtext
    endif
    Call wDokSchreiben "<Home><Down>"
    Call wDokSchreiben "<Mod1 Shift Right>"
    EditCopy
    if Left$(GetClipboardtext,8) <> "Hardware" then Warnlog "4. Index entry is wrong!"
    Call wDokSchreiben "<End>"
    Call wDokSchreiben "<Shift Left>"
    EditCopy
    if GetClipboardtext <> "4" then Warnlog "4. Index entry -> Pagenumber is wrong!"
    Call wDokSchreiben "<End>"
    Call wDokSchreiben "<Shift Left>",4
    EditCopy
    if GetClipboardtext <> "1, 4" then Warnlog "4. Index entry -> Pagenumber is wrong!"

    printlog "- check properties"
    InsertIndexes
    Kontext
    Active.Setpage TabVerzeichnisseVerzeichnis
    Kontext "TabVerzeichnisseVerzeichnis"
    if VerzeichnisTyp.GetSelIndex <> "2" then Warnlog "Wrong Index selected!"
    if Verzeichnistitel.Gettext <> "Tama World" then Warnlog "Wrong Index title"
    if Not ZusammenfassenGleicherEintraege.IsChecked then Warnlog "Combine identical entry 's is wrong"
    if Not ZusammenfassenMitEff.IsChecked then Warnlog "Combine identical entrys with p or pp is checked!"
    if Not GrossKlein.IsChecked then Warnlog "Case sensitive is not checked!"
    if Not AutomatischGross.IsChecked then Warnlog "AutoCapitalize entries is not checked!"
    TabVerzeichnisseVerzeichnis.Ok

    '/// Close document ///
    Call hCloseDocument
endcase

'***********************************************************************

testcase tInsertIndexesUserDefined
    Dim sFrameName as string
    '/// Open document ../input/writer/stufe1/verzeichnis/verzeichnis.sxw ///
    sFrameName = "Rahmen"

    if gApplication = "WRITER" then
        Call hDateiOeffnen(gTesttoolpath + "writer\level1\input\verzeichnis\verzeichnis.sxw")
    else
        Call hDateiOeffnen(gTesttoolpath + "writer\level1\input\masterdoc\verzeichnis\verzeichnis.sxg")
    endif
    'Document language is german
    Sleep 5
    InsertIndexesEntry
    Kontext "VerzeichniseintragEinfuegen"
    EintragNeu.Click

    Kontext "BenutzerverzeichnisDefinieren"
    NameBenutzerverzeichnis.Settext "Meins"
    BenutzerverzeichnisDefinieren.Ok
    Kontext "VerzeichniseintragEinfuegen"
    if Verzeichnis.GetSeltext <> "Meins" then
        Warnlog "Wrong index selected!"
        Verzeichnis.Select "Meins"
    endif
    EintragOk.Click
    Call wDocSetContext

    '/// Create 11 index entrys ///
    MachMirDenEintrag(0,2)        ' Artstar Custom
    MachMirDenEintrag(7,2)        ' Artstar Esprit
    MachMirDenEintrag(7,2)        ' Artstar II
    MachMirDenEintrag(7,1)        ' Artstar
    MachMirDenEintrag(4,1)        ' Fibrestar
    MachMirDenEintrag(9,1)        ' Granstar
    MachMirDenEintrag(3,2)        ' Granstar Custom
    MachMirDenEintrag(6,2)        ' Granstar II
    MachMirDenEintrag(5,1)        ' Imperialstar
    MachMirDenEintrag(3,2)        ' Rockstar DX
    MachMirDenEintrag(4,2)        ' Rockstar Pro

    Kontext "VerzeichniseintragEinfuegen"
    EinfuegenSchliessen.Click
    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<PageDown>" , 6
    Call wDokSchreiben "<End><Return>" , 3

    '/// Create index from index entrys ///
    InsertIndexes
    Kontext
    Active.SetPage TabVerzeichnisseVerzeichnis
    Kontext "TabVerzeichnisseVerzeichnis"
    Verzeichnistyp.Select "Meins"
    VerzeichnisTitel.Settext "Mein Verzeichnis"
    if Not VerzeichnisGeschuetzt.IsChecked then
        Warnlog "Protected against manual changes is not checked by default!"
    else
        VerzeichnisGeschuetzt.UnCheck
    endif
    Textrahmen.Check
    Grafiken.Check
    TabVerzeichnisseVerzeichnis.OK

    '/// Save document ///
    if gApplication = "WRITER" then
        Call hSpeichernUnterKill (gOfficepath + "user\work\userdef.sxw")
    else
        Call hSpeichernUnterKill (gOfficepath + "user\work\userdef.sxg")
    endif
    Call wNavigatorAuswahl(10,1)
    '/// Check created index ///
    Sleep 2
    Call wDokSchreiben "<Shift Mod1 End>"
    EditCopy
    if GetClipBoardText<>"Mein Verzeichnis" then Warnlog "Wrong index name in document!"
    Call wDokSchreiben "<Home><Down>"
    Call wDokSchreiben "<Shift Mod1 Right>"
    EditCopy
    if Left$(GetClipBoardText,7) <> "Artstar" then Warnlog "1. Index entry is not 'Artstar' but "+ GetClipBoardtext
    Call wDokSchreiben "<End>"
    Call wDokSchreiben "<Shift Left>"
    EditCopy
    if GetClipBoardText<>"1" then Warnlog "1. Index entry is nott on page 1 but "+ GetClipBoardtext

    Call wDokSchreiben "<Home><Down>",3
    Call wDokSchreiben "<Shift Mod1 Right>"
    EditCopy
    if Left$(GetClipBoardText,7) <> sFrameName + "1" then Warnlog "Frame 1 is not in index ! (" & GetClipBoardText & ")"

    Call wDokSchreiben "<Home><Down>",7
    Call wDokSchreiben "<Shift Mod1 Right>"
    EditCopy
    if Left$(GetClipBoardText,7) <> "Artstar" then Warnlog "4. Index entry is not 'Artstar' but "+ GetClipBoardtext
    Call wDokSchreiben "<End>"
    Call wDokSchreiben "<Shift Left>"
    EditCopy
    if GetClipBoardText<>"2" then Warnlog "4. Index entry is not on page 2 but "+ GetClipBoardtext

    Call wDokSchreiben "<Home><Down>",4
    Call wDokSchreiben "<Shift Mod1 Right>"
    Call wDokSchreiben "<Shift Left>"
    EditCopy
    if Left$(GetClipBoardText,7) <> sFrameName + "5" then Warnlog "Frame 5 not found in index"+ GetClipBoardtext

    Call wDokSchreiben "<Home><Down>",4
    Call wDokSchreiben "<Shift Mod1 Right>",2
    EditCopy
    if Left$(GetClipBoardText,15) <> "Granstar Custom" then Warnlog "7. Index entry is not 'Granstar Custom' but "+ GetClipBoardtext

    Call wDokSchreiben "<Home><Down>",5
    Call wDokSchreiben "<Shift Mod1 Right>"
    Call wDokSchreiben "<Shift Left>"
    EditCopy
    if GetClipBoardText<> sFrameName + "8" then Warnlog "Frame 8 not found in index " + GetClipBoardtext

    Call wDokSchreiben "<Home><Down>",8
    Call wDokSchreiben "<Shift Mod1 Right>",2
    EditCopy
    if Left$(GetClipBoardText,12) <> "Rockstar Pro" then Warnlog "11. Index entry is not 'Rockstar Pro' but "+ GetClipBoardtext
    Call wDokSchreiben "<End>"
    Call wDokSchreiben "<Shift Left>"
    EditCopy
    if GetClipBoardText<>"4" then Warnlog "11. Index entry is not on Page '4' but "+ GetClipBoardtext

    Call wDokSchreiben "<Home><Down>",3
    Call wDokSchreiben "<Shift Mod1 Right>"
    Call wDokSchreiben "<Shift Left>"
    EditCopy
    if GetClipBoardText<> sFrameName + "12" then Warnlog "Frame 12 not found in index"+ GetClipBoardtext

    printlog "- edit Index (not testable in detail)"
    '/// Close document ///
    Call hCloseDocument

endcase
