'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_020_.inc,v $
'*
'*  $Revision: 1.30 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:27:33 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*                                                                **
'* owner : helge.delfs@sun.com                                    **
'*                                                                **
'* short description :                                            **
'*                                                                **
'\******************************************************************

sub w_020_
    printLog Chr(13) + "--------- Toolbars (w_020_.inc) ----------"

'   ** Toolbar
    Call t_TB_Insert
    Call t_TB_InsertFields
    Call t_TB_ShowDrawFunctions
    Call t_TB_Form
    Call t_TB_EditAutotext
    Call t_TB_Graphics
    Call t_TB_DirektCursor
    Call t_TB_Find
    Call t_TB_Rest

end sub

'-----------------------------------------------------------

testcase t_TB_Insert
    printlog "- Toolbox ( normal ) : All within Insert"

    Call hNewDocument
    '/// Open new document ///
    printlog "- TearOff Insert-Toolbox"
    Kontext "Insertbar"
    if Not Insertbar.Exists then Call hToolbarSelect("Insert", true)
    
    if gApplication <> "HTMLDOKUMENT" then
        Kontext "Insertbar"
        'Insertbar.Move ( 20, 20 )
        printlog "  - Frame"
        '/// Click 'Frame' and Insert a Frame ///
        Rahmen.Click
        Call gMouseMove(40, 40, 60, 60)
        Call wDokSchreiben ("<Delete>")
        '/// Hit 'Delete' to remove the frame ///
    endif

    printlog "  - Graphic"
    Kontext "Insertbar"
    if Not Insertbar.Exists then Call hToolbarSelect("Insert", true)
    wait 500
	if gUSeSysDlg = False then
        '/// Click 'Insert Graphics' in Toolbox ///        
        if Grafik.IsEnabled then
            Grafik.Click
            Kontext "GrafikEinfuegenDlg"
            if GrafikEinfuegenDlg.Exists then
                Dateiname.SetText ( ConvertPath ( gTesttoolPath + "writer\input\grafik\jolink.jpg" ) )
                '/// Select graphic from file '..\writer\input\grafik\jolink.jpg' ///
                Oeffnen.Click
            else
                Warnlog "Dialog 'Insert Graphic' not up!"
            endif
            Sleep 1
            Kontext "Active"
            if Active.Exists then
                Warnlog Active.Gettext
                Active.Ok
                Kontext "GrafikEinfuegenDlg"
                GrafikEinfuegenDlg.Cancel
            endif
            Call wDokSchreiben ("<Delete>")
            '/// Hit 'Delete' to remove graphic ///
        else
            Warnlog "Button 'Graphic' on Insertbar is not enabled!"
        endif
    endif

    Sleep 2
    printlog "  - Table"
    Kontext "Insertbar"
    if Not Insertbar.Exists then Call hToolbarSelect("Insert", true)
    '/// Click 'Insert Table' in Toolbox ///
    if Tabelle.IsEnabled then
        Tabelle.Click
        Kontext "TabelleEinfuegenWriter"
        TabelleEinfuegenWriter.OK
        '/// Move cursor under table ///
        Call wDokSchreiben ("<Down>",2)
    else
        Warnlog "Button 'Table' on Insertbar is not enabled!"
    endif

    printlog "  - Document"
    Kontext "Insertbar"
    if Not Insertbar.Exists then Call hToolbarSelect("Insert", true)
    if gUseSysDlg = False then
        '/// Click 'Document' in toolbar ///
        if DateiEinfuegen.IsEnabled then
            DateiEinfuegen.CLick
            Kontext "OeffnenDlg"
            Sleep 1
            OeffnenDlg.Cancel
            '/// Cancel upcoming File-Open dialog ///
        else
            Warnlog "Button 'Insert File' on Insertbar is not enabled!"
        endif
    endif

    if gApplication <> "HTMLDOKUMENT" then
        printlog "  - Footnote"
        Kontext "Insertbar"
        if Not Insertbar.Exists then Call hToolbarSelect("Insert", true)
        if Fussnote.IsEnabled then
            Fussnote.Click
            '/// Click 'Insert Footnote Directly' in Toolbox ///
            Call wDokSchreiben ("<PageUp>")
        else
            Warnlog "Button 'Footnote' on Insertbar is not enabled!"
        endif
        
        Sleep 2
        printlog "  - Endnote"
        Kontext "Insertbar"
        if Not Insertbar.Exists then Call hToolbarSelect("Insert", true)
        '/// Click 'Insert Endnote Directly' in Toolbox ///
        if Endnote.IsEnabled then
            Endnote.CLick
            Call wDokSchreiben ("<PageUp>")
        else
            Warnlog "Button 'Endnote' on Insertbar is not enabled!"
        endif

        
        printlog "  - Index Marker"
        Call wDokSchreiben ("Index Marker <Shift Home>")
        Kontext "Insertbar"
        if Not Insertbar.Exists then Call hToolbarSelect("Insert", true)
        '/// Click 'Insert Index Marker' in Toolbox ///
        if Verzeichnis.IsEnabled then
            Verzeichnis.CLick
            Kontext "VerzeichniseintragEinfuegen"
            VerzeichniseintragEinfuegen.Close
            '/// Close upcoming 'Insert Index Entry' dialog ///
        else
            Warnlog "Button 'Index Marker' on Insertbar is not enabled!"
        endif            
    endif

    printlog "  - Special Character"
    Kontext "Insertbar"
    if Not Insertbar.Exists then Call hToolbarSelect("Insert", true)
    if Sonderzeichen.IsEnabled then
        Sonderzeichen.CLick
        Kontext "Sonderzeichen"
        '/// Click 'Insert Special Character' in Toolbox ///
        Sonderzeichen.Cancel
        '/// Cancel upcoming 'Special Character' dialog ///
    else
        Warnlog "Button 'Special Character' on Insertbar is not enabled!"
    endif

    printlog "  - Insert Section"
    Kontext "Insertbar"
    if Not Insertbar.Exists then Call hToolbarSelect("Insert", true)
    if BereichEinfuegen.IsEnabled then
        BereichEinfuegen.Click
        '/// Click 'Insert Section' in Toolbox ///
        Kontext
        Active.Setpage TabBereiche
        Kontext "TabBereiche"
        TabBereiche.Ok
        '/// Close upcoming 'Section' dialog ///
    else
        Warnlog "Button 'Insert Section' on Insertbar is not enabled!"
    endif

    printlog "  - Bookmark"
    Kontext "Insertbar"
    if Not Insertbar.Exists then Call hToolbarSelect("Insert", true)
    if Textmarke.IsEnabled then
        Textmarke.CLick
        '/// Click 'Insert Bookmark' in Toolbox ///
        Kontext "TextmarkeEinfuegen"
        Textmarken.SetText "Bookmark"
        '/// Enter a bookmark name and close dialog ///
        TextmarkeEinfuegen.OK
    else
        Warnlog "Button 'Bookmark' on Insertbar is not enabled!"
    endif

    Kontext "Insertbar"           ' nur durch Schlieen der Toolbox ist der Dialog ansprechbar
    if Insertbar.Exists then Insertbar.Close
    '/// Close toolbar ///

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase t_TB_InsertFields
    Dim Ende, i as Integer
    printlog "- Toolbox ( normal ) : Fields"

	if gPlatgroup = "unx" then
		QAErrorlog "HDE: Doesn't run on unix"
		goto endsub
	endif	
    Call hNewDocument
    '/// Open new document ///
    printlog "- TearOff Insert Toolbox"
    '/// Tear off toolbar and open insert toolbar 
    Kontext "Insertbar"
    if Not Insertbar.Exists then Call hToolbarSelect("Insert", true)
    '/// Click 'Insert Fields' in insertbar ///    
    Sleep 1
    Feldbefehle.OpenMenu    
    wait 500    
    if gApplication = "HTMLDOKUMENT" then
        Call hMenuSelectNr(6)
    else
        Call hMenuSelectNr(8)
    endif
    Kontext
    try
        Active.SetPage TabDokumentFeldbefehle
        Kontext "TabDokumentFeldbefehle"
        '/// Cancel upcoming 'Fields' dialog ///
        TabDokumentFeldbefehle.Cancel
    catch
        QAErrorlog "Dialog for Fields is not up !"
    endcatch
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase t_TB_ShowDrawFunctions
    printlog "- Toolbox ( normal ) : Draw Functions"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif

    Call hNewDocument
    '/// Open new document ///
    ViewZoom
    Kontext "Massstab"
    Optimal.Check
    Massstab.OK

    Kontext "DrawBar"
    if Not DrawBar.Exists then Call hToolbarSelect("Drawing", true)
    '/// Open 'Draw functions' toolbar ///
    Sleep 5

    printlog "  - Draw Line"
    Kontext "Drawbar"
    '/// Draw a Line ///
    try
        Linie.Click
        Call gMouseMove(20, 20, 30, 30)
        Call wDokSchreiben ("<Escape>")
    catch
        Warnlog " Line could not be created !"
    endcatch

    printlog "  - Draw Rectangle"
    Kontext "Drawbar"
    '/// Draw a Rectangle ///
    Rechteck.Click
    Call gMouseMove(31, 20, 40, 40)
    Call wDokSchreiben ("<Escape>")

    printlog "  - Draw Ellipse"
    Kontext "Drawbar"
    '/// Draw an Ellipse ///
    Ellipse.Click
    Call gMouseMove(31, 30, 60, 50)
    Call wDokSchreiben ("<Escape>")

    printlog "  - Draw Freeform"
    Kontext "Drawbar"
    Freihand.Click
    '/// Draw a Freeform ///
    Call gMouseMove ( 23, 20, 35, 31 )
    Call gMouseMove ( 35, 31, 40, 90 )
    Call gMouseMove ( 41, 91, 55 , 70 )
    Call gMouseClick( 55, 70 )
    Call wDokSchreiben ("<Escape>")

    printlog "  - Draw Textobject"
    Kontext "Drawbar"
    '/// Draw a Textobject ///
    Textobjekt.Click
    Call gMouseMove ( 17, 17, 28, 25 )
    Call wDokSchreiben ("Textobject")
    Call gMouseClick ( 50, 99 )
    Call wDokSchreiben ("<Escape>")

    printlog "  - Draw Callouts"
    Kontext "Drawbar"
    '/// Draw a Callout ///
    Legende.Click
    Call gMouseMove (15, 20, 50, 60)
    Call gMouseClick( 50, 60 )
    Call wDokSchreiben ("<Escape>")

    Kontext "Drawbar"
    Drawbar.Close
    '/// Close toolbar 'Draw Functions' ///
    ViewZoom
    Kontext "Massstab"
    Vergroesserung100.Check
    Massstab.OK

    Call hCloseDocument
    '/// Close active document ///

endcase

'-----------------------------------------------------------

testcase t_TB_Form
    printlog "- Toolbox ( normal ) : Formular"

    Call hNewDocument
    '/// Open new document ///
    Sleep 1
    Kontext "FormControls"
    if Not FormControls.Exists then Call hToolbarSelect("Controls", true)

    try
        '/// Tear off 'Form' Toolbox ///
        Kontext "FormControls"
        if Not FormControls.Exists then
            Warnlog "Toolbar 'FormControls' is not opened!"
            Call hCloseDocument
            goto endsub
        end sub
        wait 500
        Pushbutton.Click
        '/// Insert a pushbutton from toolbox ///
        Call hMalZeichnenMitSelektion ( 10, 20, 20, 25 )
        Sleep 2
        Kontext "FormControls"
        ControlProperties.Click
        Sleep 2
        '///+ Open Control Properties ///
        printlog "   - Control Properties"
        Call sMenufunktionen("-Pushbutton-")
        
        Kontext "FormControls"
        wait 500
        Radiobutton.Click
        '/// Insert a Radiobutton from toolbox ///
        Call hMalZeichnenMitSelektion ( 22, 20, 32, 25 )
        '///+ Open Control Properties ///
        Call sMenufunktionen("-Radiobutton-")
        
        Kontext "FormControls"
        wait 500
        Checkbox.Click
        '/// Insert a Checkbox from toolbox ///
        Call hMalZeichnenMitSelektion ( 35, 20, 45, 25 )
        '///+ Open Control Properties ///
        Call sMenufunktionen("-Checkbox-")

        Kontext "FormControls"
        if Ucase(gApplication) <> "HTMLDOKUMENT" then
            wait 500
            Label.Click
            '/// Insert a textbox from toolbox ///
            Call hMalZeichnenMitSelektion ( 47, 20, 58, 25 )
            '///+ Open Control Properties ///
            Call sMenufunktionen("-Textbox-")
        endif
          
        Sleep 3
        Kontext "FormControls"
        '/// Insert an Edit Field from toolbox ///
        Edit.Click
        Wait 500
        Call hMalZeichnenMitSelektion ( 22, 30, 32, 35 )
        '///+ Open Control Properties ///
        Call sMenufunktionen("-Edit-")
        
        Kontext "FormControls"
        Listbox.Click
        Wait 500
        '/// Insert a listbox ///
        Call hMalZeichnenMitSelektion ( 35, 30, 45, 35 )
        '///+ Step through pages of upcoming Autopilot ///
        Call sAutopilot_ListboxCombobox("Listbox")
        '///+ Open Control Properties ///
        Call sMenufunktionen("-Listbox-")
        
        Kontext "FormControls"
        if Ucase(gApplication) <> "HTMLDOKUMENT" then
            Combobox.Click
            '/// Insert a Combobox from toolbox ///
            Wait 500
            Call hMalZeichnenMitSelektion ( 47, 30, 58, 35 )
            '///+ Step through pages of upcoming Autopilot ///
            Call sAutopilot_ListboxCombobox("Combo")
            '///+ Open Control Properties ///
            Call sMenufunktionen("-Combobox-")
        endif    
        
        '/// Insert a Formatted Field from toolbox ///
        Kontext "FormControls"
        if Ucase(gApplication) <> "HTMLDOKUMENT" then
            FormattedField.Click
            Wait 500
            Call hMalZeichnenMitSelektion ( 35, 50, 45, 55 )
            '///+ Open Control Properties ///
            Call sMenufunktionen("-Formatted Field-")
        endif
        Sleep 3
        Call gMouseClick ( 40, 80 )
        Kontext "FormControls"
        '/// Click 'Design Mode' in Toolbox ///
        wait 500
        SwitchControlDesignMode.Click
        Sleep 1
        '/// Click 'Design Mode' in Toolbox ///
        SwitchControlDesignMode.Click
        printlog "   - Design mode"
        Kontext "FormControls"
        FormControls.Close        
    catch
        Exceptlog
    endcatch

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase t_TB_EditAutotext
    printlog "- Toolbox ( normal ) : Autotext"

    Call hNewDocument
    '/// Open new document ///
    Kontext "Insertbar"
    if Not Insertbar.Exists then Call hToolbarSelect("Insert", true)
    Sleep 2
    Autotext.Click
    '/// Click 'Autotext' in Toolbar ///
    wait 500
    Kontext "Active"
    if Active.Exists then
        Active.Gettext
        Active.Ok
    endif
    Sleep 5
    Kontext "Autotext"
    '/// Close upcoming 'Autotext' dialog ///
    Autotext.Close
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase t_TB_Find
    printlog "- Toolbox ( normal ) : Find & Replace"
    Call hNewDocument
    '/// Open new document ///
    Kontext "Standardbar"
    if Not Standardbar.Exists then Call hToolbarSelect("Standard", true)
    '/// Click 'Find' in Toolbar ///
    FindAndReplace.Click
    Kontext "FindAndReplace"
    '/// Close 'Find&Replace' dialog ///
    FindAndReplace.Close
    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase t_TB_Graphics
    printlog "- Toolbox ( normal ) : Graphic"

    Call hNewDocument
    '/// Open new document ///
    Call hGrafikEinfuegen ( gTesttoolpath + "writer\input\grafik\jolink.jpg" )
    '/// Insert graphic from file ..\writer\input\grafik\jolink.jpg ///

    Kontext "Toolbar"
    if Not Toolbar.Exists then Call hToolbarSelect("Tools", true)
    try
        '/// Click 'Graphic' in Toolbar ///
        GrafikenAusEin.Click
    catch
        Warnlog "Error on switching Graphic off!"
    endcatch
    Sleep 2
    try
        '/// Click 'Graphic' in Toolbar ///
        GrafikenAusEin.Click
    catch
        Warnlog "Error on switching Graphic on!"
    endcatch
    Sleep 2

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase t_TB_DirektCursor
    printlog "- Toolbox ( normal ) : Direct Cursor"
    if gApplication = "HTMLDOKUMENT" then
        printlog "Not in WriterWeb!"
        goto endsub
    endif

    Call hNewDocument
    '/// Open new document ///
    Kontext "Toolbar"
    if Not Toolbar.Exists then Call hToolbarSelect("Tools", true)
    '/// Click 'Direct Cursor' in Toolbar ///
    Direktcursor.Click
    Sleep 1
    Call gMouseDoubleClick(50, 70)
    '/// Point cursor somewhere in document ///
    Call wDokSchreiben ("Direct Cursor On")
    '/// Insert some words in document ///

    Kontext "Toolbar"
    if Not Toolbar.Exists then Call hToolbarSelect("Tools", true)
    '/// Click 'Direct Cursor' in Toolbar ///
    Direktcursor.Click
    Call gMouseDoubleClick (80, 20)
    '/// Insert some text in document ///
    Call wDokSchreiben ("Direct Cursor Off")

    Call hCloseDocument
    '/// Close active document ///
endcase

'-----------------------------------------------------------

testcase t_TB_Rest
    printlog "- Toolbox ( normal ) : Rest"

    Call hNewDocument
    '/// Open new document ///
    printlog "  - Hyperlink"
    Kontext "Toolbar"
    if Not Toolbar.Exists then Call hToolbarSelect("Tools", true)
    try
        '/// Click 'Hyperlink' in Toolbar ///
        Hyperlink.Click
        Sleep 2
        '/// Click 'Hyperlink' in Toolbar ///
        Hyperlink.Click
        Warnlog "Button 'Hyperlink' should have been removed!"
    catch
    endcatch

    printlog "  - OnlineLayout"
    if gApplication <> "HTMLDOKUMENT" then
        Kontext "Toolbar"
        if Not Toolbar.Exists then Call hToolbarSelect("Tools", true)
        try
            '/// Click 'Online Layout' in Toolbar ///
            OnlineLayout.Click
            Sleep 2
            '/// Click 'Online Layout' in Toolbar ///
            OnlineLayout.Click
        catch
            Warnlog "Button 'OnlineLayout' is missing or disabled!"
        endcatch
    endif

    printlog "  - Nonprinting Characters"
    Kontext "Toolbar"
    if Not Toolbar.Exists then Call hToolbarSelect("Tools", true)
    try
        '/// Click 'Nonprinting Characters' in Toolbar ///
        SteuerzeichenEinAus.Click
        Sleep 2
        '/// Click 'Nonprinting Characters' in Toolbar ///
        SteuerzeichenEinAus.Click
    catch
        Warnlog "Button 'Nonprinting Characters' is missing or disabled!"
    endcatch

    printlog "  - Graphics on/off"
    Kontext "Toolbar"
    if Not Toolbar.Exists then Call hToolbarSelect("Tools", true)
    try
        '/// Click 'Graphics' in Toolbar  ///
        GrafikenAusEin.Click
        Sleep 2
        '/// Click 'Graphics' in Toolbar  ///
        GrafikenAusEin.Click
    catch
        Warnlog "Button 'Graphics' is missing or disabled!"
    endcatch
    Call hCloseDocument
    '/// Close active document ///
endcase
