'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: xw_perf1.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/08 08:33:29 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Library for Writer XML Performance Test
'*
'***************************************************************************************
' **
' #1 xeinfach
' #1 xkurz
' #1 xtable
' #1 xmanual
' #1 xfulldoc
' #1 beinfach
' #1 bkurz
' #1 btable
' #1 tinitnormal
' #1 xCreateDocs
' #1 bCreateDocs
' **
'\**************************************************************************************

testcase xeinfach
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("einfach_sxw.nopid")
 for i = 1 to 4
'/// Loading XML document 4 times. ///
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\einfach.sxw"))
  sleep(10)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\einfach" & i & ".sxw"))
  printlog "Document should has been saved."
'/// After each load and save the XML document will be closed. ///
  call hCloseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase xkurz
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("kurz_sxw.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading XML document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\kurz.sxw"))
  sleep(10)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\kurz" & i & ".sxw"))
  printlog "Document should has been saved."
'/// After each load and save the XML document will be closed. ///
  call hCloseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase xtable
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("table_sxw.nopid")
 for i = 1 to 6
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading XML document <b>6</b> times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\table.sxw"))
  sleep(40)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\table" & i & ".sxw"))
  printlog "Document should has been saved."
  sleep(30)
'/// After each load and save the XML document will be closed. ///
  call hCloseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase xmanual
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("manual_sxw.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading XML document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\manual.sxw"))
  sleep(40)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\manual" & i & ".sxw"))
  printlog "Document should has been saved."
'/// After each load and save the XML document will be closed. ///
  call hCloseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase xfulldoc
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("fulldoc_sxw.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading XML document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\fulldoc.sxw"))
  sleep(40)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\fulldoc" & i & ".sxw"))
  printlog "Document should has been saved."
'/// After each load and save the XML document will be closed. ///
  call hCloseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase beinfach
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("einfach_sdw.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading <b>binary</b> document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\binary\einfach.sdw"))
  sleep(10)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\binary\einfach" & i & ".sdw"))
  printlog "Document should has been saved."
'/// After each load and save the document will be closed with recepiting the verify of loosing items in the old binary format. ///
  call hCloseAndLooseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase bkurz
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("kurz_sdw.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading <b>binary</b> document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\binary\kurz.sdw"))
  sleep(10)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\binary\kurz" & i & ".sdw"))
  printlog "Document should has been saved."
'/// After each load and save the document will be closed with recepiting the verify of loosing items in the old binary format. ///
  call hCloseAndLooseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase btable
 Dim i as integer
'/// The office will be closed and started with profiling environment. ///
 call hExitAndRestart ("table_sdw.nopid")
 for i = 1 to 4
  printlog "---------------------------------------------------------------"
  printlog "Round: " & i
'/// Loading <b>binary</b> document 4 times. ///
  call hDateiOeffnen (gTesttoolPath & ConvertPath("xml\level2\input\profile\binary\table.sdw"))
  sleep(40)
  printlog "Document should has been loaded."
'/// Saving the same document 4 times to get a good average of the loading and saving times. ///
  call hSpeichernUnterKill (gOfficePath & ConvertPath("user\work\xml\profile\binary\table" & i & ".sdw"))
  printlog "Document should has been saved."
'/// After each load and save the document will be closed with recepiting the verify of loosing items in the old binary format. ///
  call hCloseAndLooseDocument
  printlog "Document should has been closed."
 next i
endcase

'-------------------------------------------------------------------------

testcase tinitnormal
'/// The office will be closed and started <u><b>without</b></u> profiling environment. ///
 call ExitRestartTheOffice
endcase

'-------------------------------------------------------------------------

testcase xCreateDocs
 Dim OfficeBuild as string
 Dim CommandlineString(18) as string
 Dim ShellExec as integer
 Dim i as integer
'/// With the Perl scripts from <a href="mailto:andre.fischer@germany">Andre Fischer</a> ///
'///+ the logfiles in <i>..user/work/xml/profile</i> directory a Calc ///
'///+ document will be created. ///
'/// The filter which is needed for the perl script came from the &acute;xmloff&acute; development team, resp. engineer <a href="mailto:daniel.vogelheim@germany">Daniel Vogelheim</a>. ///
'///+ and are located in <i>...testtool/input/profile/filter</i>. ///
'/// In this round the logs of the XML files will be analyzed.///
  printlog "Build: " & OfficeBuild
  '-------------------
  CommandlineString(1) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\einfach_sxw.nopid " & gOfficePath & "user\work\xml\profile\results\einfach_sxw.sxc")
  CommandlineString(2) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\kurz_sxw.nopid " & gOfficePath & "user\work\xml\profile\results\kurz_sxw.sxc")
  CommandlineString(3) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\table_sxw.nopid " & gOfficePath & "user\work\xml\profile\results\table_sxw.sxc")
  CommandlineString(4) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\manual_sxw.nopid " & gOfficePath & "user\work\xml\profile\results\manual_sxw.sxc")
  CommandlineString(5) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\fulldoc_sxw.nopid " & gOfficePath & "user\work\xml\profile\results\fulldoc_sxw.sxc")
  '-------------------
 for i = 1 to 5
  printlog "Command (" & i & "): " & lcase(CommandlineString(i))
  if gPlatGroup = "unx" then
    ShellExec = Shell("perl " & CommandlineString(i) , 1 )
   else
    ShellExec = Shell("perl.exe " & CommandlineString(i) , 1)
  end if
  if ShellExec(i) = 0 then
    printlog "Succesfully executed."
   else
    warnlog "A mistake has been happened."
  end if
 next i
endcase

'-------------------------------------------------------------------------

testcase bCreateDocs
 Dim OfficeBuild as string
 Dim CommandlineString(18) as string
 Dim ShellExec as integer
 Dim i as integer
'/// With the Perl scripts from <a href="mailto:andre.fischer@germany">Andre Fischer</a> ///
'///+ the logfiles in <i>..user/work/xml/profile/</i> directory a Calc ///
'///+ document will be created. ///
'/// The filter which is needed for the perl script came from the &acute;xmloff&acute; development team, resp. engineer <a href="mailto:daniel.vogelheim@germany">Daniel Vogelheim</a>. ///
'///+ and are located in <i>...testtool/input/profile/filter</i>. ///
'/// In this round the logs of the binary files will be analyzed.///
  printlog "Build: " & OfficeBuild
  '-------------------
  CommandlineString(1) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\einfach_sdw.nopid " & gOfficePath & "user\work\xml\profile\results\einfach_sdw.sxc")
  CommandlineString(2) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\kurz_sdw.nopid " & gOfficePath & "user\work\xml\profile\results\kurz_sdw.sxc")
  CommandlineString(3) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\table_sdw.nopid " & gOfficePath & "user\work\xml\profile\results\table_sdw.sxc")
  CommandlineString(4) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\manual_sdw.nopid " & gOfficePath & "user\work\xml\profile\results\manual_sdw.sxc")
  CommandlineString(5) = ConvertPath(gTesttoolPath & "global\tools\input\profile\write-calc-doc.pl -i " & gTesttoolPath & "global\tools\input\profile\filter\xml.filter " & gOfficePath & "user\work\xml\profile\results\fulldoc_sdw.nopid " & gOfficePath & "user\work\xml\profile\results\fulldoc_sdw.sxc")  
  '-------------------
 for i = 1 to 5
  printlog "Command (" & i & "): " & lcase(CommandlineString(i))
  if gPlatGroup = "unx" then
    ShellExec = Shell("perl " & CommandlineString(i) , 1 )
   else
    ShellExec = Shell("perl.exe " & CommandlineString(i) , 1)
  end if
  if ShellExec(i) = 0 then
    printlog "Succesfully executed."
   else
    warnlog "A mistake has been happened."
  end if
 next i
endcase

'-------------------------------------------------------------------------

