/* Scroller.java
 * Copyright (C) 1996 by William Giel
 *
 * E-mail: rvdi@usa.nai.net
 * WWW: http://www.nai.net/~rvdi/home.htm
 *
 ***************************************************************************
 * Abstract
 * --------
 * This unit provides a scrolling, read-only text display class, derived
 * from java.awt.TextArea.
 ***************************************************************************
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee for NON-COMMERCIAL purposes is hereby granted.
 * 
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 ***************************************************************************/

import java.awt.*;
import java.lang.*;


////////////////////////////////////////////
// This creates a read-only scrolling text
// display area.
////////////////////////////////////////////

public class Scroller extends TextArea
{
    static final String NEWLINE="\r\n";
    
	Scroller(String string, int rows, int columns)
	{
		super(string,rows,columns);
		setEditable(false);
	}

	public void newLine()
	{
		super.appendText(NEWLINE);	    
	}
}

