/* GeoWindow.java
 * Copyright (C) 1996 by William Giel
 *
 * E-mail: rvdi@usa.nai.net
 * WWW: http://www.nai.net/~rvdi/home.htm
 *
 ***************************************************************************
 * Abstract
 * --------
 * This unit creates the main control panel, in which positions can be
 * entered, map dialogs selected, help invoked, or computations initiated
 * or reset.
 ***************************************************************************
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee for NON-COMMERCIAL purposes is hereby granted.
 * 
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 ***************************************************************************/

import java.awt.*;
import java.applet.*;
import java.lang.*;
import java.net.*;

import MapWindow;
import Scroller;
import wgCheckbox;
import Geoid;
import dms;
import Format;
import MessageBox;
import mapWindowMaker;

public class geoWindow extends Dialog
{
    int H_SIZE=400;
    int V_SIZE=300;

    mapWindowMaker mwmWorld=null;
    mapWindowMaker mwmUSA=null;
    
	MapWindow windowWorld=null;
	MapWindow windowUSA=null;

	int width, height;
	commonData data;
	imageLoader ilMaps=null;

	helpDialog help=null;
	fileLoader helpFile=null;
	String helpString=null;

	Applet app;

	ResourceCheck checkResources=null;	
	
	TextField lat1,long1,lat2,long2,statusField;
	Scroller scroller;
	wgCheckbox nad27,nad83;
	boolean coord27=false;
	boolean coord83=false;

	String homeLat27,homeLong27,homeLat83,homeLong83;

	MessageBox notReadyMessage=null;


    ////////////////////////
    //Geoid class for NAD 27
    ////////////////////////
    Geoid clarke1866=new Geoid(6378206.4,294.978698);
    
	////////////////////////
    //Geoid class for NAD 83
    ////////////////////////
    Geoid grs80=new Geoid(6378137.0,298.2572221008827);
    


	void userInterface()
	{
	    addNotify();
		 
       	GridBagLayout gridbag=new GridBagLayout();
       	GridBagConstraints c=new GridBagConstraints();
        	
       	setFont(new Font(gwConst.FONTSTRING,Font.BOLD,gwConst.FONTHEIGHT));
       	setLayout(gridbag);
			
        setBackground(Color.lightGray);

        c.fill=GridBagConstraints.NONE;
        c.weightx=1.0;c.weighty=1.0;
        c.insets=new Insets(5,5,0,5);

        setTitle(gwConst.LABEL);
       	
        
        c.insets=new Insets(5,5,0,0);
		c.gridwidth=5;
        c.anchor=GridBagConstraints.EAST;
      	Label lbl0 = new Label(gwConst.LABEL_0);
       	gridbag.setConstraints(lbl0,c);
       	add(lbl0);

        
       	c.insets=new Insets(5,0,0,5);
        c.gridwidth=GridBagConstraints.REMAINDER;
        c.anchor=GridBagConstraints.EAST;
      	lbl0 = new Label(gwConst.LABEL_1);
       	gridbag.setConstraints(lbl0,c);
       	add(lbl0);       	

        c.insets=new Insets(0,5,0,0);
        c.gridwidth=1;
       	c.anchor=GridBagConstraints.WEST;
		lbl0 = new Label(gwConst.LABEL_2);
       	gridbag.setConstraints(lbl0,c);
       	add(lbl0);

       	c.insets=new Insets(0,0,0,0);
        c.gridwidth=4;
       	c.anchor=GridBagConstraints.EAST;
		lat1 = new TextField("", 15);
       	gridbag.setConstraints(lat1,c);
       	add(lat1);
       	
        c.insets=new Insets(0,0,0,5);
        c.gridwidth=GridBagConstraints.REMAINDER;
       	c.anchor=GridBagConstraints.EAST;
		lat2 = new TextField("", 15);
       	gridbag.setConstraints(lat2,c);
       	add(lat2);

        c.insets=new Insets(0,5,0,0);
        c.gridwidth=1;
       	c.anchor=GridBagConstraints.WEST;
		lbl0 = new Label(gwConst.LABEL_3);
       	gridbag.setConstraints(lbl0,c);
       	add(lbl0);          


        c.insets=new Insets(0,0,0,0);
        c.gridwidth=4;
       	c.anchor=GridBagConstraints.EAST;
		long1 = new TextField("", 15);
       	gridbag.setConstraints(long1,c);
       	add(long1);

        c.insets=new Insets(0,0,0,5);
        c.gridwidth=GridBagConstraints.REMAINDER;
       	c.anchor=GridBagConstraints.EAST;
		long2 = new TextField("", 15);
       	gridbag.setConstraints(long2,c);
       	add(long2);


		CheckboxGroup datums=new CheckboxGroup();
		nad27=new wgCheckbox(gwConst.LABEL_4, datums, false);
		nad83=new wgCheckbox(gwConst.LABEL_5, datums, false);
		Panel p=new Panel();
		p.add(nad27);
		p.add(nad83);
		c.insets=new Insets(2,5,2,5);
        c.gridwidth=GridBagConstraints.REMAINDER;
        c.anchor=GridBagConstraints.CENTER;
        gridbag.setConstraints(p,c);
        add(p);

        c.gridwidth=GridBagConstraints.REMAINDER;
 	    c.fill=GridBagConstraints.BOTH;
        c.insets=new Insets(0,5,0,5);
        scroller = new Scroller("",5,50);
        gridbag.setConstraints(scroller, c);
        scroller.setBackground(Color.white);
        add(scroller);

        c.fill = GridBagConstraints.BOTH;
        c.anchor=GridBagConstraints.CENTER;

		c.insets=new Insets(0,0,0,0);        
        c.gridwidth=1;
		Button butt0 = new Button(gwConst.LABEL_6);
        gridbag.setConstraints(butt0,c);
        add(butt0);

	
        c.gridwidth=2;        
        butt0 = new Button(gwConst.LABEL_7);			
        gridbag.setConstraints(butt0,c);
        add(butt0);
        
        c.gridwidth=2;
		butt0 = new Button(gwConst.LABEL_8);
        gridbag.setConstraints(butt0,c);
        add(butt0);

        c.gridwidth=2;
		butt0 = new Button(gwConst.LABEL_9);
        gridbag.setConstraints(butt0,c);
        add(butt0);        
        
		
        c.gridwidth=GridBagConstraints.REMAINDER;
        butt0 = new Button(gwConst.LABEL_10);			
        gridbag.setConstraints(butt0,c);
        add(butt0);

		c.insets=new Insets(3,3,10,5);
        c.gridwidth=GridBagConstraints.REMAINDER;
        statusField = new TextField("",50);
        statusField.setEditable(false);
        gridbag.setConstraints(statusField,c);
        add(statusField);        

		nad83.setState(true);
       	if(coord83)
       		coord83 = setHomeFields(homeLat83,homeLong83);
       	else if (coord27){
       		coord27 = setHomeFields(homeLat27,homeLong27);
       		if(coord27)nad27.setState(true);
       	}

        scroller.setText(gwConst.COPYRIGHT_2);

        resize(H_SIZE, V_SIZE);
        Dimension screenSize = getToolkit().getScreenSize();
        move((screenSize.width -H_SIZE)/2,(screenSize.height - V_SIZE)/2);
       
	}

	geoWindow(Applet applet)
	{
	    super(new Frame(),true);

	    app=applet;


	    homeLat27   =   app.getParameter("LAT27");
	    homeLong27  =   app.getParameter("LONG27");
	    if(null != homeLat27 && null != homeLong27)coord27=true;

	    homeLat83   =   app.getParameter("LAT83");
	    homeLong83  =   app.getParameter("LONG83");
	    if(null != homeLat83 && null != homeLong83)coord83=true;

	    
	    
		userInterface();

	    String szImage[] = new String[3];

		szImage[0]= gwConst.REDPIN;
	    szImage[1]= gwConst.WORLD_MAP;
	    szImage[2]= gwConst.USA_MAP;

	    ilMaps=new imageLoader(app,szImage,3,null);
	    ilMaps.start();

	    mwmWorld=new mapWindowMaker(ilMaps,1,lat1,long1,lat2,long2);
	    mwmWorld.start();

	    mwmUSA=new mapWindowMaker(ilMaps,2,lat1,long1,lat2,long2);
	    mwmUSA.start();

	    helpFile=new fileLoader(app,gwConst.HELP_FILE,null);
	    helpFile.start();

	    checkResources=new ResourceCheck(mwmWorld,mwmUSA,helpFile,statusField);
	    checkResources.start();

	    notReadyMessage=new MessageBox(gwConst.NOT_READY);

	}

	public void paint(Graphics g)
	{
		Color color=g.getColor();
		g.setColor(Color.lightGray);
		g.fill3DRect(0,0,size().width,size().height,true);
		g.setColor(color);
	}

    double DecimalDegrees(String string)
    {
    	double angle;
    	try{
    			angle=dms.dms2decdeg(string);
    	   }catch (Invalid_Angular_Data e)
    			{
    				scroller.appendText("\r\n" + e);
    				return Math.PI;
    			}

    	if(angle > 360 || angle < -360)return Math.PI;
    	return angle;
    }

    public boolean action(Event evt, Object arg)
    {
		if(arg.equals(gwConst.LABEL_6)) 
        {
        	//Since Java Dialogs are not modal, we need this...
        	if(null != windowUSA && windowUSA.isShowing())
        		return true;
        		
        	if(null==windowWorld){
        	        if(checkResources.areReady())
        	            windowWorld=mwmWorld.retrieveMapWindow();
        	        else if(null != notReadyMessage)
            	        notReadyMessage.show();
        	}
        		
        	if(null != windowWorld && !windowWorld.isShowing()){
        	    statusField.setText(gwConst.PREP_WORLD);
        		if((coord83 && nad83.getState()) || (coord27 && nad27.getState()))
        			windowWorld.show(new Mercator((nad83.getState())? gwConst.MERC_83 : gwConst.MERC_27),
        			                                                data.latitude2,data.longitude2);
        		else
        			windowWorld.show(new Mercator((nad83.getState())? gwConst.MERC_83 : gwConst.MERC_27 ));
        		statusField.setText(gwConst.READY);
        	}
       	    
			return true;
        }
		else if(arg.equals(gwConst.LABEL_7)) 
        {
       		//Since Java Dialogs are not modal, we need this...
        	if(null != windowWorld && windowWorld.isShowing())
        		return true;
    	        		
        	if(null==windowUSA){
        	        if(checkResources.areReady())
        	            windowUSA=mwmUSA.retrieveMapWindow();
        	        else if(null != notReadyMessage)
            	        notReadyMessage.show();
        	}
        	
        	if(null != windowUSA && !windowUSA.isShowing()){
        	    statusField.setText(gwConst.PREP_US);
        		if((coord83 && nad83.getState()) || (coord27 && nad27.getState()))
        			windowUSA.show(new Sinusoidal((nad83.getState())? gwConst.SINU_83 : gwConst.SINU_27),
        			                                            data.latitude2,data.longitude2);
        		else
        			windowUSA.show(new Sinusoidal((nad83.getState())? gwConst.SINU_83 : gwConst.SINU_27));
        		statusField.setText(gwConst.READY);
        	}
        	return true;
        }
        else if(arg.equals(gwConst.LABEL_8))
        {
        	double phi0,lam0,phi1,lam1;
        	
			statusField.setText(gwConst.COMPUTING);
			if(Math.PI==(phi0=DecimalDegrees(lat1.getText())) ||
				Math.PI==(lam0=DecimalDegrees(long1.getText()))){
				statusField.setText(gwConst.READY);
				return true;
			}
			scroller.appendText(gwConst.FROM + ((phi0 >= 0)?"N ":"S ") +
				dms.decdeg2dms(Math.abs(phi0),3) +
				((lam0 < 0)? "    E ":"    W ") +
				dms.decdeg2dms(Math.abs(lam0),3));
			
			if(Math.PI==(phi1=DecimalDegrees(lat2.getText())) ||
					Math.PI==(lam1=DecimalDegrees(long2.getText()))){
					    statusField.setText(gwConst.READY);
        				return true;
			}

			AzimuthDistance rudoe =	(nad83.getState())?
    			grs80.RudoeInverse(phi0,-lam0,phi1,-lam1):
    			clarke1866.RudoeInverse(phi0,-lam0,phi1,-lam1);

   			scroller.appendText(gwConst.DISTANCE +
    				Format.toString(rudoe.distance/1000.0,3) +
    				" km (" + Format.toString(rudoe.distance/.3048/5280.0,4) +
    				" miles)" );
			scroller.appendText(gwConst.AZIMUTH +
					dms.decdeg2dms(rudoe.azimuth, 3) +
					gwConst.RECKONED );    			

			scroller.appendText(gwConst.TO + ((phi1 >= 0)?"N ":"S ") +
				dms.decdeg2dms(Math.abs(phi1),3) +
				((lam1 < 0)? "    E ":"    W ") +
				dms.decdeg2dms(Math.abs(lam1),3));

			statusField.setText(gwConst.READY);
			return true;
        }
        else if(arg.equals(gwConst.LABEL_9))
        {
        	lat1.setText("");
        	long1.setText("");
        	lat2.setText("");
        	long2.setText("");

            if(nad83.getState() && coord83)
       			setHomeFields(homeLat83,homeLong83);
       		else if(nad27.getState() && coord27)
   				setHomeFields(homeLat27,homeLong27);

        	scroller.setText(gwConst.COPYRIGHT_2);
        	statusField.setText(gwConst.READY);
        	return true;
        }
        else if(arg.equals(gwConst.LABEL_10)){
        	if(null != help && help.isShowing())
        		return true;
        		
        	if(null==help){
        		if(checkResources.areReady()){
        		    helpString=helpFile.retrieveFileContent();
        		    if(null != helpString)
            		    help=new helpDialog(gwConst.HELP_TITLE,helpString);
        		}
        	    else if(null != notReadyMessage)
            	        notReadyMessage.show();
        	}
   
        	if(null != help && !help.isShowing())
        			help.show();
        		
			return true;
        }
        return false;
    }

    boolean isUnchanged(String latitude, String longitude)
    {
    	double d_latitude,d_longitude;
    	
		try{
        	d_latitude=dms.dms2decdeg(latitude);
         	d_longitude=dms.dms2decdeg(longitude);
           }catch(Invalid_Angular_Data exc)
         		{
         			return false;
         		}
        return (data.longitude2==d_longitude && data.latitude2==d_latitude);
    }

    boolean setHomeFields(String latitude, String longitude)
    {
    	
    	try{
        	data.latitude2=dms.dms2decdeg(latitude);
         	data.longitude2=dms.dms2decdeg(longitude);
           }catch(Invalid_Angular_Data exc)
         		{
         			lat2.setText("");
         			long2.setText("");
         			return false;
         		}
 		lat2.setText(latitude);
	    long2.setText(longitude);
	    return true;
	}

	public boolean handleEvent(Event e)
    {
        if (e.id == Event.WINDOW_DESTROY
        		||	(e.id == Event.KEY_PRESS && e.key==27)){
            hide();
            return true;
        }
        else if (e.id == wgCheckbox.CB_BUTTON){
            if(nad83.getState()){
          		if(coord83 && isUnchanged(homeLat27,homeLong27))
          			setHomeFields(homeLat83,homeLong83);
          		else{
         			lat2.setText("");
         			long2.setText("");
       			}               			
       		}
       		else{
       			if(coord27 && isUnchanged(homeLat83,homeLong83))
       				setHomeFields(homeLat27,homeLong27);
       			else{
       				lat2.setText("");
       				long2.setText("");
       			}           				
   			}
        }
        return super.handleEvent(e);
    }

    public void show()
    {
        super.show();
        lat1.requestFocus();           
    }

    public void finalize()
    {
        if(null != ilMaps && ilMaps.isAlive())ilMaps.stop();
        if(null != helpFile && helpFile.isAlive())helpFile.stop();
        if(null != mwmWorld && mwmWorld.isAlive())mwmWorld.stop();
        if(null != mwmUSA && mwmUSA.isAlive())mwmUSA.stop();
        if(null != checkResources && checkResources.isAlive())checkResources.stop();
    }
}

class ResourceCheck extends Thread
{
    mapWindowMaker mwmWorld;
    mapWindowMaker mwmUSA;
    fileLoader helpFile;
    TextField statusField;
    Thread thisThread=null;
    boolean ready;
   
    
    ResourceCheck(mapWindowMaker World, mapWindowMaker USA,
                    fileLoader help, TextField status)
    {
        mwmWorld=World;
        mwmUSA=USA;
        helpFile=help;
        statusField=status;
    }

    public void start()
    {
        if(null==thisThread){
            thisThread=new Thread(this);
            thisThread.start();
        }
    }


    public void run()
    {
        MapWindow windowWorld=null;
        MapWindow windowUSA=null;
        String helpString=null;

        ready=false;
        statusField.setText(gwConst.PREPARING);
        while(null != thisThread){
            if(null == windowWorld && null != mwmWorld)
                windowWorld=mwmWorld.retrieveMapWindow();
            else if(null==windowUSA && null != mwmUSA)
                windowUSA=mwmUSA.retrieveMapWindow();
            else if(null==helpString && null != helpFile)
                helpString=helpFile.retrieveFileContent();
            else{
                if(null != helpFile)helpFile.stop();
                if(null != mwmWorld)mwmWorld.stop();
                if(null != mwmUSA)mwmUSA.stop();
                statusField.setText(gwConst.READY);
                ready=true;
                break;
            }
        }
    }

    public boolean areReady()
    {
        return ready;
    }

}
        
	
		
