/*
 *  Copyright 2001-2005 Internet2
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cxxtest/TestSuite.h>

#include <saml/saml.h>
#include <sstream>

using namespace saml;
using namespace std;

class SAMLSubjectTest : public CxxTest::TestSuite {
public:
    XMLCh *name,*name2;

    void setUp() {
        name = XMLString::transcode("foo");
        name2 = XMLString::transcode("bar");
    }

    void tearDown() {
        XMLString::release(&name);
        XMLString::release(&name2);
    }
    
    void testSAMLSubject(void) {
        TS_TRACE("testing SAMLSubject class");

        
        auto_ptr<SAMLSubject> s(new SAMLSubject());
        TS_ASSERT(s.get());
        s->setNameIdentifier(new SAMLNameIdentifier(name));
        auto_ptr<SAMLSubject> s2((SAMLSubject*)s->clone());

        stringstream str1,str2;
        str1 << *s.get();
        str2 << *s2.get();
        
        TS_ASSERT_EQUALS(str1.str(),str2.str());

        auto_ptr<SAMLSubject> s3(new SAMLSubject(str1));
        s->getNameIdentifier()->setName(name2);
        s3->getNameIdentifier()->setName(name2);
        stringstream str3,str4;
        str3 << *s.get();
        str4 << *s3.get();

        TS_ASSERT_EQUALS(str3.str(),str4.str());
        TS_ASSERT(!XMLString::compareString(s3->getNameIdentifier()->getName(),name2));
        TS_ASSERT_THROWS(s->setNameIdentifier(s3->getNameIdentifier()), SAMLException);
    }
};
