/*
** Copyright (C) 2000 Alan McIvor <alan@mcivor.gen.nz>
** Copyright (C) 2003 Guilhem Bonnefille <guilhem.bonnefille@free.fr>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <cstdlib>
#include <cstring>

#include "namedid.h"

NAMED_ID::NAMED_ID(char *id, char *name):
  mId(NULL), mName(NULL)
{
    setId(id);
    mName = strdup(name);
}

/// Usefull to compute a complex id (after creation)
void NAMED_ID::setId(const char *id)
{
  // First, free memory
  free(mId);

  // Then, duplicate Id
  mId = strdup(id);
}
