/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class NewFieldContainer!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILENEWFIELDCONTAINERINST

#include <stdlib.h>
#include <stdio.h>

#include <OpenSG/OSGConfig.h>

#include "OSGNewFieldContainerBase.h"
#include "OSGNewFieldContainer.h"


OSG_USING_NAMESPACE

const OSG::BitVector  NewFieldContainerBase::FooFieldMask = 
    (TypeTraits<BitVector>::One << NewFieldContainerBase::FooFieldId);

const OSG::BitVector  NewFieldContainerBase::BarFieldMask = 
    (TypeTraits<BitVector>::One << NewFieldContainerBase::BarFieldId);

const OSG::BitVector NewFieldContainerBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var UInt32          NewFieldContainerBase::_mfFoo
    The foos.
*/
/*! \var TripleInt       NewFieldContainerBase::_sfBar
    A Field contains the new TripleInt type.
*/

//! NewFieldContainer description

FieldDescription *NewFieldContainerBase::_desc[] = 
{
    new FieldDescription(MFUInt32::getClassType(), 
                     "foo", 
                     FooFieldId, FooFieldMask,
                     false,
                     (FieldAccessMethod) &NewFieldContainerBase::getMFFoo),
    new FieldDescription(SFTripleInt::getClassType(), 
                     "bar", 
                     BarFieldId, BarFieldMask,
                     false,
                     (FieldAccessMethod) &NewFieldContainerBase::getSFBar)
};


FieldContainerType NewFieldContainerBase::_type(
    "NewFieldContainer",
    "FieldContainer",
    NULL,
    (PrototypeCreateF) &NewFieldContainerBase::createEmpty,
    NewFieldContainer::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(NewFieldContainerBase, NewFieldContainerPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &NewFieldContainerBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &NewFieldContainerBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr NewFieldContainerBase::shallowCopy(void) const 
{ 
    NewFieldContainerPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const NewFieldContainer *>(this)); 

    return returnValue; 
}

UInt32 NewFieldContainerBase::getContainerSize(void) const 
{ 
    return sizeof(NewFieldContainer); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void NewFieldContainerBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((NewFieldContainerBase *) &other, whichField);
}
#else
void NewFieldContainerBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((NewFieldContainerBase *) &other, whichField, sInfo);
}
void NewFieldContainerBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void NewFieldContainerBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfFoo.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

NewFieldContainerBase::NewFieldContainerBase(void) :
    _mfFoo                    (), 
    _sfBar                    (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

NewFieldContainerBase::NewFieldContainerBase(const NewFieldContainerBase &source) :
    _mfFoo                    (source._mfFoo                    ), 
    _sfBar                    (source._sfBar                    ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

NewFieldContainerBase::~NewFieldContainerBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 NewFieldContainerBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (FooFieldMask & whichField))
    {
        returnValue += _mfFoo.getBinSize();
    }

    if(FieldBits::NoField != (BarFieldMask & whichField))
    {
        returnValue += _sfBar.getBinSize();
    }


    return returnValue;
}

void NewFieldContainerBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (FooFieldMask & whichField))
    {
        _mfFoo.copyToBin(pMem);
    }

    if(FieldBits::NoField != (BarFieldMask & whichField))
    {
        _sfBar.copyToBin(pMem);
    }


}

void NewFieldContainerBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (FooFieldMask & whichField))
    {
        _mfFoo.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (BarFieldMask & whichField))
    {
        _sfBar.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void NewFieldContainerBase::executeSyncImpl(      NewFieldContainerBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (FooFieldMask & whichField))
        _mfFoo.syncWith(pOther->_mfFoo);

    if(FieldBits::NoField != (BarFieldMask & whichField))
        _sfBar.syncWith(pOther->_sfBar);


}
#else
void NewFieldContainerBase::executeSyncImpl(      NewFieldContainerBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (BarFieldMask & whichField))
        _sfBar.syncWith(pOther->_sfBar);


    if(FieldBits::NoField != (FooFieldMask & whichField))
        _mfFoo.syncWith(pOther->_mfFoo, sInfo);


}

void NewFieldContainerBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (FooFieldMask & whichField))
        _mfFoo.beginEdit(uiAspect, uiContainerSize);

}
#endif



#include <OpenSG/OSGSFieldTypeDef.inl>
#include <OpenSG/OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<NewFieldContainerPtr>::_type("NewFieldContainerPtr", "FieldContainerPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(NewFieldContainerPtr, );
OSG_DLLEXPORT_MFIELD_DEF1(NewFieldContainerPtr, );

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGNEWFIELDCONTAINERBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGNEWFIELDCONTAINERBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGNEWFIELDCONTAINERFIELDS_HEADER_CVSID;
}

