/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class GeoCubes!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEGEOCUBESINST

#include <stdlib.h>
#include <stdio.h>

#include <OpenSG/OSGConfig.h>

#include "OSGGeoCubesBase.h"
#include "OSGGeoCubes.h"


OSG_USING_NAMESPACE

const OSG::BitVector  GeoCubesBase::PositionFieldMask = 
    (TypeTraits<BitVector>::One << GeoCubesBase::PositionFieldId);

const OSG::BitVector  GeoCubesBase::LengthFieldMask = 
    (TypeTraits<BitVector>::One << GeoCubesBase::LengthFieldId);

const OSG::BitVector  GeoCubesBase::ColorFieldMask = 
    (TypeTraits<BitVector>::One << GeoCubesBase::ColorFieldId);

const OSG::BitVector GeoCubesBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Pnt3f           GeoCubesBase::_mfPosition
    The cubes' positions.
*/
/*! \var Real32          GeoCubesBase::_mfLength
    The cubes' sizes.
*/
/*! \var Color3f         GeoCubesBase::_mfColor
    The cubes' colors.
*/

//! GeoCubes description

FieldDescription *GeoCubesBase::_desc[] = 
{
    new FieldDescription(MFPnt3f::getClassType(), 
                     "position", 
                     PositionFieldId, PositionFieldMask,
                     false,
                     (FieldAccessMethod) &GeoCubesBase::getMFPosition),
    new FieldDescription(MFReal32::getClassType(), 
                     "length", 
                     LengthFieldId, LengthFieldMask,
                     false,
                     (FieldAccessMethod) &GeoCubesBase::getMFLength),
    new FieldDescription(MFColor3f::getClassType(), 
                     "color", 
                     ColorFieldId, ColorFieldMask,
                     false,
                     (FieldAccessMethod) &GeoCubesBase::getMFColor)
};


FieldContainerType GeoCubesBase::_type(
    "GeoCubes",
    "Geometry",
    NULL,
    (PrototypeCreateF) &GeoCubesBase::createEmpty,
    GeoCubes::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(GeoCubesBase, GeoCubesPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &GeoCubesBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &GeoCubesBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr GeoCubesBase::shallowCopy(void) const 
{ 
    GeoCubesPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const GeoCubes *>(this)); 

    return returnValue; 
}

UInt32 GeoCubesBase::getContainerSize(void) const 
{ 
    return sizeof(GeoCubes); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void GeoCubesBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((GeoCubesBase *) &other, whichField);
}
#else
void GeoCubesBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((GeoCubesBase *) &other, whichField, sInfo);
}
void GeoCubesBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void GeoCubesBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfPosition.terminateShare(uiAspect, this->getContainerSize());
    _mfLength.terminateShare(uiAspect, this->getContainerSize());
    _mfColor.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

GeoCubesBase::GeoCubesBase(void) :
    _mfPosition               (), 
    _mfLength                 (), 
    _mfColor                  (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

GeoCubesBase::GeoCubesBase(const GeoCubesBase &source) :
    _mfPosition               (source._mfPosition               ), 
    _mfLength                 (source._mfLength                 ), 
    _mfColor                  (source._mfColor                  ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

GeoCubesBase::~GeoCubesBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 GeoCubesBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
    {
        returnValue += _mfPosition.getBinSize();
    }

    if(FieldBits::NoField != (LengthFieldMask & whichField))
    {
        returnValue += _mfLength.getBinSize();
    }

    if(FieldBits::NoField != (ColorFieldMask & whichField))
    {
        returnValue += _mfColor.getBinSize();
    }


    return returnValue;
}

void GeoCubesBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
    {
        _mfPosition.copyToBin(pMem);
    }

    if(FieldBits::NoField != (LengthFieldMask & whichField))
    {
        _mfLength.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ColorFieldMask & whichField))
    {
        _mfColor.copyToBin(pMem);
    }


}

void GeoCubesBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
    {
        _mfPosition.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (LengthFieldMask & whichField))
    {
        _mfLength.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ColorFieldMask & whichField))
    {
        _mfColor.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void GeoCubesBase::executeSyncImpl(      GeoCubesBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
        _mfPosition.syncWith(pOther->_mfPosition);

    if(FieldBits::NoField != (LengthFieldMask & whichField))
        _mfLength.syncWith(pOther->_mfLength);

    if(FieldBits::NoField != (ColorFieldMask & whichField))
        _mfColor.syncWith(pOther->_mfColor);


}
#else
void GeoCubesBase::executeSyncImpl(      GeoCubesBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);


    if(FieldBits::NoField != (PositionFieldMask & whichField))
        _mfPosition.syncWith(pOther->_mfPosition, sInfo);

    if(FieldBits::NoField != (LengthFieldMask & whichField))
        _mfLength.syncWith(pOther->_mfLength, sInfo);

    if(FieldBits::NoField != (ColorFieldMask & whichField))
        _mfColor.syncWith(pOther->_mfColor, sInfo);


}

void GeoCubesBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
        _mfPosition.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (LengthFieldMask & whichField))
        _mfLength.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (ColorFieldMask & whichField))
        _mfColor.beginEdit(uiAspect, uiContainerSize);

}
#endif



#include <OpenSG/OSGSFieldTypeDef.inl>
#include <OpenSG/OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<GeoCubesPtr>::_type("GeoCubesPtr", "GeometryPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(GeoCubesPtr, OSG_MYLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(GeoCubesPtr, OSG_MYLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGGEOCUBESBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGGEOCUBESBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGGEOCUBESFIELDS_HEADER_CVSID;
}

