/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class CGChunk!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILECGCHUNKINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGCGChunkBase.h"
#include "OSGCGChunk.h"


OSG_USING_NAMESPACE

const OSG::BitVector  CGChunkBase::VertexProfileFieldMask = 
    (TypeTraits<BitVector>::One << CGChunkBase::VertexProfileFieldId);

const OSG::BitVector  CGChunkBase::FragmentProfileFieldMask = 
    (TypeTraits<BitVector>::One << CGChunkBase::FragmentProfileFieldId);

const OSG::BitVector  CGChunkBase::VertexEntryPointFieldMask = 
    (TypeTraits<BitVector>::One << CGChunkBase::VertexEntryPointFieldId);

const OSG::BitVector  CGChunkBase::VertexArgumentsFieldMask = 
    (TypeTraits<BitVector>::One << CGChunkBase::VertexArgumentsFieldId);

const OSG::BitVector  CGChunkBase::FragmentEntryPointFieldMask = 
    (TypeTraits<BitVector>::One << CGChunkBase::FragmentEntryPointFieldId);

const OSG::BitVector  CGChunkBase::FragmentArgumentsFieldMask = 
    (TypeTraits<BitVector>::One << CGChunkBase::FragmentArgumentsFieldId);

const OSG::BitVector  CGChunkBase::GLIdFieldMask = 
    (TypeTraits<BitVector>::One << CGChunkBase::GLIdFieldId);

const OSG::BitVector CGChunkBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var UInt32          CGChunkBase::_sfVertexProfile
    vertex profile
*/
/*! \var UInt32          CGChunkBase::_sfFragmentProfile
    vertex profile
*/
/*! \var std::string     CGChunkBase::_sfVertexEntryPoint
    
*/
/*! \var std::string     CGChunkBase::_mfVertexArguments
    
*/
/*! \var std::string     CGChunkBase::_sfFragmentEntryPoint
    
*/
/*! \var std::string     CGChunkBase::_mfFragmentArguments
    
*/
/*! \var UInt32          CGChunkBase::_sfGLId
    
*/

//! CGChunk description

FieldDescription *CGChunkBase::_desc[] = 
{
    new FieldDescription(SFUInt32::getClassType(), 
                     "vertexProfile", 
                     VertexProfileFieldId, VertexProfileFieldMask,
                     false,
                     (FieldAccessMethod) &CGChunkBase::getSFVertexProfile),
    new FieldDescription(SFUInt32::getClassType(), 
                     "fragmentProfile", 
                     FragmentProfileFieldId, FragmentProfileFieldMask,
                     false,
                     (FieldAccessMethod) &CGChunkBase::getSFFragmentProfile),
    new FieldDescription(SFString::getClassType(), 
                     "vertexEntryPoint", 
                     VertexEntryPointFieldId, VertexEntryPointFieldMask,
                     false,
                     (FieldAccessMethod) &CGChunkBase::getSFVertexEntryPoint),
    new FieldDescription(MFString::getClassType(), 
                     "vertexArguments", 
                     VertexArgumentsFieldId, VertexArgumentsFieldMask,
                     false,
                     (FieldAccessMethod) &CGChunkBase::getMFVertexArguments),
    new FieldDescription(SFString::getClassType(), 
                     "fragmentEntryPoint", 
                     FragmentEntryPointFieldId, FragmentEntryPointFieldMask,
                     false,
                     (FieldAccessMethod) &CGChunkBase::getSFFragmentEntryPoint),
    new FieldDescription(MFString::getClassType(), 
                     "fragmentArguments", 
                     FragmentArgumentsFieldId, FragmentArgumentsFieldMask,
                     false,
                     (FieldAccessMethod) &CGChunkBase::getMFFragmentArguments),
    new FieldDescription(SFUInt32::getClassType(), 
                     "GLId", 
                     GLIdFieldId, GLIdFieldMask,
                     true,
                     (FieldAccessMethod) &CGChunkBase::getSFGLId)
};


FieldContainerType CGChunkBase::_type(
    "CGChunk",
    "ShaderChunk",
    NULL,
    (PrototypeCreateF) &CGChunkBase::createEmpty,
    CGChunk::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(CGChunkBase, CGChunkPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &CGChunkBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &CGChunkBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr CGChunkBase::shallowCopy(void) const 
{ 
    CGChunkPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const CGChunk *>(this)); 

    return returnValue; 
}

UInt32 CGChunkBase::getContainerSize(void) const 
{ 
    return sizeof(CGChunk); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void CGChunkBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((CGChunkBase *) &other, whichField);
}
#else
void CGChunkBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((CGChunkBase *) &other, whichField, sInfo);
}
void CGChunkBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void CGChunkBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfVertexArguments.terminateShare(uiAspect, this->getContainerSize());
    _mfFragmentArguments.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

CGChunkBase::CGChunkBase(void) :
    _sfVertexProfile          (UInt32(6145)), 
    _sfFragmentProfile        (UInt32(6145)), 
    _sfVertexEntryPoint       (), 
    _mfVertexArguments        (), 
    _sfFragmentEntryPoint     (), 
    _mfFragmentArguments      (), 
    _sfGLId                   (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

CGChunkBase::CGChunkBase(const CGChunkBase &source) :
    _sfVertexProfile          (source._sfVertexProfile          ), 
    _sfFragmentProfile        (source._sfFragmentProfile        ), 
    _sfVertexEntryPoint       (source._sfVertexEntryPoint       ), 
    _mfVertexArguments        (source._mfVertexArguments        ), 
    _sfFragmentEntryPoint     (source._sfFragmentEntryPoint     ), 
    _mfFragmentArguments      (source._mfFragmentArguments      ), 
    _sfGLId                   (source._sfGLId                   ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

CGChunkBase::~CGChunkBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 CGChunkBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (VertexProfileFieldMask & whichField))
    {
        returnValue += _sfVertexProfile.getBinSize();
    }

    if(FieldBits::NoField != (FragmentProfileFieldMask & whichField))
    {
        returnValue += _sfFragmentProfile.getBinSize();
    }

    if(FieldBits::NoField != (VertexEntryPointFieldMask & whichField))
    {
        returnValue += _sfVertexEntryPoint.getBinSize();
    }

    if(FieldBits::NoField != (VertexArgumentsFieldMask & whichField))
    {
        returnValue += _mfVertexArguments.getBinSize();
    }

    if(FieldBits::NoField != (FragmentEntryPointFieldMask & whichField))
    {
        returnValue += _sfFragmentEntryPoint.getBinSize();
    }

    if(FieldBits::NoField != (FragmentArgumentsFieldMask & whichField))
    {
        returnValue += _mfFragmentArguments.getBinSize();
    }

    if(FieldBits::NoField != (GLIdFieldMask & whichField))
    {
        returnValue += _sfGLId.getBinSize();
    }


    return returnValue;
}

void CGChunkBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (VertexProfileFieldMask & whichField))
    {
        _sfVertexProfile.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FragmentProfileFieldMask & whichField))
    {
        _sfFragmentProfile.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VertexEntryPointFieldMask & whichField))
    {
        _sfVertexEntryPoint.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VertexArgumentsFieldMask & whichField))
    {
        _mfVertexArguments.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FragmentEntryPointFieldMask & whichField))
    {
        _sfFragmentEntryPoint.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FragmentArgumentsFieldMask & whichField))
    {
        _mfFragmentArguments.copyToBin(pMem);
    }

    if(FieldBits::NoField != (GLIdFieldMask & whichField))
    {
        _sfGLId.copyToBin(pMem);
    }


}

void CGChunkBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (VertexProfileFieldMask & whichField))
    {
        _sfVertexProfile.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FragmentProfileFieldMask & whichField))
    {
        _sfFragmentProfile.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VertexEntryPointFieldMask & whichField))
    {
        _sfVertexEntryPoint.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VertexArgumentsFieldMask & whichField))
    {
        _mfVertexArguments.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FragmentEntryPointFieldMask & whichField))
    {
        _sfFragmentEntryPoint.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FragmentArgumentsFieldMask & whichField))
    {
        _mfFragmentArguments.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (GLIdFieldMask & whichField))
    {
        _sfGLId.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void CGChunkBase::executeSyncImpl(      CGChunkBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (VertexProfileFieldMask & whichField))
        _sfVertexProfile.syncWith(pOther->_sfVertexProfile);

    if(FieldBits::NoField != (FragmentProfileFieldMask & whichField))
        _sfFragmentProfile.syncWith(pOther->_sfFragmentProfile);

    if(FieldBits::NoField != (VertexEntryPointFieldMask & whichField))
        _sfVertexEntryPoint.syncWith(pOther->_sfVertexEntryPoint);

    if(FieldBits::NoField != (VertexArgumentsFieldMask & whichField))
        _mfVertexArguments.syncWith(pOther->_mfVertexArguments);

    if(FieldBits::NoField != (FragmentEntryPointFieldMask & whichField))
        _sfFragmentEntryPoint.syncWith(pOther->_sfFragmentEntryPoint);

    if(FieldBits::NoField != (FragmentArgumentsFieldMask & whichField))
        _mfFragmentArguments.syncWith(pOther->_mfFragmentArguments);

    if(FieldBits::NoField != (GLIdFieldMask & whichField))
        _sfGLId.syncWith(pOther->_sfGLId);


}
#else
void CGChunkBase::executeSyncImpl(      CGChunkBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (VertexProfileFieldMask & whichField))
        _sfVertexProfile.syncWith(pOther->_sfVertexProfile);

    if(FieldBits::NoField != (FragmentProfileFieldMask & whichField))
        _sfFragmentProfile.syncWith(pOther->_sfFragmentProfile);

    if(FieldBits::NoField != (VertexEntryPointFieldMask & whichField))
        _sfVertexEntryPoint.syncWith(pOther->_sfVertexEntryPoint);

    if(FieldBits::NoField != (FragmentEntryPointFieldMask & whichField))
        _sfFragmentEntryPoint.syncWith(pOther->_sfFragmentEntryPoint);

    if(FieldBits::NoField != (GLIdFieldMask & whichField))
        _sfGLId.syncWith(pOther->_sfGLId);


    if(FieldBits::NoField != (VertexArgumentsFieldMask & whichField))
        _mfVertexArguments.syncWith(pOther->_mfVertexArguments, sInfo);

    if(FieldBits::NoField != (FragmentArgumentsFieldMask & whichField))
        _mfFragmentArguments.syncWith(pOther->_mfFragmentArguments, sInfo);


}

void CGChunkBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (VertexArgumentsFieldMask & whichField))
        _mfVertexArguments.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (FragmentArgumentsFieldMask & whichField))
        _mfFragmentArguments.beginEdit(uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<CGChunkPtr>::_type("CGChunkPtr", "ShaderChunkPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(CGChunkPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(CGChunkPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGCGCHUNKBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGCGCHUNKBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGCGCHUNKFIELDS_HEADER_CVSID;
}

