/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class Character!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILECHARACTERINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGCharacterBase.h"
#include "OSGCharacter.h"


OSG_USING_NAMESPACE

const OSG::BitVector  CharacterBase::ModelFieldMask = 
    (TypeTraits<BitVector>::One << CharacterBase::ModelFieldId);

const OSG::BitVector  CharacterBase::CurrentAnimationFieldMask = 
    (TypeTraits<BitVector>::One << CharacterBase::CurrentAnimationFieldId);

const OSG::BitVector  CharacterBase::BlendTimeFieldMask = 
    (TypeTraits<BitVector>::One << CharacterBase::BlendTimeFieldId);

const OSG::BitVector  CharacterBase::DeltaFieldMask = 
    (TypeTraits<BitVector>::One << CharacterBase::DeltaFieldId);

const OSG::BitVector  CharacterBase::TimeScaleFieldMask = 
    (TypeTraits<BitVector>::One << CharacterBase::TimeScaleFieldId);

const OSG::BitVector  CharacterBase::DrawSkeletonFieldMask = 
    (TypeTraits<BitVector>::One << CharacterBase::DrawSkeletonFieldId);

const OSG::BitVector  CharacterBase::UseShaderForGeometryFieldMask = 
    (TypeTraits<BitVector>::One << CharacterBase::UseShaderForGeometryFieldId);

const OSG::BitVector  CharacterBase::ModelVolumeFieldMask = 
    (TypeTraits<BitVector>::One << CharacterBase::ModelVolumeFieldId);

const OSG::BitVector CharacterBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var CharacterModelPtr CharacterBase::_sfModel
    The model this character uses.
*/
/*! \var UInt32          CharacterBase::_sfCurrentAnimation
    Currently running animation.
*/
/*! \var Real32          CharacterBase::_sfBlendTime
    Blending time for switching between animations.
*/
/*! \var Real32          CharacterBase::_sfDelta
    Delta time in seconds for the next frame to render. If set to -1,          the time         is measured inside the Character Core and animated automatically.
*/
/*! \var Real32          CharacterBase::_sfTimeScale
    Scale factor to slow down/speed up animations. Only used if         delta is less than 0.
*/
/*! \var bool            CharacterBase::_sfDrawSkeleton
    Flag for controlling drawing of the skeleton. If the skeleton is         drawn, the skin is not drawn (and vice versa).
*/
/*! \var bool            CharacterBase::_sfUseShaderForGeometry
    Flag for controlling whether the skin is deformed in software or whether         the vertices are passed undeformed and a shader is expected to do the job.
*/
/*! \var DynamicVolume   CharacterBase::_sfModelVolume
    The bounding volume of the character.
*/

//! Character description

FieldDescription *CharacterBase::_desc[] = 
{
    new FieldDescription(SFCharacterModelPtr::getClassType(), 
                     "model", 
                     ModelFieldId, ModelFieldMask,
                     false,
                     (FieldAccessMethod) &CharacterBase::getSFModel),
    new FieldDescription(SFUInt32::getClassType(), 
                     "currentAnimation", 
                     CurrentAnimationFieldId, CurrentAnimationFieldMask,
                     false,
                     (FieldAccessMethod) &CharacterBase::getSFCurrentAnimation),
    new FieldDescription(SFReal32::getClassType(), 
                     "blendTime", 
                     BlendTimeFieldId, BlendTimeFieldMask,
                     false,
                     (FieldAccessMethod) &CharacterBase::getSFBlendTime),
    new FieldDescription(SFReal32::getClassType(), 
                     "delta", 
                     DeltaFieldId, DeltaFieldMask,
                     false,
                     (FieldAccessMethod) &CharacterBase::getSFDelta),
    new FieldDescription(SFReal32::getClassType(), 
                     "timeScale", 
                     TimeScaleFieldId, TimeScaleFieldMask,
                     false,
                     (FieldAccessMethod) &CharacterBase::getSFTimeScale),
    new FieldDescription(SFBool::getClassType(), 
                     "drawSkeleton", 
                     DrawSkeletonFieldId, DrawSkeletonFieldMask,
                     false,
                     (FieldAccessMethod) &CharacterBase::getSFDrawSkeleton),
    new FieldDescription(SFBool::getClassType(), 
                     "useShaderForGeometry", 
                     UseShaderForGeometryFieldId, UseShaderForGeometryFieldMask,
                     false,
                     (FieldAccessMethod) &CharacterBase::getSFUseShaderForGeometry),
    new FieldDescription(SFDynamicVolume::getClassType(), 
                     "modelVolume", 
                     ModelVolumeFieldId, ModelVolumeFieldMask,
                     true,
                     (FieldAccessMethod) &CharacterBase::getSFModelVolume)
};


FieldContainerType CharacterBase::_type(
    "Character",
    "Drawable",
    NULL,
    (PrototypeCreateF) &CharacterBase::createEmpty,
    Character::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(CharacterBase, CharacterPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &CharacterBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &CharacterBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr CharacterBase::shallowCopy(void) const 
{ 
    CharacterPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const Character *>(this)); 

    return returnValue; 
}

UInt32 CharacterBase::getContainerSize(void) const 
{ 
    return sizeof(Character); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void CharacterBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((CharacterBase *) &other, whichField);
}
#else
void CharacterBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((CharacterBase *) &other, whichField, sInfo);
}
void CharacterBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void CharacterBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

CharacterBase::CharacterBase(void) :
    _sfModel                  (), 
    _sfCurrentAnimation       (), 
    _sfBlendTime              (Real32(1.f)), 
    _sfDelta                  (Real32(-1.f)), 
    _sfTimeScale              (Real32(1.f)), 
    _sfDrawSkeleton           (bool(false)), 
    _sfUseShaderForGeometry   (), 
    _sfModelVolume            (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

CharacterBase::CharacterBase(const CharacterBase &source) :
    _sfModel                  (source._sfModel                  ), 
    _sfCurrentAnimation       (source._sfCurrentAnimation       ), 
    _sfBlendTime              (source._sfBlendTime              ), 
    _sfDelta                  (source._sfDelta                  ), 
    _sfTimeScale              (source._sfTimeScale              ), 
    _sfDrawSkeleton           (source._sfDrawSkeleton           ), 
    _sfUseShaderForGeometry   (source._sfUseShaderForGeometry   ), 
    _sfModelVolume            (source._sfModelVolume            ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

CharacterBase::~CharacterBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 CharacterBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ModelFieldMask & whichField))
    {
        returnValue += _sfModel.getBinSize();
    }

    if(FieldBits::NoField != (CurrentAnimationFieldMask & whichField))
    {
        returnValue += _sfCurrentAnimation.getBinSize();
    }

    if(FieldBits::NoField != (BlendTimeFieldMask & whichField))
    {
        returnValue += _sfBlendTime.getBinSize();
    }

    if(FieldBits::NoField != (DeltaFieldMask & whichField))
    {
        returnValue += _sfDelta.getBinSize();
    }

    if(FieldBits::NoField != (TimeScaleFieldMask & whichField))
    {
        returnValue += _sfTimeScale.getBinSize();
    }

    if(FieldBits::NoField != (DrawSkeletonFieldMask & whichField))
    {
        returnValue += _sfDrawSkeleton.getBinSize();
    }

    if(FieldBits::NoField != (UseShaderForGeometryFieldMask & whichField))
    {
        returnValue += _sfUseShaderForGeometry.getBinSize();
    }

    if(FieldBits::NoField != (ModelVolumeFieldMask & whichField))
    {
        returnValue += _sfModelVolume.getBinSize();
    }


    return returnValue;
}

void CharacterBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ModelFieldMask & whichField))
    {
        _sfModel.copyToBin(pMem);
    }

    if(FieldBits::NoField != (CurrentAnimationFieldMask & whichField))
    {
        _sfCurrentAnimation.copyToBin(pMem);
    }

    if(FieldBits::NoField != (BlendTimeFieldMask & whichField))
    {
        _sfBlendTime.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DeltaFieldMask & whichField))
    {
        _sfDelta.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TimeScaleFieldMask & whichField))
    {
        _sfTimeScale.copyToBin(pMem);
    }

    if(FieldBits::NoField != (DrawSkeletonFieldMask & whichField))
    {
        _sfDrawSkeleton.copyToBin(pMem);
    }

    if(FieldBits::NoField != (UseShaderForGeometryFieldMask & whichField))
    {
        _sfUseShaderForGeometry.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ModelVolumeFieldMask & whichField))
    {
        _sfModelVolume.copyToBin(pMem);
    }


}

void CharacterBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ModelFieldMask & whichField))
    {
        _sfModel.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (CurrentAnimationFieldMask & whichField))
    {
        _sfCurrentAnimation.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (BlendTimeFieldMask & whichField))
    {
        _sfBlendTime.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DeltaFieldMask & whichField))
    {
        _sfDelta.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TimeScaleFieldMask & whichField))
    {
        _sfTimeScale.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (DrawSkeletonFieldMask & whichField))
    {
        _sfDrawSkeleton.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (UseShaderForGeometryFieldMask & whichField))
    {
        _sfUseShaderForGeometry.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ModelVolumeFieldMask & whichField))
    {
        _sfModelVolume.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void CharacterBase::executeSyncImpl(      CharacterBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ModelFieldMask & whichField))
        _sfModel.syncWith(pOther->_sfModel);

    if(FieldBits::NoField != (CurrentAnimationFieldMask & whichField))
        _sfCurrentAnimation.syncWith(pOther->_sfCurrentAnimation);

    if(FieldBits::NoField != (BlendTimeFieldMask & whichField))
        _sfBlendTime.syncWith(pOther->_sfBlendTime);

    if(FieldBits::NoField != (DeltaFieldMask & whichField))
        _sfDelta.syncWith(pOther->_sfDelta);

    if(FieldBits::NoField != (TimeScaleFieldMask & whichField))
        _sfTimeScale.syncWith(pOther->_sfTimeScale);

    if(FieldBits::NoField != (DrawSkeletonFieldMask & whichField))
        _sfDrawSkeleton.syncWith(pOther->_sfDrawSkeleton);

    if(FieldBits::NoField != (UseShaderForGeometryFieldMask & whichField))
        _sfUseShaderForGeometry.syncWith(pOther->_sfUseShaderForGeometry);

    if(FieldBits::NoField != (ModelVolumeFieldMask & whichField))
        _sfModelVolume.syncWith(pOther->_sfModelVolume);


}
#else
void CharacterBase::executeSyncImpl(      CharacterBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (ModelFieldMask & whichField))
        _sfModel.syncWith(pOther->_sfModel);

    if(FieldBits::NoField != (CurrentAnimationFieldMask & whichField))
        _sfCurrentAnimation.syncWith(pOther->_sfCurrentAnimation);

    if(FieldBits::NoField != (BlendTimeFieldMask & whichField))
        _sfBlendTime.syncWith(pOther->_sfBlendTime);

    if(FieldBits::NoField != (DeltaFieldMask & whichField))
        _sfDelta.syncWith(pOther->_sfDelta);

    if(FieldBits::NoField != (TimeScaleFieldMask & whichField))
        _sfTimeScale.syncWith(pOther->_sfTimeScale);

    if(FieldBits::NoField != (DrawSkeletonFieldMask & whichField))
        _sfDrawSkeleton.syncWith(pOther->_sfDrawSkeleton);

    if(FieldBits::NoField != (UseShaderForGeometryFieldMask & whichField))
        _sfUseShaderForGeometry.syncWith(pOther->_sfUseShaderForGeometry);

    if(FieldBits::NoField != (ModelVolumeFieldMask & whichField))
        _sfModelVolume.syncWith(pOther->_sfModelVolume);



}

void CharacterBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<CharacterPtr>::_type("CharacterPtr", "DrawablePtr");
#endif


OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGCharacterBase.cpp,v 1.2 2006/02/20 17:04:12 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGCHARACTERBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGCHARACTERBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGCHARACTERFIELDS_HEADER_CVSID;
}

