/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class DeformableGeometry!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &DeformableGeometryBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 DeformableGeometryBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
DeformableGeometryPtr DeformableGeometryBase::create(void) 
{
    DeformableGeometryPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = DeformableGeometryPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
DeformableGeometryPtr DeformableGeometryBase::createEmpty(void) 
{ 
    DeformableGeometryPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the DeformableGeometry::_mfDeformers field.
inline
MFDeformerPtr *DeformableGeometryBase::getMFDeformers(void)
{
    return &_mfDeformers;
}

//! Get the DeformableGeometry::_sfBasePositions field.
inline
SFGeoPositionsPtr *DeformableGeometryBase::getSFBasePositions(void)
{
    return &_sfBasePositions;
}

//! Get the DeformableGeometry::_sfBaseNormals field.
inline
SFGeoNormalsPtr *DeformableGeometryBase::getSFBaseNormals(void)
{
    return &_sfBaseNormals;
}


//! Get the value of the DeformableGeometry::_sfBasePositions field.
inline
GeoPositionsPtr &DeformableGeometryBase::getBasePositions(void)
{
    return _sfBasePositions.getValue();
}

//! Get the value of the DeformableGeometry::_sfBasePositions field.
inline
const GeoPositionsPtr &DeformableGeometryBase::getBasePositions(void) const
{
    return _sfBasePositions.getValue();
}

//! Set the value of the DeformableGeometry::_sfBasePositions field.
inline
void DeformableGeometryBase::setBasePositions(const GeoPositionsPtr &value)
{
    _sfBasePositions.setValue(value);
}

//! Get the value of the DeformableGeometry::_sfBaseNormals field.
inline
GeoNormalsPtr &DeformableGeometryBase::getBaseNormals(void)
{
    return _sfBaseNormals.getValue();
}

//! Get the value of the DeformableGeometry::_sfBaseNormals field.
inline
const GeoNormalsPtr &DeformableGeometryBase::getBaseNormals(void) const
{
    return _sfBaseNormals.getValue();
}

//! Set the value of the DeformableGeometry::_sfBaseNormals field.
inline
void DeformableGeometryBase::setBaseNormals(const GeoNormalsPtr &value)
{
    _sfBaseNormals.setValue(value);
}


//! Get the value of the \a index element the DeformableGeometry::_mfDeformers field.
inline
DeformerPtr &DeformableGeometryBase::getDeformers(const UInt32 index)
{
    return _mfDeformers[index];
}

//! Get the DeformableGeometry::_mfDeformers field.
inline
MFDeformerPtr &DeformableGeometryBase::getDeformers(void)
{
    return _mfDeformers;
}

//! Get the DeformableGeometry::_mfDeformers field.
inline
const MFDeformerPtr &DeformableGeometryBase::getDeformers(void) const
{
    return _mfDeformers;
}

OSG_END_NAMESPACE

#define OSGDEFORMABLEGEOMETRYBASE_INLINE_CVSID "@(#)$Id: FCBaseTemplate_inl.h,v 1.20 2002/12/04 14:22:22 dirk Exp $"

