/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class ShaderChunk!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILESHADERCHUNKINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGShaderChunkBase.h"
#include "OSGShaderChunk.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  ShaderChunkBase::VertexProgramFieldMask = 
    (TypeTraits<BitVector>::One << ShaderChunkBase::VertexProgramFieldId);

const OSG::BitVector  ShaderChunkBase::FragmentProgramFieldMask = 
    (TypeTraits<BitVector>::One << ShaderChunkBase::FragmentProgramFieldId);

const OSG::BitVector  ShaderChunkBase::GeometryProgramFieldMask = 
    (TypeTraits<BitVector>::One << ShaderChunkBase::GeometryProgramFieldId);

const OSG::BitVector ShaderChunkBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var std::string     ShaderChunkBase::_sfVertexProgram
    vertex program source
*/
/*! \var std::string     ShaderChunkBase::_sfFragmentProgram
    fragment program source
*/
/*! \var std::string     ShaderChunkBase::_sfGeometryProgram
    geometry program source
*/

//! ShaderChunk description

FieldDescription *ShaderChunkBase::_desc[] = 
{
    new FieldDescription(SFString::getClassType(), 
                     "vertexProgram", 
                     VertexProgramFieldId, VertexProgramFieldMask,
                     false,
                     (FieldAccessMethod) &ShaderChunkBase::getSFVertexProgram),
    new FieldDescription(SFString::getClassType(), 
                     "fragmentProgram", 
                     FragmentProgramFieldId, FragmentProgramFieldMask,
                     false,
                     (FieldAccessMethod) &ShaderChunkBase::getSFFragmentProgram),
    new FieldDescription(SFString::getClassType(), 
                     "geometryProgram", 
                     GeometryProgramFieldId, GeometryProgramFieldMask,
                     false,
                     (FieldAccessMethod) &ShaderChunkBase::getSFGeometryProgram)
};


FieldContainerType ShaderChunkBase::_type(
    "ShaderChunk",
    "ShaderParameterChunk",
    NULL,
    NULL, 
    ShaderChunk::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(ShaderChunkBase, ShaderChunkPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &ShaderChunkBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &ShaderChunkBase::getType(void) const 
{
    return _type;
} 


UInt32 ShaderChunkBase::getContainerSize(void) const 
{ 
    return sizeof(ShaderChunk); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void ShaderChunkBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((ShaderChunkBase *) &other, whichField);
}
#else
void ShaderChunkBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((ShaderChunkBase *) &other, whichField, sInfo);
}
void ShaderChunkBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void ShaderChunkBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

ShaderChunkBase::ShaderChunkBase(void) :
    _sfVertexProgram          (), 
    _sfFragmentProgram        (), 
    _sfGeometryProgram        (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

ShaderChunkBase::ShaderChunkBase(const ShaderChunkBase &source) :
    _sfVertexProgram          (source._sfVertexProgram          ), 
    _sfFragmentProgram        (source._sfFragmentProgram        ), 
    _sfGeometryProgram        (source._sfGeometryProgram        ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

ShaderChunkBase::~ShaderChunkBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 ShaderChunkBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (VertexProgramFieldMask & whichField))
    {
        returnValue += _sfVertexProgram.getBinSize();
    }

    if(FieldBits::NoField != (FragmentProgramFieldMask & whichField))
    {
        returnValue += _sfFragmentProgram.getBinSize();
    }

    if(FieldBits::NoField != (GeometryProgramFieldMask & whichField))
    {
        returnValue += _sfGeometryProgram.getBinSize();
    }


    return returnValue;
}

void ShaderChunkBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (VertexProgramFieldMask & whichField))
    {
        _sfVertexProgram.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FragmentProgramFieldMask & whichField))
    {
        _sfFragmentProgram.copyToBin(pMem);
    }

    if(FieldBits::NoField != (GeometryProgramFieldMask & whichField))
    {
        _sfGeometryProgram.copyToBin(pMem);
    }


}

void ShaderChunkBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (VertexProgramFieldMask & whichField))
    {
        _sfVertexProgram.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FragmentProgramFieldMask & whichField))
    {
        _sfFragmentProgram.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (GeometryProgramFieldMask & whichField))
    {
        _sfGeometryProgram.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void ShaderChunkBase::executeSyncImpl(      ShaderChunkBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (VertexProgramFieldMask & whichField))
        _sfVertexProgram.syncWith(pOther->_sfVertexProgram);

    if(FieldBits::NoField != (FragmentProgramFieldMask & whichField))
        _sfFragmentProgram.syncWith(pOther->_sfFragmentProgram);

    if(FieldBits::NoField != (GeometryProgramFieldMask & whichField))
        _sfGeometryProgram.syncWith(pOther->_sfGeometryProgram);


}
#else
void ShaderChunkBase::executeSyncImpl(      ShaderChunkBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (VertexProgramFieldMask & whichField))
        _sfVertexProgram.syncWith(pOther->_sfVertexProgram);

    if(FieldBits::NoField != (FragmentProgramFieldMask & whichField))
        _sfFragmentProgram.syncWith(pOther->_sfFragmentProgram);

    if(FieldBits::NoField != (GeometryProgramFieldMask & whichField))
        _sfGeometryProgram.syncWith(pOther->_sfGeometryProgram);



}

void ShaderChunkBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<ShaderChunkPtr>::_type("ShaderChunkPtr", "ShaderParameterChunkPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(ShaderChunkPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(ShaderChunkPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGShaderChunkBase.cpp,v 1.8 2006/11/17 17:16:04 a-m-z Exp $";
    static Char8 cvsid_hpp       [] = OSGSHADERCHUNKBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGSHADERCHUNKBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGSHADERCHUNKFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

