/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class ShaderParameterMatrix!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILESHADERPARAMETERMATRIXINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGShaderParameterMatrixBase.h"
#include "OSGShaderParameterMatrix.h"


OSG_USING_NAMESPACE

const OSG::BitVector  ShaderParameterMatrixBase::ValueFieldMask = 
    (TypeTraits<BitVector>::One << ShaderParameterMatrixBase::ValueFieldId);

const OSG::BitVector ShaderParameterMatrixBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Matrix          ShaderParameterMatrixBase::_sfValue
    parameter value
*/

//! ShaderParameterMatrix description

FieldDescription *ShaderParameterMatrixBase::_desc[] = 
{
    new FieldDescription(SFMatrix::getClassType(), 
                     "value", 
                     ValueFieldId, ValueFieldMask,
                     false,
                     (FieldAccessMethod) &ShaderParameterMatrixBase::getSFValue)
};


FieldContainerType ShaderParameterMatrixBase::_type(
    "ShaderParameterMatrix",
    "ShaderParameter",
    NULL,
    (PrototypeCreateF) &ShaderParameterMatrixBase::createEmpty,
    ShaderParameterMatrix::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(ShaderParameterMatrixBase, ShaderParameterMatrixPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &ShaderParameterMatrixBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &ShaderParameterMatrixBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr ShaderParameterMatrixBase::shallowCopy(void) const 
{ 
    ShaderParameterMatrixPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const ShaderParameterMatrix *>(this)); 

    return returnValue; 
}

UInt32 ShaderParameterMatrixBase::getContainerSize(void) const 
{ 
    return sizeof(ShaderParameterMatrix); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void ShaderParameterMatrixBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((ShaderParameterMatrixBase *) &other, whichField);
}
#else
void ShaderParameterMatrixBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((ShaderParameterMatrixBase *) &other, whichField, sInfo);
}
void ShaderParameterMatrixBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void ShaderParameterMatrixBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

ShaderParameterMatrixBase::ShaderParameterMatrixBase(void) :
    _sfValue                  (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

ShaderParameterMatrixBase::ShaderParameterMatrixBase(const ShaderParameterMatrixBase &source) :
    _sfValue                  (source._sfValue                  ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

ShaderParameterMatrixBase::~ShaderParameterMatrixBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 ShaderParameterMatrixBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ValueFieldMask & whichField))
    {
        returnValue += _sfValue.getBinSize();
    }


    return returnValue;
}

void ShaderParameterMatrixBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ValueFieldMask & whichField))
    {
        _sfValue.copyToBin(pMem);
    }


}

void ShaderParameterMatrixBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ValueFieldMask & whichField))
    {
        _sfValue.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void ShaderParameterMatrixBase::executeSyncImpl(      ShaderParameterMatrixBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ValueFieldMask & whichField))
        _sfValue.syncWith(pOther->_sfValue);


}
#else
void ShaderParameterMatrixBase::executeSyncImpl(      ShaderParameterMatrixBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (ValueFieldMask & whichField))
        _sfValue.syncWith(pOther->_sfValue);



}

void ShaderParameterMatrixBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<ShaderParameterMatrixPtr>::_type("ShaderParameterMatrixPtr", "ShaderParameterPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(ShaderParameterMatrixPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(ShaderParameterMatrixPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGShaderParameterMatrixBase.cpp,v 1.6 2006/02/20 17:04:38 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGSHADERPARAMETERMATRIXBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGSHADERPARAMETERMATRIXBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGSHADERPARAMETERMATRIXFIELDS_HEADER_CVSID;
}

