/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000,2001 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/



#ifndef _OSGFONTSTYLEFIELDS_H_
#define _OSGFONTSTYLEFIELDS_H_

#ifdef __sgi
#pragma once
#endif

#include <string>
#include <sstream>
using namespace std;

#include <OSGConfig.h>

#include <OSGFieldContainerPtr.h>
#include <OSGNodeCoreFieldDataType.h>
#include <OSGSystemDef.h>

#include <OSGNodeCoreFields.h>

#include <OSGFontStyle.h>
#include <OSGFontStyleFactory.h>
#include <OSGMFBaseTypes.h>

//#include <OSGTXFFont.h>
//#include <OSGTXFFontStyle.h>
//#include <OSGTTFontStyle.h>
//#include <OSGText.h>
//#include <OSGSharedFontStyle.h>

OSG_BEGIN_NAMESPACE


typedef FontStyle* FontStyleP;


/*! \brief FontStyle field traits 
*/

template <>
struct FieldDataTraits<FontStyleP> : 
    public FieldTraitsRecurseBase<FontStyleP>
{
    static DataType       _type;

    enum                  { StringConvertable = ToStringConvertable | 
                                                FromStringConvertable    };

    static DataType       &getType      (void) { return _type;          }

    static Char8          *getSName     (void) { return "SFFontStyleP"; }
    static Char8          *getMName     (void) { return "MFFontStyleP"; }

    static FontStyleP getDefault   (void) { return FontStyleP();   }

    static const FieldType &getScanAsTypeMF(void)
    {
        return SFString::getClassType();
    }

    static const FieldType &getScanAsTypeSF(void)
    {
        return MFString::getClassType();
    }

    static bool getFromString( FontStyleP  &outVal,
							   const Char8 *&inVal)
    {
		PathHandler paths;
		paths.push_backPath(".");

		istringstream buf( inVal );

		Real32 fontSize;
		string fontName;

		buf >> fontSize
			>> fontName;

		outVal = FontStyleFactory::the().create(paths, fontName.c_str(), fontSize);

		if(outVal == NULL)
		{
			cout << "************* getFromString: FontStyleFactory "
                 << "returned NULL, when trying to load font: " 
				 << inVal 
				 << endl;

			exit(3);

			return false;
		}

		cout << " ************* getFromString in OSGFontStyleFields "
             << "called successfully, loaded font: " 
			 << inVal 
			 << endl;

        return true;
    }

    static void putToString( const FontStyleP &inVal,
							 std::string     &outVal )
    {
		ostringstream buf;
		
		buf << '\"' 
			<< inVal->getSize()
			<< ' '
			<< inVal->getFontName()
			<< '\"';

		outVal = buf.str();
    }
    
    static UInt32 getBinSize(const FontStyleP &oObject)
    {
		// AT: HIER WEITERMACHEN!

		cout << "getBinSize in OSGFontStyleFields called with " 
             << &oObject << endl;

		return 0;

        //return oObject.getBinSize();
    }

    static UInt32 getBinSize(const FontStyleP *,
                                   UInt32      uiNumObjects)
    {
        return sizeof(FontStyleP) * uiNumObjects;
    }

    static void copyToBin(      BinaryDataHandler &pMem, 
                          const FontStyleP        &oObject)
    {
	   
		// AT: HIER WEITERMACHEN!
		//oObject.copyToBin(pMem);
		cout << "copyToBin in OSGFontStyleFields called with " 
			 << &pMem 
			 << " " 
			 << &oObject 
			 << endl;
    }

    static void copyToBin(      BinaryDataHandler &pMem, 
                          const FontStyleP        *pObjectStore,
                                UInt32             uiNumObjects)
    {
        for(UInt32 i = 0; i < uiNumObjects; i++)
        {
            copyToBin(pMem, pObjectStore[i]);
        }
    }

    static void copyFromBin(BinaryDataHandler &pMem, 
                            FontStyleP     &oObject)
    {
		// AT: HIER WEITERMACHEN!
        //oObject.copyFromBin(pMem);
		cout << "copyFromBin in OSGFontStyleFields called" 
			 << &pMem 
			 << " " 
			 << &oObject << endl;
    }

    static void copyFromBin(BinaryDataHandler &pMem, 
                            FontStyleP        *pObjectStore,
                            UInt32             uiNumObjects)
    {
        for(UInt32 i = 0; i < uiNumObjects; i++)
        {
            copyFromBin(pMem, pObjectStore[i]);
        }
    }
};

/*! \brief FontStyleP fields
*/

 //! SFFontStyleP
//! \ingroup SingleFields

typedef SField<FontStyleP> SFFontStyleP;

#ifndef OSG_COMPILEFONTSTYLEINST
OSG_DLLEXPORT_DECL1(SField, FontStyleP, OSG_SYSTEMLIB_DLLTMPLMAPPING)
OSG_DLLEXPORT_DECL1(MField, FontStyleP, OSG_SYSTEMLIB_DLLTMPLMAPPING)
#endif


OSG_END_NAMESPACE

#define OSGFONTSTYLEFIELDS_HEADER_CVSID "@(#)$Id: $"

#endif /* _OSGFONTSTYLEFIELDS_H_ */
