/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2003 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGDXFFILE_H_
#define _OSGDXFFILE_H_
#ifdef __sgi
#pragma once
#endif

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include <OSGBaseTypes.h>
#include <OSGSystemDef.h>

#include <OSGNodePtr.h>
#include <OSGPathHandler.h>

#include "OSGDXFEntityBase.h"

#include <map>

OSG_BEGIN_NAMESPACE

//---------------------------------------------------------------------------
//  Forward References
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//  Types
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//  Class
//---------------------------------------------------------------------------

/*! \brief Loader interface to the DXFEntityBase hierarchy, itself part of this
    hierarchy.
 */

class OSG_SYSTEMLIB_DLLMAPPING DXFFile : public DXFEntityBase
{
    /*==========================  PUBLIC  =================================*/
  public:

    /*---------------------------------------------------------------------*/
    /*! \name                      Get                                     */
    /*! \{                                                                 */

    static  const Char8 *getClassname(void)       { return "DXFFile"; }

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                      Set                                     */
    /*! \{                                                                 */

	static void registerEntityType(const Char8 *parentEntityTypeName,
								   DXFEntityBase *entityType  );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                      Parsing                                 */
    /*! \{                                                                 */

    static NodePtr load(std::istream &is);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                        Dump                                  */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                   Destructor                                 */
    /*! \{                                                                 */

    virtual ~DXFFile(void);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                      Member                                  */
    /*! \{                                                                 */
	typedef std::multimap<std::string, std::string> StringToStringMMap;

	EntityTypeMap       _entityTypes;
	StringToStringMMap  _entityTypeHierarchy;

	static DXFFile *_the;

 	/*---------------------------------------------------------------------*/
    /*! \name                     Parsing                                  */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    typedef DXFEntityBase Inherited;

    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    DXFFile(void);

    /*! \}                                                                 */
	/*---------------------------------------------------------------------*/
    /*! \name                     Parsing                                  */
    /*! \{                                                                 */

	virtual DXFResult evalRecord(void);
	virtual DXFResult beginEntity(void);	
	virtual DXFResult endEntity(void);	

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/

	static PathHandler _pathHandler; // TODO: wird rausfliegen!

    // prohibit default functions (move to 'public' if needed)
    DXFFile(const DXFFile &source);
    void operator =(const DXFFile &source);
};

OSG_END_NAMESPACE

#define OSGDXFFILE_HEADER_CVSID "@(#)$Id: OSGDXFFile.h,v 1.2 2005/10/14 08:33:35 a-m-z Exp $"

// #include "OSGDXFFile.inl"

#endif /* _OSGDXFFILE_H_ */
