/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class StateChunk!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILESTATECHUNKINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGStateChunkBase.h"
#include "OSGStateChunk.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  StateChunkBase::IgnoreFieldMask = 
    (TypeTraits<BitVector>::One << StateChunkBase::IgnoreFieldId);

const OSG::BitVector StateChunkBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var bool            StateChunkBase::_sfIgnore
    Enables / disables a chunk
*/

//! StateChunk description

FieldDescription *StateChunkBase::_desc[] = 
{
    new FieldDescription(SFBool::getClassType(), 
                     "ignore", 
                     IgnoreFieldId, IgnoreFieldMask,
                     false,
                     (FieldAccessMethod) &StateChunkBase::getSFIgnore)
};


FieldContainerType StateChunkBase::_type(
    "StateChunk",
    "Attachment",
    NULL,
    NULL, 
    StateChunk::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(StateChunkBase, StateChunkPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &StateChunkBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &StateChunkBase::getType(void) const 
{
    return _type;
} 


UInt32 StateChunkBase::getContainerSize(void) const 
{ 
    return sizeof(StateChunk); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void StateChunkBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((StateChunkBase *) &other, whichField);
}
#else
void StateChunkBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((StateChunkBase *) &other, whichField, sInfo);
}
void StateChunkBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void StateChunkBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

StateChunkBase::StateChunkBase(void) :
    _sfIgnore                 (bool(false)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

StateChunkBase::StateChunkBase(const StateChunkBase &source) :
    _sfIgnore                 (source._sfIgnore                 ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

StateChunkBase::~StateChunkBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 StateChunkBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (IgnoreFieldMask & whichField))
    {
        returnValue += _sfIgnore.getBinSize();
    }


    return returnValue;
}

void StateChunkBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (IgnoreFieldMask & whichField))
    {
        _sfIgnore.copyToBin(pMem);
    }


}

void StateChunkBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (IgnoreFieldMask & whichField))
    {
        _sfIgnore.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void StateChunkBase::executeSyncImpl(      StateChunkBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (IgnoreFieldMask & whichField))
        _sfIgnore.syncWith(pOther->_sfIgnore);


}
#else
void StateChunkBase::executeSyncImpl(      StateChunkBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (IgnoreFieldMask & whichField))
        _sfIgnore.syncWith(pOther->_sfIgnore);



}

void StateChunkBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<StateChunkPtr>::_type("StateChunkPtr", "AttachmentPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(StateChunkPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(StateChunkPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.47 2006/03/17 17:03:19 pdaehne Exp $";
    static Char8 cvsid_hpp       [] = OSGSTATECHUNKBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGSTATECHUNKBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGSTATECHUNKFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

