# OpenVerse Debugging GUI
# 
# this file initalizes the program and does any
# platform specific things/setup. It will then source 
# supporting modules.
#
# Module Name		- Debugging GUI
# Current Maintainter 	- Cruise <cruise@openverse.org>
# Sourced By		- InitMain
#
# Copyright (C) 1999 David Gale <cruise@openverse.org>
# For more information visit http://OpenVerse.org/
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
# USA.

# NOTE: Now using string compare to increase performance

proc ToggleDebug {} {
	global MV

	if $MV(debug) {
		set MV(debug) 0
		if {[winfo exists .debug]} {destroy .debug}
	} else {
		OpenDebugWindow
		set MV(debug) 1
	}
}

proc OpenDebugWindow {} {
	global MV

	toplevel .debug
	wm title .debug [Trns openverse_debug_window]
	frame .debug.stuff -relief sunken -borderwidth 2
	frame .debug.text -relief sunken -borderwidth 2

	label .debug.stuff.pos -text [Trns current_position] -relief raised -borderwidth 2
	label .debug.stuff.x -width 3 -textvariable MV(x) -relief raised -borderwidth 2
	label .debug.stuff.y -width 3 -textvariable MV(y) -relief raised -borderwidth 2
	checkbutton .debug.stuff.scr_prot -variable MV(debug.scroll.prot) \
		-text [Trns autoscroll_protocol]
	checkbutton .debug.stuff.scr_other -variable MV(debug.scroll.other) \
		-text [Trns autoscroll_other]
	button .debug.stuff.mem -text [Trns dump_memory] \
		-command Debug_MemDump


	text .debug.text.text_prot -relief raised -borderwidth 2 -height 10
	text .debug.text.text_other -relief raised -borderwidth 2 -height 10

	pack .debug.stuff -side top -fill both -expand y
	pack .debug.text -side bottom -fill both -expand y
	pack .debug.stuff.pos .debug.stuff.x .debug.stuff.y \
		.debug.stuff.scr_prot .debug.stuff.scr_other \
		.debug.stuff.mem -side left

	pack .debug.text.text_other -side bottom -fill both -expand y
	pack .debug.text.text_prot -side bottom -fill both -expand y
}

proc DebugIt { what type} {
	global MV

	#
	# Verify type.
	#
	switch -- $type {
		"prot" {}
		"other" {}
		default {set type "other"}
	}

	if $MV(debug) {
		if {[winfo exists .debug]} {
			.debug.text.text_$type insert end "$what\n"
			if {$MV(debug.scroll.$type)} {
				.debug.text.text_$type see end
			}
		}
	}
}

#
# Debug_MemDump
# 
# This function will write out the whole MV array to a disk file for you
# to view. it's quite ugly :)
#
proc Debug_MemDump {} {
	global MV AE tl MVS SMVS SET

	set outfile [open "$MV(homedir)/Dump.mem" w]
	set arrays [list MV AE tl MVS SMVS SET]
	#
	# debug all the arrays.
	#
	foreach ar $arrays {
		puts $outfile "------------------------------------------------------------------------------"
		puts $outfile " THIS IS THE $ar\() ARRAY"
		puts $outfile "------------------------------------------------------------------------------"
		set toggle 0
		set values {}
		set keys {}
		foreach var [array get $ar] {
			if {!$toggle} {
				lappend keys $var
				set toggle 1
			} else {
				set toggle 0
			}
		}
		set keys [lsort $keys]
		foreach key $keys {
			puts $outfile [format "%-39.39s %-39.39s" $key [set $ar\($key)]]
		}
	}
	puts $outfile "------------------------------------------------------------------------------"
	puts $outfile " IMAGES using memory"
	puts $outfile "------------------------------------------------------------------------------"
	set keys {}
	foreach image [image names] {
		lappend keys $image
	}
	set keys [lsort $keys]
	foreach key $keys {
		puts $outfile [format "%-39.39s %-39.39s" $key [image type $key]]
	}
        #
        # Process Plugins!
        #
        foreach plugin $MV(plugin.traps.Debug_memory) {
                if ![$MV(plugin.traps.Debug_memory.$plugin) $outfile] {
			DebugIt "Debug_MemDump: Plugin $plugin requested to cancel processing... ignoring." other
		}
        }

	close $outfile
	DebugIt "MV array (main memory) written to $MV(homedir)/Dump.mem, Enjoy!" other
}
