//
// $Id: VariableProbe.h 4147 2007-06-22 16:36:36Z bakerj $
//
//****************************************************************************************//
// Copyright (c) 2002-2007, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
#ifndef VARIABLEPROBE_H
#define VARIABLEPROBE_H

#include "AbsProbe.h"

using namespace std;

/**
	This class is responsible for collecting variable information for variable_objects.
	This class should be platform independant.
*/
class VariableProbe : public AbsProbe {
public:
	~VariableProbe();
	
	/** Run the variable probe */
	ItemVector* CollectItems(Object* object);

	/** Return a new Item created for storing variable information */
	Item* CreateItem();

	/** Ensure that the VariableProbe is a singleton. */
	static AbsProbe* Instance();
	
private:

	/** Return an Item for the specified variable id. */
	Item* GetItemForVarId(string varId);

	/** Return all the variable ids in the definitions file being processed. */
	StringVector* GetVariableIds();

	VariableProbe();

	static VariableProbe *instance;
};

#endif
