
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 * Some of the code in this file was copied from the xine-ui project.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: mutex.c 1173 2006-09-18 12:48:40Z mschwerin $
 *
 */

#include "config.h"

#include <stdio.h>

#include "mutex.h"

#ifdef DEBUG_THREADS
int
_mutex_lock (pthread_mutex_t * mutex, char *file, int line)
{
    printf ("THREAD: [thread: 0x%X] waiting for lock at %s:%03d\n",
            (int) pthread_self (), file, line);
    int ret = pthread_mutex_lock (mutex);
    printf ("THREAD: [thread: 0x%X] aquired lock at %s:%03d\n",
            (int) pthread_self (), file, line);
    return ret;
}

int
_mutex_unlock (pthread_mutex_t * mutex, char *file, int line)
{
    int ret = pthread_mutex_unlock (mutex);
    printf ("THREAD: [thread: 0x%X] freed lock at %s:%03d\n",
            (int) pthread_self (), file, line);
    return ret;
}
#endif
