//
// C++ Implementation: columncontrol
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "columncontroldlg.h"

ColumnControlDlg::ColumnControlDlg(QWidget* parent)
 : QDialog(parent)
{
	setupUi(this);
}


ColumnControlDlg::~ColumnControlDlg()
{
}


void ColumnControlDlg::setContent(const QStringList & shown, const QStringList & hidden)
{
   _pShownList->addItems(shown);
   _pHiddenList->addItems(hidden);
}



QStringList ColumnControlDlg::shownColumns()
{
   QStringList result;
   for (int i=0; i<_pShownList->count(); ++i)
      result.push_back(_pShownList->item(i)->text());
   return result;
}


QStringList ColumnControlDlg::hiddenColumns()
{
   QStringList result;
   for (int i=0; i<_pHiddenList->count(); ++i)
      result.push_back(_pHiddenList->item(i)->text());
   return result;
}

void ColumnControlDlg::on__pHideButton_clicked()
{
 	if (_pShownList->selectedItems().size() == 0)
		return;
	QListWidgetItem* pItem = _pShownList->selectedItems().first();
	int row = _pShownList->row(pItem);
	pItem = _pShownList->takeItem(row);
	_pHiddenList->insertItem(_pHiddenList->count(), pItem);
}

void ColumnControlDlg::on__pShowButton_clicked()
{
 	if (_pHiddenList->selectedItems().size() == 0)
		return;
	QListWidgetItem* pItem = _pHiddenList->selectedItems().first();
	int row = _pHiddenList->row(pItem);
	pItem = _pHiddenList->takeItem(row);
	_pShownList->insertItem(_pShownList->count(), pItem);
}


void ColumnControlDlg::on__pUpButton_clicked()
{
 /*  Q3ListBoxItem* pItem = _pShownList->selectedItem();
   if (!pItem)
		return;
	int index = _pShownList->index(pItem);
	QString text = pItem->text();
   // if it is already the first item
	if (index==0)
      return;
   _pShownList->removeItem(index);
   _pShownList->insertItem(text, index-1);
	_pShownList->setSelected(index-1, true);*/
}

void ColumnControlDlg::on__pDownButton_clicked()
{
/*	if (_pShownList->selectedItems().size() == 0)
		return;
   Q3ListBoxItem* pItem = _pShownList->selectedItem();
   int index = _pShownList->index(pItem);
	QString text = pItem->text();
	// if it is already the last item
   if (index==_pShownList->count()-1)
      return;
   _pShownList->removeItem(index);
   _pShownList->insertItem(text, index+1);
	_pShownList->setSelected(index+1, true);*/
}

