//
// C++ Implementation: pluginsettingsdlg
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <qlayout.h>
#include <qtabwidget.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <QVBoxLayout>
#include <QHBoxLayout>


#include "pluginsettingsdlg.h"

#include "plugincontainer.h"


namespace NPlugin 
{

PluginSettingsDlg::PluginSettingsDlg(QWidget *parent, const char *name)
 : QDialog(parent)
{
	setObjectName(name);
	QVBoxLayout* pMainLayout = new QVBoxLayout(this);
	pMainLayout->setMargin(5);
	pMainLayout->setSpacing(6);
	_pPluginWidget = new QTabWidget(this);
	_pPluginWidget->setObjectName("PluginSettingsTabs");
	pMainLayout->addWidget(_pPluginWidget);
	QHBoxLayout* pButtonLayout = new QHBoxLayout();
	pMainLayout->addLayout(pButtonLayout);
	QPushButton* pOkButton = new QPushButton(tr("&OK"), this);
	connect(pOkButton, SIGNAL(clicked()), SLOT(accept()));
	QPushButton* pCancelButton = new QPushButton(tr("&Cancel"), this);
	connect(pCancelButton, SIGNAL(clicked()), SLOT(reject()));
	pButtonLayout->addItem(new QSpacerItem(0,0, QSizePolicy::Expanding, QSizePolicy::Minimum ));
	pButtonLayout->addWidget(pOkButton);
	pButtonLayout->addWidget(pCancelButton);
}


PluginSettingsDlg::~PluginSettingsDlg()
{
}

void PluginSettingsDlg::addPlugin(PluginContainer* pPluginContainer)
{
//	_pPluginWidget->addTab( new QLabel("test", _pPluginWidget), pPluginContainer->title() );
	QWidget* pSettingsWidget = pPluginContainer->getSettingsWidget(this);
	if (pSettingsWidget != 0)
	{
		_pPluginWidget->addTab(pSettingsWidget, pPluginContainer->title());
	}
}


};
