/*
**  SSL/TCPConnection.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#define id openssl_id
#include <openssl/ssl.h>
#undef id

#import <Foundation/Foundation.h>

#import <Pantomime/Connection.h>

@interface TCPSSLConnection : NSObject <Connection>
{
  // ivars
  NSString *name;
  int port;
  int connectionTimeout;
  int readTimeout;
  int writeTimeout;
  int fd;

  SSL_CTX *ctx;
  SSL *ssl;
  BIO *sbio;
}

@end


//
// private methods
// 
@interface TCPSSLConnection (Private)

- (void) _initializeSSLContext;

- (void) _readBytes: (char *) theBytes
             length: (int *) theLength;

- (void) _readBytesBySkippingCR: (BOOL) aBOOL
			    buf: (char **) buf
                         length: (int *) theLength;

- (void) _writeBytes: (char *) theBytes
              length: (int *) theLength;

@end
