/*
**  Message.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_Message
#define _Pantomime_H_Message

#include <Pantomime/Part.h>

#import <Foundation/NSArray.h>
#import <Foundation/NSCalendarDate.h>
#import <Foundation/NSCoder.h>
#import <Foundation/NSData.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSObject.h>

@class Flags;
@class Folder;
@class InternetAddress;

#define CRLF "\r\n"
#define LF "\n"

@interface Message : Part <NSCoding>
{
  @protected
    NSData *rawSource;

  @private
    BOOL initialized;
    NSMutableArray *recipients;
    NSMutableDictionary *headers;
    int messageNumber;
    Flags *flags;

    Folder *folder;

    NSMutableDictionary *properties;

    NSArray *references;
}

- (id) init;
- (id) initWithHeaders: (NSDictionary *) theHeaders;
- (id) initWithHeadersFromData: (NSData *) theHeaders;

- (void) dealloc;

//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder;
- (id) initWithCoder: (NSCoder *) theCoder;


//
// access / mutation methods
//
- (InternetAddress *) from;
- (void) setFrom: (InternetAddress *) theInternetAddress;

- (int) messageNumber;
- (void) setMessageNumber: (int) theMessageNumber;

- (NSString *) messageID;
- (void) setMessageID: (NSString *) theMessageID;

- (NSString *) inReplyTo;
- (void) setInReplyTo: (NSString *) theInReplyTo;

- (NSCalendarDate *) receivedDate;
- (void) setReceivedDate: (NSCalendarDate *) theDate;

- (void) addToRecipients: (InternetAddress *) theAddress;
- (void) removeFromRecipients: (InternetAddress *) theAddress;
- (NSArray *) recipients;
- (void) setRecipients: (NSArray *) theRecipients;
- (int) recipientsCount;
- (void) removeAllRecipients;

- (InternetAddress*) replyTo;
- (void) setReplyTo: (InternetAddress *) theInternetAddress;

- (NSString *) subject;
- (void) setSubject: (NSString *) theSubject;
- (NSString *) baseSubject;
- (void) setBaseSubject: (NSString *) theBaseSubject;

- (BOOL) isInitialized;
- (void) setInitialized: (BOOL) b;

- (Flags *) flags;
- (void) setFlags: (Flags *) theFlags;

- (NSString *) mimeVersion;
- (void) setMimeVersion: (NSString *) theMimeVersion;

- (Message *) replyWithReplyToAll: (BOOL) flag;
- (Message *) forward;

- (void) addHeader: (NSString *) theName
         withValue: (NSString *) theValue;

- (id) headerValueForName: (NSString *) theName;

- (NSDictionary *) allHeaders;

- (Folder *) folder;
- (void) setFolder: (Folder *) theFolder;

- (void) setHeaders: (NSDictionary *) theHeaders;

- (NSData *) rawSource;
- (void) setRawSource: (NSData *) theRawSource;

- (NSString *) organization;
- (void) setOrganization: (NSString *) theOrganization;

- (id) propertyForKey: (id) theKey;
- (void) setProperty: (id) theProperty
              forKey: (id) theKey;

//
//
//
- (NSCalendarDate *) resentDate;
- (void) setResentDate: (NSCalendarDate *) theResentDate;

- (InternetAddress *) resentFrom;
- (void) setResentFrom: (InternetAddress *) theInternetAddress;

- (NSString *) resentMessageID;
- (void) setResentMessageID: (NSString *) theResentMessageID;

- (NSString *) resentSubject;
- (void) setResentSubject: (NSString *) theResentSubject;

- (NSArray *) allReferences;
- (void) setReferences: (NSArray *) theReferences;

- (void) addHeadersFromData: (NSData *) theHeaders;

@end


//
// Message's comparison category
//
@interface Message (Comparing)

- (int) compareAccordingToNumber: (Message *) aMessage;
- (int) reverseCompareAccordingToNumber: (Message *) aMessage;
- (int) compareAccordingToDate: (Message *) aMessage;
- (int) reverseCompareAccordingToDate: (Message *) aMessage;
- (int) compareAccordingToSender: (Message *) aMessage;
- (int) reverseCompareAccordingToSender: (Message *) aMessage;
- (int) compareAccordingToSize: (Message *) aMessage;
- (int) reverseCompareAccordingToSize: (Message *) aMessage;

@end


//
// Private methods
//
@interface Message (Private)

- (NSString *) _computeBaseSubject;
- (NSData *) _formatRecipientsWithType: (int) theType;

@end

#endif // _Pantomime_H_Message



